/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.llvm.CXString;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXStringSet
extends Struct<CXStringSet> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STRINGS;
    public static final int COUNT;

    protected CXStringSet(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CXStringSet create(long address, @Nullable ByteBuffer container) {
        return new CXStringSet(address, container);
    }

    public CXStringSet(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXStringSet.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CXString *")
    public CXString.Buffer Strings() {
        return CXStringSet.nStrings(this.address());
    }

    @NativeType(value="unsigned")
    public int Count() {
        return CXStringSet.nCount(this.address());
    }

    public static CXStringSet create(long address) {
        return new CXStringSet(address, null);
    }

    public static @Nullable CXStringSet createSafe(long address) {
        return address == 0L ? null : new CXStringSet(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CXString.Buffer nStrings(long struct) {
        return CXString.create(MemoryUtil.memGetAddress((long)(struct + (long)STRINGS)), CXStringSet.nCount(struct));
    }

    public static int nCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)COUNT));
    }

    static {
        Struct.Layout layout = CXStringSet.__struct((Struct.Member[])new Struct.Member[]{CXStringSet.__member((int)POINTER_SIZE), CXStringSet.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STRINGS = layout.offsetof(0);
        COUNT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXStringSet, Buffer> {
        private static final CXStringSet ELEMENT_FACTORY = CXStringSet.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CXStringSet getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CXString *")
        public CXString.Buffer Strings() {
            return CXStringSet.nStrings(this.address());
        }

        @NativeType(value="unsigned")
        public int Count() {
            return CXStringSet.nCount(this.address());
        }
    }
}

