/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.SharedLibrary;

public class LLVMError {
    public static final int LLVMErrorSuccess = 0;

    protected LLVMError() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="LLVMErrorTypeId")
    public static long LLVMGetErrorTypeId(@NativeType(value="LLVMErrorRef") long Err) {
        long __functionAddress = Functions.GetErrorTypeId;
        if (Checks.CHECKS) {
            Checks.check((long)Err);
        }
        return JNI.invokePP((long)Err, (long)__functionAddress);
    }

    public static void LLVMConsumeError(@NativeType(value="LLVMErrorRef") long Err) {
        long __functionAddress = Functions.ConsumeError;
        if (Checks.CHECKS) {
            Checks.check((long)Err);
        }
        JNI.invokePV((long)Err, (long)__functionAddress);
    }

    public static long nLLVMGetErrorMessage(long Err) {
        long __functionAddress = Functions.GetErrorMessage;
        if (Checks.CHECKS) {
            Checks.check((long)Err);
        }
        return JNI.invokePP((long)Err, (long)__functionAddress);
    }

    @NativeType(value="char *")
    public static @Nullable ByteBuffer LLVMGetErrorMessage(@NativeType(value="LLVMErrorRef") long Err) {
        long __result = LLVMError.nLLVMGetErrorMessage(Err);
        return MemoryUtil.memByteBufferNT1Safe((long)__result);
    }

    public static void nLLVMDisposeErrorMessage(long ErrMsg) {
        long __functionAddress = Functions.DisposeErrorMessage;
        JNI.invokePV((long)ErrMsg, (long)__functionAddress);
    }

    public static void LLVMDisposeErrorMessage(@NativeType(value="char *") ByteBuffer ErrMsg) {
        LLVMError.nLLVMDisposeErrorMessage(MemoryUtil.memAddress((ByteBuffer)ErrMsg));
    }

    @NativeType(value="LLVMErrorTypeId")
    public static long LLVMGetStringErrorTypeId() {
        long __functionAddress = Functions.GetStringErrorTypeId;
        return JNI.invokeP((long)__functionAddress);
    }

    public static long nLLVMCreateStringError(long ErrMsg) {
        long __functionAddress = Functions.CreateStringError;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokePP((long)ErrMsg, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMCreateStringError(@NativeType(value="char const *") ByteBuffer ErrMsg) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)ErrMsg);
        }
        return LLVMError.nLLVMCreateStringError(MemoryUtil.memAddress((ByteBuffer)ErrMsg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMErrorRef")
    public static long LLVMCreateStringError(@NativeType(value="char const *") CharSequence ErrMsg) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(ErrMsg, true);
            long ErrMsgEncoded = stack.getPointerAddress();
            long l = LLVMError.nLLVMCreateStringError(ErrMsgEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static final class Functions {
        public static final long GetErrorTypeId = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetErrorTypeId");
        public static final long ConsumeError = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMConsumeError");
        public static final long GetErrorMessage = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetErrorMessage");
        public static final long DisposeErrorMessage = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDisposeErrorMessage");
        public static final long GetStringErrorTypeId = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetStringErrorTypeId");
        public static final long CreateStringError = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMCreateStringError");

        private Functions() {
        }
    }
}

