/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.llvm.LLVMOrcLLJITBuilderObjectLinkingLayerCreatorFunctionI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMLLJIT {
    protected LLVMLLJIT() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="LLVMOrcLLJITBuilderRef")
    public static long LLVMOrcCreateLLJITBuilder() {
        long __functionAddress = Functions.OrcCreateLLJITBuilder;
        return JNI.invokeP((long)__functionAddress);
    }

    public static void LLVMOrcDisposeLLJITBuilder(@NativeType(value="LLVMOrcLLJITBuilderRef") long Builder) {
        long __functionAddress = Functions.OrcDisposeLLJITBuilder;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
        }
        JNI.invokePV((long)Builder, (long)__functionAddress);
    }

    public static void LLVMOrcLLJITBuilderSetJITTargetMachineBuilder(@NativeType(value="LLVMOrcLLJITBuilderRef") long Builder, @NativeType(value="LLVMOrcJITTargetMachineBuilderRef") long JTMB) {
        long __functionAddress = Functions.OrcLLJITBuilderSetJITTargetMachineBuilder;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)JTMB);
        }
        JNI.invokePPV((long)Builder, (long)JTMB, (long)__functionAddress);
    }

    public static void nLLVMOrcLLJITBuilderSetObjectLinkingLayerCreator(long Builder, long F, long Ctx) {
        long __functionAddress = Functions.OrcLLJITBuilderSetObjectLinkingLayerCreator;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Ctx);
        }
        JNI.invokePPPV((long)Builder, (long)F, (long)Ctx, (long)__functionAddress);
    }

    public static void LLVMOrcLLJITBuilderSetObjectLinkingLayerCreator(@NativeType(value="LLVMOrcLLJITBuilderRef") long Builder, @NativeType(value="LLVMOrcObjectLayerRef (*) (void *, LLVMOrcExecutionSessionRef, char const *)") LLVMOrcLLJITBuilderObjectLinkingLayerCreatorFunctionI F, @NativeType(value="void *") long Ctx) {
        LLVMLLJIT.nLLVMOrcLLJITBuilderSetObjectLinkingLayerCreator(Builder, F.address(), Ctx);
    }

    public static long nLLVMOrcCreateLLJIT(long Result, long Builder) {
        long __functionAddress = Functions.OrcCreateLLJIT;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
        }
        return JNI.invokePPP((long)Result, (long)Builder, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcCreateLLJIT(@NativeType(value="LLVMOrcLLJITRef *") PointerBuffer Result, @NativeType(value="LLVMOrcLLJITBuilderRef") long Builder) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)Result, (int)1);
        }
        return LLVMLLJIT.nLLVMOrcCreateLLJIT(MemoryUtil.memAddress((CustomBuffer)Result), Builder);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcDisposeLLJIT(@NativeType(value="LLVMOrcLLJITRef") long J) {
        long __functionAddress = Functions.OrcDisposeLLJIT;
        if (Checks.CHECKS) {
            Checks.check((long)J);
        }
        return JNI.invokePP((long)J, (long)__functionAddress);
    }

    @NativeType(value="LLVMOrcExecutionSessionRef")
    public static long LLVMOrcLLJITGetExecutionSession(@NativeType(value="LLVMOrcLLJITRef") long J) {
        long __functionAddress = Functions.OrcLLJITGetExecutionSession;
        if (Checks.CHECKS) {
            Checks.check((long)J);
        }
        return JNI.invokePP((long)J, (long)__functionAddress);
    }

    @NativeType(value="LLVMOrcJITDylibRef")
    public static long LLVMOrcLLJITGetMainJITDylib(@NativeType(value="LLVMOrcLLJITRef") long J) {
        long __functionAddress = Functions.OrcLLJITGetMainJITDylib;
        if (Checks.CHECKS) {
            Checks.check((long)J);
        }
        return JNI.invokePP((long)J, (long)__functionAddress);
    }

    public static long nLLVMOrcLLJITGetTripleString(long J) {
        long __functionAddress = Functions.OrcLLJITGetTripleString;
        if (Checks.CHECKS) {
            Checks.check((long)J);
        }
        return JNI.invokePP((long)J, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String LLVMOrcLLJITGetTripleString(@NativeType(value="LLVMOrcLLJITRef") long J) {
        long __result = LLVMLLJIT.nLLVMOrcLLJITGetTripleString(J);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="char")
    public static byte LLVMOrcLLJITGetGlobalPrefix(@NativeType(value="LLVMOrcLLJITRef") long J) {
        long __functionAddress = Functions.OrcLLJITGetGlobalPrefix;
        if (Checks.CHECKS) {
            Checks.check((long)J);
        }
        return JNI.invokePB((long)J, (long)__functionAddress);
    }

    public static long nLLVMOrcLLJITMangleAndIntern(long J, long UnmangledName) {
        long __functionAddress = Functions.OrcLLJITMangleAndIntern;
        if (Checks.CHECKS) {
            Checks.check((long)J);
        }
        return JNI.invokePPP((long)J, (long)UnmangledName, (long)__functionAddress);
    }

    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
    public static long LLVMOrcLLJITMangleAndIntern(@NativeType(value="LLVMOrcLLJITRef") long J, @NativeType(value="char const *") ByteBuffer UnmangledName) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)UnmangledName);
        }
        return LLVMLLJIT.nLLVMOrcLLJITMangleAndIntern(J, MemoryUtil.memAddress((ByteBuffer)UnmangledName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
    public static long LLVMOrcLLJITMangleAndIntern(@NativeType(value="LLVMOrcLLJITRef") long J, @NativeType(value="char const *") CharSequence UnmangledName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(UnmangledName, true);
            long UnmangledNameEncoded = stack.getPointerAddress();
            long l = LLVMLLJIT.nLLVMOrcLLJITMangleAndIntern(J, UnmangledNameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcLLJITAddObjectFile(@NativeType(value="LLVMOrcLLJITRef") long J, @NativeType(value="LLVMOrcJITDylibRef") long JD, @NativeType(value="LLVMMemoryBufferRef") long ObjBuffer) {
        long __functionAddress = Functions.OrcLLJITAddObjectFile;
        if (Checks.CHECKS) {
            Checks.check((long)J);
            Checks.check((long)JD);
            Checks.check((long)ObjBuffer);
        }
        return JNI.invokePPPP((long)J, (long)JD, (long)ObjBuffer, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcLLJITAddObjectFileWithRT(@NativeType(value="LLVMOrcLLJITRef") long J, @NativeType(value="LLVMOrcResourceTrackerRef") long RT, @NativeType(value="LLVMMemoryBufferRef") long ObjBuffer) {
        long __functionAddress = Functions.OrcLLJITAddObjectFileWithRT;
        if (Checks.CHECKS) {
            Checks.check((long)J);
            Checks.check((long)RT);
            Checks.check((long)ObjBuffer);
        }
        return JNI.invokePPPP((long)J, (long)RT, (long)ObjBuffer, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcLLJITAddLLVMIRModule(@NativeType(value="LLVMOrcLLJITRef") long J, @NativeType(value="LLVMOrcJITDylibRef") long JD, @NativeType(value="LLVMOrcThreadSafeModuleRef") long TSM) {
        long __functionAddress = Functions.OrcLLJITAddLLVMIRModule;
        if (Checks.CHECKS) {
            Checks.check((long)J);
            Checks.check((long)JD);
            Checks.check((long)TSM);
        }
        return JNI.invokePPPP((long)J, (long)JD, (long)TSM, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcLLJITAddLLVMIRModuleWithRT(@NativeType(value="LLVMOrcLLJITRef") long J, @NativeType(value="LLVMOrcResourceTrackerRef") long JD, @NativeType(value="LLVMOrcThreadSafeModuleRef") long TSM) {
        long __functionAddress = Functions.OrcLLJITAddLLVMIRModuleWithRT;
        if (Checks.CHECKS) {
            Checks.check((long)J);
            Checks.check((long)JD);
            Checks.check((long)TSM);
        }
        return JNI.invokePPPP((long)J, (long)JD, (long)TSM, (long)__functionAddress);
    }

    public static long nLLVMOrcLLJITLookup(long J, long Result, long Name) {
        long __functionAddress = Functions.OrcLLJITLookup;
        if (Checks.CHECKS) {
            Checks.check((long)J);
        }
        return JNI.invokePPPP((long)J, (long)Result, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcLLJITLookup(@NativeType(value="LLVMOrcLLJITRef") long J, @NativeType(value="LLVMOrcExecutorAddress *") LongBuffer Result, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)Result, (int)1);
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMLLJIT.nLLVMOrcLLJITLookup(J, MemoryUtil.memAddress((LongBuffer)Result), MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcLLJITLookup(@NativeType(value="LLVMOrcLLJITRef") long J, @NativeType(value="LLVMOrcExecutorAddress *") LongBuffer Result, @NativeType(value="char const *") CharSequence Name) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)Result, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMLLJIT.nLLVMOrcLLJITLookup(J, MemoryUtil.memAddress((LongBuffer)Result), NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMOrcObjectLayerRef")
    public static long LLVMOrcLLJITGetObjLinkingLayer(@NativeType(value="LLVMOrcLLJITRef") long J) {
        long __functionAddress = Functions.OrcLLJITGetObjLinkingLayer;
        if (Checks.CHECKS) {
            Checks.check((long)J);
        }
        return JNI.invokePP((long)J, (long)__functionAddress);
    }

    @NativeType(value="LLVMOrcObjectTransformLayerRef")
    public static long LLVMOrcLLJITGetObjTransformLayer(@NativeType(value="LLVMOrcLLJITRef") long J) {
        long __functionAddress = Functions.OrcLLJITGetObjTransformLayer;
        if (Checks.CHECKS) {
            Checks.check((long)J);
        }
        return JNI.invokePP((long)J, (long)__functionAddress);
    }

    @NativeType(value="LLVMOrcIRTransformLayerRef")
    public static long LLVMOrcLLJITGetIRTransformLayer(@NativeType(value="LLVMOrcLLJITRef") long J) {
        long __functionAddress = Functions.OrcLLJITGetIRTransformLayer;
        if (Checks.CHECKS) {
            Checks.check((long)J);
        }
        return JNI.invokePP((long)J, (long)__functionAddress);
    }

    public static long nLLVMOrcLLJITGetDataLayoutStr(long J) {
        long __functionAddress = Functions.OrcLLJITGetDataLayoutStr;
        if (Checks.CHECKS) {
            Checks.check((long)J);
        }
        return JNI.invokePP((long)J, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String LLVMOrcLLJITGetDataLayoutStr(@NativeType(value="LLVMOrcLLJITRef") long J) {
        long __result = LLVMLLJIT.nLLVMOrcLLJITGetDataLayoutStr(J);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static final class Functions {
        public static final long OrcCreateLLJITBuilder = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcCreateLLJITBuilder");
        public static final long OrcDisposeLLJITBuilder = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcDisposeLLJITBuilder");
        public static final long OrcLLJITBuilderSetJITTargetMachineBuilder = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcLLJITBuilderSetJITTargetMachineBuilder");
        public static final long OrcLLJITBuilderSetObjectLinkingLayerCreator = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcLLJITBuilderSetObjectLinkingLayerCreator");
        public static final long OrcCreateLLJIT = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcCreateLLJIT");
        public static final long OrcDisposeLLJIT = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcDisposeLLJIT");
        public static final long OrcLLJITGetExecutionSession = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcLLJITGetExecutionSession");
        public static final long OrcLLJITGetMainJITDylib = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcLLJITGetMainJITDylib");
        public static final long OrcLLJITGetTripleString = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcLLJITGetTripleString");
        public static final long OrcLLJITGetGlobalPrefix = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcLLJITGetGlobalPrefix");
        public static final long OrcLLJITMangleAndIntern = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcLLJITMangleAndIntern");
        public static final long OrcLLJITAddObjectFile = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcLLJITAddObjectFile");
        public static final long OrcLLJITAddObjectFileWithRT = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcLLJITAddObjectFileWithRT");
        public static final long OrcLLJITAddLLVMIRModule = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcLLJITAddLLVMIRModule");
        public static final long OrcLLJITAddLLVMIRModuleWithRT = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcLLJITAddLLVMIRModuleWithRT");
        public static final long OrcLLJITLookup = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcLLJITLookup");
        public static final long OrcLLJITGetObjLinkingLayer = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcLLJITGetObjLinkingLayer");
        public static final long OrcLLJITGetObjTransformLayer = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcLLJITGetObjTransformLayer");
        public static final long OrcLLJITGetIRTransformLayer = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcLLJITGetIRTransformLayer");
        public static final long OrcLLJITGetDataLayoutStr = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcLLJITGetDataLayoutStr");

        private Functions() {
        }
    }
}

