/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMOrcCLookupSetElement
extends Struct<LLVMOrcCLookupSetElement>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int LOOKUPFLAGS;

    protected LLVMOrcCLookupSetElement(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected LLVMOrcCLookupSetElement create(long address, @Nullable ByteBuffer container) {
        return new LLVMOrcCLookupSetElement(address, container);
    }

    public LLVMOrcCLookupSetElement(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LLVMOrcCLookupSetElement.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
    public long Name() {
        return LLVMOrcCLookupSetElement.nName(this.address());
    }

    @NativeType(value="LLVMOrcSymbolLookupFlags")
    public int LookupFlags() {
        return LLVMOrcCLookupSetElement.nLookupFlags(this.address());
    }

    public LLVMOrcCLookupSetElement Name(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long value) {
        LLVMOrcCLookupSetElement.nName(this.address(), value);
        return this;
    }

    public LLVMOrcCLookupSetElement LookupFlags(@NativeType(value="LLVMOrcSymbolLookupFlags") int value) {
        LLVMOrcCLookupSetElement.nLookupFlags(this.address(), value);
        return this;
    }

    public LLVMOrcCLookupSetElement set(long Name, int LookupFlags) {
        this.Name(Name);
        this.LookupFlags(LookupFlags);
        return this;
    }

    public LLVMOrcCLookupSetElement set(LLVMOrcCLookupSetElement src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static LLVMOrcCLookupSetElement malloc() {
        return new LLVMOrcCLookupSetElement(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static LLVMOrcCLookupSetElement calloc() {
        return new LLVMOrcCLookupSetElement(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static LLVMOrcCLookupSetElement create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new LLVMOrcCLookupSetElement(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static LLVMOrcCLookupSetElement create(long address) {
        return new LLVMOrcCLookupSetElement(address, null);
    }

    public static @Nullable LLVMOrcCLookupSetElement createSafe(long address) {
        return address == 0L ? null : new LLVMOrcCLookupSetElement(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)LLVMOrcCLookupSetElement.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMOrcCLookupSetElement.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static LLVMOrcCLookupSetElement malloc(MemoryStack stack) {
        return new LLVMOrcCLookupSetElement(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LLVMOrcCLookupSetElement calloc(MemoryStack stack) {
        return new LLVMOrcCLookupSetElement(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nName(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NAME));
    }

    public static int nLookupFlags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)LOOKUPFLAGS));
    }

    public static void nName(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NAME), (long)Checks.check((long)value));
    }

    public static void nLookupFlags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)LOOKUPFLAGS), (int)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)NAME)));
    }

    static {
        Struct.Layout layout = LLVMOrcCLookupSetElement.__struct((Struct.Member[])new Struct.Member[]{LLVMOrcCLookupSetElement.__member((int)POINTER_SIZE), LLVMOrcCLookupSetElement.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        LOOKUPFLAGS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LLVMOrcCLookupSetElement, Buffer>
    implements NativeResource {
        private static final LLVMOrcCLookupSetElement ELEMENT_FACTORY = LLVMOrcCLookupSetElement.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected LLVMOrcCLookupSetElement getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
        public long Name() {
            return LLVMOrcCLookupSetElement.nName(this.address());
        }

        @NativeType(value="LLVMOrcSymbolLookupFlags")
        public int LookupFlags() {
            return LLVMOrcCLookupSetElement.nLookupFlags(this.address());
        }

        public Buffer Name(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long value) {
            LLVMOrcCLookupSetElement.nName(this.address(), value);
            return this;
        }

        public Buffer LookupFlags(@NativeType(value="LLVMOrcSymbolLookupFlags") int value) {
            LLVMOrcCLookupSetElement.nLookupFlags(this.address(), value);
            return this;
        }
    }
}

