/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.SharedLibrary;

public class LLVMRemarks {
    public static final int REMARKS_API_VERSION = 1;
    public static final int LLVMRemarkTypeUnknown = 0;
    public static final int LLVMRemarkTypePassed = 1;
    public static final int LLVMRemarkTypeMissed = 2;
    public static final int LLVMRemarkTypeAnalysis = 3;
    public static final int LLVMRemarkTypeAnalysisFPCommute = 4;
    public static final int LLVMRemarkTypeAnalysisAliasing = 5;
    public static final int LLVMRemarkTypeFailure = 6;

    protected LLVMRemarks() {
        throw new UnsupportedOperationException();
    }

    public static long nLLVMRemarkStringGetData(long String2) {
        long __functionAddress = Functions.RemarkStringGetData;
        if (Checks.CHECKS) {
            Checks.check((long)String2);
        }
        return JNI.invokePP((long)String2, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String LLVMRemarkStringGetData(@NativeType(value="LLVMRemarkStringRef") long String2) {
        long __result = LLVMRemarks.nLLVMRemarkStringGetData(String2);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="uint32_t")
    public static int LLVMRemarkStringGetLen(@NativeType(value="LLVMRemarkStringRef") long String2) {
        long __functionAddress = Functions.RemarkStringGetLen;
        if (Checks.CHECKS) {
            Checks.check((long)String2);
        }
        return JNI.invokePI((long)String2, (long)__functionAddress);
    }

    @NativeType(value="LLVMRemarkStringRef")
    public static long LLVMRemarkDebugLocGetSourceFilePath(@NativeType(value="LLVMRemarkDebugLocRef") long DL) {
        long __functionAddress = Functions.RemarkDebugLocGetSourceFilePath;
        if (Checks.CHECKS) {
            Checks.check((long)DL);
        }
        return JNI.invokePP((long)DL, (long)__functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int LLVMRemarkDebugLocGetSourceLine(@NativeType(value="LLVMRemarkDebugLocRef") long DL) {
        long __functionAddress = Functions.RemarkDebugLocGetSourceLine;
        if (Checks.CHECKS) {
            Checks.check((long)DL);
        }
        return JNI.invokePI((long)DL, (long)__functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int LLVMRemarkDebugLocGetSourceColumn(@NativeType(value="LLVMRemarkDebugLocRef") long DL) {
        long __functionAddress = Functions.RemarkDebugLocGetSourceColumn;
        if (Checks.CHECKS) {
            Checks.check((long)DL);
        }
        return JNI.invokePI((long)DL, (long)__functionAddress);
    }

    @NativeType(value="LLVMRemarkStringRef")
    public static long LLVMRemarkArgGetKey(@NativeType(value="LLVMRemarkArgRef") long Arg) {
        long __functionAddress = Functions.RemarkArgGetKey;
        if (Checks.CHECKS) {
            Checks.check((long)Arg);
        }
        return JNI.invokePP((long)Arg, (long)__functionAddress);
    }

    @NativeType(value="LLVMRemarkStringRef")
    public static long LLVMRemarkArgGetValue(@NativeType(value="LLVMRemarkArgRef") long Arg) {
        long __functionAddress = Functions.RemarkArgGetValue;
        if (Checks.CHECKS) {
            Checks.check((long)Arg);
        }
        return JNI.invokePP((long)Arg, (long)__functionAddress);
    }

    @NativeType(value="LLVMRemarkDebugLocRef")
    public static long LLVMRemarkArgGetDebugLoc(@NativeType(value="LLVMRemarkArgRef") long Arg) {
        long __functionAddress = Functions.RemarkArgGetDebugLoc;
        if (Checks.CHECKS) {
            Checks.check((long)Arg);
        }
        return JNI.invokePP((long)Arg, (long)__functionAddress);
    }

    public static void LLVMRemarkEntryDispose(@NativeType(value="LLVMRemarkEntryRef") long Remark) {
        long __functionAddress = Functions.RemarkEntryDispose;
        if (Checks.CHECKS) {
            Checks.check((long)Remark);
        }
        JNI.invokePV((long)Remark, (long)__functionAddress);
    }

    @NativeType(value="enum LLVMRemarkType")
    public static int LLVMRemarkEntryGetType(@NativeType(value="LLVMRemarkEntryRef") long Remark) {
        long __functionAddress = Functions.RemarkEntryGetType;
        if (Checks.CHECKS) {
            Checks.check((long)Remark);
        }
        return JNI.invokePI((long)Remark, (long)__functionAddress);
    }

    @NativeType(value="LLVMRemarkStringRef")
    public static long LLVMRemarkEntryGetPassName(@NativeType(value="LLVMRemarkEntryRef") long Remark) {
        long __functionAddress = Functions.RemarkEntryGetPassName;
        if (Checks.CHECKS) {
            Checks.check((long)Remark);
        }
        return JNI.invokePP((long)Remark, (long)__functionAddress);
    }

    @NativeType(value="LLVMRemarkStringRef")
    public static long LLVMRemarkEntryGetRemarkName(@NativeType(value="LLVMRemarkEntryRef") long Remark) {
        long __functionAddress = Functions.RemarkEntryGetRemarkName;
        if (Checks.CHECKS) {
            Checks.check((long)Remark);
        }
        return JNI.invokePP((long)Remark, (long)__functionAddress);
    }

    @NativeType(value="LLVMRemarkStringRef")
    public static long LLVMRemarkEntryGetFunctionName(@NativeType(value="LLVMRemarkEntryRef") long Remark) {
        long __functionAddress = Functions.RemarkEntryGetFunctionName;
        if (Checks.CHECKS) {
            Checks.check((long)Remark);
        }
        return JNI.invokePP((long)Remark, (long)__functionAddress);
    }

    @NativeType(value="LLVMRemarkDebugLocRef")
    public static long LLVMRemarkEntryGetDebugLoc(@NativeType(value="LLVMRemarkEntryRef") long Remark) {
        long __functionAddress = Functions.RemarkEntryGetDebugLoc;
        if (Checks.CHECKS) {
            Checks.check((long)Remark);
        }
        return JNI.invokePP((long)Remark, (long)__functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long LLVMRemarkEntryGetHotness(@NativeType(value="LLVMRemarkEntryRef") long Remark) {
        long __functionAddress = Functions.RemarkEntryGetHotness;
        if (Checks.CHECKS) {
            Checks.check((long)Remark);
        }
        return JNI.invokePJ((long)Remark, (long)__functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int LLVMRemarkEntryGetNumArgs(@NativeType(value="LLVMRemarkEntryRef") long Remark) {
        long __functionAddress = Functions.RemarkEntryGetNumArgs;
        if (Checks.CHECKS) {
            Checks.check((long)Remark);
        }
        return JNI.invokePI((long)Remark, (long)__functionAddress);
    }

    @NativeType(value="LLVMRemarkArgRef")
    public static long LLVMRemarkEntryGetFirstArg(@NativeType(value="LLVMRemarkEntryRef") long Remark) {
        long __functionAddress = Functions.RemarkEntryGetFirstArg;
        if (Checks.CHECKS) {
            Checks.check((long)Remark);
        }
        return JNI.invokePP((long)Remark, (long)__functionAddress);
    }

    @NativeType(value="LLVMRemarkArgRef")
    public static long LLVMRemarkEntryGetNextArg(@NativeType(value="LLVMRemarkArgRef") long It, @NativeType(value="LLVMRemarkEntryRef") long Remark) {
        long __functionAddress = Functions.RemarkEntryGetNextArg;
        if (Checks.CHECKS) {
            Checks.check((long)It);
            Checks.check((long)Remark);
        }
        return JNI.invokePPP((long)It, (long)Remark, (long)__functionAddress);
    }

    public static long nLLVMRemarkParserCreateYAML(long Buf, long Size) {
        long __functionAddress = Functions.RemarkParserCreateYAML;
        return JNI.invokePJP((long)Buf, (long)Size, (long)__functionAddress);
    }

    @NativeType(value="LLVMRemarkParserRef")
    public static long LLVMRemarkParserCreateYAML(@NativeType(value="void const *") ByteBuffer Buf) {
        return LLVMRemarks.nLLVMRemarkParserCreateYAML(MemoryUtil.memAddress((ByteBuffer)Buf), Buf.remaining());
    }

    public static long nLLVMRemarkParserCreateBitstream(long Buf, long Size) {
        long __functionAddress = Functions.RemarkParserCreateBitstream;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokePJP((long)Buf, (long)Size, (long)__functionAddress);
    }

    @NativeType(value="LLVMRemarkParserRef")
    public static long LLVMRemarkParserCreateBitstream(@NativeType(value="void const *") ByteBuffer Buf) {
        return LLVMRemarks.nLLVMRemarkParserCreateBitstream(MemoryUtil.memAddress((ByteBuffer)Buf), Buf.remaining());
    }

    @NativeType(value="LLVMRemarkEntryRef")
    public static long LLVMRemarkParserGetNext(@NativeType(value="LLVMRemarkParserRef") long Parser) {
        long __functionAddress = Functions.RemarkParserGetNext;
        if (Checks.CHECKS) {
            Checks.check((long)Parser);
        }
        return JNI.invokePP((long)Parser, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMRemarkParserHasError(@NativeType(value="LLVMRemarkParserRef") long Parser) {
        long __functionAddress = Functions.RemarkParserHasError;
        if (Checks.CHECKS) {
            Checks.check((long)Parser);
        }
        return JNI.invokePI((long)Parser, (long)__functionAddress) != 0;
    }

    public static long nLLVMRemarkParserGetErrorMessage(long Parser) {
        long __functionAddress = Functions.RemarkParserGetErrorMessage;
        if (Checks.CHECKS) {
            Checks.check((long)Parser);
        }
        return JNI.invokePP((long)Parser, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String LLVMRemarkParserGetErrorMessage(@NativeType(value="LLVMRemarkParserRef") long Parser) {
        long __result = LLVMRemarks.nLLVMRemarkParserGetErrorMessage(Parser);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static void LLVMRemarkParserDispose(@NativeType(value="LLVMRemarkParserRef") long Parser) {
        long __functionAddress = Functions.RemarkParserDispose;
        if (Checks.CHECKS) {
            Checks.check((long)Parser);
        }
        JNI.invokePV((long)Parser, (long)__functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int LLVMRemarkVersion() {
        long __functionAddress = Functions.RemarkVersion;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokeI((long)__functionAddress);
    }

    public static final class Functions {
        public static final long RemarkStringGetData = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRemarkStringGetData");
        public static final long RemarkStringGetLen = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRemarkStringGetLen");
        public static final long RemarkDebugLocGetSourceFilePath = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRemarkDebugLocGetSourceFilePath");
        public static final long RemarkDebugLocGetSourceLine = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRemarkDebugLocGetSourceLine");
        public static final long RemarkDebugLocGetSourceColumn = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRemarkDebugLocGetSourceColumn");
        public static final long RemarkArgGetKey = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRemarkArgGetKey");
        public static final long RemarkArgGetValue = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRemarkArgGetValue");
        public static final long RemarkArgGetDebugLoc = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRemarkArgGetDebugLoc");
        public static final long RemarkEntryDispose = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRemarkEntryDispose");
        public static final long RemarkEntryGetType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRemarkEntryGetType");
        public static final long RemarkEntryGetPassName = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRemarkEntryGetPassName");
        public static final long RemarkEntryGetRemarkName = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRemarkEntryGetRemarkName");
        public static final long RemarkEntryGetFunctionName = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRemarkEntryGetFunctionName");
        public static final long RemarkEntryGetDebugLoc = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRemarkEntryGetDebugLoc");
        public static final long RemarkEntryGetHotness = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRemarkEntryGetHotness");
        public static final long RemarkEntryGetNumArgs = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRemarkEntryGetNumArgs");
        public static final long RemarkEntryGetFirstArg = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRemarkEntryGetFirstArg");
        public static final long RemarkEntryGetNextArg = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRemarkEntryGetNextArg");
        public static final long RemarkParserCreateYAML = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRemarkParserCreateYAML");
        public static final long RemarkParserCreateBitstream = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMRemarkParserCreateBitstream");
        public static final long RemarkParserGetNext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRemarkParserGetNext");
        public static final long RemarkParserHasError = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRemarkParserHasError");
        public static final long RemarkParserGetErrorMessage = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRemarkParserGetErrorMessage");
        public static final long RemarkParserDispose = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMRemarkParserDispose");
        public static final long RemarkVersion = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMRemarkVersion");

        private Functions() {
        }
    }
}

