/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.llvm.LLVMMustPreserveI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.SharedLibrary;

public class LLVMTransforms {
    protected LLVMTransforms() {
        throw new UnsupportedOperationException();
    }

    public static void LLVMAddAggressiveInstCombinerPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddAggressiveInstCombinerPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddCoroEarlyPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddCoroEarlyPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddCoroSplitPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddCoroSplitPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddCoroElidePass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddCoroElidePass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddCoroCleanupPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddCoroCleanupPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMPassManagerBuilderAddCoroutinePassesToExtensionPoints(@NativeType(value="LLVMPassManagerBuilderRef") long PMB) {
        long __functionAddress = Functions.PassManagerBuilderAddCoroutinePassesToExtensionPoints;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PMB);
        }
        JNI.invokePV((long)PMB, (long)__functionAddress);
    }

    public static void LLVMAddInstructionCombiningPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddInstructionCombiningPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddInstructionSimplifyPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddInstructionSimplifyPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddArgumentPromotionPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddArgumentPromotionPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddConstantMergePass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddConstantMergePass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddMergeFunctionsPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddMergeFunctionsPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddCalledValuePropagationPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddCalledValuePropagationPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddDeadArgEliminationPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddDeadArgEliminationPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddFunctionAttrsPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddFunctionAttrsPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddFunctionInliningPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddFunctionInliningPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddAlwaysInlinerPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddAlwaysInlinerPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddGlobalDCEPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddGlobalDCEPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddGlobalOptimizerPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddGlobalOptimizerPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddIPConstantPropagationPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddIPConstantPropagationPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddPruneEHPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddPruneEHPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddIPSCCPPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddIPSCCPPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddInternalizePass(@NativeType(value="LLVMPassManagerRef") long PM, @NativeType(value="unsigned int") int AllButMain) {
        long __functionAddress = Functions.AddInternalizePass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (int)AllButMain, (long)__functionAddress);
    }

    public static void nLLVMAddInternalizePassWithMustPreservePredicate(long PM, long Context, long MustPreserve) {
        long __functionAddress = Functions.AddInternalizePassWithMustPreservePredicate;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
            Checks.check((long)Context);
        }
        JNI.invokePPPV((long)PM, (long)Context, (long)MustPreserve, (long)__functionAddress);
    }

    public static void LLVMAddInternalizePassWithMustPreservePredicate(@NativeType(value="LLVMPassManagerRef") long PM, @NativeType(value="void *") long Context, @NativeType(value="LLVMBool (*) (LLVMValueRef, void *)") LLVMMustPreserveI MustPreserve) {
        LLVMTransforms.nLLVMAddInternalizePassWithMustPreservePredicate(PM, Context, MustPreserve.address());
    }

    public static void LLVMAddStripDeadPrototypesPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddStripDeadPrototypesPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddStripSymbolsPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddStripSymbolsPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static long nLLVMRunPasses(long M, long Passes, long TM, long Options) {
        long __functionAddress = Functions.RunPasses;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)M);
            Checks.check((long)TM);
            Checks.check((long)Options);
        }
        return JNI.invokePPPPP((long)M, (long)Passes, (long)TM, (long)Options, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMRunPasses(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Passes, @NativeType(value="LLVMTargetMachineRef") long TM, @NativeType(value="LLVMPassBuilderOptionsRef") long Options) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Passes);
        }
        return LLVMTransforms.nLLVMRunPasses(M, MemoryUtil.memAddress((ByteBuffer)Passes), TM, Options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMErrorRef")
    public static long LLVMRunPasses(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Passes, @NativeType(value="LLVMTargetMachineRef") long TM, @NativeType(value="LLVMPassBuilderOptionsRef") long Options) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Passes, true);
            long PassesEncoded = stack.getPointerAddress();
            long l = LLVMTransforms.nLLVMRunPasses(M, PassesEncoded, TM, Options);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMPassBuilderOptionsRef")
    public static long LLVMCreatePassBuilderOptions() {
        long __functionAddress = Functions.CreatePassBuilderOptions;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokeP((long)__functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetVerifyEach(@NativeType(value="LLVMPassBuilderOptionsRef") long Options, @NativeType(value="LLVMBool") boolean VerifyEach) {
        long __functionAddress = Functions.PassBuilderOptionsSetVerifyEach;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Options);
        }
        JNI.invokePV((long)Options, (int)(VerifyEach ? 1 : 0), (long)__functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetDebugLogging(@NativeType(value="LLVMPassBuilderOptionsRef") long Options, @NativeType(value="LLVMBool") boolean DebugLogging) {
        long __functionAddress = Functions.PassBuilderOptionsSetDebugLogging;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Options);
        }
        JNI.invokePV((long)Options, (int)(DebugLogging ? 1 : 0), (long)__functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetLoopInterleaving(@NativeType(value="LLVMPassBuilderOptionsRef") long Options, @NativeType(value="LLVMBool") boolean LoopInterleaving) {
        long __functionAddress = Functions.PassBuilderOptionsSetLoopInterleaving;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Options);
        }
        JNI.invokePV((long)Options, (int)(LoopInterleaving ? 1 : 0), (long)__functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetLoopVectorization(@NativeType(value="LLVMPassBuilderOptionsRef") long Options, @NativeType(value="LLVMBool") boolean LoopVectorization) {
        long __functionAddress = Functions.PassBuilderOptionsSetLoopVectorization;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Options);
        }
        JNI.invokePV((long)Options, (int)(LoopVectorization ? 1 : 0), (long)__functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetSLPVectorization(@NativeType(value="LLVMPassBuilderOptionsRef") long Options, @NativeType(value="LLVMBool") boolean SLPVectorization) {
        long __functionAddress = Functions.PassBuilderOptionsSetSLPVectorization;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Options);
        }
        JNI.invokePV((long)Options, (int)(SLPVectorization ? 1 : 0), (long)__functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetLoopUnrolling(@NativeType(value="LLVMPassBuilderOptionsRef") long Options, @NativeType(value="LLVMBool") boolean LoopUnrolling) {
        long __functionAddress = Functions.PassBuilderOptionsSetLoopUnrolling;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Options);
        }
        JNI.invokePV((long)Options, (int)(LoopUnrolling ? 1 : 0), (long)__functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetForgetAllSCEVInLoopUnroll(@NativeType(value="LLVMPassBuilderOptionsRef") long Options, @NativeType(value="LLVMBool") boolean ForgetAllSCEVInLoopUnroll) {
        long __functionAddress = Functions.PassBuilderOptionsSetForgetAllSCEVInLoopUnroll;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Options);
        }
        JNI.invokePV((long)Options, (int)(ForgetAllSCEVInLoopUnroll ? 1 : 0), (long)__functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetLicmMssaOptCap(@NativeType(value="LLVMPassBuilderOptionsRef") long Options, @NativeType(value="unsigned") int LicmMssaOptCap) {
        long __functionAddress = Functions.PassBuilderOptionsSetLicmMssaOptCap;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Options);
        }
        JNI.invokePV((long)Options, (int)LicmMssaOptCap, (long)__functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetLicmMssaNoAccForPromotionCap(@NativeType(value="LLVMPassBuilderOptionsRef") long Options, @NativeType(value="unsigned") int LicmMssaNoAccForPromotionCap) {
        long __functionAddress = Functions.PassBuilderOptionsSetLicmMssaNoAccForPromotionCap;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Options);
        }
        JNI.invokePV((long)Options, (int)LicmMssaNoAccForPromotionCap, (long)__functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetCallGraphProfile(@NativeType(value="LLVMPassBuilderOptionsRef") long Options, @NativeType(value="LLVMBool") boolean CallGraphProfile) {
        long __functionAddress = Functions.PassBuilderOptionsSetCallGraphProfile;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Options);
        }
        JNI.invokePV((long)Options, (int)(CallGraphProfile ? 1 : 0), (long)__functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetMergeFunctions(@NativeType(value="LLVMPassBuilderOptionsRef") long Options, @NativeType(value="LLVMBool") boolean MergeFunctions) {
        long __functionAddress = Functions.PassBuilderOptionsSetMergeFunctions;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Options);
        }
        JNI.invokePV((long)Options, (int)(MergeFunctions ? 1 : 0), (long)__functionAddress);
    }

    public static void LLVMPassBuilderOptionsSetInlinerThreshold(@NativeType(value="LLVMPassBuilderOptionsRef") long Options, int Threshold) {
        long __functionAddress = Functions.PassBuilderOptionsSetInlinerThreshold;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Options);
        }
        JNI.invokePV((long)Options, (int)Threshold, (long)__functionAddress);
    }

    public static void LLVMDisposePassBuilderOptions(@NativeType(value="LLVMPassBuilderOptionsRef") long Options) {
        long __functionAddress = Functions.DisposePassBuilderOptions;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Options);
        }
        JNI.invokePV((long)Options, (long)__functionAddress);
    }

    @NativeType(value="LLVMPassManagerBuilderRef")
    public static long LLVMPassManagerBuilderCreate() {
        long __functionAddress = Functions.PassManagerBuilderCreate;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokeP((long)__functionAddress);
    }

    public static void LLVMPassManagerBuilderDispose(@NativeType(value="LLVMPassManagerBuilderRef") long PMB) {
        long __functionAddress = Functions.PassManagerBuilderDispose;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PMB);
        }
        JNI.invokePV((long)PMB, (long)__functionAddress);
    }

    public static void LLVMPassManagerBuilderSetOptLevel(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="unsigned int") int OptLevel) {
        long __functionAddress = Functions.PassManagerBuilderSetOptLevel;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PMB);
        }
        JNI.invokePV((long)PMB, (int)OptLevel, (long)__functionAddress);
    }

    public static void LLVMPassManagerBuilderSetSizeLevel(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="unsigned int") int SizeLevel) {
        long __functionAddress = Functions.PassManagerBuilderSetSizeLevel;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PMB);
        }
        JNI.invokePV((long)PMB, (int)SizeLevel, (long)__functionAddress);
    }

    public static void LLVMPassManagerBuilderSetDisableUnitAtATime(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="LLVMBool") boolean Value) {
        long __functionAddress = Functions.PassManagerBuilderSetDisableUnitAtATime;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PMB);
        }
        JNI.invokePV((long)PMB, (int)(Value ? 1 : 0), (long)__functionAddress);
    }

    public static void LLVMPassManagerBuilderSetDisableUnrollLoops(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="LLVMBool") boolean Value) {
        long __functionAddress = Functions.PassManagerBuilderSetDisableUnrollLoops;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PMB);
        }
        JNI.invokePV((long)PMB, (int)(Value ? 1 : 0), (long)__functionAddress);
    }

    public static void LLVMPassManagerBuilderSetDisableSimplifyLibCalls(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="LLVMBool") boolean Value) {
        long __functionAddress = Functions.PassManagerBuilderSetDisableSimplifyLibCalls;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PMB);
        }
        JNI.invokePV((long)PMB, (int)(Value ? 1 : 0), (long)__functionAddress);
    }

    public static void LLVMPassManagerBuilderUseInlinerWithThreshold(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="unsigned int") int Threshold) {
        long __functionAddress = Functions.PassManagerBuilderUseInlinerWithThreshold;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PMB);
        }
        JNI.invokePV((long)PMB, (int)Threshold, (long)__functionAddress);
    }

    public static void LLVMPassManagerBuilderPopulateFunctionPassManager(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.PassManagerBuilderPopulateFunctionPassManager;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PMB);
            Checks.check((long)PM);
        }
        JNI.invokePPV((long)PMB, (long)PM, (long)__functionAddress);
    }

    public static void LLVMPassManagerBuilderPopulateModulePassManager(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.PassManagerBuilderPopulateModulePassManager;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PMB);
            Checks.check((long)PM);
        }
        JNI.invokePPV((long)PMB, (long)PM, (long)__functionAddress);
    }

    public static void LLVMPassManagerBuilderPopulateLTOPassManager(@NativeType(value="LLVMPassManagerBuilderRef") long PMB, @NativeType(value="LLVMPassManagerRef") long PM, @NativeType(value="LLVMBool") boolean Internalize, @NativeType(value="LLVMBool") boolean RunInliner) {
        long __functionAddress = Functions.PassManagerBuilderPopulateLTOPassManager;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PMB);
            Checks.check((long)PM);
        }
        JNI.invokePPV((long)PMB, (long)PM, (int)(Internalize ? 1 : 0), (int)(RunInliner ? 1 : 0), (long)__functionAddress);
    }

    public static void LLVMAddAggressiveDCEPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddAggressiveDCEPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddDCEPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddDCEPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddBitTrackingDCEPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddBitTrackingDCEPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddAlignmentFromAssumptionsPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddAlignmentFromAssumptionsPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddCFGSimplificationPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddCFGSimplificationPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddDeadStoreEliminationPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddDeadStoreEliminationPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddScalarizerPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddScalarizerPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddMergedLoadStoreMotionPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddMergedLoadStoreMotionPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddGVNPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddGVNPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddNewGVNPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddNewGVNPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddIndVarSimplifyPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddIndVarSimplifyPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddJumpThreadingPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddJumpThreadingPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddLICMPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLICMPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddLoopDeletionPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLoopDeletionPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddLoopIdiomPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLoopIdiomPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddLoopRotatePass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLoopRotatePass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddLoopRerollPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLoopRerollPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddLoopUnrollPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLoopUnrollPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddLoopUnrollAndJamPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLoopUnrollAndJamPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddLoopUnswitchPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLoopUnswitchPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddLowerAtomicPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLowerAtomicPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddMemCpyOptPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddMemCpyOptPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddPartiallyInlineLibCallsPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddPartiallyInlineLibCallsPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddReassociatePass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddReassociatePass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddSCCPPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddSCCPPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddScalarReplAggregatesPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddScalarReplAggregatesPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddScalarReplAggregatesPassSSA(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddScalarReplAggregatesPassSSA;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddScalarReplAggregatesPassWithThreshold(@NativeType(value="LLVMPassManagerRef") long PM, int Threshold) {
        long __functionAddress = Functions.AddScalarReplAggregatesPassWithThreshold;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (int)Threshold, (long)__functionAddress);
    }

    public static void LLVMAddSimplifyLibCallsPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddSimplifyLibCallsPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddTailCallEliminationPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddTailCallEliminationPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddConstantPropagationPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddConstantPropagationPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddDemoteMemoryToRegisterPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddDemoteMemoryToRegisterPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddVerifierPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddVerifierPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddCorrelatedValuePropagationPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddCorrelatedValuePropagationPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddEarlyCSEPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddEarlyCSEPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddEarlyCSEMemSSAPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddEarlyCSEMemSSAPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddLowerExpectIntrinsicPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLowerExpectIntrinsicPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddLowerConstantIntrinsicsPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLowerConstantIntrinsicsPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddTypeBasedAliasAnalysisPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddTypeBasedAliasAnalysisPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddScopedNoAliasAAPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddScopedNoAliasAAPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddBasicAliasAnalysisPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddBasicAliasAnalysisPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddUnifyFunctionExitNodesPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddUnifyFunctionExitNodesPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddLowerSwitchPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLowerSwitchPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddPromoteMemoryToRegisterPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddPromoteMemoryToRegisterPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddAddDiscriminatorsPass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddAddDiscriminatorsPass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddLoopVectorizePass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddLoopVectorizePass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static void LLVMAddSLPVectorizePass(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddSLPVectorizePass;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)PM);
        }
        JNI.invokePV((long)PM, (long)__functionAddress);
    }

    public static final class Functions {
        public static final long AddAggressiveInstCombinerPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddAggressiveInstCombinerPass");
        public static final long AddCoroEarlyPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddCoroEarlyPass");
        public static final long AddCoroSplitPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddCoroSplitPass");
        public static final long AddCoroElidePass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddCoroElidePass");
        public static final long AddCoroCleanupPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddCoroCleanupPass");
        public static final long PassManagerBuilderAddCoroutinePassesToExtensionPoints = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMPassManagerBuilderAddCoroutinePassesToExtensionPoints");
        public static final long AddInstructionCombiningPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddInstructionCombiningPass");
        public static final long AddInstructionSimplifyPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddInstructionSimplifyPass");
        public static final long AddArgumentPromotionPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddArgumentPromotionPass");
        public static final long AddConstantMergePass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddConstantMergePass");
        public static final long AddMergeFunctionsPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddMergeFunctionsPass");
        public static final long AddCalledValuePropagationPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddCalledValuePropagationPass");
        public static final long AddDeadArgEliminationPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddDeadArgEliminationPass");
        public static final long AddFunctionAttrsPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddFunctionAttrsPass");
        public static final long AddFunctionInliningPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddFunctionInliningPass");
        public static final long AddAlwaysInlinerPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddAlwaysInlinerPass");
        public static final long AddGlobalDCEPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddGlobalDCEPass");
        public static final long AddGlobalOptimizerPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddGlobalOptimizerPass");
        public static final long AddIPConstantPropagationPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddIPConstantPropagationPass");
        public static final long AddPruneEHPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddPruneEHPass");
        public static final long AddIPSCCPPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddIPSCCPPass");
        public static final long AddInternalizePass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddInternalizePass");
        public static final long AddInternalizePassWithMustPreservePredicate = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddInternalizePassWithMustPreservePredicate");
        public static final long AddStripDeadPrototypesPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddStripDeadPrototypesPass");
        public static final long AddStripSymbolsPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddStripSymbolsPass");
        public static final long RunPasses = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMRunPasses");
        public static final long CreatePassBuilderOptions = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMCreatePassBuilderOptions");
        public static final long PassBuilderOptionsSetVerifyEach = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMPassBuilderOptionsSetVerifyEach");
        public static final long PassBuilderOptionsSetDebugLogging = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMPassBuilderOptionsSetDebugLogging");
        public static final long PassBuilderOptionsSetLoopInterleaving = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMPassBuilderOptionsSetLoopInterleaving");
        public static final long PassBuilderOptionsSetLoopVectorization = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMPassBuilderOptionsSetLoopVectorization");
        public static final long PassBuilderOptionsSetSLPVectorization = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMPassBuilderOptionsSetSLPVectorization");
        public static final long PassBuilderOptionsSetLoopUnrolling = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMPassBuilderOptionsSetLoopUnrolling");
        public static final long PassBuilderOptionsSetForgetAllSCEVInLoopUnroll = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMPassBuilderOptionsSetForgetAllSCEVInLoopUnroll");
        public static final long PassBuilderOptionsSetLicmMssaOptCap = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMPassBuilderOptionsSetLicmMssaOptCap");
        public static final long PassBuilderOptionsSetLicmMssaNoAccForPromotionCap = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMPassBuilderOptionsSetLicmMssaNoAccForPromotionCap");
        public static final long PassBuilderOptionsSetCallGraphProfile = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMPassBuilderOptionsSetCallGraphProfile");
        public static final long PassBuilderOptionsSetMergeFunctions = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMPassBuilderOptionsSetMergeFunctions");
        public static final long PassBuilderOptionsSetInlinerThreshold = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMPassBuilderOptionsSetInlinerThreshold");
        public static final long DisposePassBuilderOptions = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMDisposePassBuilderOptions");
        public static final long PassManagerBuilderCreate = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMPassManagerBuilderCreate");
        public static final long PassManagerBuilderDispose = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMPassManagerBuilderDispose");
        public static final long PassManagerBuilderSetOptLevel = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMPassManagerBuilderSetOptLevel");
        public static final long PassManagerBuilderSetSizeLevel = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMPassManagerBuilderSetSizeLevel");
        public static final long PassManagerBuilderSetDisableUnitAtATime = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMPassManagerBuilderSetDisableUnitAtATime");
        public static final long PassManagerBuilderSetDisableUnrollLoops = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMPassManagerBuilderSetDisableUnrollLoops");
        public static final long PassManagerBuilderSetDisableSimplifyLibCalls = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMPassManagerBuilderSetDisableSimplifyLibCalls");
        public static final long PassManagerBuilderUseInlinerWithThreshold = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMPassManagerBuilderUseInlinerWithThreshold");
        public static final long PassManagerBuilderPopulateFunctionPassManager = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMPassManagerBuilderPopulateFunctionPassManager");
        public static final long PassManagerBuilderPopulateModulePassManager = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMPassManagerBuilderPopulateModulePassManager");
        public static final long PassManagerBuilderPopulateLTOPassManager = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMPassManagerBuilderPopulateLTOPassManager");
        public static final long AddAggressiveDCEPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddAggressiveDCEPass");
        public static final long AddDCEPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddDCEPass");
        public static final long AddBitTrackingDCEPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddBitTrackingDCEPass");
        public static final long AddAlignmentFromAssumptionsPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddAlignmentFromAssumptionsPass");
        public static final long AddCFGSimplificationPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddCFGSimplificationPass");
        public static final long AddDeadStoreEliminationPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddDeadStoreEliminationPass");
        public static final long AddScalarizerPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddScalarizerPass");
        public static final long AddMergedLoadStoreMotionPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddMergedLoadStoreMotionPass");
        public static final long AddGVNPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddGVNPass");
        public static final long AddNewGVNPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddNewGVNPass");
        public static final long AddIndVarSimplifyPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddIndVarSimplifyPass");
        public static final long AddJumpThreadingPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddJumpThreadingPass");
        public static final long AddLICMPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddLICMPass");
        public static final long AddLoopDeletionPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddLoopDeletionPass");
        public static final long AddLoopIdiomPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddLoopIdiomPass");
        public static final long AddLoopRotatePass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddLoopRotatePass");
        public static final long AddLoopRerollPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddLoopRerollPass");
        public static final long AddLoopUnrollPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddLoopUnrollPass");
        public static final long AddLoopUnrollAndJamPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddLoopUnrollAndJamPass");
        public static final long AddLoopUnswitchPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddLoopUnswitchPass");
        public static final long AddLowerAtomicPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddLowerAtomicPass");
        public static final long AddMemCpyOptPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddMemCpyOptPass");
        public static final long AddPartiallyInlineLibCallsPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddPartiallyInlineLibCallsPass");
        public static final long AddReassociatePass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddReassociatePass");
        public static final long AddSCCPPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddSCCPPass");
        public static final long AddScalarReplAggregatesPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddScalarReplAggregatesPass");
        public static final long AddScalarReplAggregatesPassSSA = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddScalarReplAggregatesPassSSA");
        public static final long AddScalarReplAggregatesPassWithThreshold = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddScalarReplAggregatesPassWithThreshold");
        public static final long AddSimplifyLibCallsPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddSimplifyLibCallsPass");
        public static final long AddTailCallEliminationPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddTailCallEliminationPass");
        public static final long AddConstantPropagationPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddConstantPropagationPass");
        public static final long AddDemoteMemoryToRegisterPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddDemoteMemoryToRegisterPass");
        public static final long AddVerifierPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddVerifierPass");
        public static final long AddCorrelatedValuePropagationPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddCorrelatedValuePropagationPass");
        public static final long AddEarlyCSEPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddEarlyCSEPass");
        public static final long AddEarlyCSEMemSSAPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddEarlyCSEMemSSAPass");
        public static final long AddLowerExpectIntrinsicPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddLowerExpectIntrinsicPass");
        public static final long AddLowerConstantIntrinsicsPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddLowerConstantIntrinsicsPass");
        public static final long AddTypeBasedAliasAnalysisPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddTypeBasedAliasAnalysisPass");
        public static final long AddScopedNoAliasAAPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddScopedNoAliasAAPass");
        public static final long AddBasicAliasAnalysisPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddBasicAliasAnalysisPass");
        public static final long AddUnifyFunctionExitNodesPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddUnifyFunctionExitNodesPass");
        public static final long AddLowerSwitchPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddLowerSwitchPass");
        public static final long AddPromoteMemoryToRegisterPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddPromoteMemoryToRegisterPass");
        public static final long AddAddDiscriminatorsPass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddAddDiscriminatorsPass");
        public static final long AddLoopVectorizePass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddLoopVectorizePass");
        public static final long AddSLPVectorizePass = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMAddSLPVectorizePass");

        private Functions() {
        }
    }
}

