/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lmdb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class MDBEnvInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ME_MAPADDR;
    public static final int ME_MAPSIZE;
    public static final int ME_LAST_PGNO;
    public static final int ME_LAST_TXNID;
    public static final int ME_MAXREADERS;
    public static final int ME_NUMREADERS;

    MDBEnvInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public MDBEnvInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), MDBEnvInfo.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public long me_mapaddr() {
        return MDBEnvInfo.nme_mapaddr(this.address());
    }

    public long me_mapsize() {
        return MDBEnvInfo.nme_mapsize(this.address());
    }

    public long me_last_pgno() {
        return MDBEnvInfo.nme_last_pgno(this.address());
    }

    public long me_last_txnid() {
        return MDBEnvInfo.nme_last_txnid(this.address());
    }

    public int me_maxreaders() {
        return MDBEnvInfo.nme_maxreaders(this.address());
    }

    public int me_numreaders() {
        return MDBEnvInfo.nme_numreaders(this.address());
    }

    public static MDBEnvInfo malloc() {
        return MDBEnvInfo.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static MDBEnvInfo calloc() {
        return MDBEnvInfo.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static MDBEnvInfo create() {
        return new MDBEnvInfo(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static MDBEnvInfo create(long address) {
        return address == 0L ? null : new MDBEnvInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return MDBEnvInfo.create(MemoryUtil.nmemAlloc((long)(capacity * SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return MDBEnvInfo.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer((int)(capacity * SIZEOF)));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static MDBEnvInfo mallocStack() {
        return MDBEnvInfo.mallocStack(MemoryStack.stackGet());
    }

    public static MDBEnvInfo callocStack() {
        return MDBEnvInfo.callocStack(MemoryStack.stackGet());
    }

    public static MDBEnvInfo mallocStack(MemoryStack stack) {
        return MDBEnvInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static MDBEnvInfo callocStack(MemoryStack stack) {
        return MDBEnvInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return MDBEnvInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return MDBEnvInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return MDBEnvInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return MDBEnvInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nme_mapaddr(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ME_MAPADDR));
    }

    public static long nme_mapsize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ME_MAPSIZE));
    }

    public static long nme_last_pgno(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ME_LAST_PGNO));
    }

    public static long nme_last_txnid(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ME_LAST_TXNID));
    }

    public static int nme_maxreaders(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ME_MAXREADERS));
    }

    public static int nme_numreaders(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ME_NUMREADERS));
    }

    static {
        Struct.Layout layout = MDBEnvInfo.__struct((Struct.Member[])new Struct.Member[]{MDBEnvInfo.__member((int)POINTER_SIZE), MDBEnvInfo.__member((int)POINTER_SIZE), MDBEnvInfo.__member((int)POINTER_SIZE), MDBEnvInfo.__member((int)POINTER_SIZE), MDBEnvInfo.__member((int)4), MDBEnvInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ME_MAPADDR = layout.offsetof(0);
        ME_MAPSIZE = layout.offsetof(1);
        ME_LAST_PGNO = layout.offsetof(2);
        ME_LAST_TXNID = layout.offsetof(3);
        ME_MAXREADERS = layout.offsetof(4);
        ME_NUMREADERS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<MDBEnvInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected MDBEnvInfo newInstance(long address) {
            return new MDBEnvInfo(address, this.container);
        }

        protected int sizeof() {
            return SIZEOF;
        }

        public long me_mapaddr() {
            return MDBEnvInfo.nme_mapaddr(this.address());
        }

        public long me_mapsize() {
            return MDBEnvInfo.nme_mapsize(this.address());
        }

        public long me_last_pgno() {
            return MDBEnvInfo.nme_last_pgno(this.address());
        }

        public long me_last_txnid() {
            return MDBEnvInfo.nme_last_txnid(this.address());
        }

        public int me_maxreaders() {
            return MDBEnvInfo.nme_maxreaders(this.address());
        }

        public int me_numreaders() {
            return MDBEnvInfo.nme_numreaders(this.address());
        }
    }
}

