/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lmdb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct MDB_val")
public class MDBVal
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MV_SIZE;
    public static final int MV_DATA;

    MDBVal(long address, ByteBuffer container) {
        super(address, container);
    }

    public MDBVal(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), MDBVal.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long mv_size() {
        return MDBVal.nmv_size(this.address());
    }

    @NativeType(value="void *")
    public ByteBuffer mv_data() {
        return MDBVal.nmv_data(this.address());
    }

    public MDBVal mv_size(@NativeType(value="size_t") long value) {
        MDBVal.nmv_size(this.address(), value);
        return this;
    }

    public MDBVal mv_data(@NativeType(value="void *") ByteBuffer value) {
        MDBVal.nmv_data(this.address(), value);
        return this;
    }

    public MDBVal set(long mv_size, ByteBuffer mv_data) {
        this.mv_size(mv_size);
        this.mv_data(mv_data);
        return this;
    }

    public MDBVal set(MDBVal src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static MDBVal malloc() {
        return MDBVal.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static MDBVal calloc() {
        return MDBVal.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static MDBVal create() {
        return new MDBVal(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static MDBVal create(long address) {
        return address == 0L ? null : new MDBVal(address, null);
    }

    public static Buffer malloc(int capacity) {
        return MDBVal.create(MDBVal.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return MDBVal.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(MDBVal.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static MDBVal mallocStack() {
        return MDBVal.mallocStack(MemoryStack.stackGet());
    }

    public static MDBVal callocStack() {
        return MDBVal.callocStack(MemoryStack.stackGet());
    }

    public static MDBVal mallocStack(MemoryStack stack) {
        return MDBVal.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static MDBVal callocStack(MemoryStack stack) {
        return MDBVal.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return MDBVal.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return MDBVal.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return MDBVal.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return MDBVal.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nmv_size(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)MV_SIZE));
    }

    public static ByteBuffer nmv_data(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)MV_DATA)), (int)((int)MDBVal.nmv_size(struct)));
    }

    public static void nmv_size(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MV_SIZE), (long)value);
    }

    public static void nmv_data(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MV_DATA), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
        if (value != null) {
            MDBVal.nmv_size(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = MDBVal.__struct((Struct.Member[])new Struct.Member[]{MDBVal.__member((int)POINTER_SIZE), MDBVal.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MV_SIZE = layout.offsetof(0);
        MV_DATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<MDBVal, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected MDBVal newInstance(long address) {
            return new MDBVal(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="size_t")
        public long mv_size() {
            return MDBVal.nmv_size(this.address());
        }

        @NativeType(value="void *")
        public ByteBuffer mv_data() {
            return MDBVal.nmv_data(this.address());
        }

        public Buffer mv_size(@NativeType(value="size_t") long value) {
            MDBVal.nmv_size(this.address(), value);
            return this;
        }

        public Buffer mv_data(@NativeType(value="void *") ByteBuffer value) {
            MDBVal.nmv_data(this.address(), value);
            return this;
        }
    }
}

