/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lmdb;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.util.lmdb.LibLMDB;
import org.lwjgl.util.lmdb.MDBCmpFuncI;
import org.lwjgl.util.lmdb.MDBEnvInfo;
import org.lwjgl.util.lmdb.MDBMsgFuncI;
import org.lwjgl.util.lmdb.MDBRelFuncI;
import org.lwjgl.util.lmdb.MDBStat;
import org.lwjgl.util.lmdb.MDBVal;

public class LMDB {
    public static final int MDB_VERSION_MAJOR = 0;
    public static final int MDB_VERSION_MINOR = 9;
    public static final int MDB_VERSION_PATCH = 30;
    public static final int MDB_VERSION_FULL = 589854;
    public static final String MDB_VERSION_DATE = "October 19, 2021";
    public static final String MDB_VERSION_STRING;
    public static final int MDB_FIXEDMAP = 1;
    public static final int MDB_NOSUBDIR = 16384;
    public static final int MDB_NOSYNC = 65536;
    public static final int MDB_RDONLY = 131072;
    public static final int MDB_NOMETASYNC = 262144;
    public static final int MDB_WRITEMAP = 524288;
    public static final int MDB_MAPASYNC = 0x100000;
    public static final int MDB_NOTLS = 0x200000;
    public static final int MDB_NOLOCK = 0x400000;
    public static final int MDB_NORDAHEAD = 0x800000;
    public static final int MDB_NOMEMINIT = 0x1000000;
    public static final int MDB_REVERSEKEY = 2;
    public static final int MDB_DUPSORT = 4;
    public static final int MDB_INTEGERKEY = 8;
    public static final int MDB_DUPFIXED = 16;
    public static final int MDB_INTEGERDUP = 32;
    public static final int MDB_REVERSEDUP = 64;
    public static final int MDB_CREATE = 262144;
    public static final int MDB_NOOVERWRITE = 16;
    public static final int MDB_NODUPDATA = 32;
    public static final int MDB_CURRENT = 64;
    public static final int MDB_RESERVE = 65536;
    public static final int MDB_APPEND = 131072;
    public static final int MDB_APPENDDUP = 262144;
    public static final int MDB_MULTIPLE = 524288;
    public static final int MDB_CP_COMPACT = 1;
    public static final int MDB_FIRST = 0;
    public static final int MDB_FIRST_DUP = 1;
    public static final int MDB_GET_BOTH = 2;
    public static final int MDB_GET_BOTH_RANGE = 3;
    public static final int MDB_GET_CURRENT = 4;
    public static final int MDB_GET_MULTIPLE = 5;
    public static final int MDB_LAST = 6;
    public static final int MDB_LAST_DUP = 7;
    public static final int MDB_NEXT = 8;
    public static final int MDB_NEXT_DUP = 9;
    public static final int MDB_NEXT_MULTIPLE = 10;
    public static final int MDB_NEXT_NODUP = 11;
    public static final int MDB_PREV = 12;
    public static final int MDB_PREV_DUP = 13;
    public static final int MDB_PREV_NODUP = 14;
    public static final int MDB_SET = 15;
    public static final int MDB_SET_KEY = 16;
    public static final int MDB_SET_RANGE = 17;
    public static final int MDB_PREV_MULTIPLE = 18;
    public static final int MDB_SUCCESS = 0;
    public static final int MDB_KEYEXIST = -30799;
    public static final int MDB_NOTFOUND = -30798;
    public static final int MDB_PAGE_NOTFOUND = -30797;
    public static final int MDB_CORRUPTED = -30796;
    public static final int MDB_PANIC = -30795;
    public static final int MDB_VERSION_MISMATCH = -30794;
    public static final int MDB_INVALID = -30793;
    public static final int MDB_MAP_FULL = -30792;
    public static final int MDB_DBS_FULL = -30791;
    public static final int MDB_READERS_FULL = -30790;
    public static final int MDB_TLS_FULL = -30789;
    public static final int MDB_TXN_FULL = -30788;
    public static final int MDB_CURSOR_FULL = -30787;
    public static final int MDB_PAGE_FULL = -30786;
    public static final int MDB_MAP_RESIZED = -30785;
    public static final int MDB_INCOMPATIBLE = -30784;
    public static final int MDB_BAD_RSLOT = -30783;
    public static final int MDB_BAD_TXN = -30782;
    public static final int MDB_BAD_VALSIZE = -30781;
    public static final int MDB_BAD_DBI = -30780;
    public static final int MDB_LAST_ERRCODE = -30780;

    protected LMDB() {
        throw new UnsupportedOperationException();
    }

    public static native long nmdb_version(long var0, long var2, long var4);

    @Nullable
    @NativeType(value="char *")
    public static String mdb_version(@Nullable @NativeType(value="int *") IntBuffer major, @Nullable @NativeType(value="int *") IntBuffer minor, @Nullable @NativeType(value="int *") IntBuffer patch) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)major, (int)1);
            Checks.checkSafe((Buffer)minor, (int)1);
            Checks.checkSafe((Buffer)patch, (int)1);
        }
        long __result = LMDB.nmdb_version(MemoryUtil.memAddressSafe((IntBuffer)major), MemoryUtil.memAddressSafe((IntBuffer)minor), MemoryUtil.memAddressSafe((IntBuffer)patch));
        return MemoryUtil.memASCIISafe((long)__result);
    }

    public static native long nmdb_strerror(int var0);

    @NativeType(value="char *")
    public static String mdb_strerror(int err) {
        long __result = LMDB.nmdb_strerror(err);
        return MemoryUtil.memASCII((long)__result);
    }

    public static native int nmdb_env_create(long var0);

    public static int mdb_env_create(@NativeType(value="MDB_env **") PointerBuffer env) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)env, (int)1);
        }
        return LMDB.nmdb_env_create(MemoryUtil.memAddress((CustomBuffer)env));
    }

    public static native int nmdb_env_open(long var0, long var2, int var4, int var5);

    public static int mdb_env_open(@NativeType(value="MDB_env *") long env, @NativeType(value="char const *") ByteBuffer path, @NativeType(value="unsigned int") int flags, @NativeType(value="mdb_mode_t") int mode) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
            Checks.checkNT1((ByteBuffer)path);
        }
        return LMDB.nmdb_env_open(env, MemoryUtil.memAddress((ByteBuffer)path), flags, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mdb_env_open(@NativeType(value="MDB_env *") long env, @NativeType(value="char const *") CharSequence path, @NativeType(value="unsigned int") int flags, @NativeType(value="mdb_mode_t") int mode) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            int n = LMDB.nmdb_env_open(env, pathEncoded, flags, mode);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nmdb_env_copy(long var0, long var2);

    public static int mdb_env_copy(@NativeType(value="MDB_env *") long env, @NativeType(value="char const *") ByteBuffer path) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
            Checks.checkNT1((ByteBuffer)path);
        }
        return LMDB.nmdb_env_copy(env, MemoryUtil.memAddress((ByteBuffer)path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mdb_env_copy(@NativeType(value="MDB_env *") long env, @NativeType(value="char const *") CharSequence path) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            int n = LMDB.nmdb_env_copy(env, pathEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nmdb_env_copy2(long var0, long var2, int var4);

    public static int mdb_env_copy2(@NativeType(value="MDB_env *") long env, @NativeType(value="char const *") ByteBuffer path, @NativeType(value="unsigned int") int flags) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
            Checks.checkNT1((ByteBuffer)path);
        }
        return LMDB.nmdb_env_copy2(env, MemoryUtil.memAddress((ByteBuffer)path), flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mdb_env_copy2(@NativeType(value="MDB_env *") long env, @NativeType(value="char const *") CharSequence path, @NativeType(value="unsigned int") int flags) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            int n = LMDB.nmdb_env_copy2(env, pathEncoded, flags);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nmdb_env_stat(long var0, long var2);

    public static int mdb_env_stat(@NativeType(value="MDB_env *") long env, @NativeType(value="MDB_stat *") MDBStat stat) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
        }
        return LMDB.nmdb_env_stat(env, stat.address());
    }

    public static native int nmdb_env_info(long var0, long var2);

    public static int mdb_env_info(@NativeType(value="MDB_env *") long env, @NativeType(value="MDB_envinfo *") MDBEnvInfo stat) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
        }
        return LMDB.nmdb_env_info(env, stat.address());
    }

    public static native int nmdb_env_sync(long var0, int var2);

    public static int mdb_env_sync(@NativeType(value="MDB_env *") long env, @NativeType(value="int") boolean force) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
        }
        return LMDB.nmdb_env_sync(env, force ? 1 : 0);
    }

    public static native void nmdb_env_close(long var0);

    public static void mdb_env_close(@NativeType(value="MDB_env *") long env) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
        }
        LMDB.nmdb_env_close(env);
    }

    public static native int nmdb_env_set_flags(long var0, int var2, int var3);

    public static int mdb_env_set_flags(@NativeType(value="MDB_env *") long env, @NativeType(value="unsigned int") int flags, @NativeType(value="int") boolean onoff) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
        }
        return LMDB.nmdb_env_set_flags(env, flags, onoff ? 1 : 0);
    }

    public static native int nmdb_env_get_flags(long var0, long var2);

    public static int mdb_env_get_flags(@NativeType(value="MDB_env *") long env, @NativeType(value="unsigned int *") IntBuffer flags) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
            Checks.check((Buffer)flags, (int)1);
        }
        return LMDB.nmdb_env_get_flags(env, MemoryUtil.memAddress((IntBuffer)flags));
    }

    public static native int nmdb_env_get_path(long var0, long var2);

    public static int mdb_env_get_path(@NativeType(value="MDB_env *") long env, @NativeType(value="char const **") PointerBuffer path) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
            Checks.check((CustomBuffer)path, (int)1);
        }
        return LMDB.nmdb_env_get_path(env, MemoryUtil.memAddress((CustomBuffer)path));
    }

    public static native int nmdb_env_set_mapsize(long var0, long var2);

    public static int mdb_env_set_mapsize(@NativeType(value="MDB_env *") long env, @NativeType(value="size_t") long size) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
        }
        return LMDB.nmdb_env_set_mapsize(env, size);
    }

    public static native int nmdb_env_set_maxreaders(long var0, int var2);

    public static int mdb_env_set_maxreaders(@NativeType(value="MDB_env *") long env, @NativeType(value="unsigned int") int readers) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
        }
        return LMDB.nmdb_env_set_maxreaders(env, readers);
    }

    public static native int nmdb_env_get_maxreaders(long var0, long var2);

    public static int mdb_env_get_maxreaders(@NativeType(value="MDB_env *") long env, @NativeType(value="unsigned int *") IntBuffer readers) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
            Checks.check((Buffer)readers, (int)1);
        }
        return LMDB.nmdb_env_get_maxreaders(env, MemoryUtil.memAddress((IntBuffer)readers));
    }

    public static native int nmdb_env_set_maxdbs(long var0, int var2);

    public static int mdb_env_set_maxdbs(@NativeType(value="MDB_env *") long env, @NativeType(value="MDB_dbi") int dbs) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
        }
        return LMDB.nmdb_env_set_maxdbs(env, dbs);
    }

    public static native int nmdb_env_get_maxkeysize(long var0);

    public static int mdb_env_get_maxkeysize(@NativeType(value="MDB_env *") long env) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
        }
        return LMDB.nmdb_env_get_maxkeysize(env);
    }

    public static native int nmdb_env_set_userctx(long var0, long var2);

    public static int mdb_env_set_userctx(@NativeType(value="MDB_env *") long env, @NativeType(value="void *") long ctx) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
            Checks.check((long)ctx);
        }
        return LMDB.nmdb_env_set_userctx(env, ctx);
    }

    public static native long nmdb_env_get_userctx(long var0);

    @NativeType(value="void *")
    public static long mdb_env_get_userctx(@NativeType(value="MDB_env *") long env) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
        }
        return LMDB.nmdb_env_get_userctx(env);
    }

    public static native int nmdb_txn_begin(long var0, long var2, int var4, long var5);

    public static int mdb_txn_begin(@NativeType(value="MDB_env *") long env, @NativeType(value="MDB_txn *") long parent, @NativeType(value="unsigned int") int flags, @NativeType(value="MDB_txn **") PointerBuffer txn) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
            Checks.check((CustomBuffer)txn, (int)1);
        }
        return LMDB.nmdb_txn_begin(env, parent, flags, MemoryUtil.memAddress((CustomBuffer)txn));
    }

    public static native long nmdb_txn_env(long var0);

    @NativeType(value="MDB_env *")
    public static long mdb_txn_env(@NativeType(value="MDB_txn *") long txn) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
        }
        return LMDB.nmdb_txn_env(txn);
    }

    public static native long nmdb_txn_id(long var0);

    @NativeType(value="size_t")
    public static long mdb_txn_id(@NativeType(value="MDB_txn *") long txn) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
        }
        return LMDB.nmdb_txn_id(txn);
    }

    public static native int nmdb_txn_commit(long var0);

    public static int mdb_txn_commit(@NativeType(value="MDB_txn *") long txn) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
        }
        return LMDB.nmdb_txn_commit(txn);
    }

    public static native void nmdb_txn_abort(long var0);

    public static void mdb_txn_abort(@NativeType(value="MDB_txn *") long txn) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
        }
        LMDB.nmdb_txn_abort(txn);
    }

    public static native void nmdb_txn_reset(long var0);

    public static void mdb_txn_reset(@NativeType(value="MDB_txn *") long txn) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
        }
        LMDB.nmdb_txn_reset(txn);
    }

    public static native int nmdb_txn_renew(long var0);

    public static int mdb_txn_renew(@NativeType(value="MDB_txn *") long txn) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
        }
        return LMDB.nmdb_txn_renew(txn);
    }

    public static native int nmdb_dbi_open(long var0, long var2, int var4, long var5);

    public static int mdb_dbi_open(@NativeType(value="MDB_txn *") long txn, @Nullable @NativeType(value="char const *") ByteBuffer name, @NativeType(value="unsigned int") int flags, @NativeType(value="MDB_dbi *") IntBuffer dbi) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
            Checks.checkNT1Safe((ByteBuffer)name);
            Checks.check((Buffer)dbi, (int)1);
        }
        return LMDB.nmdb_dbi_open(txn, MemoryUtil.memAddressSafe((ByteBuffer)name), flags, MemoryUtil.memAddress((IntBuffer)dbi));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mdb_dbi_open(@NativeType(value="MDB_txn *") long txn, @Nullable @NativeType(value="char const *") CharSequence name, @NativeType(value="unsigned int") int flags, @NativeType(value="MDB_dbi *") IntBuffer dbi) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
            Checks.check((Buffer)dbi, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(name, true);
            long nameEncoded = name == null ? 0L : stack.getPointerAddress();
            int n = LMDB.nmdb_dbi_open(txn, nameEncoded, flags, MemoryUtil.memAddress((IntBuffer)dbi));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nmdb_stat(long var0, int var2, long var3);

    public static int mdb_stat(@NativeType(value="MDB_txn *") long txn, @NativeType(value="MDB_dbi") int dbi, @NativeType(value="MDB_stat *") MDBStat stat) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
        }
        return LMDB.nmdb_stat(txn, dbi, stat.address());
    }

    public static native int nmdb_dbi_flags(long var0, int var2, long var3);

    public static int mdb_dbi_flags(@NativeType(value="MDB_txn *") long txn, @NativeType(value="MDB_dbi") int dbi, @NativeType(value="unsigned int *") IntBuffer flags) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
            Checks.check((Buffer)flags, (int)1);
        }
        return LMDB.nmdb_dbi_flags(txn, dbi, MemoryUtil.memAddress((IntBuffer)flags));
    }

    public static native void nmdb_dbi_close(long var0, int var2);

    public static void mdb_dbi_close(@NativeType(value="MDB_env *") long env, @NativeType(value="MDB_dbi") int dbi) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
        }
        LMDB.nmdb_dbi_close(env, dbi);
    }

    public static native int nmdb_drop(long var0, int var2, int var3);

    public static int mdb_drop(@NativeType(value="MDB_txn *") long txn, @NativeType(value="MDB_dbi") int dbi, @NativeType(value="int") boolean del) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
        }
        return LMDB.nmdb_drop(txn, dbi, del ? 1 : 0);
    }

    public static native int nmdb_set_compare(long var0, int var2, long var3);

    public static int mdb_set_compare(@NativeType(value="MDB_txn *") long txn, @NativeType(value="MDB_dbi") int dbi, @NativeType(value="MDB_cmp_func *") MDBCmpFuncI cmp) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
        }
        return LMDB.nmdb_set_compare(txn, dbi, cmp.address());
    }

    public static native int nmdb_set_dupsort(long var0, int var2, long var3);

    public static int mdb_set_dupsort(@NativeType(value="MDB_txn *") long txn, @NativeType(value="MDB_dbi") int dbi, @NativeType(value="MDB_cmp_func *") MDBCmpFuncI cmp) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
        }
        return LMDB.nmdb_set_dupsort(txn, dbi, cmp.address());
    }

    public static native int nmdb_set_relfunc(long var0, int var2, long var3);

    public static int mdb_set_relfunc(@NativeType(value="MDB_txn *") long txn, @NativeType(value="MDB_dbi") int dbi, @NativeType(value="MDB_rel_func *") MDBRelFuncI rel) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
        }
        return LMDB.nmdb_set_relfunc(txn, dbi, rel.address());
    }

    public static native int nmdb_set_relctx(long var0, int var2, long var3);

    public static int mdb_set_relctx(@NativeType(value="MDB_txn *") long txn, @NativeType(value="MDB_dbi") int dbi, @NativeType(value="void *") long ctx) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
            Checks.check((long)ctx);
        }
        return LMDB.nmdb_set_relctx(txn, dbi, ctx);
    }

    public static native int nmdb_get(long var0, int var2, long var3, long var5);

    public static int mdb_get(@NativeType(value="MDB_txn *") long txn, @NativeType(value="MDB_dbi") int dbi, @NativeType(value="MDB_val *") MDBVal key, @NativeType(value="MDB_val *") MDBVal data) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
        }
        return LMDB.nmdb_get(txn, dbi, key.address(), data.address());
    }

    public static native int nmdb_put(long var0, int var2, long var3, long var5, int var7);

    public static int mdb_put(@NativeType(value="MDB_txn *") long txn, @NativeType(value="MDB_dbi") int dbi, @NativeType(value="MDB_val *") MDBVal key, @NativeType(value="MDB_val *") MDBVal data, @NativeType(value="unsigned int") int flags) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
        }
        return LMDB.nmdb_put(txn, dbi, key.address(), data.address(), flags);
    }

    public static native int nmdb_del(long var0, int var2, long var3, long var5);

    public static int mdb_del(@NativeType(value="MDB_txn *") long txn, @NativeType(value="MDB_dbi") int dbi, @NativeType(value="MDB_val *") MDBVal key, @Nullable @NativeType(value="MDB_val *") MDBVal data) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
        }
        return LMDB.nmdb_del(txn, dbi, key.address(), MemoryUtil.memAddressSafe((Pointer)data));
    }

    public static native int nmdb_cursor_open(long var0, int var2, long var3);

    public static int mdb_cursor_open(@NativeType(value="MDB_txn *") long txn, @NativeType(value="MDB_dbi") int dbi, @NativeType(value="MDB_cursor **") PointerBuffer cursor) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
            Checks.check((CustomBuffer)cursor, (int)1);
        }
        return LMDB.nmdb_cursor_open(txn, dbi, MemoryUtil.memAddress((CustomBuffer)cursor));
    }

    public static native void nmdb_cursor_close(long var0);

    public static void mdb_cursor_close(@NativeType(value="MDB_cursor *") long cursor) {
        if (Checks.CHECKS) {
            Checks.check((long)cursor);
        }
        LMDB.nmdb_cursor_close(cursor);
    }

    public static native int nmdb_cursor_renew(long var0, long var2);

    public static int mdb_cursor_renew(@NativeType(value="MDB_txn *") long txn, @NativeType(value="MDB_cursor *") long cursor) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
            Checks.check((long)cursor);
        }
        return LMDB.nmdb_cursor_renew(txn, cursor);
    }

    public static native long nmdb_cursor_txn(long var0);

    @NativeType(value="MDB_txn *")
    public static long mdb_cursor_txn(@NativeType(value="MDB_cursor *") long cursor) {
        if (Checks.CHECKS) {
            Checks.check((long)cursor);
        }
        return LMDB.nmdb_cursor_txn(cursor);
    }

    public static native int nmdb_cursor_dbi(long var0);

    @NativeType(value="MDB_dbi")
    public static int mdb_cursor_dbi(@NativeType(value="MDB_cursor *") long cursor) {
        if (Checks.CHECKS) {
            Checks.check((long)cursor);
        }
        return LMDB.nmdb_cursor_dbi(cursor);
    }

    public static native int nmdb_cursor_get(long var0, long var2, long var4, int var6);

    public static int mdb_cursor_get(@NativeType(value="MDB_cursor *") long cursor, @NativeType(value="MDB_val *") MDBVal key, @NativeType(value="MDB_val *") MDBVal data, @NativeType(value="MDB_cursor_op") int op) {
        if (Checks.CHECKS) {
            Checks.check((long)cursor);
        }
        return LMDB.nmdb_cursor_get(cursor, key.address(), data.address(), op);
    }

    public static native int nmdb_cursor_put(long var0, long var2, long var4, int var6);

    public static int mdb_cursor_put(@NativeType(value="MDB_cursor *") long cursor, @NativeType(value="MDB_val *") MDBVal key, @NativeType(value="MDB_val *") MDBVal data, @NativeType(value="unsigned int") int flags) {
        if (Checks.CHECKS) {
            Checks.check((long)cursor);
        }
        return LMDB.nmdb_cursor_put(cursor, key.address(), data.address(), flags);
    }

    public static native int nmdb_cursor_del(long var0, int var2);

    public static int mdb_cursor_del(@NativeType(value="MDB_cursor *") long cursor, @NativeType(value="unsigned int") int flags) {
        if (Checks.CHECKS) {
            Checks.check((long)cursor);
        }
        return LMDB.nmdb_cursor_del(cursor, flags);
    }

    public static native int nmdb_cursor_count(long var0, long var2);

    public static int mdb_cursor_count(@NativeType(value="MDB_cursor *") long cursor, @NativeType(value="size_t *") PointerBuffer countp) {
        if (Checks.CHECKS) {
            Checks.check((long)cursor);
            Checks.check((CustomBuffer)countp, (int)1);
        }
        return LMDB.nmdb_cursor_count(cursor, MemoryUtil.memAddress((CustomBuffer)countp));
    }

    public static native int nmdb_cmp(long var0, int var2, long var3, long var5);

    public static int mdb_cmp(@NativeType(value="MDB_txn *") long txn, @NativeType(value="MDB_dbi") int dbi, @NativeType(value="MDB_val const *") MDBVal a, @NativeType(value="MDB_val const *") MDBVal b) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
        }
        return LMDB.nmdb_cmp(txn, dbi, a.address(), b.address());
    }

    public static native int nmdb_dcmp(long var0, int var2, long var3, long var5);

    public static int mdb_dcmp(@NativeType(value="MDB_txn *") long txn, @NativeType(value="MDB_dbi") int dbi, @NativeType(value="MDB_val const *") MDBVal a, @NativeType(value="MDB_val const *") MDBVal b) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
        }
        return LMDB.nmdb_dcmp(txn, dbi, a.address(), b.address());
    }

    public static native int nmdb_reader_list(long var0, long var2, long var4);

    public static int mdb_reader_list(@NativeType(value="MDB_env *") long env, @NativeType(value="MDB_msg_func *") MDBMsgFuncI func, @NativeType(value="void *") long ctx) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
            Checks.check((long)ctx);
        }
        return LMDB.nmdb_reader_list(env, func.address(), ctx);
    }

    public static native int nmdb_reader_check(long var0, long var2);

    public static int mdb_reader_check(@NativeType(value="MDB_env *") long env, @NativeType(value="int *") IntBuffer dead) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
            Checks.check((Buffer)dead, (int)1);
        }
        return LMDB.nmdb_reader_check(env, MemoryUtil.memAddress((IntBuffer)dead));
    }

    public static native long nmdb_version(int[] var0, int[] var1, int[] var2);

    @Nullable
    @NativeType(value="char *")
    public static String mdb_version(@Nullable @NativeType(value="int *") int[] major, @Nullable @NativeType(value="int *") int[] minor, @Nullable @NativeType(value="int *") int[] patch) {
        if (Checks.CHECKS) {
            Checks.checkSafe((int[])major, (int)1);
            Checks.checkSafe((int[])minor, (int)1);
            Checks.checkSafe((int[])patch, (int)1);
        }
        long __result = LMDB.nmdb_version(major, minor, patch);
        return MemoryUtil.memASCIISafe((long)__result);
    }

    public static native int nmdb_env_get_flags(long var0, int[] var2);

    public static int mdb_env_get_flags(@NativeType(value="MDB_env *") long env, @NativeType(value="unsigned int *") int[] flags) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
            Checks.check((int[])flags, (int)1);
        }
        return LMDB.nmdb_env_get_flags(env, flags);
    }

    public static native int nmdb_env_get_maxreaders(long var0, int[] var2);

    public static int mdb_env_get_maxreaders(@NativeType(value="MDB_env *") long env, @NativeType(value="unsigned int *") int[] readers) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
            Checks.check((int[])readers, (int)1);
        }
        return LMDB.nmdb_env_get_maxreaders(env, readers);
    }

    public static native int nmdb_dbi_open(long var0, long var2, int var4, int[] var5);

    public static int mdb_dbi_open(@NativeType(value="MDB_txn *") long txn, @Nullable @NativeType(value="char const *") ByteBuffer name, @NativeType(value="unsigned int") int flags, @NativeType(value="MDB_dbi *") int[] dbi) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
            Checks.checkNT1Safe((ByteBuffer)name);
            Checks.check((int[])dbi, (int)1);
        }
        return LMDB.nmdb_dbi_open(txn, MemoryUtil.memAddressSafe((ByteBuffer)name), flags, dbi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mdb_dbi_open(@NativeType(value="MDB_txn *") long txn, @Nullable @NativeType(value="char const *") CharSequence name, @NativeType(value="unsigned int") int flags, @NativeType(value="MDB_dbi *") int[] dbi) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
            Checks.check((int[])dbi, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(name, true);
            long nameEncoded = name == null ? 0L : stack.getPointerAddress();
            int n = LMDB.nmdb_dbi_open(txn, nameEncoded, flags, dbi);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nmdb_dbi_flags(long var0, int var2, int[] var3);

    public static int mdb_dbi_flags(@NativeType(value="MDB_txn *") long txn, @NativeType(value="MDB_dbi") int dbi, @NativeType(value="unsigned int *") int[] flags) {
        if (Checks.CHECKS) {
            Checks.check((long)txn);
            Checks.check((int[])flags, (int)1);
        }
        return LMDB.nmdb_dbi_flags(txn, dbi, flags);
    }

    public static native int nmdb_reader_check(long var0, int[] var2);

    public static int mdb_reader_check(@NativeType(value="MDB_env *") long env, @NativeType(value="int *") int[] dead) {
        if (Checks.CHECKS) {
            Checks.check((long)env);
            Checks.check((int[])dead, (int)1);
        }
        return LMDB.nmdb_reader_check(env, dead);
    }

    static {
        LibLMDB.initialize();
        MDB_VERSION_STRING = String.format("LMDB %d.%d.%d: (%s)", 0, 9, 30, MDB_VERSION_DATE);
    }
}

