/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct LZ4F_decompressOptions_t")
public class LZ4FDecompressOptions
extends Struct<LZ4FDecompressOptions>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STABLEDST;
    public static final int SKIPCHECKSUMS;
    public static final int RESERVED1;
    public static final int RESERVED0;

    protected LZ4FDecompressOptions(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected LZ4FDecompressOptions create(long address, @Nullable ByteBuffer container) {
        return new LZ4FDecompressOptions(address, container);
    }

    public LZ4FDecompressOptions(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LZ4FDecompressOptions.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned")
    public int stableDst() {
        return LZ4FDecompressOptions.nstableDst(this.address());
    }

    @NativeType(value="unsigned")
    public int skipChecksums() {
        return LZ4FDecompressOptions.nskipChecksums(this.address());
    }

    @NativeType(value="unsigned")
    public int reserved1() {
        return LZ4FDecompressOptions.nreserved1(this.address());
    }

    @NativeType(value="unsigned")
    public int reserved0() {
        return LZ4FDecompressOptions.nreserved0(this.address());
    }

    public LZ4FDecompressOptions stableDst(@NativeType(value="unsigned") int value) {
        LZ4FDecompressOptions.nstableDst(this.address(), value);
        return this;
    }

    public LZ4FDecompressOptions skipChecksums(@NativeType(value="unsigned") int value) {
        LZ4FDecompressOptions.nskipChecksums(this.address(), value);
        return this;
    }

    public LZ4FDecompressOptions reserved1(@NativeType(value="unsigned") int value) {
        LZ4FDecompressOptions.nreserved1(this.address(), value);
        return this;
    }

    public LZ4FDecompressOptions reserved0(@NativeType(value="unsigned") int value) {
        LZ4FDecompressOptions.nreserved0(this.address(), value);
        return this;
    }

    public LZ4FDecompressOptions set(int stableDst, int skipChecksums, int reserved1, int reserved0) {
        this.stableDst(stableDst);
        this.skipChecksums(skipChecksums);
        this.reserved1(reserved1);
        this.reserved0(reserved0);
        return this;
    }

    public LZ4FDecompressOptions set(LZ4FDecompressOptions src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static LZ4FDecompressOptions malloc() {
        return new LZ4FDecompressOptions(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static LZ4FDecompressOptions calloc() {
        return new LZ4FDecompressOptions(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static LZ4FDecompressOptions create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new LZ4FDecompressOptions(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static LZ4FDecompressOptions create(long address) {
        return new LZ4FDecompressOptions(address, null);
    }

    public static @Nullable LZ4FDecompressOptions createSafe(long address) {
        return address == 0L ? null : new LZ4FDecompressOptions(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)LZ4FDecompressOptions.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LZ4FDecompressOptions.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static LZ4FDecompressOptions mallocStack() {
        return LZ4FDecompressOptions.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LZ4FDecompressOptions callocStack() {
        return LZ4FDecompressOptions.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LZ4FDecompressOptions mallocStack(MemoryStack stack) {
        return LZ4FDecompressOptions.malloc(stack);
    }

    @Deprecated
    public static LZ4FDecompressOptions callocStack(MemoryStack stack) {
        return LZ4FDecompressOptions.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return LZ4FDecompressOptions.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return LZ4FDecompressOptions.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return LZ4FDecompressOptions.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return LZ4FDecompressOptions.calloc(capacity, stack);
    }

    public static LZ4FDecompressOptions malloc(MemoryStack stack) {
        return new LZ4FDecompressOptions(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LZ4FDecompressOptions calloc(MemoryStack stack) {
        return new LZ4FDecompressOptions(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nstableDst(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STABLEDST));
    }

    public static int nskipChecksums(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SKIPCHECKSUMS));
    }

    public static int nreserved1(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)RESERVED1));
    }

    public static int nreserved0(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)RESERVED0));
    }

    public static void nstableDst(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STABLEDST), (int)value);
    }

    public static void nskipChecksums(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SKIPCHECKSUMS), (int)value);
    }

    public static void nreserved1(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)RESERVED1), (int)value);
    }

    public static void nreserved0(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)RESERVED0), (int)value);
    }

    static {
        Struct.Layout layout = LZ4FDecompressOptions.__struct((Struct.Member[])new Struct.Member[]{LZ4FDecompressOptions.__member((int)4), LZ4FDecompressOptions.__member((int)4), LZ4FDecompressOptions.__member((int)4), LZ4FDecompressOptions.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STABLEDST = layout.offsetof(0);
        SKIPCHECKSUMS = layout.offsetof(1);
        RESERVED1 = layout.offsetof(2);
        RESERVED0 = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<LZ4FDecompressOptions, Buffer>
    implements NativeResource {
        private static final LZ4FDecompressOptions ELEMENT_FACTORY = LZ4FDecompressOptions.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected LZ4FDecompressOptions getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned")
        public int stableDst() {
            return LZ4FDecompressOptions.nstableDst(this.address());
        }

        @NativeType(value="unsigned")
        public int skipChecksums() {
            return LZ4FDecompressOptions.nskipChecksums(this.address());
        }

        @NativeType(value="unsigned")
        public int reserved1() {
            return LZ4FDecompressOptions.nreserved1(this.address());
        }

        @NativeType(value="unsigned")
        public int reserved0() {
            return LZ4FDecompressOptions.nreserved0(this.address());
        }

        public Buffer stableDst(@NativeType(value="unsigned") int value) {
            LZ4FDecompressOptions.nstableDst(this.address(), value);
            return this;
        }

        public Buffer skipChecksums(@NativeType(value="unsigned") int value) {
            LZ4FDecompressOptions.nskipChecksums(this.address(), value);
            return this;
        }

        public Buffer reserved1(@NativeType(value="unsigned") int value) {
            LZ4FDecompressOptions.nreserved1(this.address(), value);
            return this;
        }

        public Buffer reserved0(@NativeType(value="unsigned") int value) {
            LZ4FDecompressOptions.nreserved0(this.address(), value);
            return this;
        }
    }
}

