/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meow;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.meow.MeowU128;

@NativeType(value="union meow_hash")
public class MeowHash
extends Struct<MeowHash>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int U128;
    public static final int U64;
    public static final int U32;

    protected MeowHash(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected MeowHash create(long address, @Nullable ByteBuffer container) {
        return new MeowHash(address, container);
    }

    public MeowHash(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), MeowHash.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="meow_u128")
    public MeowU128 u128() {
        return MeowHash.nu128(this.address());
    }

    @NativeType(value="meow_u64[2]")
    public LongBuffer u64() {
        return MeowHash.nu64(this.address());
    }

    @NativeType(value="meow_u64")
    public long u64(int index) {
        return MeowHash.nu64(this.address(), index);
    }

    @NativeType(value="meow_u32[4]")
    public IntBuffer u32() {
        return MeowHash.nu32(this.address());
    }

    @NativeType(value="meow_u32")
    public int u32(int index) {
        return MeowHash.nu32(this.address(), index);
    }

    public static MeowHash malloc() {
        return new MeowHash(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static MeowHash calloc() {
        return new MeowHash(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static MeowHash create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new MeowHash(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static MeowHash create(long address) {
        return new MeowHash(address, null);
    }

    public static @Nullable MeowHash createSafe(long address) {
        return address == 0L ? null : new MeowHash(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)MeowHash.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MeowHash.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static MeowHash mallocStack() {
        return MeowHash.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static MeowHash callocStack() {
        return MeowHash.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static MeowHash mallocStack(MemoryStack stack) {
        return MeowHash.malloc(stack);
    }

    @Deprecated
    public static MeowHash callocStack(MemoryStack stack) {
        return MeowHash.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return MeowHash.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return MeowHash.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return MeowHash.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return MeowHash.calloc(capacity, stack);
    }

    public static MeowHash malloc(MemoryStack stack) {
        return new MeowHash(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static MeowHash calloc(MemoryStack stack) {
        return new MeowHash(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static MeowU128 nu128(long struct) {
        return MeowU128.create(struct + (long)U128);
    }

    public static LongBuffer nu64(long struct) {
        return MemoryUtil.memLongBuffer((long)(struct + (long)U64), (int)2);
    }

    public static long nu64(long struct, int index) {
        return MemoryUtil.memGetLong((long)(struct + (long)U64 + Checks.check((int)index, (int)2) * 8L));
    }

    public static IntBuffer nu32(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)U32), (int)4);
    }

    public static int nu32(long struct, int index) {
        return MemoryUtil.memGetInt((long)(struct + (long)U32 + Checks.check((int)index, (int)4) * 4L));
    }

    static {
        Struct.Layout layout = MeowHash.__union((Struct.Member[])new Struct.Member[]{MeowHash.__member((int)MeowU128.SIZEOF, (int)MeowU128.ALIGNOF, (boolean)true), MeowHash.__array((int)8, (int)2), MeowHash.__array((int)4, (int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        U128 = layout.offsetof(0);
        U64 = layout.offsetof(1);
        U32 = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<MeowHash, Buffer>
    implements NativeResource {
        private static final MeowHash ELEMENT_FACTORY = MeowHash.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected MeowHash getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="meow_u128")
        public MeowU128 u128() {
            return MeowHash.nu128(this.address());
        }

        @NativeType(value="meow_u64[2]")
        public LongBuffer u64() {
            return MeowHash.nu64(this.address());
        }

        @NativeType(value="meow_u64")
        public long u64(int index) {
            return MeowHash.nu64(this.address(), index);
        }

        @NativeType(value="meow_u32[4]")
        public IntBuffer u32() {
            return MeowHash.nu32(this.address());
        }

        @NativeType(value="meow_u32")
        public int u32(int index) {
            return MeowHash.nu32(this.address(), index);
        }
    }
}

