/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meshoptimizer;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct meshopt_Stream")
public class MeshoptStream
extends Struct<MeshoptStream>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;
    public static final int SIZE;
    public static final int STRIDE;

    protected MeshoptStream(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected MeshoptStream create(long address, @Nullable ByteBuffer container) {
        return new MeshoptStream(address, container);
    }

    public MeshoptStream(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), MeshoptStream.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void const *")
    public ByteBuffer data(int capacity) {
        return MeshoptStream.ndata(this.address(), capacity);
    }

    @NativeType(value="size_t")
    public long size() {
        return MeshoptStream.nsize(this.address());
    }

    @NativeType(value="size_t")
    public long stride() {
        return MeshoptStream.nstride(this.address());
    }

    public MeshoptStream data(@NativeType(value="void const *") ByteBuffer value) {
        MeshoptStream.ndata(this.address(), value);
        return this;
    }

    public MeshoptStream size(@NativeType(value="size_t") long value) {
        MeshoptStream.nsize(this.address(), value);
        return this;
    }

    public MeshoptStream stride(@NativeType(value="size_t") long value) {
        MeshoptStream.nstride(this.address(), value);
        return this;
    }

    public MeshoptStream set(ByteBuffer data, long size, long stride) {
        this.data(data);
        this.size(size);
        this.stride(stride);
        return this;
    }

    public MeshoptStream set(MeshoptStream src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static MeshoptStream malloc() {
        return new MeshoptStream(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static MeshoptStream calloc() {
        return new MeshoptStream(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static MeshoptStream create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new MeshoptStream(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static MeshoptStream create(long address) {
        return new MeshoptStream(address, null);
    }

    @Nullable
    public static MeshoptStream createSafe(long address) {
        return address == 0L ? null : new MeshoptStream(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)MeshoptStream.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MeshoptStream.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static MeshoptStream malloc(MemoryStack stack) {
        return new MeshoptStream(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static MeshoptStream calloc(MemoryStack stack) {
        return new MeshoptStream(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndata(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)), (int)capacity);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SIZE));
    }

    public static long nstride(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)STRIDE));
    }

    public static void ndata(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DATA), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SIZE), (long)value);
    }

    public static void nstride(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)STRIDE), (long)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)));
    }

    static {
        Struct.Layout layout = MeshoptStream.__struct((Struct.Member[])new Struct.Member[]{MeshoptStream.__member((int)POINTER_SIZE), MeshoptStream.__member((int)POINTER_SIZE), MeshoptStream.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        STRIDE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<MeshoptStream, Buffer>
    implements NativeResource {
        private static final MeshoptStream ELEMENT_FACTORY = MeshoptStream.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected MeshoptStream getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void const *")
        public ByteBuffer data(int capacity) {
            return MeshoptStream.ndata(this.address(), capacity);
        }

        @NativeType(value="size_t")
        public long size() {
            return MeshoptStream.nsize(this.address());
        }

        @NativeType(value="size_t")
        public long stride() {
            return MeshoptStream.nstride(this.address());
        }

        public Buffer data(@NativeType(value="void const *") ByteBuffer value) {
            MeshoptStream.ndata(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="size_t") long value) {
            MeshoptStream.nsize(this.address(), value);
            return this;
        }

        public Buffer stride(@NativeType(value="size_t") long value) {
            MeshoptStream.nstride(this.address(), value);
            return this;
        }
    }
}

