/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meshoptimizer;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct meshopt_VertexFetchStatistics")
public class MeshoptVertexFetchStatistics
extends Struct<MeshoptVertexFetchStatistics>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BYTES_FETCHED;
    public static final int OVERFETCH;

    protected MeshoptVertexFetchStatistics(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected MeshoptVertexFetchStatistics create(long address, @Nullable ByteBuffer container) {
        return new MeshoptVertexFetchStatistics(address, container);
    }

    public MeshoptVertexFetchStatistics(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), MeshoptVertexFetchStatistics.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int bytes_fetched() {
        return MeshoptVertexFetchStatistics.nbytes_fetched(this.address());
    }

    public float overfetch() {
        return MeshoptVertexFetchStatistics.noverfetch(this.address());
    }

    public static MeshoptVertexFetchStatistics malloc() {
        return new MeshoptVertexFetchStatistics(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static MeshoptVertexFetchStatistics calloc() {
        return new MeshoptVertexFetchStatistics(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static MeshoptVertexFetchStatistics create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new MeshoptVertexFetchStatistics(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static MeshoptVertexFetchStatistics create(long address) {
        return new MeshoptVertexFetchStatistics(address, null);
    }

    @Nullable
    public static MeshoptVertexFetchStatistics createSafe(long address) {
        return address == 0L ? null : new MeshoptVertexFetchStatistics(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)MeshoptVertexFetchStatistics.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MeshoptVertexFetchStatistics.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static MeshoptVertexFetchStatistics malloc(MemoryStack stack) {
        return new MeshoptVertexFetchStatistics(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static MeshoptVertexFetchStatistics calloc(MemoryStack stack) {
        return new MeshoptVertexFetchStatistics(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nbytes_fetched(long struct) {
        return UNSAFE.getInt(null, struct + (long)BYTES_FETCHED);
    }

    public static float noverfetch(long struct) {
        return UNSAFE.getFloat(null, struct + (long)OVERFETCH);
    }

    static {
        Struct.Layout layout = MeshoptVertexFetchStatistics.__struct((Struct.Member[])new Struct.Member[]{MeshoptVertexFetchStatistics.__member((int)4), MeshoptVertexFetchStatistics.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BYTES_FETCHED = layout.offsetof(0);
        OVERFETCH = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<MeshoptVertexFetchStatistics, Buffer>
    implements NativeResource {
        private static final MeshoptVertexFetchStatistics ELEMENT_FACTORY = MeshoptVertexFetchStatistics.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected MeshoptVertexFetchStatistics getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int bytes_fetched() {
            return MeshoptVertexFetchStatistics.nbytes_fetched(this.address());
        }

        public float overfetch() {
            return MeshoptVertexFetchStatistics.noverfetch(this.address());
        }
    }
}

