/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.nfd;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.nfd.NFDWindowHandle;

@NativeType(value="struct nfdpickfolderu8args_t")
public class NFDPickFolderArgs
extends Struct<NFDPickFolderArgs>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DEFAULTPATH;
    public static final int PARENTWINDOW;

    protected NFDPickFolderArgs(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NFDPickFolderArgs create(long address, @Nullable ByteBuffer container) {
        return new NFDPickFolderArgs(address, container);
    }

    public NFDPickFolderArgs(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NFDPickFolderArgs.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @Nullable
    @NativeType(value="nfdchar_t const *")
    public ByteBuffer defaultPath() {
        return NFDPickFolderArgs.ndefaultPath(this.address());
    }

    @Nullable
    @NativeType(value="nfdchar_t const *")
    public String defaultPathString() {
        return NFDPickFolderArgs.ndefaultPathString(this.address());
    }

    @NativeType(value="nfdwindowhandle_t")
    public NFDWindowHandle parentWindow() {
        return NFDPickFolderArgs.nparentWindow(this.address());
    }

    public NFDPickFolderArgs defaultPath(@Nullable @NativeType(value="nfdchar_t const *") ByteBuffer value) {
        NFDPickFolderArgs.ndefaultPath(this.address(), value);
        return this;
    }

    public NFDPickFolderArgs parentWindow(@NativeType(value="nfdwindowhandle_t") NFDWindowHandle value) {
        NFDPickFolderArgs.nparentWindow(this.address(), value);
        return this;
    }

    public NFDPickFolderArgs parentWindow(Consumer<NFDWindowHandle> consumer) {
        consumer.accept(this.parentWindow());
        return this;
    }

    public NFDPickFolderArgs set(@Nullable ByteBuffer defaultPath, NFDWindowHandle parentWindow) {
        this.defaultPath(defaultPath);
        this.parentWindow(parentWindow);
        return this;
    }

    public NFDPickFolderArgs set(NFDPickFolderArgs src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NFDPickFolderArgs malloc() {
        return new NFDPickFolderArgs(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static NFDPickFolderArgs calloc() {
        return new NFDPickFolderArgs(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static NFDPickFolderArgs create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new NFDPickFolderArgs(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static NFDPickFolderArgs create(long address) {
        return new NFDPickFolderArgs(address, null);
    }

    @Nullable
    public static NFDPickFolderArgs createSafe(long address) {
        return address == 0L ? null : new NFDPickFolderArgs(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)NFDPickFolderArgs.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NFDPickFolderArgs.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static NFDPickFolderArgs malloc(MemoryStack stack) {
        return new NFDPickFolderArgs(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NFDPickFolderArgs calloc(MemoryStack stack) {
        return new NFDPickFolderArgs(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    @Nullable
    public static ByteBuffer ndefaultPath(long struct) {
        return MemoryUtil.memByteBufferNT1Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)DEFAULTPATH)));
    }

    @Nullable
    public static String ndefaultPathString(long struct) {
        return MemoryUtil.memUTF8Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)DEFAULTPATH)));
    }

    public static NFDWindowHandle nparentWindow(long struct) {
        return NFDWindowHandle.create(struct + (long)PARENTWINDOW);
    }

    public static void ndefaultPath(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)DEFAULTPATH), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
    }

    public static void nparentWindow(long struct, NFDWindowHandle value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PARENTWINDOW), (long)NFDWindowHandle.SIZEOF);
    }

    static {
        Struct.Layout layout = NFDPickFolderArgs.__struct((Struct.Member[])new Struct.Member[]{NFDPickFolderArgs.__member((int)POINTER_SIZE), NFDPickFolderArgs.__member((int)NFDWindowHandle.SIZEOF, (int)NFDWindowHandle.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DEFAULTPATH = layout.offsetof(0);
        PARENTWINDOW = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NFDPickFolderArgs, Buffer>
    implements NativeResource {
        private static final NFDPickFolderArgs ELEMENT_FACTORY = NFDPickFolderArgs.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NFDPickFolderArgs getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Nullable
        @NativeType(value="nfdchar_t const *")
        public ByteBuffer defaultPath() {
            return NFDPickFolderArgs.ndefaultPath(this.address());
        }

        @Nullable
        @NativeType(value="nfdchar_t const *")
        public String defaultPathString() {
            return NFDPickFolderArgs.ndefaultPathString(this.address());
        }

        @NativeType(value="nfdwindowhandle_t")
        public NFDWindowHandle parentWindow() {
            return NFDPickFolderArgs.nparentWindow(this.address());
        }

        public Buffer defaultPath(@Nullable @NativeType(value="nfdchar_t const *") ByteBuffer value) {
            NFDPickFolderArgs.ndefaultPath(this.address(), value);
            return this;
        }

        public Buffer parentWindow(@NativeType(value="nfdwindowhandle_t") NFDWindowHandle value) {
            NFDPickFolderArgs.nparentWindow(this.address(), value);
            return this;
        }

        public Buffer parentWindow(Consumer<NFDWindowHandle> consumer) {
            consumer.accept(this.parentWindow());
            return this;
        }
    }
}

