/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.nuklear.NkAllocator;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_pool")
class NkPool
extends Struct<NkPool> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ALLOC;
    public static final int TYPE;
    public static final int PAGE_COUNT;
    public static final int PAGES;
    public static final int FREELIST;
    public static final int CAPACITY;
    public static final int SIZE;
    public static final int CAP;

    protected NkPool(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkPool create(long address, @Nullable ByteBuffer container) {
        return new NkPool(address, container);
    }

    NkPool(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkPool.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_allocator")
    public NkAllocator alloc() {
        return NkPool.nalloc(this.address());
    }

    @NativeType(value="enum nk_allocation_type")
    public int type() {
        return NkPool.ntype(this.address());
    }

    @NativeType(value="unsigned int")
    public int page_count() {
        return NkPool.npage_count(this.address());
    }

    @NativeType(value="struct nk_page *")
    public long pages() {
        return NkPool.npages(this.address());
    }

    @NativeType(value="struct nk_page_element *")
    public long freelist() {
        return NkPool.nfreelist(this.address());
    }

    @NativeType(value="unsigned")
    public int capacity$() {
        return NkPool.ncapacity$(this.address());
    }

    @NativeType(value="nk_size")
    public long size() {
        return NkPool.nsize(this.address());
    }

    @NativeType(value="nk_size")
    public long cap() {
        return NkPool.ncap(this.address());
    }

    public static NkPool create(long address) {
        return new NkPool(address, null);
    }

    @Nullable
    public static NkPool createSafe(long address) {
        return address == 0L ? null : new NkPool(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static NkAllocator nalloc(long struct) {
        return NkAllocator.create(struct + (long)ALLOC);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static int npage_count(long struct) {
        return UNSAFE.getInt(null, struct + (long)PAGE_COUNT);
    }

    public static long npages(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PAGES));
    }

    public static long nfreelist(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)FREELIST));
    }

    public static int ncapacity$(long struct) {
        return UNSAFE.getInt(null, struct + (long)CAPACITY);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SIZE));
    }

    public static long ncap(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)CAP));
    }

    static {
        Struct.Layout layout = NkPool.__struct((Struct.Member[])new Struct.Member[]{NkPool.__member((int)NkAllocator.SIZEOF, (int)NkAllocator.ALIGNOF), NkPool.__member((int)4), NkPool.__member((int)4), NkPool.__member((int)POINTER_SIZE), NkPool.__member((int)POINTER_SIZE), NkPool.__member((int)4), NkPool.__member((int)POINTER_SIZE), NkPool.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ALLOC = layout.offsetof(0);
        TYPE = layout.offsetof(1);
        PAGE_COUNT = layout.offsetof(2);
        PAGES = layout.offsetof(3);
        FREELIST = layout.offsetof(4);
        CAPACITY = layout.offsetof(5);
        SIZE = layout.offsetof(6);
        CAP = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<NkPool, Buffer> {
        private static final NkPool ELEMENT_FACTORY = NkPool.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkPool getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_allocator")
        public NkAllocator alloc() {
            return NkPool.nalloc(this.address());
        }

        @NativeType(value="enum nk_allocation_type")
        public int type() {
            return NkPool.ntype(this.address());
        }

        @NativeType(value="unsigned int")
        public int page_count() {
            return NkPool.npage_count(this.address());
        }

        @NativeType(value="struct nk_page *")
        public long pages() {
            return NkPool.npages(this.address());
        }

        @NativeType(value="struct nk_page_element *")
        public long freelist() {
            return NkPool.nfreelist(this.address());
        }

        @NativeType(value="unsigned")
        public int capacity$() {
            return NkPool.ncapacity$(this.address());
        }

        @NativeType(value="nk_size")
        public long size() {
            return NkPool.nsize(this.address());
        }

        @NativeType(value="nk_size")
        public long cap() {
            return NkPool.ncap(this.address());
        }
    }
}

