/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.nuklear.NkStyleScrollbar;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_style_edit")
public class NkStyleEdit
extends Struct<NkStyleEdit>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NORMAL;
    public static final int HOVER;
    public static final int ACTIVE;
    public static final int BORDER_COLOR;
    public static final int SCROLLBAR;
    public static final int CURSOR_NORMAL;
    public static final int CURSOR_HOVER;
    public static final int CURSOR_TEXT_NORMAL;
    public static final int CURSOR_TEXT_HOVER;
    public static final int TEXT_NORMAL;
    public static final int TEXT_HOVER;
    public static final int TEXT_ACTIVE;
    public static final int SELECTED_NORMAL;
    public static final int SELECTED_HOVER;
    public static final int SELECTED_TEXT_NORMAL;
    public static final int SELECTED_TEXT_HOVER;
    public static final int BORDER;
    public static final int ROUNDING;
    public static final int CURSOR_SIZE;
    public static final int SCROLLBAR_SIZE;
    public static final int PADDING;
    public static final int ROW_PADDING;

    protected NkStyleEdit(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkStyleEdit create(long address, @Nullable ByteBuffer container) {
        return new NkStyleEdit(address, container);
    }

    public NkStyleEdit(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkStyleEdit.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem normal() {
        return NkStyleEdit.nnormal(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem hover() {
        return NkStyleEdit.nhover(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem active() {
        return NkStyleEdit.nactive(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor border_color() {
        return NkStyleEdit.nborder_color(this.address());
    }

    @NativeType(value="struct nk_style_scrollbar")
    public NkStyleScrollbar scrollbar() {
        return NkStyleEdit.nscrollbar(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor cursor_normal() {
        return NkStyleEdit.ncursor_normal(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor cursor_hover() {
        return NkStyleEdit.ncursor_hover(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor cursor_text_normal() {
        return NkStyleEdit.ncursor_text_normal(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor cursor_text_hover() {
        return NkStyleEdit.ncursor_text_hover(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor text_normal() {
        return NkStyleEdit.ntext_normal(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor text_hover() {
        return NkStyleEdit.ntext_hover(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor text_active() {
        return NkStyleEdit.ntext_active(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor selected_normal() {
        return NkStyleEdit.nselected_normal(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor selected_hover() {
        return NkStyleEdit.nselected_hover(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor selected_text_normal() {
        return NkStyleEdit.nselected_text_normal(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor selected_text_hover() {
        return NkStyleEdit.nselected_text_hover(this.address());
    }

    public float border() {
        return NkStyleEdit.nborder(this.address());
    }

    public float rounding() {
        return NkStyleEdit.nrounding(this.address());
    }

    public float cursor_size() {
        return NkStyleEdit.ncursor_size(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 scrollbar_size() {
        return NkStyleEdit.nscrollbar_size(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 padding() {
        return NkStyleEdit.npadding(this.address());
    }

    public float row_padding() {
        return NkStyleEdit.nrow_padding(this.address());
    }

    public NkStyleEdit normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleEdit.nnormal(this.address(), value);
        return this;
    }

    public NkStyleEdit normal(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.normal());
        return this;
    }

    public NkStyleEdit hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleEdit.nhover(this.address(), value);
        return this;
    }

    public NkStyleEdit hover(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.hover());
        return this;
    }

    public NkStyleEdit active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleEdit.nactive(this.address(), value);
        return this;
    }

    public NkStyleEdit active(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.active());
        return this;
    }

    public NkStyleEdit border_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleEdit.nborder_color(this.address(), value);
        return this;
    }

    public NkStyleEdit border_color(Consumer<NkColor> consumer) {
        consumer.accept(this.border_color());
        return this;
    }

    public NkStyleEdit scrollbar(@NativeType(value="struct nk_style_scrollbar") NkStyleScrollbar value) {
        NkStyleEdit.nscrollbar(this.address(), value);
        return this;
    }

    public NkStyleEdit scrollbar(Consumer<NkStyleScrollbar> consumer) {
        consumer.accept(this.scrollbar());
        return this;
    }

    public NkStyleEdit cursor_normal(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleEdit.ncursor_normal(this.address(), value);
        return this;
    }

    public NkStyleEdit cursor_normal(Consumer<NkColor> consumer) {
        consumer.accept(this.cursor_normal());
        return this;
    }

    public NkStyleEdit cursor_hover(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleEdit.ncursor_hover(this.address(), value);
        return this;
    }

    public NkStyleEdit cursor_hover(Consumer<NkColor> consumer) {
        consumer.accept(this.cursor_hover());
        return this;
    }

    public NkStyleEdit cursor_text_normal(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleEdit.ncursor_text_normal(this.address(), value);
        return this;
    }

    public NkStyleEdit cursor_text_normal(Consumer<NkColor> consumer) {
        consumer.accept(this.cursor_text_normal());
        return this;
    }

    public NkStyleEdit cursor_text_hover(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleEdit.ncursor_text_hover(this.address(), value);
        return this;
    }

    public NkStyleEdit cursor_text_hover(Consumer<NkColor> consumer) {
        consumer.accept(this.cursor_text_hover());
        return this;
    }

    public NkStyleEdit text_normal(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleEdit.ntext_normal(this.address(), value);
        return this;
    }

    public NkStyleEdit text_normal(Consumer<NkColor> consumer) {
        consumer.accept(this.text_normal());
        return this;
    }

    public NkStyleEdit text_hover(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleEdit.ntext_hover(this.address(), value);
        return this;
    }

    public NkStyleEdit text_hover(Consumer<NkColor> consumer) {
        consumer.accept(this.text_hover());
        return this;
    }

    public NkStyleEdit text_active(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleEdit.ntext_active(this.address(), value);
        return this;
    }

    public NkStyleEdit text_active(Consumer<NkColor> consumer) {
        consumer.accept(this.text_active());
        return this;
    }

    public NkStyleEdit selected_normal(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleEdit.nselected_normal(this.address(), value);
        return this;
    }

    public NkStyleEdit selected_normal(Consumer<NkColor> consumer) {
        consumer.accept(this.selected_normal());
        return this;
    }

    public NkStyleEdit selected_hover(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleEdit.nselected_hover(this.address(), value);
        return this;
    }

    public NkStyleEdit selected_hover(Consumer<NkColor> consumer) {
        consumer.accept(this.selected_hover());
        return this;
    }

    public NkStyleEdit selected_text_normal(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleEdit.nselected_text_normal(this.address(), value);
        return this;
    }

    public NkStyleEdit selected_text_normal(Consumer<NkColor> consumer) {
        consumer.accept(this.selected_text_normal());
        return this;
    }

    public NkStyleEdit selected_text_hover(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleEdit.nselected_text_hover(this.address(), value);
        return this;
    }

    public NkStyleEdit selected_text_hover(Consumer<NkColor> consumer) {
        consumer.accept(this.selected_text_hover());
        return this;
    }

    public NkStyleEdit border(float value) {
        NkStyleEdit.nborder(this.address(), value);
        return this;
    }

    public NkStyleEdit rounding(float value) {
        NkStyleEdit.nrounding(this.address(), value);
        return this;
    }

    public NkStyleEdit cursor_size(float value) {
        NkStyleEdit.ncursor_size(this.address(), value);
        return this;
    }

    public NkStyleEdit scrollbar_size(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleEdit.nscrollbar_size(this.address(), value);
        return this;
    }

    public NkStyleEdit scrollbar_size(Consumer<NkVec2> consumer) {
        consumer.accept(this.scrollbar_size());
        return this;
    }

    public NkStyleEdit padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleEdit.npadding(this.address(), value);
        return this;
    }

    public NkStyleEdit padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.padding());
        return this;
    }

    public NkStyleEdit row_padding(float value) {
        NkStyleEdit.nrow_padding(this.address(), value);
        return this;
    }

    public NkStyleEdit set(NkStyleItem normal, NkStyleItem hover, NkStyleItem active, NkColor border_color, NkStyleScrollbar scrollbar, NkColor cursor_normal, NkColor cursor_hover, NkColor cursor_text_normal, NkColor cursor_text_hover, NkColor text_normal, NkColor text_hover, NkColor text_active, NkColor selected_normal, NkColor selected_hover, NkColor selected_text_normal, NkColor selected_text_hover, float border, float rounding, float cursor_size, NkVec2 scrollbar_size, NkVec2 padding, float row_padding) {
        this.normal(normal);
        this.hover(hover);
        this.active(active);
        this.border_color(border_color);
        this.scrollbar(scrollbar);
        this.cursor_normal(cursor_normal);
        this.cursor_hover(cursor_hover);
        this.cursor_text_normal(cursor_text_normal);
        this.cursor_text_hover(cursor_text_hover);
        this.text_normal(text_normal);
        this.text_hover(text_hover);
        this.text_active(text_active);
        this.selected_normal(selected_normal);
        this.selected_hover(selected_hover);
        this.selected_text_normal(selected_text_normal);
        this.selected_text_hover(selected_text_hover);
        this.border(border);
        this.rounding(rounding);
        this.cursor_size(cursor_size);
        this.scrollbar_size(scrollbar_size);
        this.padding(padding);
        this.row_padding(row_padding);
        return this;
    }

    public NkStyleEdit set(NkStyleEdit src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkStyleEdit malloc() {
        return new NkStyleEdit(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static NkStyleEdit calloc() {
        return new NkStyleEdit(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static NkStyleEdit create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new NkStyleEdit(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static NkStyleEdit create(long address) {
        return new NkStyleEdit(address, null);
    }

    @Nullable
    public static NkStyleEdit createSafe(long address) {
        return address == 0L ? null : new NkStyleEdit(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)NkStyleEdit.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkStyleEdit.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static NkStyleEdit mallocStack() {
        return NkStyleEdit.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleEdit callocStack() {
        return NkStyleEdit.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleEdit mallocStack(MemoryStack stack) {
        return NkStyleEdit.malloc(stack);
    }

    @Deprecated
    public static NkStyleEdit callocStack(MemoryStack stack) {
        return NkStyleEdit.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkStyleEdit.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkStyleEdit.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleEdit.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleEdit.calloc(capacity, stack);
    }

    public static NkStyleEdit malloc(MemoryStack stack) {
        return new NkStyleEdit(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkStyleEdit calloc(MemoryStack stack) {
        return new NkStyleEdit(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkStyleItem nnormal(long struct) {
        return NkStyleItem.create(struct + (long)NORMAL);
    }

    public static NkStyleItem nhover(long struct) {
        return NkStyleItem.create(struct + (long)HOVER);
    }

    public static NkStyleItem nactive(long struct) {
        return NkStyleItem.create(struct + (long)ACTIVE);
    }

    public static NkColor nborder_color(long struct) {
        return NkColor.create(struct + (long)BORDER_COLOR);
    }

    public static NkStyleScrollbar nscrollbar(long struct) {
        return NkStyleScrollbar.create(struct + (long)SCROLLBAR);
    }

    public static NkColor ncursor_normal(long struct) {
        return NkColor.create(struct + (long)CURSOR_NORMAL);
    }

    public static NkColor ncursor_hover(long struct) {
        return NkColor.create(struct + (long)CURSOR_HOVER);
    }

    public static NkColor ncursor_text_normal(long struct) {
        return NkColor.create(struct + (long)CURSOR_TEXT_NORMAL);
    }

    public static NkColor ncursor_text_hover(long struct) {
        return NkColor.create(struct + (long)CURSOR_TEXT_HOVER);
    }

    public static NkColor ntext_normal(long struct) {
        return NkColor.create(struct + (long)TEXT_NORMAL);
    }

    public static NkColor ntext_hover(long struct) {
        return NkColor.create(struct + (long)TEXT_HOVER);
    }

    public static NkColor ntext_active(long struct) {
        return NkColor.create(struct + (long)TEXT_ACTIVE);
    }

    public static NkColor nselected_normal(long struct) {
        return NkColor.create(struct + (long)SELECTED_NORMAL);
    }

    public static NkColor nselected_hover(long struct) {
        return NkColor.create(struct + (long)SELECTED_HOVER);
    }

    public static NkColor nselected_text_normal(long struct) {
        return NkColor.create(struct + (long)SELECTED_TEXT_NORMAL);
    }

    public static NkColor nselected_text_hover(long struct) {
        return NkColor.create(struct + (long)SELECTED_TEXT_HOVER);
    }

    public static float nborder(long struct) {
        return UNSAFE.getFloat(null, struct + (long)BORDER);
    }

    public static float nrounding(long struct) {
        return UNSAFE.getFloat(null, struct + (long)ROUNDING);
    }

    public static float ncursor_size(long struct) {
        return UNSAFE.getFloat(null, struct + (long)CURSOR_SIZE);
    }

    public static NkVec2 nscrollbar_size(long struct) {
        return NkVec2.create(struct + (long)SCROLLBAR_SIZE);
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static float nrow_padding(long struct) {
        return UNSAFE.getFloat(null, struct + (long)ROW_PADDING);
    }

    public static void nnormal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)NORMAL), (long)NkStyleItem.SIZEOF);
    }

    public static void nhover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)HOVER), (long)NkStyleItem.SIZEOF);
    }

    public static void nactive(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ACTIVE), (long)NkStyleItem.SIZEOF);
    }

    public static void nborder_color(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)BORDER_COLOR), (long)NkColor.SIZEOF);
    }

    public static void nscrollbar(long struct, NkStyleScrollbar value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SCROLLBAR), (long)NkStyleScrollbar.SIZEOF);
    }

    public static void ncursor_normal(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CURSOR_NORMAL), (long)NkColor.SIZEOF);
    }

    public static void ncursor_hover(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CURSOR_HOVER), (long)NkColor.SIZEOF);
    }

    public static void ncursor_text_normal(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CURSOR_TEXT_NORMAL), (long)NkColor.SIZEOF);
    }

    public static void ncursor_text_hover(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CURSOR_TEXT_HOVER), (long)NkColor.SIZEOF);
    }

    public static void ntext_normal(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)TEXT_NORMAL), (long)NkColor.SIZEOF);
    }

    public static void ntext_hover(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)TEXT_HOVER), (long)NkColor.SIZEOF);
    }

    public static void ntext_active(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)TEXT_ACTIVE), (long)NkColor.SIZEOF);
    }

    public static void nselected_normal(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SELECTED_NORMAL), (long)NkColor.SIZEOF);
    }

    public static void nselected_hover(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SELECTED_HOVER), (long)NkColor.SIZEOF);
    }

    public static void nselected_text_normal(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SELECTED_TEXT_NORMAL), (long)NkColor.SIZEOF);
    }

    public static void nselected_text_hover(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SELECTED_TEXT_HOVER), (long)NkColor.SIZEOF);
    }

    public static void nborder(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)BORDER, value);
    }

    public static void nrounding(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)ROUNDING, value);
    }

    public static void ncursor_size(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)CURSOR_SIZE, value);
    }

    public static void nscrollbar_size(long struct, NkVec2 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SCROLLBAR_SIZE), (long)NkVec2.SIZEOF);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PADDING), (long)NkVec2.SIZEOF);
    }

    public static void nrow_padding(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)ROW_PADDING, value);
    }

    static {
        Struct.Layout layout = NkStyleEdit.__struct((Struct.Member[])new Struct.Member[]{NkStyleEdit.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleEdit.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleEdit.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleEdit.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleEdit.__member((int)NkStyleScrollbar.SIZEOF, (int)NkStyleScrollbar.ALIGNOF), NkStyleEdit.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleEdit.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleEdit.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleEdit.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleEdit.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleEdit.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleEdit.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleEdit.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleEdit.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleEdit.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleEdit.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleEdit.__member((int)4), NkStyleEdit.__member((int)4), NkStyleEdit.__member((int)4), NkStyleEdit.__member((int)NkVec2.SIZEOF, (int)NkVec2.ALIGNOF), NkStyleEdit.__member((int)NkVec2.SIZEOF, (int)NkVec2.ALIGNOF), NkStyleEdit.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NORMAL = layout.offsetof(0);
        HOVER = layout.offsetof(1);
        ACTIVE = layout.offsetof(2);
        BORDER_COLOR = layout.offsetof(3);
        SCROLLBAR = layout.offsetof(4);
        CURSOR_NORMAL = layout.offsetof(5);
        CURSOR_HOVER = layout.offsetof(6);
        CURSOR_TEXT_NORMAL = layout.offsetof(7);
        CURSOR_TEXT_HOVER = layout.offsetof(8);
        TEXT_NORMAL = layout.offsetof(9);
        TEXT_HOVER = layout.offsetof(10);
        TEXT_ACTIVE = layout.offsetof(11);
        SELECTED_NORMAL = layout.offsetof(12);
        SELECTED_HOVER = layout.offsetof(13);
        SELECTED_TEXT_NORMAL = layout.offsetof(14);
        SELECTED_TEXT_HOVER = layout.offsetof(15);
        BORDER = layout.offsetof(16);
        ROUNDING = layout.offsetof(17);
        CURSOR_SIZE = layout.offsetof(18);
        SCROLLBAR_SIZE = layout.offsetof(19);
        PADDING = layout.offsetof(20);
        ROW_PADDING = layout.offsetof(21);
    }

    public static class Buffer
    extends StructBuffer<NkStyleEdit, Buffer>
    implements NativeResource {
        private static final NkStyleEdit ELEMENT_FACTORY = NkStyleEdit.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkStyleEdit getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem normal() {
            return NkStyleEdit.nnormal(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem hover() {
            return NkStyleEdit.nhover(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem active() {
            return NkStyleEdit.nactive(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor border_color() {
            return NkStyleEdit.nborder_color(this.address());
        }

        @NativeType(value="struct nk_style_scrollbar")
        public NkStyleScrollbar scrollbar() {
            return NkStyleEdit.nscrollbar(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor cursor_normal() {
            return NkStyleEdit.ncursor_normal(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor cursor_hover() {
            return NkStyleEdit.ncursor_hover(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor cursor_text_normal() {
            return NkStyleEdit.ncursor_text_normal(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor cursor_text_hover() {
            return NkStyleEdit.ncursor_text_hover(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor text_normal() {
            return NkStyleEdit.ntext_normal(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor text_hover() {
            return NkStyleEdit.ntext_hover(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor text_active() {
            return NkStyleEdit.ntext_active(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor selected_normal() {
            return NkStyleEdit.nselected_normal(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor selected_hover() {
            return NkStyleEdit.nselected_hover(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor selected_text_normal() {
            return NkStyleEdit.nselected_text_normal(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor selected_text_hover() {
            return NkStyleEdit.nselected_text_hover(this.address());
        }

        public float border() {
            return NkStyleEdit.nborder(this.address());
        }

        public float rounding() {
            return NkStyleEdit.nrounding(this.address());
        }

        public float cursor_size() {
            return NkStyleEdit.ncursor_size(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 scrollbar_size() {
            return NkStyleEdit.nscrollbar_size(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 padding() {
            return NkStyleEdit.npadding(this.address());
        }

        public float row_padding() {
            return NkStyleEdit.nrow_padding(this.address());
        }

        public Buffer normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleEdit.nnormal(this.address(), value);
            return this;
        }

        public Buffer normal(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.normal());
            return this;
        }

        public Buffer hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleEdit.nhover(this.address(), value);
            return this;
        }

        public Buffer hover(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.hover());
            return this;
        }

        public Buffer active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleEdit.nactive(this.address(), value);
            return this;
        }

        public Buffer active(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.active());
            return this;
        }

        public Buffer border_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleEdit.nborder_color(this.address(), value);
            return this;
        }

        public Buffer border_color(Consumer<NkColor> consumer) {
            consumer.accept(this.border_color());
            return this;
        }

        public Buffer scrollbar(@NativeType(value="struct nk_style_scrollbar") NkStyleScrollbar value) {
            NkStyleEdit.nscrollbar(this.address(), value);
            return this;
        }

        public Buffer scrollbar(Consumer<NkStyleScrollbar> consumer) {
            consumer.accept(this.scrollbar());
            return this;
        }

        public Buffer cursor_normal(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleEdit.ncursor_normal(this.address(), value);
            return this;
        }

        public Buffer cursor_normal(Consumer<NkColor> consumer) {
            consumer.accept(this.cursor_normal());
            return this;
        }

        public Buffer cursor_hover(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleEdit.ncursor_hover(this.address(), value);
            return this;
        }

        public Buffer cursor_hover(Consumer<NkColor> consumer) {
            consumer.accept(this.cursor_hover());
            return this;
        }

        public Buffer cursor_text_normal(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleEdit.ncursor_text_normal(this.address(), value);
            return this;
        }

        public Buffer cursor_text_normal(Consumer<NkColor> consumer) {
            consumer.accept(this.cursor_text_normal());
            return this;
        }

        public Buffer cursor_text_hover(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleEdit.ncursor_text_hover(this.address(), value);
            return this;
        }

        public Buffer cursor_text_hover(Consumer<NkColor> consumer) {
            consumer.accept(this.cursor_text_hover());
            return this;
        }

        public Buffer text_normal(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleEdit.ntext_normal(this.address(), value);
            return this;
        }

        public Buffer text_normal(Consumer<NkColor> consumer) {
            consumer.accept(this.text_normal());
            return this;
        }

        public Buffer text_hover(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleEdit.ntext_hover(this.address(), value);
            return this;
        }

        public Buffer text_hover(Consumer<NkColor> consumer) {
            consumer.accept(this.text_hover());
            return this;
        }

        public Buffer text_active(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleEdit.ntext_active(this.address(), value);
            return this;
        }

        public Buffer text_active(Consumer<NkColor> consumer) {
            consumer.accept(this.text_active());
            return this;
        }

        public Buffer selected_normal(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleEdit.nselected_normal(this.address(), value);
            return this;
        }

        public Buffer selected_normal(Consumer<NkColor> consumer) {
            consumer.accept(this.selected_normal());
            return this;
        }

        public Buffer selected_hover(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleEdit.nselected_hover(this.address(), value);
            return this;
        }

        public Buffer selected_hover(Consumer<NkColor> consumer) {
            consumer.accept(this.selected_hover());
            return this;
        }

        public Buffer selected_text_normal(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleEdit.nselected_text_normal(this.address(), value);
            return this;
        }

        public Buffer selected_text_normal(Consumer<NkColor> consumer) {
            consumer.accept(this.selected_text_normal());
            return this;
        }

        public Buffer selected_text_hover(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleEdit.nselected_text_hover(this.address(), value);
            return this;
        }

        public Buffer selected_text_hover(Consumer<NkColor> consumer) {
            consumer.accept(this.selected_text_hover());
            return this;
        }

        public Buffer border(float value) {
            NkStyleEdit.nborder(this.address(), value);
            return this;
        }

        public Buffer rounding(float value) {
            NkStyleEdit.nrounding(this.address(), value);
            return this;
        }

        public Buffer cursor_size(float value) {
            NkStyleEdit.ncursor_size(this.address(), value);
            return this;
        }

        public Buffer scrollbar_size(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleEdit.nscrollbar_size(this.address(), value);
            return this;
        }

        public Buffer scrollbar_size(Consumer<NkVec2> consumer) {
            consumer.accept(this.scrollbar_size());
            return this;
        }

        public Buffer padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleEdit.npadding(this.address(), value);
            return this;
        }

        public Buffer padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.padding());
            return this;
        }

        public Buffer row_padding(float value) {
            NkStyleEdit.nrow_padding(this.address(), value);
            return this;
        }
    }
}

