/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkDrawBeginCallback;
import org.lwjgl.nuklear.NkDrawBeginCallbackI;
import org.lwjgl.nuklear.NkDrawEndCallback;
import org.lwjgl.nuklear.NkDrawEndCallbackI;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_style_progress")
public class NkStyleProgress
extends Struct<NkStyleProgress>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NORMAL;
    public static final int HOVER;
    public static final int ACTIVE;
    public static final int BORDER_COLOR;
    public static final int CURSOR_NORMAL;
    public static final int CURSOR_HOVER;
    public static final int CURSOR_ACTIVE;
    public static final int CURSOR_BORDER_COLOR;
    public static final int ROUNDING;
    public static final int BORDER;
    public static final int CURSOR_BORDER;
    public static final int CURSOR_ROUNDING;
    public static final int PADDING;
    public static final int USERDATA;
    public static final int DRAW_BEGIN;
    public static final int DRAW_END;

    protected NkStyleProgress(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkStyleProgress create(long address, @Nullable ByteBuffer container) {
        return new NkStyleProgress(address, container);
    }

    public NkStyleProgress(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkStyleProgress.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem normal() {
        return NkStyleProgress.nnormal(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem hover() {
        return NkStyleProgress.nhover(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem active() {
        return NkStyleProgress.nactive(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor border_color() {
        return NkStyleProgress.nborder_color(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem cursor_normal() {
        return NkStyleProgress.ncursor_normal(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem cursor_hover() {
        return NkStyleProgress.ncursor_hover(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem cursor_active() {
        return NkStyleProgress.ncursor_active(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor cursor_border_color() {
        return NkStyleProgress.ncursor_border_color(this.address());
    }

    public float rounding() {
        return NkStyleProgress.nrounding(this.address());
    }

    public float border() {
        return NkStyleProgress.nborder(this.address());
    }

    public float cursor_border() {
        return NkStyleProgress.ncursor_border(this.address());
    }

    public float cursor_rounding() {
        return NkStyleProgress.ncursor_rounding(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 padding() {
        return NkStyleProgress.npadding(this.address());
    }

    @NativeType(value="nk_handle")
    public NkHandle userdata() {
        return NkStyleProgress.nuserdata(this.address());
    }

    @Nullable
    @NativeType(value="nk_draw_begin")
    public NkDrawBeginCallback draw_begin() {
        return NkStyleProgress.ndraw_begin(this.address());
    }

    @Nullable
    @NativeType(value="nk_draw_end")
    public NkDrawEndCallback draw_end() {
        return NkStyleProgress.ndraw_end(this.address());
    }

    public NkStyleProgress normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleProgress.nnormal(this.address(), value);
        return this;
    }

    public NkStyleProgress normal(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.normal());
        return this;
    }

    public NkStyleProgress hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleProgress.nhover(this.address(), value);
        return this;
    }

    public NkStyleProgress hover(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.hover());
        return this;
    }

    public NkStyleProgress active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleProgress.nactive(this.address(), value);
        return this;
    }

    public NkStyleProgress active(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.active());
        return this;
    }

    public NkStyleProgress border_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleProgress.nborder_color(this.address(), value);
        return this;
    }

    public NkStyleProgress border_color(Consumer<NkColor> consumer) {
        consumer.accept(this.border_color());
        return this;
    }

    public NkStyleProgress cursor_normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleProgress.ncursor_normal(this.address(), value);
        return this;
    }

    public NkStyleProgress cursor_normal(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.cursor_normal());
        return this;
    }

    public NkStyleProgress cursor_hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleProgress.ncursor_hover(this.address(), value);
        return this;
    }

    public NkStyleProgress cursor_hover(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.cursor_hover());
        return this;
    }

    public NkStyleProgress cursor_active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleProgress.ncursor_active(this.address(), value);
        return this;
    }

    public NkStyleProgress cursor_active(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.cursor_active());
        return this;
    }

    public NkStyleProgress cursor_border_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleProgress.ncursor_border_color(this.address(), value);
        return this;
    }

    public NkStyleProgress cursor_border_color(Consumer<NkColor> consumer) {
        consumer.accept(this.cursor_border_color());
        return this;
    }

    public NkStyleProgress rounding(float value) {
        NkStyleProgress.nrounding(this.address(), value);
        return this;
    }

    public NkStyleProgress border(float value) {
        NkStyleProgress.nborder(this.address(), value);
        return this;
    }

    public NkStyleProgress cursor_border(float value) {
        NkStyleProgress.ncursor_border(this.address(), value);
        return this;
    }

    public NkStyleProgress cursor_rounding(float value) {
        NkStyleProgress.ncursor_rounding(this.address(), value);
        return this;
    }

    public NkStyleProgress padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleProgress.npadding(this.address(), value);
        return this;
    }

    public NkStyleProgress padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.padding());
        return this;
    }

    public NkStyleProgress userdata(@NativeType(value="nk_handle") NkHandle value) {
        NkStyleProgress.nuserdata(this.address(), value);
        return this;
    }

    public NkStyleProgress userdata(Consumer<NkHandle> consumer) {
        consumer.accept(this.userdata());
        return this;
    }

    public NkStyleProgress draw_begin(@Nullable @NativeType(value="nk_draw_begin") NkDrawBeginCallbackI value) {
        NkStyleProgress.ndraw_begin(this.address(), value);
        return this;
    }

    public NkStyleProgress draw_end(@Nullable @NativeType(value="nk_draw_end") NkDrawEndCallbackI value) {
        NkStyleProgress.ndraw_end(this.address(), value);
        return this;
    }

    public NkStyleProgress set(NkStyleItem normal, NkStyleItem hover, NkStyleItem active, NkColor border_color, NkStyleItem cursor_normal, NkStyleItem cursor_hover, NkStyleItem cursor_active, NkColor cursor_border_color, float rounding, float border, float cursor_border, float cursor_rounding, NkVec2 padding, NkHandle userdata, NkDrawBeginCallbackI draw_begin, NkDrawEndCallbackI draw_end) {
        this.normal(normal);
        this.hover(hover);
        this.active(active);
        this.border_color(border_color);
        this.cursor_normal(cursor_normal);
        this.cursor_hover(cursor_hover);
        this.cursor_active(cursor_active);
        this.cursor_border_color(cursor_border_color);
        this.rounding(rounding);
        this.border(border);
        this.cursor_border(cursor_border);
        this.cursor_rounding(cursor_rounding);
        this.padding(padding);
        this.userdata(userdata);
        this.draw_begin(draw_begin);
        this.draw_end(draw_end);
        return this;
    }

    public NkStyleProgress set(NkStyleProgress src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkStyleProgress malloc() {
        return new NkStyleProgress(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static NkStyleProgress calloc() {
        return new NkStyleProgress(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static NkStyleProgress create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new NkStyleProgress(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static NkStyleProgress create(long address) {
        return new NkStyleProgress(address, null);
    }

    @Nullable
    public static NkStyleProgress createSafe(long address) {
        return address == 0L ? null : new NkStyleProgress(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)NkStyleProgress.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkStyleProgress.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static NkStyleProgress mallocStack() {
        return NkStyleProgress.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleProgress callocStack() {
        return NkStyleProgress.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleProgress mallocStack(MemoryStack stack) {
        return NkStyleProgress.malloc(stack);
    }

    @Deprecated
    public static NkStyleProgress callocStack(MemoryStack stack) {
        return NkStyleProgress.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkStyleProgress.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkStyleProgress.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleProgress.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleProgress.calloc(capacity, stack);
    }

    public static NkStyleProgress malloc(MemoryStack stack) {
        return new NkStyleProgress(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkStyleProgress calloc(MemoryStack stack) {
        return new NkStyleProgress(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkStyleItem nnormal(long struct) {
        return NkStyleItem.create(struct + (long)NORMAL);
    }

    public static NkStyleItem nhover(long struct) {
        return NkStyleItem.create(struct + (long)HOVER);
    }

    public static NkStyleItem nactive(long struct) {
        return NkStyleItem.create(struct + (long)ACTIVE);
    }

    public static NkColor nborder_color(long struct) {
        return NkColor.create(struct + (long)BORDER_COLOR);
    }

    public static NkStyleItem ncursor_normal(long struct) {
        return NkStyleItem.create(struct + (long)CURSOR_NORMAL);
    }

    public static NkStyleItem ncursor_hover(long struct) {
        return NkStyleItem.create(struct + (long)CURSOR_HOVER);
    }

    public static NkStyleItem ncursor_active(long struct) {
        return NkStyleItem.create(struct + (long)CURSOR_ACTIVE);
    }

    public static NkColor ncursor_border_color(long struct) {
        return NkColor.create(struct + (long)CURSOR_BORDER_COLOR);
    }

    public static float nrounding(long struct) {
        return UNSAFE.getFloat(null, struct + (long)ROUNDING);
    }

    public static float nborder(long struct) {
        return UNSAFE.getFloat(null, struct + (long)BORDER);
    }

    public static float ncursor_border(long struct) {
        return UNSAFE.getFloat(null, struct + (long)CURSOR_BORDER);
    }

    public static float ncursor_rounding(long struct) {
        return UNSAFE.getFloat(null, struct + (long)CURSOR_ROUNDING);
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    @Nullable
    public static NkDrawBeginCallback ndraw_begin(long struct) {
        return NkDrawBeginCallback.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)DRAW_BEGIN)));
    }

    @Nullable
    public static NkDrawEndCallback ndraw_end(long struct) {
        return NkDrawEndCallback.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)DRAW_END)));
    }

    public static void nnormal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)NORMAL), (long)NkStyleItem.SIZEOF);
    }

    public static void nhover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)HOVER), (long)NkStyleItem.SIZEOF);
    }

    public static void nactive(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ACTIVE), (long)NkStyleItem.SIZEOF);
    }

    public static void nborder_color(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)BORDER_COLOR), (long)NkColor.SIZEOF);
    }

    public static void ncursor_normal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CURSOR_NORMAL), (long)NkStyleItem.SIZEOF);
    }

    public static void ncursor_hover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CURSOR_HOVER), (long)NkStyleItem.SIZEOF);
    }

    public static void ncursor_active(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CURSOR_ACTIVE), (long)NkStyleItem.SIZEOF);
    }

    public static void ncursor_border_color(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CURSOR_BORDER_COLOR), (long)NkColor.SIZEOF);
    }

    public static void nrounding(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)ROUNDING, value);
    }

    public static void nborder(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)BORDER, value);
    }

    public static void ncursor_border(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)CURSOR_BORDER, value);
    }

    public static void ncursor_rounding(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)CURSOR_ROUNDING, value);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PADDING), (long)NkVec2.SIZEOF);
    }

    public static void nuserdata(long struct, NkHandle value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)USERDATA), (long)NkHandle.SIZEOF);
    }

    public static void ndraw_begin(long struct, @Nullable NkDrawBeginCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DRAW_BEGIN), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void ndraw_end(long struct, @Nullable NkDrawEndCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DRAW_END), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    static {
        Struct.Layout layout = NkStyleProgress.__struct((Struct.Member[])new Struct.Member[]{NkStyleProgress.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleProgress.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleProgress.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleProgress.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleProgress.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleProgress.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleProgress.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleProgress.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleProgress.__member((int)4), NkStyleProgress.__member((int)4), NkStyleProgress.__member((int)4), NkStyleProgress.__member((int)4), NkStyleProgress.__member((int)NkVec2.SIZEOF, (int)NkVec2.ALIGNOF), NkStyleProgress.__member((int)NkHandle.SIZEOF, (int)NkHandle.ALIGNOF), NkStyleProgress.__member((int)POINTER_SIZE), NkStyleProgress.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NORMAL = layout.offsetof(0);
        HOVER = layout.offsetof(1);
        ACTIVE = layout.offsetof(2);
        BORDER_COLOR = layout.offsetof(3);
        CURSOR_NORMAL = layout.offsetof(4);
        CURSOR_HOVER = layout.offsetof(5);
        CURSOR_ACTIVE = layout.offsetof(6);
        CURSOR_BORDER_COLOR = layout.offsetof(7);
        ROUNDING = layout.offsetof(8);
        BORDER = layout.offsetof(9);
        CURSOR_BORDER = layout.offsetof(10);
        CURSOR_ROUNDING = layout.offsetof(11);
        PADDING = layout.offsetof(12);
        USERDATA = layout.offsetof(13);
        DRAW_BEGIN = layout.offsetof(14);
        DRAW_END = layout.offsetof(15);
    }

    public static class Buffer
    extends StructBuffer<NkStyleProgress, Buffer>
    implements NativeResource {
        private static final NkStyleProgress ELEMENT_FACTORY = NkStyleProgress.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkStyleProgress getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem normal() {
            return NkStyleProgress.nnormal(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem hover() {
            return NkStyleProgress.nhover(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem active() {
            return NkStyleProgress.nactive(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor border_color() {
            return NkStyleProgress.nborder_color(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem cursor_normal() {
            return NkStyleProgress.ncursor_normal(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem cursor_hover() {
            return NkStyleProgress.ncursor_hover(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem cursor_active() {
            return NkStyleProgress.ncursor_active(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor cursor_border_color() {
            return NkStyleProgress.ncursor_border_color(this.address());
        }

        public float rounding() {
            return NkStyleProgress.nrounding(this.address());
        }

        public float border() {
            return NkStyleProgress.nborder(this.address());
        }

        public float cursor_border() {
            return NkStyleProgress.ncursor_border(this.address());
        }

        public float cursor_rounding() {
            return NkStyleProgress.ncursor_rounding(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 padding() {
            return NkStyleProgress.npadding(this.address());
        }

        @NativeType(value="nk_handle")
        public NkHandle userdata() {
            return NkStyleProgress.nuserdata(this.address());
        }

        @Nullable
        @NativeType(value="nk_draw_begin")
        public NkDrawBeginCallback draw_begin() {
            return NkStyleProgress.ndraw_begin(this.address());
        }

        @Nullable
        @NativeType(value="nk_draw_end")
        public NkDrawEndCallback draw_end() {
            return NkStyleProgress.ndraw_end(this.address());
        }

        public Buffer normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleProgress.nnormal(this.address(), value);
            return this;
        }

        public Buffer normal(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.normal());
            return this;
        }

        public Buffer hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleProgress.nhover(this.address(), value);
            return this;
        }

        public Buffer hover(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.hover());
            return this;
        }

        public Buffer active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleProgress.nactive(this.address(), value);
            return this;
        }

        public Buffer active(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.active());
            return this;
        }

        public Buffer border_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleProgress.nborder_color(this.address(), value);
            return this;
        }

        public Buffer border_color(Consumer<NkColor> consumer) {
            consumer.accept(this.border_color());
            return this;
        }

        public Buffer cursor_normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleProgress.ncursor_normal(this.address(), value);
            return this;
        }

        public Buffer cursor_normal(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.cursor_normal());
            return this;
        }

        public Buffer cursor_hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleProgress.ncursor_hover(this.address(), value);
            return this;
        }

        public Buffer cursor_hover(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.cursor_hover());
            return this;
        }

        public Buffer cursor_active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleProgress.ncursor_active(this.address(), value);
            return this;
        }

        public Buffer cursor_active(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.cursor_active());
            return this;
        }

        public Buffer cursor_border_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleProgress.ncursor_border_color(this.address(), value);
            return this;
        }

        public Buffer cursor_border_color(Consumer<NkColor> consumer) {
            consumer.accept(this.cursor_border_color());
            return this;
        }

        public Buffer rounding(float value) {
            NkStyleProgress.nrounding(this.address(), value);
            return this;
        }

        public Buffer border(float value) {
            NkStyleProgress.nborder(this.address(), value);
            return this;
        }

        public Buffer cursor_border(float value) {
            NkStyleProgress.ncursor_border(this.address(), value);
            return this;
        }

        public Buffer cursor_rounding(float value) {
            NkStyleProgress.ncursor_rounding(this.address(), value);
            return this;
        }

        public Buffer padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleProgress.npadding(this.address(), value);
            return this;
        }

        public Buffer padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.padding());
            return this;
        }

        public Buffer userdata(@NativeType(value="nk_handle") NkHandle value) {
            NkStyleProgress.nuserdata(this.address(), value);
            return this;
        }

        public Buffer userdata(Consumer<NkHandle> consumer) {
            consumer.accept(this.userdata());
            return this;
        }

        public Buffer draw_begin(@Nullable @NativeType(value="nk_draw_begin") NkDrawBeginCallbackI value) {
            NkStyleProgress.ndraw_begin(this.address(), value);
            return this;
        }

        public Buffer draw_end(@Nullable @NativeType(value="nk_draw_end") NkDrawEndCallbackI value) {
            NkStyleProgress.ndraw_end(this.address(), value);
            return this;
        }
    }
}

