/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkDrawBeginCallback;
import org.lwjgl.nuklear.NkDrawBeginCallbackI;
import org.lwjgl.nuklear.NkDrawEndCallback;
import org.lwjgl.nuklear.NkDrawEndCallbackI;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_style_toggle")
public class NkStyleToggle
extends Struct<NkStyleToggle>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NORMAL;
    public static final int HOVER;
    public static final int ACTIVE;
    public static final int BORDER_COLOR;
    public static final int CURSOR_NORMAL;
    public static final int CURSOR_HOVER;
    public static final int TEXT_NORMAL;
    public static final int TEXT_HOVER;
    public static final int TEXT_ACTIVE;
    public static final int TEXT_BACKGROUND;
    public static final int TEXT_ALIGNMENT;
    public static final int PADDING;
    public static final int TOUCH_PADDING;
    public static final int SPACING;
    public static final int BORDER;
    public static final int USERDATA;
    public static final int DRAW_BEGIN;
    public static final int DRAW_END;

    protected NkStyleToggle(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkStyleToggle create(long address, @Nullable ByteBuffer container) {
        return new NkStyleToggle(address, container);
    }

    public NkStyleToggle(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkStyleToggle.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem normal() {
        return NkStyleToggle.nnormal(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem hover() {
        return NkStyleToggle.nhover(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem active() {
        return NkStyleToggle.nactive(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor border_color() {
        return NkStyleToggle.nborder_color(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem cursor_normal() {
        return NkStyleToggle.ncursor_normal(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem cursor_hover() {
        return NkStyleToggle.ncursor_hover(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor text_normal() {
        return NkStyleToggle.ntext_normal(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor text_hover() {
        return NkStyleToggle.ntext_hover(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor text_active() {
        return NkStyleToggle.ntext_active(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor text_background() {
        return NkStyleToggle.ntext_background(this.address());
    }

    @NativeType(value="nk_flags")
    public int text_alignment() {
        return NkStyleToggle.ntext_alignment(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 padding() {
        return NkStyleToggle.npadding(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 touch_padding() {
        return NkStyleToggle.ntouch_padding(this.address());
    }

    public float spacing() {
        return NkStyleToggle.nspacing(this.address());
    }

    public float border() {
        return NkStyleToggle.nborder(this.address());
    }

    @NativeType(value="nk_handle")
    public NkHandle userdata() {
        return NkStyleToggle.nuserdata(this.address());
    }

    @Nullable
    @NativeType(value="nk_draw_begin")
    public NkDrawBeginCallback draw_begin() {
        return NkStyleToggle.ndraw_begin(this.address());
    }

    @Nullable
    @NativeType(value="nk_draw_end")
    public NkDrawEndCallback draw_end() {
        return NkStyleToggle.ndraw_end(this.address());
    }

    public NkStyleToggle normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleToggle.nnormal(this.address(), value);
        return this;
    }

    public NkStyleToggle normal(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.normal());
        return this;
    }

    public NkStyleToggle hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleToggle.nhover(this.address(), value);
        return this;
    }

    public NkStyleToggle hover(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.hover());
        return this;
    }

    public NkStyleToggle active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleToggle.nactive(this.address(), value);
        return this;
    }

    public NkStyleToggle active(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.active());
        return this;
    }

    public NkStyleToggle border_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleToggle.nborder_color(this.address(), value);
        return this;
    }

    public NkStyleToggle border_color(Consumer<NkColor> consumer) {
        consumer.accept(this.border_color());
        return this;
    }

    public NkStyleToggle cursor_normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleToggle.ncursor_normal(this.address(), value);
        return this;
    }

    public NkStyleToggle cursor_normal(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.cursor_normal());
        return this;
    }

    public NkStyleToggle cursor_hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleToggle.ncursor_hover(this.address(), value);
        return this;
    }

    public NkStyleToggle cursor_hover(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.cursor_hover());
        return this;
    }

    public NkStyleToggle text_normal(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleToggle.ntext_normal(this.address(), value);
        return this;
    }

    public NkStyleToggle text_normal(Consumer<NkColor> consumer) {
        consumer.accept(this.text_normal());
        return this;
    }

    public NkStyleToggle text_hover(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleToggle.ntext_hover(this.address(), value);
        return this;
    }

    public NkStyleToggle text_hover(Consumer<NkColor> consumer) {
        consumer.accept(this.text_hover());
        return this;
    }

    public NkStyleToggle text_active(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleToggle.ntext_active(this.address(), value);
        return this;
    }

    public NkStyleToggle text_active(Consumer<NkColor> consumer) {
        consumer.accept(this.text_active());
        return this;
    }

    public NkStyleToggle text_background(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleToggle.ntext_background(this.address(), value);
        return this;
    }

    public NkStyleToggle text_background(Consumer<NkColor> consumer) {
        consumer.accept(this.text_background());
        return this;
    }

    public NkStyleToggle text_alignment(@NativeType(value="nk_flags") int value) {
        NkStyleToggle.ntext_alignment(this.address(), value);
        return this;
    }

    public NkStyleToggle padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleToggle.npadding(this.address(), value);
        return this;
    }

    public NkStyleToggle padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.padding());
        return this;
    }

    public NkStyleToggle touch_padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleToggle.ntouch_padding(this.address(), value);
        return this;
    }

    public NkStyleToggle touch_padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.touch_padding());
        return this;
    }

    public NkStyleToggle spacing(float value) {
        NkStyleToggle.nspacing(this.address(), value);
        return this;
    }

    public NkStyleToggle border(float value) {
        NkStyleToggle.nborder(this.address(), value);
        return this;
    }

    public NkStyleToggle userdata(@NativeType(value="nk_handle") NkHandle value) {
        NkStyleToggle.nuserdata(this.address(), value);
        return this;
    }

    public NkStyleToggle userdata(Consumer<NkHandle> consumer) {
        consumer.accept(this.userdata());
        return this;
    }

    public NkStyleToggle draw_begin(@Nullable @NativeType(value="nk_draw_begin") NkDrawBeginCallbackI value) {
        NkStyleToggle.ndraw_begin(this.address(), value);
        return this;
    }

    public NkStyleToggle draw_end(@Nullable @NativeType(value="nk_draw_end") NkDrawEndCallbackI value) {
        NkStyleToggle.ndraw_end(this.address(), value);
        return this;
    }

    public NkStyleToggle set(NkStyleItem normal, NkStyleItem hover, NkStyleItem active, NkColor border_color, NkStyleItem cursor_normal, NkStyleItem cursor_hover, NkColor text_normal, NkColor text_hover, NkColor text_active, NkColor text_background, int text_alignment, NkVec2 padding, NkVec2 touch_padding, float spacing, float border, NkHandle userdata, NkDrawBeginCallbackI draw_begin, NkDrawEndCallbackI draw_end) {
        this.normal(normal);
        this.hover(hover);
        this.active(active);
        this.border_color(border_color);
        this.cursor_normal(cursor_normal);
        this.cursor_hover(cursor_hover);
        this.text_normal(text_normal);
        this.text_hover(text_hover);
        this.text_active(text_active);
        this.text_background(text_background);
        this.text_alignment(text_alignment);
        this.padding(padding);
        this.touch_padding(touch_padding);
        this.spacing(spacing);
        this.border(border);
        this.userdata(userdata);
        this.draw_begin(draw_begin);
        this.draw_end(draw_end);
        return this;
    }

    public NkStyleToggle set(NkStyleToggle src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkStyleToggle malloc() {
        return new NkStyleToggle(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static NkStyleToggle calloc() {
        return new NkStyleToggle(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static NkStyleToggle create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new NkStyleToggle(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static NkStyleToggle create(long address) {
        return new NkStyleToggle(address, null);
    }

    @Nullable
    public static NkStyleToggle createSafe(long address) {
        return address == 0L ? null : new NkStyleToggle(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)NkStyleToggle.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkStyleToggle.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static NkStyleToggle mallocStack() {
        return NkStyleToggle.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleToggle callocStack() {
        return NkStyleToggle.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleToggle mallocStack(MemoryStack stack) {
        return NkStyleToggle.malloc(stack);
    }

    @Deprecated
    public static NkStyleToggle callocStack(MemoryStack stack) {
        return NkStyleToggle.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkStyleToggle.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkStyleToggle.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleToggle.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleToggle.calloc(capacity, stack);
    }

    public static NkStyleToggle malloc(MemoryStack stack) {
        return new NkStyleToggle(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkStyleToggle calloc(MemoryStack stack) {
        return new NkStyleToggle(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkStyleItem nnormal(long struct) {
        return NkStyleItem.create(struct + (long)NORMAL);
    }

    public static NkStyleItem nhover(long struct) {
        return NkStyleItem.create(struct + (long)HOVER);
    }

    public static NkStyleItem nactive(long struct) {
        return NkStyleItem.create(struct + (long)ACTIVE);
    }

    public static NkColor nborder_color(long struct) {
        return NkColor.create(struct + (long)BORDER_COLOR);
    }

    public static NkStyleItem ncursor_normal(long struct) {
        return NkStyleItem.create(struct + (long)CURSOR_NORMAL);
    }

    public static NkStyleItem ncursor_hover(long struct) {
        return NkStyleItem.create(struct + (long)CURSOR_HOVER);
    }

    public static NkColor ntext_normal(long struct) {
        return NkColor.create(struct + (long)TEXT_NORMAL);
    }

    public static NkColor ntext_hover(long struct) {
        return NkColor.create(struct + (long)TEXT_HOVER);
    }

    public static NkColor ntext_active(long struct) {
        return NkColor.create(struct + (long)TEXT_ACTIVE);
    }

    public static NkColor ntext_background(long struct) {
        return NkColor.create(struct + (long)TEXT_BACKGROUND);
    }

    public static int ntext_alignment(long struct) {
        return UNSAFE.getInt(null, struct + (long)TEXT_ALIGNMENT);
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static NkVec2 ntouch_padding(long struct) {
        return NkVec2.create(struct + (long)TOUCH_PADDING);
    }

    public static float nspacing(long struct) {
        return UNSAFE.getFloat(null, struct + (long)SPACING);
    }

    public static float nborder(long struct) {
        return UNSAFE.getFloat(null, struct + (long)BORDER);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    @Nullable
    public static NkDrawBeginCallback ndraw_begin(long struct) {
        return NkDrawBeginCallback.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)DRAW_BEGIN)));
    }

    @Nullable
    public static NkDrawEndCallback ndraw_end(long struct) {
        return NkDrawEndCallback.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)DRAW_END)));
    }

    public static void nnormal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)NORMAL), (long)NkStyleItem.SIZEOF);
    }

    public static void nhover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)HOVER), (long)NkStyleItem.SIZEOF);
    }

    public static void nactive(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ACTIVE), (long)NkStyleItem.SIZEOF);
    }

    public static void nborder_color(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)BORDER_COLOR), (long)NkColor.SIZEOF);
    }

    public static void ncursor_normal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CURSOR_NORMAL), (long)NkStyleItem.SIZEOF);
    }

    public static void ncursor_hover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CURSOR_HOVER), (long)NkStyleItem.SIZEOF);
    }

    public static void ntext_normal(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)TEXT_NORMAL), (long)NkColor.SIZEOF);
    }

    public static void ntext_hover(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)TEXT_HOVER), (long)NkColor.SIZEOF);
    }

    public static void ntext_active(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)TEXT_ACTIVE), (long)NkColor.SIZEOF);
    }

    public static void ntext_background(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)TEXT_BACKGROUND), (long)NkColor.SIZEOF);
    }

    public static void ntext_alignment(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TEXT_ALIGNMENT, value);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PADDING), (long)NkVec2.SIZEOF);
    }

    public static void ntouch_padding(long struct, NkVec2 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)TOUCH_PADDING), (long)NkVec2.SIZEOF);
    }

    public static void nspacing(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)SPACING, value);
    }

    public static void nborder(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)BORDER, value);
    }

    public static void nuserdata(long struct, NkHandle value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)USERDATA), (long)NkHandle.SIZEOF);
    }

    public static void ndraw_begin(long struct, @Nullable NkDrawBeginCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DRAW_BEGIN), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void ndraw_end(long struct, @Nullable NkDrawEndCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DRAW_END), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    static {
        Struct.Layout layout = NkStyleToggle.__struct((Struct.Member[])new Struct.Member[]{NkStyleToggle.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleToggle.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleToggle.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleToggle.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleToggle.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleToggle.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleToggle.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleToggle.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleToggle.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleToggle.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleToggle.__member((int)4), NkStyleToggle.__member((int)NkVec2.SIZEOF, (int)NkVec2.ALIGNOF), NkStyleToggle.__member((int)NkVec2.SIZEOF, (int)NkVec2.ALIGNOF), NkStyleToggle.__member((int)4), NkStyleToggle.__member((int)4), NkStyleToggle.__member((int)NkHandle.SIZEOF, (int)NkHandle.ALIGNOF), NkStyleToggle.__member((int)POINTER_SIZE), NkStyleToggle.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NORMAL = layout.offsetof(0);
        HOVER = layout.offsetof(1);
        ACTIVE = layout.offsetof(2);
        BORDER_COLOR = layout.offsetof(3);
        CURSOR_NORMAL = layout.offsetof(4);
        CURSOR_HOVER = layout.offsetof(5);
        TEXT_NORMAL = layout.offsetof(6);
        TEXT_HOVER = layout.offsetof(7);
        TEXT_ACTIVE = layout.offsetof(8);
        TEXT_BACKGROUND = layout.offsetof(9);
        TEXT_ALIGNMENT = layout.offsetof(10);
        PADDING = layout.offsetof(11);
        TOUCH_PADDING = layout.offsetof(12);
        SPACING = layout.offsetof(13);
        BORDER = layout.offsetof(14);
        USERDATA = layout.offsetof(15);
        DRAW_BEGIN = layout.offsetof(16);
        DRAW_END = layout.offsetof(17);
    }

    public static class Buffer
    extends StructBuffer<NkStyleToggle, Buffer>
    implements NativeResource {
        private static final NkStyleToggle ELEMENT_FACTORY = NkStyleToggle.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkStyleToggle getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem normal() {
            return NkStyleToggle.nnormal(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem hover() {
            return NkStyleToggle.nhover(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem active() {
            return NkStyleToggle.nactive(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor border_color() {
            return NkStyleToggle.nborder_color(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem cursor_normal() {
            return NkStyleToggle.ncursor_normal(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem cursor_hover() {
            return NkStyleToggle.ncursor_hover(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor text_normal() {
            return NkStyleToggle.ntext_normal(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor text_hover() {
            return NkStyleToggle.ntext_hover(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor text_active() {
            return NkStyleToggle.ntext_active(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor text_background() {
            return NkStyleToggle.ntext_background(this.address());
        }

        @NativeType(value="nk_flags")
        public int text_alignment() {
            return NkStyleToggle.ntext_alignment(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 padding() {
            return NkStyleToggle.npadding(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 touch_padding() {
            return NkStyleToggle.ntouch_padding(this.address());
        }

        public float spacing() {
            return NkStyleToggle.nspacing(this.address());
        }

        public float border() {
            return NkStyleToggle.nborder(this.address());
        }

        @NativeType(value="nk_handle")
        public NkHandle userdata() {
            return NkStyleToggle.nuserdata(this.address());
        }

        @Nullable
        @NativeType(value="nk_draw_begin")
        public NkDrawBeginCallback draw_begin() {
            return NkStyleToggle.ndraw_begin(this.address());
        }

        @Nullable
        @NativeType(value="nk_draw_end")
        public NkDrawEndCallback draw_end() {
            return NkStyleToggle.ndraw_end(this.address());
        }

        public Buffer normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleToggle.nnormal(this.address(), value);
            return this;
        }

        public Buffer normal(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.normal());
            return this;
        }

        public Buffer hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleToggle.nhover(this.address(), value);
            return this;
        }

        public Buffer hover(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.hover());
            return this;
        }

        public Buffer active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleToggle.nactive(this.address(), value);
            return this;
        }

        public Buffer active(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.active());
            return this;
        }

        public Buffer border_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleToggle.nborder_color(this.address(), value);
            return this;
        }

        public Buffer border_color(Consumer<NkColor> consumer) {
            consumer.accept(this.border_color());
            return this;
        }

        public Buffer cursor_normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleToggle.ncursor_normal(this.address(), value);
            return this;
        }

        public Buffer cursor_normal(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.cursor_normal());
            return this;
        }

        public Buffer cursor_hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleToggle.ncursor_hover(this.address(), value);
            return this;
        }

        public Buffer cursor_hover(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.cursor_hover());
            return this;
        }

        public Buffer text_normal(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleToggle.ntext_normal(this.address(), value);
            return this;
        }

        public Buffer text_normal(Consumer<NkColor> consumer) {
            consumer.accept(this.text_normal());
            return this;
        }

        public Buffer text_hover(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleToggle.ntext_hover(this.address(), value);
            return this;
        }

        public Buffer text_hover(Consumer<NkColor> consumer) {
            consumer.accept(this.text_hover());
            return this;
        }

        public Buffer text_active(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleToggle.ntext_active(this.address(), value);
            return this;
        }

        public Buffer text_active(Consumer<NkColor> consumer) {
            consumer.accept(this.text_active());
            return this;
        }

        public Buffer text_background(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleToggle.ntext_background(this.address(), value);
            return this;
        }

        public Buffer text_background(Consumer<NkColor> consumer) {
            consumer.accept(this.text_background());
            return this;
        }

        public Buffer text_alignment(@NativeType(value="nk_flags") int value) {
            NkStyleToggle.ntext_alignment(this.address(), value);
            return this;
        }

        public Buffer padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleToggle.npadding(this.address(), value);
            return this;
        }

        public Buffer padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.padding());
            return this;
        }

        public Buffer touch_padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleToggle.ntouch_padding(this.address(), value);
            return this;
        }

        public Buffer touch_padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.touch_padding());
            return this;
        }

        public Buffer spacing(float value) {
            NkStyleToggle.nspacing(this.address(), value);
            return this;
        }

        public Buffer border(float value) {
            NkStyleToggle.nborder(this.address(), value);
            return this;
        }

        public Buffer userdata(@NativeType(value="nk_handle") NkHandle value) {
            NkStyleToggle.nuserdata(this.address(), value);
            return this;
        }

        public Buffer userdata(Consumer<NkHandle> consumer) {
            consumer.accept(this.userdata());
            return this;
        }

        public Buffer draw_begin(@Nullable @NativeType(value="nk_draw_begin") NkDrawBeginCallbackI value) {
            NkStyleToggle.ndraw_begin(this.address(), value);
            return this;
        }

        public Buffer draw_end(@Nullable @NativeType(value="nk_draw_end") NkDrawEndCallbackI value) {
            NkStyleToggle.ndraw_end(this.address(), value);
            return this;
        }
    }
}

