/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_style_text")
public class NkStyleText
extends Struct<NkStyleText>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int COLOR;
    public static final int PADDING;
    public static final int COLOR_FACTOR;
    public static final int DISABLED_FACTOR;

    protected NkStyleText(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkStyleText create(long address, @Nullable ByteBuffer container) {
        return new NkStyleText(address, container);
    }

    public NkStyleText(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkStyleText.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_color")
    public NkColor color() {
        return NkStyleText.ncolor(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 padding() {
        return NkStyleText.npadding(this.address());
    }

    public float color_factor() {
        return NkStyleText.ncolor_factor(this.address());
    }

    public float disabled_factor() {
        return NkStyleText.ndisabled_factor(this.address());
    }

    public NkStyleText color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleText.ncolor(this.address(), value);
        return this;
    }

    public NkStyleText color(Consumer<NkColor> consumer) {
        consumer.accept(this.color());
        return this;
    }

    public NkStyleText padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleText.npadding(this.address(), value);
        return this;
    }

    public NkStyleText padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.padding());
        return this;
    }

    public NkStyleText color_factor(float value) {
        NkStyleText.ncolor_factor(this.address(), value);
        return this;
    }

    public NkStyleText disabled_factor(float value) {
        NkStyleText.ndisabled_factor(this.address(), value);
        return this;
    }

    public NkStyleText set(NkColor color, NkVec2 padding, float color_factor, float disabled_factor) {
        this.color(color);
        this.padding(padding);
        this.color_factor(color_factor);
        this.disabled_factor(disabled_factor);
        return this;
    }

    public NkStyleText set(NkStyleText src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkStyleText malloc() {
        return new NkStyleText(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static NkStyleText calloc() {
        return new NkStyleText(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static NkStyleText create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new NkStyleText(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static NkStyleText create(long address) {
        return new NkStyleText(address, null);
    }

    @Nullable
    public static NkStyleText createSafe(long address) {
        return address == 0L ? null : new NkStyleText(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)NkStyleText.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkStyleText.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static NkStyleText mallocStack() {
        return NkStyleText.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleText callocStack() {
        return NkStyleText.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleText mallocStack(MemoryStack stack) {
        return NkStyleText.malloc(stack);
    }

    @Deprecated
    public static NkStyleText callocStack(MemoryStack stack) {
        return NkStyleText.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkStyleText.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkStyleText.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleText.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleText.calloc(capacity, stack);
    }

    public static NkStyleText malloc(MemoryStack stack) {
        return new NkStyleText(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkStyleText calloc(MemoryStack stack) {
        return new NkStyleText(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkColor ncolor(long struct) {
        return NkColor.create(struct + (long)COLOR);
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static float ncolor_factor(long struct) {
        return UNSAFE.getFloat(null, struct + (long)COLOR_FACTOR);
    }

    public static float ndisabled_factor(long struct) {
        return UNSAFE.getFloat(null, struct + (long)DISABLED_FACTOR);
    }

    public static void ncolor(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)COLOR), (long)NkColor.SIZEOF);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PADDING), (long)NkVec2.SIZEOF);
    }

    public static void ncolor_factor(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)COLOR_FACTOR, value);
    }

    public static void ndisabled_factor(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)DISABLED_FACTOR, value);
    }

    static {
        Struct.Layout layout = NkStyleText.__struct((Struct.Member[])new Struct.Member[]{NkStyleText.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleText.__member((int)NkVec2.SIZEOF, (int)NkVec2.ALIGNOF), NkStyleText.__member((int)4), NkStyleText.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        COLOR = layout.offsetof(0);
        PADDING = layout.offsetof(1);
        COLOR_FACTOR = layout.offsetof(2);
        DISABLED_FACTOR = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<NkStyleText, Buffer>
    implements NativeResource {
        private static final NkStyleText ELEMENT_FACTORY = NkStyleText.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkStyleText getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_color")
        public NkColor color() {
            return NkStyleText.ncolor(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 padding() {
            return NkStyleText.npadding(this.address());
        }

        public float color_factor() {
            return NkStyleText.ncolor_factor(this.address());
        }

        public float disabled_factor() {
            return NkStyleText.ndisabled_factor(this.address());
        }

        public Buffer color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleText.ncolor(this.address(), value);
            return this;
        }

        public Buffer color(Consumer<NkColor> consumer) {
            consumer.accept(this.color());
            return this;
        }

        public Buffer padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleText.npadding(this.address(), value);
            return this;
        }

        public Buffer padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.padding());
            return this;
        }

        public Buffer color_factor(float value) {
            NkStyleText.ncolor_factor(this.address(), value);
            return this;
        }

        public Buffer disabled_factor(float value) {
            NkStyleText.ndisabled_factor(this.address(), value);
            return this;
        }
    }
}

