/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_colorf")
public class NkColorf
extends Struct<NkColorf>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int R;
    public static final int G;
    public static final int B;
    public static final int A;

    protected NkColorf(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkColorf create(long address, @Nullable ByteBuffer container) {
        return new NkColorf(address, container);
    }

    public NkColorf(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkColorf.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float r() {
        return NkColorf.nr(this.address());
    }

    public float g() {
        return NkColorf.ng(this.address());
    }

    public float b() {
        return NkColorf.nb(this.address());
    }

    public float a() {
        return NkColorf.na(this.address());
    }

    public NkColorf r(float value) {
        NkColorf.nr(this.address(), value);
        return this;
    }

    public NkColorf g(float value) {
        NkColorf.ng(this.address(), value);
        return this;
    }

    public NkColorf b(float value) {
        NkColorf.nb(this.address(), value);
        return this;
    }

    public NkColorf a(float value) {
        NkColorf.na(this.address(), value);
        return this;
    }

    public NkColorf set(float r, float g, float b, float a) {
        this.r(r);
        this.g(g);
        this.b(b);
        this.a(a);
        return this;
    }

    public NkColorf set(NkColorf src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkColorf malloc() {
        return new NkColorf(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static NkColorf calloc() {
        return new NkColorf(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static NkColorf create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new NkColorf(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static NkColorf create(long address) {
        return new NkColorf(address, null);
    }

    public static @Nullable NkColorf createSafe(long address) {
        return address == 0L ? null : new NkColorf(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)NkColorf.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkColorf.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static NkColorf mallocStack() {
        return NkColorf.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkColorf callocStack() {
        return NkColorf.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkColorf mallocStack(MemoryStack stack) {
        return NkColorf.malloc(stack);
    }

    @Deprecated
    public static NkColorf callocStack(MemoryStack stack) {
        return NkColorf.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkColorf.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkColorf.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkColorf.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkColorf.calloc(capacity, stack);
    }

    public static NkColorf malloc(MemoryStack stack) {
        return new NkColorf(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkColorf calloc(MemoryStack stack) {
        return new NkColorf(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nr(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)R));
    }

    public static float ng(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)G));
    }

    public static float nb(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)B));
    }

    public static float na(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)A));
    }

    public static void nr(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)R), (float)value);
    }

    public static void ng(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)G), (float)value);
    }

    public static void nb(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)B), (float)value);
    }

    public static void na(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)A), (float)value);
    }

    static {
        Struct.Layout layout = NkColorf.__struct((Struct.Member[])new Struct.Member[]{NkColorf.__member((int)4), NkColorf.__member((int)4), NkColorf.__member((int)4), NkColorf.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        R = layout.offsetof(0);
        G = layout.offsetof(1);
        B = layout.offsetof(2);
        A = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<NkColorf, Buffer>
    implements NativeResource {
        private static final NkColorf ELEMENT_FACTORY = NkColorf.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected NkColorf getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float r() {
            return NkColorf.nr(this.address());
        }

        public float g() {
            return NkColorf.ng(this.address());
        }

        public float b() {
            return NkColorf.nb(this.address());
        }

        public float a() {
            return NkColorf.na(this.address());
        }

        public Buffer r(float value) {
            NkColorf.nr(this.address(), value);
            return this;
        }

        public Buffer g(float value) {
            NkColorf.ng(this.address(), value);
            return this;
        }

        public Buffer b(float value) {
            NkColorf.nb(this.address(), value);
            return this;
        }

        public Buffer a(float value) {
            NkColorf.na(this.address(), value);
            return this;
        }
    }
}

