/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkImage;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_cursor")
public class NkCursor
extends Struct<NkCursor>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int IMG;
    public static final int SIZE;
    public static final int OFFSET;

    protected NkCursor(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkCursor create(long address, @Nullable ByteBuffer container) {
        return new NkCursor(address, container);
    }

    public NkCursor(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkCursor.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_image")
    public NkImage img() {
        return NkCursor.nimg(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 size() {
        return NkCursor.nsize(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 offset() {
        return NkCursor.noffset(this.address());
    }

    public NkCursor img(@NativeType(value="struct nk_image") NkImage value) {
        NkCursor.nimg(this.address(), value);
        return this;
    }

    public NkCursor img(Consumer<NkImage> consumer) {
        consumer.accept(this.img());
        return this;
    }

    public NkCursor size(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkCursor.nsize(this.address(), value);
        return this;
    }

    public NkCursor size(Consumer<NkVec2> consumer) {
        consumer.accept(this.size());
        return this;
    }

    public NkCursor offset(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkCursor.noffset(this.address(), value);
        return this;
    }

    public NkCursor offset(Consumer<NkVec2> consumer) {
        consumer.accept(this.offset());
        return this;
    }

    public NkCursor set(NkImage img, NkVec2 size, NkVec2 offset) {
        this.img(img);
        this.size(size);
        this.offset(offset);
        return this;
    }

    public NkCursor set(NkCursor src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkCursor malloc() {
        return new NkCursor(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static NkCursor calloc() {
        return new NkCursor(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static NkCursor create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new NkCursor(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static NkCursor create(long address) {
        return new NkCursor(address, null);
    }

    public static @Nullable NkCursor createSafe(long address) {
        return address == 0L ? null : new NkCursor(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)NkCursor.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkCursor.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static NkCursor mallocStack() {
        return NkCursor.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkCursor callocStack() {
        return NkCursor.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkCursor mallocStack(MemoryStack stack) {
        return NkCursor.malloc(stack);
    }

    @Deprecated
    public static NkCursor callocStack(MemoryStack stack) {
        return NkCursor.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkCursor.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkCursor.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkCursor.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkCursor.calloc(capacity, stack);
    }

    public static NkCursor malloc(MemoryStack stack) {
        return new NkCursor(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkCursor calloc(MemoryStack stack) {
        return new NkCursor(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkImage nimg(long struct) {
        return NkImage.create(struct + (long)IMG);
    }

    public static NkVec2 nsize(long struct) {
        return NkVec2.create(struct + (long)SIZE);
    }

    public static NkVec2 noffset(long struct) {
        return NkVec2.create(struct + (long)OFFSET);
    }

    public static void nimg(long struct, NkImage value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)IMG), (long)NkImage.SIZEOF);
    }

    public static void nsize(long struct, NkVec2 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SIZE), (long)NkVec2.SIZEOF);
    }

    public static void noffset(long struct, NkVec2 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)OFFSET), (long)NkVec2.SIZEOF);
    }

    static {
        Struct.Layout layout = NkCursor.__struct((Struct.Member[])new Struct.Member[]{NkCursor.__member((int)NkImage.SIZEOF, (int)NkImage.ALIGNOF), NkCursor.__member((int)NkVec2.SIZEOF, (int)NkVec2.ALIGNOF), NkCursor.__member((int)NkVec2.SIZEOF, (int)NkVec2.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        IMG = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        OFFSET = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<NkCursor, Buffer>
    implements NativeResource {
        private static final NkCursor ELEMENT_FACTORY = NkCursor.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected NkCursor getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_image")
        public NkImage img() {
            return NkCursor.nimg(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 size() {
            return NkCursor.nsize(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 offset() {
            return NkCursor.noffset(this.address());
        }

        public Buffer img(@NativeType(value="struct nk_image") NkImage value) {
            NkCursor.nimg(this.address(), value);
            return this;
        }

        public Buffer img(Consumer<NkImage> consumer) {
            consumer.accept(this.img());
            return this;
        }

        public Buffer size(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkCursor.nsize(this.address(), value);
            return this;
        }

        public Buffer size(Consumer<NkVec2> consumer) {
            consumer.accept(this.size());
            return this;
        }

        public Buffer offset(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkCursor.noffset(this.address(), value);
            return this;
        }

        public Buffer offset(Consumer<NkVec2> consumer) {
            consumer.accept(this.offset());
            return this;
        }
    }
}

