/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_memory")
public class NkMemory
extends Struct<NkMemory> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PTR;
    public static final int SIZE;

    protected NkMemory(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkMemory create(long address, @Nullable ByteBuffer container) {
        return new NkMemory(address, container);
    }

    public NkMemory(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkMemory.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public @Nullable ByteBuffer ptr() {
        return NkMemory.nptr(this.address());
    }

    @NativeType(value="nk_size")
    public long size() {
        return NkMemory.nsize(this.address());
    }

    public static NkMemory create(long address) {
        return new NkMemory(address, null);
    }

    public static @Nullable NkMemory createSafe(long address) {
        return address == 0L ? null : new NkMemory(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static @Nullable ByteBuffer nptr(long struct) {
        return MemoryUtil.memByteBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PTR)), (int)((int)NkMemory.nsize(struct)));
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SIZE));
    }

    static {
        Struct.Layout layout = NkMemory.__struct((Struct.Member[])new Struct.Member[]{NkMemory.__member((int)POINTER_SIZE), NkMemory.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PTR = layout.offsetof(0);
        SIZE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkMemory, Buffer> {
        private static final NkMemory ELEMENT_FACTORY = NkMemory.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected NkMemory getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public @Nullable ByteBuffer ptr() {
            return NkMemory.nptr(this.address());
        }

        @NativeType(value="nk_size")
        public long size() {
            return NkMemory.nsize(this.address());
        }
    }
}

