/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ALC11 {
    public static final int ALC_MONO_SOURCES = 4112;
    public static final int ALC_STEREO_SOURCES = 4113;
    public static final int ALC_DEFAULT_ALL_DEVICES_SPECIFIER = 4114;
    public static final int ALC_ALL_DEVICES_SPECIFIER = 4115;
    public static final int ALC_CAPTURE_DEVICE_SPECIFIER = 784;
    public static final int ALC_CAPTURE_DEFAULT_DEVICE_SPECIFIER = 785;
    public static final int ALC_CAPTURE_SAMPLES = 786;

    protected ALC11() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(ALCCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.alcCaptureOpenDevice, caps.alcCaptureCloseDevice, caps.alcCaptureStart, caps.alcCaptureStop, caps.alcCaptureSamples});
    }

    public static long nalcCaptureOpenDevice(long devicename, int frequency, int format, int buffersize) {
        long __functionAddress = ALC.getICD().alcCaptureOpenDevice;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        return JNI.invokePP((long)__functionAddress, (long)devicename, (int)frequency, (int)format, (int)buffersize);
    }

    public static long alcCaptureOpenDevice(ByteBuffer devicename, int frequency, int format, int buffersize) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)devicename);
        }
        return ALC11.nalcCaptureOpenDevice(MemoryUtil.memAddressSafe((ByteBuffer)devicename), frequency, format, buffersize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long alcCaptureOpenDevice(CharSequence devicename, int frequency, int format, int buffersize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer devicenameEncoded = stack.UTF8(devicename);
            long l = ALC11.nalcCaptureOpenDevice(MemoryUtil.memAddressSafe((ByteBuffer)devicenameEncoded), frequency, format, buffersize);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean alcCaptureCloseDevice(long device) {
        long __functionAddress = ALC.getICD().alcCaptureCloseDevice;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkPointer((long)device);
        }
        return JNI.invokePZ((long)__functionAddress, (long)device);
    }

    public static void alcCaptureStart(long device) {
        long __functionAddress = ALC.getICD().alcCaptureStart;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkPointer((long)device);
        }
        JNI.invokePV((long)__functionAddress, (long)device);
    }

    public static void alcCaptureStop(long device) {
        long __functionAddress = ALC.getICD().alcCaptureStop;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkPointer((long)device);
        }
        JNI.invokePV((long)__functionAddress, (long)device);
    }

    public static void nalcCaptureSamples(long device, long buffer, int samples) {
        long __functionAddress = ALC.getICD().alcCaptureSamples;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
            Checks.checkPointer((long)device);
        }
        JNI.invokePPV((long)__functionAddress, (long)device, (long)buffer, (int)samples);
    }

    public static void alcCaptureSamples(long device, ByteBuffer buffer) {
        ALC11.nalcCaptureSamples(device, MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining());
    }
}

