/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.opencl.CLSVMFreeCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class CL20 {
    public static final int CL_VERSION_2_0 = 1;
    public static final int CL_INVALID_PIPE_SIZE = -69;
    public static final int CL_INVALID_DEVICE_QUEUE = -70;
    public static final int CL_DEVICE_QUEUE_ON_HOST_PROPERTIES = 4138;
    public static final int CL_DEVICE_MAX_READ_WRITE_IMAGE_ARGS = 4172;
    public static final int CL_DEVICE_MAX_GLOBAL_VARIABLE_SIZE = 4173;
    public static final int CL_DEVICE_QUEUE_ON_DEVICE_PROPERTIES = 4174;
    public static final int CL_DEVICE_QUEUE_ON_DEVICE_PREFERRED_SIZE = 4175;
    public static final int CL_DEVICE_QUEUE_ON_DEVICE_MAX_SIZE = 4176;
    public static final int CL_DEVICE_MAX_ON_DEVICE_QUEUES = 4177;
    public static final int CL_DEVICE_MAX_ON_DEVICE_EVENTS = 4178;
    public static final int CL_DEVICE_SVM_CAPABILITIES = 4179;
    public static final int CL_DEVICE_GLOBAL_VARIABLE_PREFERRED_TOTAL_SIZE = 4180;
    public static final int CL_DEVICE_MAX_PIPE_ARGS = 4181;
    public static final int CL_DEVICE_PIPE_MAX_ACTIVE_RESERVATIONS = 4182;
    public static final int CL_DEVICE_PIPE_MAX_PACKET_SIZE = 4183;
    public static final int CL_DEVICE_PREFERRED_PLATFORM_ATOMIC_ALIGNMENT = 4184;
    public static final int CL_DEVICE_PREFERRED_GLOBAL_ATOMIC_ALIGNMENT = 4185;
    public static final int CL_DEVICE_PREFERRED_LOCAL_ATOMIC_ALIGNMENT = 4186;
    public static final int CL_QUEUE_ON_DEVICE = 4;
    public static final int CL_QUEUE_ON_DEVICE_DEFAULT = 8;
    public static final int CL_DEVICE_SVM_COARSE_GRAIN_BUFFER = 1;
    public static final int CL_DEVICE_SVM_FINE_GRAIN_BUFFER = 2;
    public static final int CL_DEVICE_SVM_FINE_GRAIN_SYSTEM = 4;
    public static final int CL_DEVICE_SVM_ATOMICS = 8;
    public static final int CL_QUEUE_SIZE = 4244;
    public static final int CL_MEM_SVM_FINE_GRAIN_BUFFER = 1024;
    public static final int CL_MEM_SVM_ATOMICS = 2048;
    public static final int CL_MEM_OBJECT_PIPE = 4343;
    public static final int CL_MEM_USES_SVM_POINTER = 4361;
    public static final int CL_sRGB = 4287;
    public static final int CL_sRGBx = 4288;
    public static final int CL_sRGBA = 4289;
    public static final int CL_sBGRA = 4290;
    public static final int CL_ABGR = 4291;
    public static final int CL_PIPE_PACKET_SIZE = 4384;
    public static final int CL_PIPE_MAX_PACKETS = 4385;
    public static final int CL_SAMPLER_MIP_FILTER_MODE = 4437;
    public static final int CL_SAMPLER_LOD_MIN = 4438;
    public static final int CL_SAMPLER_LOD_MAX = 4439;
    public static final int CL_PROGRAM_BUILD_GLOBAL_VARIABLE_TOTAL_SIZE = 4485;
    public static final int CL_KERNEL_ARG_TYPE_PIPE = 8;
    public static final int CL_KERNEL_EXEC_INFO_SVM_PTRS = 4534;
    public static final int CL_KERNEL_EXEC_INFO_SVM_FINE_GRAIN_SYSTEM = 4535;
    public static final int CL_COMMAND_SVM_FREE = 4617;
    public static final int CL_COMMAND_SVM_MEMCPY = 4618;
    public static final int CL_COMMAND_SVM_MEMFILL = 4619;
    public static final int CL_COMMAND_SVM_MAP = 4620;
    public static final int CL_COMMAND_SVM_UNMAP = 4621;
    public static final int CL_PROFILING_COMMAND_COMPLETE = 4740;

    protected CL20() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(CLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.clCreateCommandQueueWithProperties, caps.clCreatePipe, caps.clGetPipeInfo, caps.clSVMAlloc, caps.clSVMFree, caps.clEnqueueSVMFree, caps.clEnqueueSVMMemcpy, caps.clEnqueueSVMMemFill, caps.clEnqueueSVMMap, caps.clEnqueueSVMUnmap, caps.clSetKernelArgSVMPointer, caps.clSetKernelExecInfo, caps.clCreateSamplerWithProperties});
    }

    public static long nclCreateCommandQueueWithProperties(long context, long device, long properties, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateCommandQueueWithProperties;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
            Checks.check((long)device);
        }
        return JNI.callPPPPP((long)__functionAddress, (long)context, (long)device, (long)properties, (long)errcode_ret);
    }

    public static long clCreateCommandQueueWithProperties(long context, long device, LongBuffer properties, IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((LongBuffer)properties);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL20.nclCreateCommandQueueWithProperties(context, device, MemoryUtil.memAddressSafe((LongBuffer)properties), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    public static long nclCreatePipe(long context, long flags, int pipe_packet_size, int pipe_max_packets, long properties, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreatePipe;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
        }
        return JNI.callPJPPP((long)__functionAddress, (long)context, (long)flags, (int)pipe_packet_size, (int)pipe_max_packets, (long)properties, (long)errcode_ret);
    }

    public static long clCreatePipe(long context, long flags, int pipe_packet_size, int pipe_max_packets, IntBuffer properties, IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((IntBuffer)properties);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL20.nclCreatePipe(context, flags, pipe_packet_size, pipe_max_packets, MemoryUtil.memAddressSafe((IntBuffer)properties), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    public static int nclGetPipeInfo(long pipe, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetPipeInfo;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)pipe);
        }
        return JNI.callPPPPI((long)__functionAddress, (long)pipe, (int)param_name, (long)param_value_size, (long)param_value, (long)param_value_size_ret);
    }

    public static int clGetPipeInfo(long pipe, int param_name, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL20.nclGetPipeInfo(pipe, param_name, Checks.remainingSafe((Buffer)param_value), MemoryUtil.memAddressSafe((ByteBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    public static int clGetPipeInfo(long pipe, int param_name, IntBuffer param_value, PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL20.nclGetPipeInfo(pipe, param_name, Checks.remainingSafe((Buffer)param_value) << 2, MemoryUtil.memAddressSafe((IntBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    public static long nclSVMAlloc(long context, long flags, long size, int alignment) {
        long __functionAddress = CL.getICD().clSVMAlloc;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
        }
        return JNI.callPJPP((long)__functionAddress, (long)context, (long)flags, (long)size, (int)alignment);
    }

    public static ByteBuffer clSVMAlloc(long context, long flags, long size, int alignment) {
        long __result = CL20.nclSVMAlloc(context, flags, size, alignment);
        return MemoryUtil.memByteBuffer((long)__result, (int)((int)size));
    }

    public static void nclSVMFree(long context, long svm_pointer) {
        long __functionAddress = CL.getICD().clSVMFree;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
        }
        JNI.callPPV((long)__functionAddress, (long)context, (long)svm_pointer);
    }

    public static void clSVMFree(long context, ByteBuffer svm_pointer) {
        CL20.nclSVMFree(context, MemoryUtil.memAddress((ByteBuffer)svm_pointer));
    }

    public static int nclEnqueueSVMFree(long command_queue, int num_svm_pointers, long svm_pointers, long pfn_free_func, long user_data, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueSVMFree;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_queue);
        }
        return JNI.callPPPPPPI((long)__functionAddress, (long)command_queue, (int)num_svm_pointers, (long)svm_pointers, (long)pfn_free_func, (long)user_data, (int)num_events_in_wait_list, (long)event_wait_list, (long)event);
    }

    public static int clEnqueueSVMFree(long command_queue, PointerBuffer svm_pointers, CLSVMFreeCallbackI pfn_free_func, long user_data, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL20.nclEnqueueSVMFree(command_queue, svm_pointers.remaining(), MemoryUtil.memAddress((CustomBuffer)svm_pointers), MemoryUtil.memAddressSafe((Pointer)pfn_free_func), user_data, Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    public static int nclEnqueueSVMMemcpy(long command_queue, int blocking_copy, long dst_ptr, long src_ptr, long size, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueSVMMemcpy;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_queue);
        }
        return JNI.callPPPPPPI((long)__functionAddress, (long)command_queue, (int)blocking_copy, (long)dst_ptr, (long)src_ptr, (long)size, (int)num_events_in_wait_list, (long)event_wait_list, (long)event);
    }

    public static int clEnqueueSVMMemcpy(long command_queue, boolean blocking_copy, ByteBuffer dst_ptr, ByteBuffer src_ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)dst_ptr, (int)src_ptr.remaining());
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL20.nclEnqueueSVMMemcpy(command_queue, blocking_copy ? 1 : 0, MemoryUtil.memAddress((ByteBuffer)dst_ptr), MemoryUtil.memAddress((ByteBuffer)src_ptr), src_ptr.remaining(), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    public static int nclEnqueueSVMMemFill(long command_queue, long svm_ptr, long pattern, long pattern_size, long size, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueSVMMemFill;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_queue);
        }
        return JNI.callPPPPPPPI((long)__functionAddress, (long)command_queue, (long)svm_ptr, (long)pattern, (long)pattern_size, (long)size, (int)num_events_in_wait_list, (long)event_wait_list, (long)event);
    }

    public static int clEnqueueSVMMemFill(long command_queue, ByteBuffer svm_ptr, ByteBuffer pattern, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL20.nclEnqueueSVMMemFill(command_queue, MemoryUtil.memAddress((ByteBuffer)svm_ptr), MemoryUtil.memAddress((ByteBuffer)pattern), pattern.remaining(), svm_ptr.remaining(), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    public static int nclEnqueueSVMMap(long command_queue, int blocking_map, long map_flags, long svm_ptr, long size, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueSVMMap;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_queue);
        }
        return JNI.callPJPPPPI((long)__functionAddress, (long)command_queue, (int)blocking_map, (long)map_flags, (long)svm_ptr, (long)size, (int)num_events_in_wait_list, (long)event_wait_list, (long)event);
    }

    public static int clEnqueueSVMMap(long command_queue, boolean blocking_map, long map_flags, ByteBuffer svm_ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL20.nclEnqueueSVMMap(command_queue, blocking_map ? 1 : 0, map_flags, MemoryUtil.memAddress((ByteBuffer)svm_ptr), svm_ptr.remaining(), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    public static int nclEnqueueSVMUnmap(long command_queue, long svm_ptr, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueSVMUnmap;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_queue);
        }
        return JNI.callPPPPI((long)__functionAddress, (long)command_queue, (long)svm_ptr, (int)num_events_in_wait_list, (long)event_wait_list, (long)event);
    }

    public static int clEnqueueSVMUnmap(long command_queue, ByteBuffer svm_ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL20.nclEnqueueSVMUnmap(command_queue, MemoryUtil.memAddress((ByteBuffer)svm_ptr), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    public static int nclSetKernelArgSVMPointer(long kernel, int arg_index, long arg_value) {
        long __functionAddress = CL.getICD().clSetKernelArgSVMPointer;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)kernel);
        }
        return JNI.callPPI((long)__functionAddress, (long)kernel, (int)arg_index, (long)arg_value);
    }

    public static int clSetKernelArgSVMPointer(long kernel, int arg_index, ByteBuffer arg_value) {
        return CL20.nclSetKernelArgSVMPointer(kernel, arg_index, MemoryUtil.memAddress((ByteBuffer)arg_value));
    }

    public static int nclSetKernelExecInfo(long kernel, int param_name, long param_value_size, long param_value) {
        long __functionAddress = CL.getICD().clSetKernelExecInfo;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)kernel);
        }
        return JNI.callPPPI((long)__functionAddress, (long)kernel, (int)param_name, (long)param_value_size, (long)param_value);
    }

    public static int clSetKernelExecInfo(long kernel, int param_name, ByteBuffer param_value) {
        return CL20.nclSetKernelExecInfo(kernel, param_name, param_value.remaining(), MemoryUtil.memAddress((ByteBuffer)param_value));
    }

    public static int clSetKernelExecInfo(long kernel, int param_name, PointerBuffer param_value) {
        return CL20.nclSetKernelExecInfo(kernel, param_name, param_value.remaining() << Pointer.POINTER_SHIFT, MemoryUtil.memAddress((CustomBuffer)param_value));
    }

    public static int clSetKernelExecInfo(long kernel, int param_name, IntBuffer param_value) {
        return CL20.nclSetKernelExecInfo(kernel, param_name, param_value.remaining() << 2, MemoryUtil.memAddress((IntBuffer)param_value));
    }

    public static long nclCreateSamplerWithProperties(long context, long sampler_properties, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateSamplerWithProperties;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
        }
        return JNI.callPPPP((long)__functionAddress, (long)context, (long)sampler_properties, (long)errcode_ret);
    }

    public static long clCreateSamplerWithProperties(long context, IntBuffer sampler_properties, IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((IntBuffer)sampler_properties);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL20.nclCreateSamplerWithProperties(context, MemoryUtil.memAddressSafe((IntBuffer)sampler_properties), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    public static long clCreateCommandQueueWithProperties(long context, long device, long[] properties, int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateCommandQueueWithProperties;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
            Checks.check((long)device);
            Checks.checkNTSafe((long[])properties);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPPPPP((long)__functionAddress, (long)context, (long)device, (long[])properties, (int[])errcode_ret);
    }

    public static long clCreatePipe(long context, long flags, int pipe_packet_size, int pipe_max_packets, int[] properties, int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreatePipe;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
            Checks.checkNTSafe((int[])properties);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPJPPP((long)__functionAddress, (long)context, (long)flags, (int)pipe_packet_size, (int)pipe_max_packets, (int[])properties, (int[])errcode_ret);
    }

    public static int clGetPipeInfo(long pipe, int param_name, int[] param_value, PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetPipeInfo;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)pipe);
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return JNI.callPPPPI((long)__functionAddress, (long)pipe, (int)param_name, (long)(Checks.lengthSafe((int[])param_value) << 2), (int[])param_value, (long)MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    public static int clSetKernelExecInfo(long kernel, int param_name, int[] param_value) {
        long __functionAddress = CL.getICD().clSetKernelExecInfo;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)kernel);
        }
        return JNI.callPPPI((long)__functionAddress, (long)kernel, (int)param_name, (long)(param_value.length << 2), (int[])param_value);
    }

    public static long clCreateSamplerWithProperties(long context, int[] sampler_properties, int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateSamplerWithProperties;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
            Checks.checkNTSafe((int[])sampler_properties);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPPPP((long)__functionAddress, (long)context, (int[])sampler_properties, (int[])errcode_ret);
    }
}

