/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CLBufferRegion
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ORIGIN;
    public static final int SIZE;

    CLBufferRegion(long address, ByteBuffer container) {
        super(address, container);
    }

    public CLBufferRegion(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), CLBufferRegion.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public long origin() {
        return CLBufferRegion.norigin(this.address());
    }

    public long size() {
        return CLBufferRegion.nsize(this.address());
    }

    public CLBufferRegion origin(long value) {
        CLBufferRegion.norigin(this.address(), value);
        return this;
    }

    public CLBufferRegion size(long value) {
        CLBufferRegion.nsize(this.address(), value);
        return this;
    }

    public CLBufferRegion set(long origin, long size) {
        this.origin(origin);
        this.size(size);
        return this;
    }

    public CLBufferRegion set(CLBufferRegion src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (int)SIZEOF);
        return this;
    }

    public static CLBufferRegion malloc() {
        return CLBufferRegion.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static CLBufferRegion calloc() {
        return CLBufferRegion.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static CLBufferRegion create() {
        return new CLBufferRegion(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static CLBufferRegion create(long address) {
        return address == 0L ? null : new CLBufferRegion(address, null);
    }

    public static Buffer malloc(int capacity) {
        return CLBufferRegion.create(MemoryUtil.nmemAlloc((long)(capacity * SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CLBufferRegion.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer((int)(capacity * SIZEOF)));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static CLBufferRegion mallocStack() {
        return CLBufferRegion.mallocStack(MemoryStack.stackGet());
    }

    public static CLBufferRegion callocStack() {
        return CLBufferRegion.callocStack(MemoryStack.stackGet());
    }

    public static CLBufferRegion mallocStack(MemoryStack stack) {
        return CLBufferRegion.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CLBufferRegion callocStack(MemoryStack stack) {
        return CLBufferRegion.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CLBufferRegion.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CLBufferRegion.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CLBufferRegion.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CLBufferRegion.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long norigin(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ORIGIN));
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SIZE));
    }

    public static void norigin(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ORIGIN), (long)value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SIZE), (long)value);
    }

    static {
        Struct.Layout layout = CLBufferRegion.__struct((Struct.Member[])new Struct.Member[]{CLBufferRegion.__member((int)POINTER_SIZE), CLBufferRegion.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ORIGIN = layout.offsetof(0);
        SIZE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CLBufferRegion, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected CLBufferRegion newInstance(long address) {
            return new CLBufferRegion(address, this.container);
        }

        protected int sizeof() {
            return SIZEOF;
        }

        public long origin() {
            return CLBufferRegion.norigin(this.address());
        }

        public long size() {
            return CLBufferRegion.nsize(this.address());
        }

        public Buffer origin(long value) {
            CLBufferRegion.norigin(this.address(), value);
            return this;
        }

        public Buffer size(long value) {
            CLBufferRegion.nsize(this.address(), value);
            return this;
        }
    }
}

