/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CLBusAddressAMD
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SURFBUSADDRESS;
    public static final int SIGNALBUSADDRESS;

    CLBusAddressAMD(long address, ByteBuffer container) {
        super(address, container);
    }

    public CLBusAddressAMD(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), CLBusAddressAMD.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public long surfbusaddress() {
        return CLBusAddressAMD.nsurfbusaddress(this.address());
    }

    public long signalbusaddress() {
        return CLBusAddressAMD.nsignalbusaddress(this.address());
    }

    public CLBusAddressAMD surfbusaddress(long value) {
        CLBusAddressAMD.nsurfbusaddress(this.address(), value);
        return this;
    }

    public CLBusAddressAMD signalbusaddress(long value) {
        CLBusAddressAMD.nsignalbusaddress(this.address(), value);
        return this;
    }

    public CLBusAddressAMD set(long surfbusaddress, long signalbusaddress) {
        this.surfbusaddress(surfbusaddress);
        this.signalbusaddress(signalbusaddress);
        return this;
    }

    public CLBusAddressAMD set(CLBusAddressAMD src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (int)SIZEOF);
        return this;
    }

    public static CLBusAddressAMD malloc() {
        return CLBusAddressAMD.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static CLBusAddressAMD calloc() {
        return CLBusAddressAMD.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static CLBusAddressAMD create() {
        return new CLBusAddressAMD(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static CLBusAddressAMD create(long address) {
        return address == 0L ? null : new CLBusAddressAMD(address, null);
    }

    public static Buffer malloc(int capacity) {
        return CLBusAddressAMD.create(MemoryUtil.nmemAlloc((long)(capacity * SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CLBusAddressAMD.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer((int)(capacity * SIZEOF)));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static CLBusAddressAMD mallocStack() {
        return CLBusAddressAMD.mallocStack(MemoryStack.stackGet());
    }

    public static CLBusAddressAMD callocStack() {
        return CLBusAddressAMD.callocStack(MemoryStack.stackGet());
    }

    public static CLBusAddressAMD mallocStack(MemoryStack stack) {
        return CLBusAddressAMD.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CLBusAddressAMD callocStack(MemoryStack stack) {
        return CLBusAddressAMD.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CLBusAddressAMD.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CLBusAddressAMD.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CLBusAddressAMD.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CLBusAddressAMD.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsurfbusaddress(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SURFBUSADDRESS));
    }

    public static long nsignalbusaddress(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SIGNALBUSADDRESS));
    }

    public static void nsurfbusaddress(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SURFBUSADDRESS), (long)value);
    }

    public static void nsignalbusaddress(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SIGNALBUSADDRESS), (long)value);
    }

    static {
        Struct.Layout layout = CLBusAddressAMD.__struct((Struct.Member[])new Struct.Member[]{CLBusAddressAMD.__member((int)8), CLBusAddressAMD.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SURFBUSADDRESS = layout.offsetof(0);
        SIGNALBUSADDRESS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CLBusAddressAMD, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected CLBusAddressAMD newInstance(long address) {
            return new CLBusAddressAMD(address, this.container);
        }

        protected int sizeof() {
            return SIZEOF;
        }

        public long surfbusaddress() {
            return CLBusAddressAMD.nsurfbusaddress(this.address());
        }

        public long signalbusaddress() {
            return CLBusAddressAMD.nsignalbusaddress(this.address());
        }

        public Buffer surfbusaddress(long value) {
            CLBusAddressAMD.nsurfbusaddress(this.address(), value);
            return this;
        }

        public Buffer signalbusaddress(long value) {
            CLBusAddressAMD.nsignalbusaddress(this.address(), value);
            return this;
        }
    }
}

