/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct cl_name_version_khr")
public class CLNameVersionKHR
extends Struct<CLNameVersionKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERSION;
    public static final int NAME;

    protected CLNameVersionKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CLNameVersionKHR create(long address, @Nullable ByteBuffer container) {
        return new CLNameVersionKHR(address, container);
    }

    public CLNameVersionKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CLNameVersionKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="cl_version_khr")
    public int version() {
        return CLNameVersionKHR.nversion(this.address());
    }

    @NativeType(value="char[64]")
    public ByteBuffer name() {
        return CLNameVersionKHR.nname(this.address());
    }

    @NativeType(value="char[64]")
    public String nameString() {
        return CLNameVersionKHR.nnameString(this.address());
    }

    public static CLNameVersionKHR malloc() {
        return new CLNameVersionKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CLNameVersionKHR calloc() {
        return new CLNameVersionKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CLNameVersionKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CLNameVersionKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CLNameVersionKHR create(long address) {
        return new CLNameVersionKHR(address, null);
    }

    public static @Nullable CLNameVersionKHR createSafe(long address) {
        return address == 0L ? null : new CLNameVersionKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CLNameVersionKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CLNameVersionKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CLNameVersionKHR malloc(MemoryStack stack) {
        return new CLNameVersionKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CLNameVersionKHR calloc(MemoryStack stack) {
        return new CLNameVersionKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nversion(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)VERSION));
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)NAME), (int)64);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)NAME));
    }

    static {
        Struct.Layout layout = CLNameVersionKHR.__struct((Struct.Member[])new Struct.Member[]{CLNameVersionKHR.__member((int)4), CLNameVersionKHR.__array((int)1, (int)64)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERSION = layout.offsetof(0);
        NAME = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CLNameVersionKHR, Buffer>
    implements NativeResource {
        private static final CLNameVersionKHR ELEMENT_FACTORY = CLNameVersionKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CLNameVersionKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="cl_version_khr")
        public int version() {
            return CLNameVersionKHR.nversion(this.address());
        }

        @NativeType(value="char[64]")
        public ByteBuffer name() {
            return CLNameVersionKHR.nname(this.address());
        }

        @NativeType(value="char[64]")
        public String nameString() {
            return CLNameVersionKHR.nnameString(this.address());
        }
    }
}

