/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class INTELAccelerator {
    public static final int CL_ACCELERATOR_DESCRIPTOR_INTEL = 16528;
    public static final int CL_ACCELERATOR_REFERENCE_COUNT_INTEL = 16529;
    public static final int CL_ACCELERATOR_CONTEXT_INTEL = 16530;
    public static final int CL_ACCELERATOR_TYPE_INTEL = 16531;
    public static final int CL_INVALID_ACCELERATOR_INTEL = -1094;
    public static final int CL_INVALID_ACCELERATOR_TYPE_INTEL = -1095;
    public static final int CL_INVALID_ACCELERATOR_DESCRIPTOR_INTEL = -1096;
    public static final int CL_ACCELERATOR_TYPE_NOT_SUPPORTED_INTEL = -1097;

    protected INTELAccelerator() {
        throw new UnsupportedOperationException();
    }

    public static long nclCreateAcceleratorINTEL(long context, int accelerator_type, long descriptor_size, long descriptor, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateAcceleratorINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
        }
        return JNI.callPPPPP((long)context, (int)accelerator_type, (long)descriptor_size, (long)descriptor, (long)errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_accelerator_intel")
    public static long clCreateAcceleratorINTEL(@NativeType(value="cl_context") long context, @NativeType(value="cl_accelerator_type_intel") int accelerator_type, @NativeType(value="void const *") ByteBuffer descriptor, @NativeType(value="cl_int *") @Nullable IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return INTELAccelerator.nclCreateAcceleratorINTEL(context, accelerator_type, descriptor.remaining(), MemoryUtil.memAddress((ByteBuffer)descriptor), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_int")
    public static int clRetainAcceleratorINTEL(@NativeType(value="cl_accelerator_intel") long accelerator) {
        long __functionAddress = CL.getICD().clRetainAcceleratorINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)accelerator);
        }
        return JNI.callPI((long)accelerator, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clReleaseAcceleratorINTEL(@NativeType(value="cl_accelerator_intel") long accelerator) {
        long __functionAddress = CL.getICD().clReleaseAcceleratorINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)accelerator);
        }
        return JNI.callPI((long)accelerator, (long)__functionAddress);
    }

    public static int nclGetAcceleratorInfoINTEL(long accelerator, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetAcceleratorInfoINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)accelerator);
        }
        return JNI.callPPPPI((long)accelerator, (int)param_name, (long)param_value_size, (long)param_value, (long)param_value_size_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetAcceleratorInfoINTEL(@NativeType(value="cl_accelerator_intel") long accelerator, @NativeType(value="cl_accelerator_info_intel") int param_name, @NativeType(value="void *") @Nullable ByteBuffer param_value, @NativeType(value="size_t *") @Nullable PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return INTELAccelerator.nclGetAcceleratorInfoINTEL(accelerator, param_name, Checks.remainingSafe((Buffer)param_value), MemoryUtil.memAddressSafe((ByteBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetAcceleratorInfoINTEL(@NativeType(value="cl_accelerator_intel") long accelerator, @NativeType(value="cl_accelerator_info_intel") int param_name, @NativeType(value="void *") @Nullable IntBuffer param_value, @NativeType(value="size_t *") @Nullable PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return INTELAccelerator.nclGetAcceleratorInfoINTEL(accelerator, param_name, Integer.toUnsignedLong(Checks.remainingSafe((Buffer)param_value)) << 2, MemoryUtil.memAddressSafe((IntBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetAcceleratorInfoINTEL(@NativeType(value="cl_accelerator_intel") long accelerator, @NativeType(value="cl_accelerator_info_intel") int param_name, @NativeType(value="void *") @Nullable PointerBuffer param_value, @NativeType(value="size_t *") @Nullable PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return INTELAccelerator.nclGetAcceleratorInfoINTEL(accelerator, param_name, Integer.toUnsignedLong(Checks.remainingSafe((CustomBuffer)param_value)) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe((Pointer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_accelerator_intel")
    public static long clCreateAcceleratorINTEL(@NativeType(value="cl_context") long context, @NativeType(value="cl_accelerator_type_intel") int accelerator_type, @NativeType(value="void const *") ByteBuffer descriptor, @NativeType(value="cl_int *") int @Nullable [] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateAcceleratorINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPPPPP((long)context, (int)accelerator_type, (long)descriptor.remaining(), (long)MemoryUtil.memAddress((ByteBuffer)descriptor), (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetAcceleratorInfoINTEL(@NativeType(value="cl_accelerator_intel") long accelerator, @NativeType(value="cl_accelerator_info_intel") int param_name, @NativeType(value="void *") int @Nullable [] param_value, @NativeType(value="size_t *") @Nullable PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetAcceleratorInfoINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)accelerator);
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return JNI.callPPPPI((long)accelerator, (int)param_name, (long)(Integer.toUnsignedLong(Checks.lengthSafe((int[])param_value)) << 2), (int[])param_value, (long)MemoryUtil.memAddressSafe((Pointer)param_value_size_ret), (long)__functionAddress);
    }
}

