/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class INTELUnifiedSharedMemory {
    public static final int CL_DEVICE_HOST_MEM_CAPABILITIES_INTEL = 16784;
    public static final int CL_DEVICE_DEVICE_MEM_CAPABILITIES_INTEL = 16785;
    public static final int CL_DEVICE_SINGLE_DEVICE_SHARED_MEM_CAPABILITIES_INTEL = 16786;
    public static final int CL_DEVICE_CROSS_DEVICE_SHARED_MEM_CAPABILITIES_INTEL = 16787;
    public static final int CL_DEVICE_SHARED_SYSTEM_MEM_CAPABILITIES_INTEL = 16788;
    public static final int CL_UNIFIED_SHARED_MEMORY_ACCESS_INTEL = 1;
    public static final int CL_UNIFIED_SHARED_MEMORY_ATOMIC_ACCESS_INTEL = 2;
    public static final int CL_UNIFIED_SHARED_MEMORY_CONCURRENT_ACCESS_INTEL = 4;
    public static final int CL_UNIFIED_SHARED_MEMORY_CONCURRENT_ATOMIC_ACCESS_INTEL = 8;
    public static final int CL_MEM_ALLOC_FLAGS_INTEL = 16789;
    public static final int CL_MEM_ALLOC_WRITE_COMBINED_INTEL = 1;
    public static final int CL_MEM_ALLOC_INITIAL_PLACEMENT_DEVICE_INTEL = 2;
    public static final int CL_MEM_ALLOC_INITIAL_PLACEMENT_HOST_INTEL = 4;
    public static final int CL_MEM_ALLOC_TYPE_INTEL = 16794;
    public static final int CL_MEM_ALLOC_BASE_PTR_INTEL = 16795;
    public static final int CL_MEM_ALLOC_SIZE_INTEL = 16796;
    public static final int CL_MEM_ALLOC_DEVICE_INTEL = 16797;
    public static final int CL_MEM_TYPE_UNKNOWN_INTEL = 16790;
    public static final int CL_MEM_TYPE_HOST_INTEL = 16791;
    public static final int CL_MEM_TYPE_DEVICE_INTEL = 16792;
    public static final int CL_MEM_TYPE_SHARED_INTEL = 16793;
    public static final int CL_KERNEL_EXEC_INFO_INDIRECT_HOST_ACCESS_INTEL = 16896;
    public static final int CL_KERNEL_EXEC_INFO_INDIRECT_DEVICE_ACCESS_INTEL = 16897;
    public static final int CL_KERNEL_EXEC_INFO_INDIRECT_SHARED_ACCESS_INTEL = 16898;
    public static final int CL_KERNEL_EXEC_INFO_USM_PTRS_INTEL = 16899;
    public static final int CL_COMMAND_MEMFILL_INTEL = 16900;
    public static final int CL_COMMAND_MEMCPY_INTEL = 16901;
    public static final int CL_COMMAND_MIGRATEMEM_INTEL = 16902;
    public static final int CL_COMMAND_MEMADVISE_INTEL = 16903;

    protected INTELUnifiedSharedMemory() {
        throw new UnsupportedOperationException();
    }

    public static long nclHostMemAllocINTEL(long context, long properties, long size, int alignment, long errcode_ret) {
        long __functionAddress = CL.getICD().clHostMemAllocINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
        }
        return JNI.callPPPPP((long)context, (long)properties, (long)size, (int)alignment, (long)errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="void *")
    public static @Nullable ByteBuffer clHostMemAllocINTEL(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_properties_intel const *") @Nullable LongBuffer properties, @NativeType(value="size_t") long size, @NativeType(value="cl_uint") int alignment, @NativeType(value="cl_int *") @Nullable IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((LongBuffer)properties);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        long __result = INTELUnifiedSharedMemory.nclHostMemAllocINTEL(context, MemoryUtil.memAddressSafe((LongBuffer)properties), size, alignment, MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
        return MemoryUtil.memByteBufferSafe((long)__result, (int)((int)size));
    }

    public static long nclDeviceMemAllocINTEL(long context, long device, long properties, long size, int alignment, long errcode_ret) {
        long __functionAddress = CL.getICD().clDeviceMemAllocINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
            Checks.check((long)device);
        }
        return JNI.callPPPPPP((long)context, (long)device, (long)properties, (long)size, (int)alignment, (long)errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="void *")
    public static @Nullable ByteBuffer clDeviceMemAllocINTEL(@NativeType(value="cl_context") long context, @NativeType(value="cl_device_id") long device, @NativeType(value="cl_mem_properties_intel const *") @Nullable LongBuffer properties, @NativeType(value="size_t") long size, @NativeType(value="cl_uint") int alignment, @NativeType(value="cl_int *") @Nullable IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((LongBuffer)properties);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        long __result = INTELUnifiedSharedMemory.nclDeviceMemAllocINTEL(context, device, MemoryUtil.memAddressSafe((LongBuffer)properties), size, alignment, MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
        return MemoryUtil.memByteBufferSafe((long)__result, (int)((int)size));
    }

    public static long nclSharedMemAllocINTEL(long context, long device, long properties, long size, int alignment, long errcode_ret) {
        long __functionAddress = CL.getICD().clSharedMemAllocINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
        }
        return JNI.callPPPPPP((long)context, (long)device, (long)properties, (long)size, (int)alignment, (long)errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="void *")
    public static @Nullable ByteBuffer clSharedMemAllocINTEL(@NativeType(value="cl_context") long context, @NativeType(value="cl_device_id") long device, @NativeType(value="cl_mem_properties_intel const *") @Nullable LongBuffer properties, @NativeType(value="size_t") long size, @NativeType(value="cl_uint") int alignment, @NativeType(value="cl_int *") @Nullable IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((LongBuffer)properties);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        long __result = INTELUnifiedSharedMemory.nclSharedMemAllocINTEL(context, device, MemoryUtil.memAddressSafe((LongBuffer)properties), size, alignment, MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
        return MemoryUtil.memByteBufferSafe((long)__result, (int)((int)size));
    }

    public static int nclMemFreeINTEL(long context, long ptr) {
        long __functionAddress = CL.getICD().clMemFreeINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
        }
        return JNI.callPPI((long)context, (long)ptr, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clMemFreeINTEL(@NativeType(value="cl_context") long context, @NativeType(value="void *") @Nullable ByteBuffer ptr) {
        return INTELUnifiedSharedMemory.nclMemFreeINTEL(context, MemoryUtil.memAddressSafe((ByteBuffer)ptr));
    }

    public static int nclMemBlockingFreeINTEL(long context, long ptr) {
        long __functionAddress = CL.getICD().clMemBlockingFreeINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
        }
        return JNI.callPPI((long)context, (long)ptr, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clMemBlockingFreeINTEL(@NativeType(value="cl_context") long context, @NativeType(value="void *") @Nullable ByteBuffer ptr) {
        return INTELUnifiedSharedMemory.nclMemBlockingFreeINTEL(context, MemoryUtil.memAddressSafe((ByteBuffer)ptr));
    }

    public static int nclGetMemAllocInfoINTEL(long context, long ptr, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetMemAllocInfoINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
        }
        return JNI.callPPPPPI((long)context, (long)ptr, (int)param_name, (long)param_value_size, (long)param_value, (long)param_value_size_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetMemAllocInfoINTEL(@NativeType(value="cl_context") long context, @NativeType(value="void const *") ByteBuffer ptr, @NativeType(value="cl_mem_info_intel") int param_name, @NativeType(value="void *") @Nullable ByteBuffer param_value, @NativeType(value="size_t *") @Nullable PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return INTELUnifiedSharedMemory.nclGetMemAllocInfoINTEL(context, MemoryUtil.memAddress((ByteBuffer)ptr), param_name, Checks.remainingSafe((Buffer)param_value), MemoryUtil.memAddressSafe((ByteBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetMemAllocInfoINTEL(@NativeType(value="cl_context") long context, @NativeType(value="void const *") ByteBuffer ptr, @NativeType(value="cl_mem_info_intel") int param_name, @NativeType(value="void *") @Nullable IntBuffer param_value, @NativeType(value="size_t *") @Nullable PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return INTELUnifiedSharedMemory.nclGetMemAllocInfoINTEL(context, MemoryUtil.memAddress((ByteBuffer)ptr), param_name, Integer.toUnsignedLong(Checks.remainingSafe((Buffer)param_value)) << 2, MemoryUtil.memAddressSafe((IntBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetMemAllocInfoINTEL(@NativeType(value="cl_context") long context, @NativeType(value="void const *") ByteBuffer ptr, @NativeType(value="cl_mem_info_intel") int param_name, @NativeType(value="void *") @Nullable PointerBuffer param_value, @NativeType(value="size_t *") @Nullable PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return INTELUnifiedSharedMemory.nclGetMemAllocInfoINTEL(context, MemoryUtil.memAddress((ByteBuffer)ptr), param_name, Integer.toUnsignedLong(Checks.remainingSafe((CustomBuffer)param_value)) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe((Pointer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    public static int nclSetKernelArgMemPointerINTEL(long kernel, int arg_index, long arg_value) {
        long __functionAddress = CL.getICD().clSetKernelArgMemPointerINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)kernel);
        }
        return JNI.callPPI((long)kernel, (int)arg_index, (long)arg_value, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArgMemPointerINTEL(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") ByteBuffer arg_value) {
        return INTELUnifiedSharedMemory.nclSetKernelArgMemPointerINTEL(kernel, arg_index, MemoryUtil.memAddress((ByteBuffer)arg_value));
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArgMemPointerINTEL(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") ShortBuffer arg_value) {
        return INTELUnifiedSharedMemory.nclSetKernelArgMemPointerINTEL(kernel, arg_index, MemoryUtil.memAddress((ShortBuffer)arg_value));
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArgMemPointerINTEL(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") IntBuffer arg_value) {
        return INTELUnifiedSharedMemory.nclSetKernelArgMemPointerINTEL(kernel, arg_index, MemoryUtil.memAddress((IntBuffer)arg_value));
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArgMemPointerINTEL(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") LongBuffer arg_value) {
        return INTELUnifiedSharedMemory.nclSetKernelArgMemPointerINTEL(kernel, arg_index, MemoryUtil.memAddress((LongBuffer)arg_value));
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArgMemPointerINTEL(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") FloatBuffer arg_value) {
        return INTELUnifiedSharedMemory.nclSetKernelArgMemPointerINTEL(kernel, arg_index, MemoryUtil.memAddress((FloatBuffer)arg_value));
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArgMemPointerINTEL(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") DoubleBuffer arg_value) {
        return INTELUnifiedSharedMemory.nclSetKernelArgMemPointerINTEL(kernel, arg_index, MemoryUtil.memAddress((DoubleBuffer)arg_value));
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArgMemPointerINTEL(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") PointerBuffer arg_value) {
        return INTELUnifiedSharedMemory.nclSetKernelArgMemPointerINTEL(kernel, arg_index, MemoryUtil.memAddress((CustomBuffer)arg_value));
    }

    public static int nclEnqueueMemFillINTEL(long command_queue, long dst_ptr, long pattern, long pattern_size, long size, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueMemFillINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_queue);
        }
        return JNI.callPPPPPPPI((long)command_queue, (long)dst_ptr, (long)pattern, (long)pattern_size, (long)size, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueMemFillINTEL(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="void *") ByteBuffer dst_ptr, @NativeType(value="void const *") ByteBuffer pattern, @NativeType(value="cl_event const *") @Nullable PointerBuffer event_wait_list, @NativeType(value="cl_event *") @Nullable PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return INTELUnifiedSharedMemory.nclEnqueueMemFillINTEL(command_queue, MemoryUtil.memAddress((ByteBuffer)dst_ptr), MemoryUtil.memAddress((ByteBuffer)pattern), pattern.remaining(), dst_ptr.remaining(), Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    public static int nclEnqueueMemcpyINTEL(long command_queue, int blocking, long dst_ptr, long src_ptr, long size, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueMemcpyINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_queue);
        }
        return JNI.callPPPPPPI((long)command_queue, (int)blocking, (long)dst_ptr, (long)src_ptr, (long)size, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueMemcpyINTEL(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_bool") boolean blocking, @NativeType(value="void *") ByteBuffer dst_ptr, @NativeType(value="void const *") ByteBuffer src_ptr, @NativeType(value="size_t") long size, @NativeType(value="cl_event const *") @Nullable PointerBuffer event_wait_list, @NativeType(value="cl_event *") @Nullable PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)dst_ptr, (long)size);
            Checks.check((Buffer)src_ptr, (long)size);
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return INTELUnifiedSharedMemory.nclEnqueueMemcpyINTEL(command_queue, blocking ? 1 : 0, MemoryUtil.memAddress((ByteBuffer)dst_ptr), MemoryUtil.memAddress((ByteBuffer)src_ptr), size, Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    public static int nclEnqueueMigrateMemINTEL(long command_queue, long ptr, long size, long flags, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueMigrateMemINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_queue);
        }
        return JNI.callPPPJPPI((long)command_queue, (long)ptr, (long)size, (long)flags, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueMigrateMemINTEL(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="void const *") ByteBuffer ptr, @NativeType(value="cl_mem_migration_flags") long flags, @NativeType(value="cl_event const *") @Nullable PointerBuffer event_wait_list, @NativeType(value="cl_event *") @Nullable PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return INTELUnifiedSharedMemory.nclEnqueueMigrateMemINTEL(command_queue, MemoryUtil.memAddress((ByteBuffer)ptr), ptr.remaining(), flags, Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    public static int nclEnqueueMemAdviseINTEL(long command_queue, long ptr, long size, long advice, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueMemAdviseINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_queue);
        }
        return JNI.callPPPJPPI((long)command_queue, (long)ptr, (long)size, (long)advice, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueMemAdviseINTEL(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="void const *") ByteBuffer ptr, @NativeType(value="cl_mem_advice_intel") long advice, @NativeType(value="cl_event const *") @Nullable PointerBuffer event_wait_list, @NativeType(value="cl_event *") @Nullable PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return INTELUnifiedSharedMemory.nclEnqueueMemAdviseINTEL(command_queue, MemoryUtil.memAddress((ByteBuffer)ptr), ptr.remaining(), advice, Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    @NativeType(value="void *")
    public static @Nullable ByteBuffer clHostMemAllocINTEL(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_properties_intel const *") long @Nullable [] properties, @NativeType(value="size_t") long size, @NativeType(value="cl_uint") int alignment, @NativeType(value="cl_int *") int @Nullable [] errcode_ret) {
        long __functionAddress = CL.getICD().clHostMemAllocINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
            Checks.checkNTSafe((long[])properties);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        long __result = JNI.callPPPPP((long)context, (long[])properties, (long)size, (int)alignment, (int[])errcode_ret, (long)__functionAddress);
        return MemoryUtil.memByteBufferSafe((long)__result, (int)((int)size));
    }

    @NativeType(value="void *")
    public static @Nullable ByteBuffer clDeviceMemAllocINTEL(@NativeType(value="cl_context") long context, @NativeType(value="cl_device_id") long device, @NativeType(value="cl_mem_properties_intel const *") long @Nullable [] properties, @NativeType(value="size_t") long size, @NativeType(value="cl_uint") int alignment, @NativeType(value="cl_int *") int @Nullable [] errcode_ret) {
        long __functionAddress = CL.getICD().clDeviceMemAllocINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
            Checks.check((long)device);
            Checks.checkNTSafe((long[])properties);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        long __result = JNI.callPPPPPP((long)context, (long)device, (long[])properties, (long)size, (int)alignment, (int[])errcode_ret, (long)__functionAddress);
        return MemoryUtil.memByteBufferSafe((long)__result, (int)((int)size));
    }

    @NativeType(value="void *")
    public static @Nullable ByteBuffer clSharedMemAllocINTEL(@NativeType(value="cl_context") long context, @NativeType(value="cl_device_id") long device, @NativeType(value="cl_mem_properties_intel const *") long @Nullable [] properties, @NativeType(value="size_t") long size, @NativeType(value="cl_uint") int alignment, @NativeType(value="cl_int *") int @Nullable [] errcode_ret) {
        long __functionAddress = CL.getICD().clSharedMemAllocINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
            Checks.checkNTSafe((long[])properties);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        long __result = JNI.callPPPPPP((long)context, (long)device, (long[])properties, (long)size, (int)alignment, (int[])errcode_ret, (long)__functionAddress);
        return MemoryUtil.memByteBufferSafe((long)__result, (int)((int)size));
    }

    @NativeType(value="cl_int")
    public static int clGetMemAllocInfoINTEL(@NativeType(value="cl_context") long context, @NativeType(value="void const *") ByteBuffer ptr, @NativeType(value="cl_mem_info_intel") int param_name, @NativeType(value="void *") int @Nullable [] param_value, @NativeType(value="size_t *") @Nullable PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetMemAllocInfoINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return JNI.callPPPPPI((long)context, (long)MemoryUtil.memAddress((ByteBuffer)ptr), (int)param_name, (long)(Integer.toUnsignedLong(Checks.lengthSafe((int[])param_value)) << 2), (int[])param_value, (long)MemoryUtil.memAddressSafe((Pointer)param_value_size_ret), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArgMemPointerINTEL(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") short[] arg_value) {
        long __functionAddress = CL.getICD().clSetKernelArgMemPointerINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)kernel);
        }
        return JNI.callPPI((long)kernel, (int)arg_index, (short[])arg_value, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArgMemPointerINTEL(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") int[] arg_value) {
        long __functionAddress = CL.getICD().clSetKernelArgMemPointerINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)kernel);
        }
        return JNI.callPPI((long)kernel, (int)arg_index, (int[])arg_value, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArgMemPointerINTEL(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") long[] arg_value) {
        long __functionAddress = CL.getICD().clSetKernelArgMemPointerINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)kernel);
        }
        return JNI.callPPI((long)kernel, (int)arg_index, (long[])arg_value, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArgMemPointerINTEL(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") float[] arg_value) {
        long __functionAddress = CL.getICD().clSetKernelArgMemPointerINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)kernel);
        }
        return JNI.callPPI((long)kernel, (int)arg_index, (float[])arg_value, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArgMemPointerINTEL(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") double[] arg_value) {
        long __functionAddress = CL.getICD().clSetKernelArgMemPointerINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)kernel);
        }
        return JNI.callPPI((long)kernel, (int)arg_index, (double[])arg_value, (long)__functionAddress);
    }
}

