/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class KHRCommandBuffer {
    public static final int CL_DEVICE_COMMAND_BUFFER_CAPABILITIES_KHR = 4777;
    public static final int CL_DEVICE_COMMAND_BUFFER_REQUIRED_QUEUE_PROPERTIES_KHR = 4778;
    public static final int CL_COMMAND_BUFFER_CAPABILITY_KERNEL_PRINTF_KHR = 1;
    public static final int CL_COMMAND_BUFFER_CAPABILITY_DEVICE_SIDE_ENQUEUE_KHR = 2;
    public static final int CL_COMMAND_BUFFER_CAPABILITY_SIMULTANEOUS_USE_KHR = 4;
    public static final int CL_COMMAND_BUFFER_CAPABILITY_OUT_OF_ORDER_KHR = 8;
    public static final int CL_COMMAND_BUFFER_STATE_RECORDING_KHR = 0;
    public static final int CL_COMMAND_BUFFER_STATE_EXECUTABLE_KHR = 1;
    public static final int CL_COMMAND_BUFFER_STATE_PENDING_KHR = 2;
    public static final int CL_COMMAND_BUFFER_STATE_INVALID_KHR = 3;
    public static final int CL_INVALID_COMMAND_BUFFER_KHR = -1138;
    public static final int CL_INVALID_SYNC_POINT_WAIT_LIST_KHR = -1139;
    public static final int CL_INCOMPATIBLE_COMMAND_QUEUE_KHR = -1140;
    public static final int CL_COMMAND_BUFFER_FLAGS_KHR = 4755;
    public static final int CL_COMMAND_BUFFER_SIMULTANEOUS_USE_KHR = 1;
    public static final int CL_COMMAND_BUFFER_QUEUES_KHR = 4756;
    public static final int CL_COMMAND_BUFFER_NUM_QUEUES_KHR = 4757;
    public static final int CL_COMMAND_BUFFER_REFERENCE_COUNT_KHR = 4758;
    public static final int CL_COMMAND_BUFFER_STATE_KHR = 4759;
    public static final int CL_COMMAND_BUFFER_PROPERTIES_ARRAY_KHR = 4760;
    public static final int CL_COMMAND_COMMAND_BUFFER_KHR = 4776;

    protected KHRCommandBuffer() {
        throw new UnsupportedOperationException();
    }

    public static long nclCreateCommandBufferKHR(int num_queues, long queues, long properties, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateCommandBufferKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPP((int)num_queues, (long)queues, (long)properties, (long)errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_command_buffer_khr")
    public static long clCreateCommandBufferKHR(@NativeType(value="cl_command_queue const *") PointerBuffer queues, @NativeType(value="cl_command_buffer_properties_khr const *") @Nullable LongBuffer properties, @NativeType(value="cl_int *") @Nullable IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((LongBuffer)properties);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return KHRCommandBuffer.nclCreateCommandBufferKHR(queues.remaining(), MemoryUtil.memAddress((CustomBuffer)queues), MemoryUtil.memAddressSafe((LongBuffer)properties), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_int")
    public static int clRetainCommandBufferKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer) {
        long __functionAddress = CL.getICD().clRetainCommandBufferKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
        }
        return JNI.callPI((long)command_buffer, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clReleaseCommandBufferKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer) {
        long __functionAddress = CL.getICD().clReleaseCommandBufferKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
        }
        return JNI.callPI((long)command_buffer, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clFinalizeCommandBufferKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer) {
        long __functionAddress = CL.getICD().clFinalizeCommandBufferKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
        }
        return JNI.callPI((long)command_buffer, (long)__functionAddress);
    }

    public static int nclEnqueueCommandBufferKHR(int num_queues, long queues, long command_buffer, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueCommandBufferKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
        }
        return JNI.callPPPPI((int)num_queues, (long)queues, (long)command_buffer, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueCommandBufferKHR(@NativeType(value="cl_command_queue *") @Nullable PointerBuffer queues, @NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_event const *") @Nullable PointerBuffer event_wait_list, @NativeType(value="cl_event *") @Nullable PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return KHRCommandBuffer.nclEnqueueCommandBufferKHR(Checks.remainingSafe((CustomBuffer)queues), MemoryUtil.memAddressSafe((Pointer)queues), command_buffer, Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    public static int nclCommandBarrierWithWaitListKHR(long command_buffer, long command_queue, int num_sync_points_in_wait_list, long sync_point_wait_list, long sync_point, long mutable_handle) {
        long __functionAddress = CL.getICD().clCommandBarrierWithWaitListKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
        }
        return JNI.callPPPPPI((long)command_buffer, (long)command_queue, (int)num_sync_points_in_wait_list, (long)sync_point_wait_list, (long)sync_point, (long)mutable_handle, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandBarrierWithWaitListKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_sync_point_khr const *") @Nullable IntBuffer sync_point_wait_list, @NativeType(value="cl_sync_point_khr *") @Nullable IntBuffer sync_point, @NativeType(value="cl_mutable_command_khr *") @Nullable PointerBuffer mutable_handle) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)sync_point, (int)1);
            Checks.checkSafe((CustomBuffer)mutable_handle, (int)1);
        }
        return KHRCommandBuffer.nclCommandBarrierWithWaitListKHR(command_buffer, command_queue, Checks.remainingSafe((Buffer)sync_point_wait_list), MemoryUtil.memAddressSafe((IntBuffer)sync_point_wait_list), MemoryUtil.memAddressSafe((IntBuffer)sync_point), MemoryUtil.memAddressSafe((Pointer)mutable_handle));
    }

    public static int nclCommandCopyBufferKHR(long command_buffer, long command_queue, long src_buffer, long dst_buffer, long src_offset, long dst_offset, long size, int num_sync_points_in_wait_list, long sync_point_wait_list, long sync_point, long mutable_handle) {
        long __functionAddress = CL.getICD().clCommandCopyBufferKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
            Checks.check((long)src_buffer);
            Checks.check((long)dst_buffer);
        }
        return JNI.callPPPPPPPPPPI((long)command_buffer, (long)command_queue, (long)src_buffer, (long)dst_buffer, (long)src_offset, (long)dst_offset, (long)size, (int)num_sync_points_in_wait_list, (long)sync_point_wait_list, (long)sync_point, (long)mutable_handle, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandCopyBufferKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_buffer, @NativeType(value="cl_mem") long dst_buffer, @NativeType(value="size_t") long src_offset, @NativeType(value="size_t") long dst_offset, @NativeType(value="size_t") long size, @NativeType(value="cl_sync_point_khr const *") @Nullable IntBuffer sync_point_wait_list, @NativeType(value="cl_sync_point_khr *") @Nullable IntBuffer sync_point, @NativeType(value="cl_mutable_command_khr *") @Nullable PointerBuffer mutable_handle) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)sync_point, (int)1);
            Checks.checkSafe((CustomBuffer)mutable_handle, (int)1);
        }
        return KHRCommandBuffer.nclCommandCopyBufferKHR(command_buffer, command_queue, src_buffer, dst_buffer, src_offset, dst_offset, size, Checks.remainingSafe((Buffer)sync_point_wait_list), MemoryUtil.memAddressSafe((IntBuffer)sync_point_wait_list), MemoryUtil.memAddressSafe((IntBuffer)sync_point), MemoryUtil.memAddressSafe((Pointer)mutable_handle));
    }

    public static int nclCommandCopyBufferRectKHR(long command_buffer, long command_queue, long src_buffer, long dst_buffer, long src_origin, long dst_origin, long region, long src_row_pitch, long src_slice_pitch, long dst_row_pitch, long dst_slice_pitch, int num_sync_points_in_wait_list, long sync_point_wait_list, long sync_point, long mutable_handle) {
        long __functionAddress = CL.getICD().clCommandCopyBufferRectKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
            Checks.check((long)src_buffer);
            Checks.check((long)dst_buffer);
        }
        return JNI.callPPPPPPPPPPPPPPI((long)command_buffer, (long)command_queue, (long)src_buffer, (long)dst_buffer, (long)src_origin, (long)dst_origin, (long)region, (long)src_row_pitch, (long)src_slice_pitch, (long)dst_row_pitch, (long)dst_slice_pitch, (int)num_sync_points_in_wait_list, (long)sync_point_wait_list, (long)sync_point, (long)mutable_handle, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandCopyBufferRectKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_buffer, @NativeType(value="cl_mem") long dst_buffer, @NativeType(value="size_t const *") PointerBuffer src_origin, @NativeType(value="size_t const *") PointerBuffer dst_origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long src_row_pitch, @NativeType(value="size_t") long src_slice_pitch, @NativeType(value="size_t") long dst_row_pitch, @NativeType(value="size_t") long dst_slice_pitch, @NativeType(value="cl_sync_point_khr const *") @Nullable IntBuffer sync_point_wait_list, @NativeType(value="cl_sync_point_khr *") @Nullable IntBuffer sync_point, @NativeType(value="cl_mutable_command_khr *") @Nullable PointerBuffer mutable_handle) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)src_origin, (int)3);
            Checks.check((CustomBuffer)dst_origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((Buffer)sync_point, (int)1);
            Checks.checkSafe((CustomBuffer)mutable_handle, (int)1);
        }
        return KHRCommandBuffer.nclCommandCopyBufferRectKHR(command_buffer, command_queue, src_buffer, dst_buffer, MemoryUtil.memAddress((CustomBuffer)src_origin), MemoryUtil.memAddress((CustomBuffer)dst_origin), MemoryUtil.memAddress((CustomBuffer)region), src_row_pitch, src_slice_pitch, dst_row_pitch, dst_slice_pitch, Checks.remainingSafe((Buffer)sync_point_wait_list), MemoryUtil.memAddressSafe((IntBuffer)sync_point_wait_list), MemoryUtil.memAddressSafe((IntBuffer)sync_point), MemoryUtil.memAddressSafe((Pointer)mutable_handle));
    }

    public static int nclCommandCopyBufferToImageKHR(long command_buffer, long command_queue, long src_buffer, long dst_image, long src_offset, long dst_origin, long region, int num_sync_points_in_wait_list, long sync_point_wait_list, long sync_point, long mutable_handle) {
        long __functionAddress = CL.getICD().clCommandCopyBufferToImageKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
            Checks.check((long)src_buffer);
            Checks.check((long)dst_image);
        }
        return JNI.callPPPPPPPPPPI((long)command_buffer, (long)command_queue, (long)src_buffer, (long)dst_image, (long)src_offset, (long)dst_origin, (long)region, (int)num_sync_points_in_wait_list, (long)sync_point_wait_list, (long)sync_point, (long)mutable_handle, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandCopyBufferToImageKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_buffer, @NativeType(value="cl_mem") long dst_image, @NativeType(value="size_t") long src_offset, @NativeType(value="size_t const *") PointerBuffer dst_origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="cl_sync_point_khr const *") @Nullable IntBuffer sync_point_wait_list, @NativeType(value="cl_sync_point_khr *") @Nullable IntBuffer sync_point, @NativeType(value="cl_mutable_command_khr *") @Nullable PointerBuffer mutable_handle) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)dst_origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((Buffer)sync_point, (int)1);
            Checks.checkSafe((CustomBuffer)mutable_handle, (int)1);
        }
        return KHRCommandBuffer.nclCommandCopyBufferToImageKHR(command_buffer, command_queue, src_buffer, dst_image, src_offset, MemoryUtil.memAddress((CustomBuffer)dst_origin), MemoryUtil.memAddress((CustomBuffer)region), Checks.remainingSafe((Buffer)sync_point_wait_list), MemoryUtil.memAddressSafe((IntBuffer)sync_point_wait_list), MemoryUtil.memAddressSafe((IntBuffer)sync_point), MemoryUtil.memAddressSafe((Pointer)mutable_handle));
    }

    public static int nclCommandCopyImageKHR(long command_buffer, long command_queue, long src_image, long dst_image, long src_origin, long dst_origin, long region, int num_sync_points_in_wait_list, long sync_point_wait_list, long sync_point, long mutable_handle) {
        long __functionAddress = CL.getICD().clCommandCopyImageKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
            Checks.check((long)src_image);
            Checks.check((long)dst_image);
        }
        return JNI.callPPPPPPPPPPI((long)command_buffer, (long)command_queue, (long)src_image, (long)dst_image, (long)src_origin, (long)dst_origin, (long)region, (int)num_sync_points_in_wait_list, (long)sync_point_wait_list, (long)sync_point, (long)mutable_handle, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandCopyImageKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_image, @NativeType(value="cl_mem") long dst_image, @NativeType(value="size_t const *") PointerBuffer src_origin, @NativeType(value="size_t const *") PointerBuffer dst_origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="cl_sync_point_khr const *") @Nullable IntBuffer sync_point_wait_list, @NativeType(value="cl_sync_point_khr *") @Nullable IntBuffer sync_point, @NativeType(value="cl_mutable_command_khr *") @Nullable PointerBuffer mutable_handle) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)src_origin, (int)3);
            Checks.check((CustomBuffer)dst_origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((Buffer)sync_point, (int)1);
            Checks.checkSafe((CustomBuffer)mutable_handle, (int)1);
        }
        return KHRCommandBuffer.nclCommandCopyImageKHR(command_buffer, command_queue, src_image, dst_image, MemoryUtil.memAddress((CustomBuffer)src_origin), MemoryUtil.memAddress((CustomBuffer)dst_origin), MemoryUtil.memAddress((CustomBuffer)region), Checks.remainingSafe((Buffer)sync_point_wait_list), MemoryUtil.memAddressSafe((IntBuffer)sync_point_wait_list), MemoryUtil.memAddressSafe((IntBuffer)sync_point), MemoryUtil.memAddressSafe((Pointer)mutable_handle));
    }

    public static int nclCommandCopyImageToBufferKHR(long command_buffer, long command_queue, long src_image, long dst_buffer, long src_origin, long region, long dst_offset, int num_sync_points_in_wait_list, long sync_point_wait_list, long sync_point, long mutable_handle) {
        long __functionAddress = CL.getICD().clCommandCopyImageToBufferKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
            Checks.check((long)src_image);
            Checks.check((long)dst_buffer);
        }
        return JNI.callPPPPPPPPPPI((long)command_buffer, (long)command_queue, (long)src_image, (long)dst_buffer, (long)src_origin, (long)region, (long)dst_offset, (int)num_sync_points_in_wait_list, (long)sync_point_wait_list, (long)sync_point, (long)mutable_handle, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandCopyImageToBufferKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_image, @NativeType(value="cl_mem") long dst_buffer, @NativeType(value="size_t const *") PointerBuffer src_origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long dst_offset, @NativeType(value="cl_sync_point_khr const *") @Nullable IntBuffer sync_point_wait_list, @NativeType(value="cl_sync_point_khr *") @Nullable IntBuffer sync_point, @NativeType(value="cl_mutable_command_khr *") @Nullable PointerBuffer mutable_handle) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)src_origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((Buffer)sync_point, (int)1);
            Checks.checkSafe((CustomBuffer)mutable_handle, (int)1);
        }
        return KHRCommandBuffer.nclCommandCopyImageToBufferKHR(command_buffer, command_queue, src_image, dst_buffer, MemoryUtil.memAddress((CustomBuffer)src_origin), MemoryUtil.memAddress((CustomBuffer)region), dst_offset, Checks.remainingSafe((Buffer)sync_point_wait_list), MemoryUtil.memAddressSafe((IntBuffer)sync_point_wait_list), MemoryUtil.memAddressSafe((IntBuffer)sync_point), MemoryUtil.memAddressSafe((Pointer)mutable_handle));
    }

    public static int nclCommandFillBufferKHR(long command_buffer, long command_queue, long buffer, long pattern, long pattern_size, long offset, long size, int num_sync_points_in_wait_list, long sync_point_wait_list, long sync_point, long mutable_handle) {
        long __functionAddress = CL.getICD().clCommandFillBufferKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
            Checks.check((long)buffer);
        }
        return JNI.callPPPPPPPPPPI((long)command_buffer, (long)command_queue, (long)buffer, (long)pattern, (long)pattern_size, (long)offset, (long)size, (int)num_sync_points_in_wait_list, (long)sync_point_wait_list, (long)sync_point, (long)mutable_handle, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandFillBufferKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="void const *") ByteBuffer pattern, @NativeType(value="size_t") long offset, @NativeType(value="size_t") long size, @NativeType(value="cl_sync_point_khr const *") @Nullable IntBuffer sync_point_wait_list, @NativeType(value="cl_sync_point_khr *") @Nullable IntBuffer sync_point, @NativeType(value="cl_mutable_command_khr *") @Nullable PointerBuffer mutable_handle) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)sync_point, (int)1);
            Checks.checkSafe((CustomBuffer)mutable_handle, (int)1);
        }
        return KHRCommandBuffer.nclCommandFillBufferKHR(command_buffer, command_queue, buffer, MemoryUtil.memAddress((ByteBuffer)pattern), pattern.remaining(), offset, size, Checks.remainingSafe((Buffer)sync_point_wait_list), MemoryUtil.memAddressSafe((IntBuffer)sync_point_wait_list), MemoryUtil.memAddressSafe((IntBuffer)sync_point), MemoryUtil.memAddressSafe((Pointer)mutable_handle));
    }

    public static int nclCommandFillImageKHR(long command_buffer, long command_queue, long image, long fill_color, long origin, long region, int num_sync_points_in_wait_list, long sync_point_wait_list, long sync_point, long mutable_handle) {
        long __functionAddress = CL.getICD().clCommandFillImageKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
            Checks.check((long)image);
        }
        return JNI.callPPPPPPPPPI((long)command_buffer, (long)command_queue, (long)image, (long)fill_color, (long)origin, (long)region, (int)num_sync_points_in_wait_list, (long)sync_point_wait_list, (long)sync_point, (long)mutable_handle, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandFillImageKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="void const *") ByteBuffer fill_color, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="cl_sync_point_khr const *") @Nullable IntBuffer sync_point_wait_list, @NativeType(value="cl_sync_point_khr *") @Nullable IntBuffer sync_point, @NativeType(value="cl_mutable_command_khr *") @Nullable PointerBuffer mutable_handle) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)fill_color, (int)16);
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((Buffer)sync_point, (int)1);
            Checks.checkSafe((CustomBuffer)mutable_handle, (int)1);
        }
        return KHRCommandBuffer.nclCommandFillImageKHR(command_buffer, command_queue, image, MemoryUtil.memAddress((ByteBuffer)fill_color), MemoryUtil.memAddress((CustomBuffer)origin), MemoryUtil.memAddress((CustomBuffer)region), Checks.remainingSafe((Buffer)sync_point_wait_list), MemoryUtil.memAddressSafe((IntBuffer)sync_point_wait_list), MemoryUtil.memAddressSafe((IntBuffer)sync_point), MemoryUtil.memAddressSafe((Pointer)mutable_handle));
    }

    @NativeType(value="cl_int")
    public static int clCommandFillImageKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="void const *") IntBuffer fill_color, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="cl_sync_point_khr const *") @Nullable IntBuffer sync_point_wait_list, @NativeType(value="cl_sync_point_khr *") @Nullable IntBuffer sync_point, @NativeType(value="cl_mutable_command_khr *") @Nullable PointerBuffer mutable_handle) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)fill_color, (int)4);
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((Buffer)sync_point, (int)1);
            Checks.checkSafe((CustomBuffer)mutable_handle, (int)1);
        }
        return KHRCommandBuffer.nclCommandFillImageKHR(command_buffer, command_queue, image, MemoryUtil.memAddress((IntBuffer)fill_color), MemoryUtil.memAddress((CustomBuffer)origin), MemoryUtil.memAddress((CustomBuffer)region), Checks.remainingSafe((Buffer)sync_point_wait_list), MemoryUtil.memAddressSafe((IntBuffer)sync_point_wait_list), MemoryUtil.memAddressSafe((IntBuffer)sync_point), MemoryUtil.memAddressSafe((Pointer)mutable_handle));
    }

    @NativeType(value="cl_int")
    public static int clCommandFillImageKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="void const *") FloatBuffer fill_color, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="cl_sync_point_khr const *") @Nullable IntBuffer sync_point_wait_list, @NativeType(value="cl_sync_point_khr *") @Nullable IntBuffer sync_point, @NativeType(value="cl_mutable_command_khr *") @Nullable PointerBuffer mutable_handle) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)fill_color, (int)4);
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((Buffer)sync_point, (int)1);
            Checks.checkSafe((CustomBuffer)mutable_handle, (int)1);
        }
        return KHRCommandBuffer.nclCommandFillImageKHR(command_buffer, command_queue, image, MemoryUtil.memAddress((FloatBuffer)fill_color), MemoryUtil.memAddress((CustomBuffer)origin), MemoryUtil.memAddress((CustomBuffer)region), Checks.remainingSafe((Buffer)sync_point_wait_list), MemoryUtil.memAddressSafe((IntBuffer)sync_point_wait_list), MemoryUtil.memAddressSafe((IntBuffer)sync_point), MemoryUtil.memAddressSafe((Pointer)mutable_handle));
    }

    public static int nclCommandNDRangeKernelKHR(long command_buffer, long command_queue, long properties, long kernel, int work_dim, long global_work_offset, long global_work_size, long local_work_size, int num_sync_points_in_wait_list, long sync_point_wait_list, long sync_point, long mutable_handle) {
        long __functionAddress = CL.getICD().clCommandNDRangeKernelKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
            Checks.check((long)kernel);
        }
        return JNI.callPPPPPPPPPPI((long)command_buffer, (long)command_queue, (long)properties, (long)kernel, (int)work_dim, (long)global_work_offset, (long)global_work_size, (long)local_work_size, (int)num_sync_points_in_wait_list, (long)sync_point_wait_list, (long)sync_point, (long)mutable_handle, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandNDRangeKernelKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_ndrange_kernel_command_properties_khr const *") @Nullable LongBuffer properties, @NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int work_dim, @NativeType(value="size_t const *") @Nullable PointerBuffer global_work_offset, @NativeType(value="size_t const *") @Nullable PointerBuffer global_work_size, @NativeType(value="size_t const *") @Nullable PointerBuffer local_work_size, @NativeType(value="cl_sync_point_khr const *") @Nullable IntBuffer sync_point_wait_list, @NativeType(value="cl_sync_point_khr *") @Nullable IntBuffer sync_point, @NativeType(value="cl_mutable_command_khr *") @Nullable PointerBuffer mutable_handle) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((LongBuffer)properties);
            Checks.checkSafe((CustomBuffer)global_work_offset, (int)work_dim);
            Checks.checkSafe((CustomBuffer)global_work_size, (int)work_dim);
            Checks.checkSafe((CustomBuffer)local_work_size, (int)work_dim);
            Checks.checkSafe((Buffer)sync_point, (int)1);
            Checks.checkSafe((CustomBuffer)mutable_handle, (int)1);
        }
        return KHRCommandBuffer.nclCommandNDRangeKernelKHR(command_buffer, command_queue, MemoryUtil.memAddressSafe((LongBuffer)properties), kernel, work_dim, MemoryUtil.memAddressSafe((Pointer)global_work_offset), MemoryUtil.memAddressSafe((Pointer)global_work_size), MemoryUtil.memAddressSafe((Pointer)local_work_size), Checks.remainingSafe((Buffer)sync_point_wait_list), MemoryUtil.memAddressSafe((IntBuffer)sync_point_wait_list), MemoryUtil.memAddressSafe((IntBuffer)sync_point), MemoryUtil.memAddressSafe((Pointer)mutable_handle));
    }

    public static int nclGetCommandBufferInfoKHR(long command_buffer, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetCommandBufferInfoKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
        }
        return JNI.callPPPPI((long)command_buffer, (int)param_name, (long)param_value_size, (long)param_value, (long)param_value_size_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetCommandBufferInfoKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_buffer_info_khr") int param_name, @NativeType(value="void *") @Nullable ByteBuffer param_value, @NativeType(value="size_t *") @Nullable PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return KHRCommandBuffer.nclGetCommandBufferInfoKHR(command_buffer, param_name, Checks.remainingSafe((Buffer)param_value), MemoryUtil.memAddressSafe((ByteBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetCommandBufferInfoKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_buffer_info_khr") int param_name, @NativeType(value="void *") @Nullable IntBuffer param_value, @NativeType(value="size_t *") @Nullable PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return KHRCommandBuffer.nclGetCommandBufferInfoKHR(command_buffer, param_name, Integer.toUnsignedLong(Checks.remainingSafe((Buffer)param_value)) << 2, MemoryUtil.memAddressSafe((IntBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetCommandBufferInfoKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_buffer_info_khr") int param_name, @NativeType(value="void *") @Nullable PointerBuffer param_value, @NativeType(value="size_t *") @Nullable PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return KHRCommandBuffer.nclGetCommandBufferInfoKHR(command_buffer, param_name, Integer.toUnsignedLong(Checks.remainingSafe((CustomBuffer)param_value)) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe((Pointer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_command_buffer_khr")
    public static long clCreateCommandBufferKHR(@NativeType(value="cl_command_queue const *") PointerBuffer queues, @NativeType(value="cl_command_buffer_properties_khr const *") long @Nullable [] properties, @NativeType(value="cl_int *") int @Nullable [] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateCommandBufferKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkNTSafe((long[])properties);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPPPP((int)queues.remaining(), (long)MemoryUtil.memAddress((CustomBuffer)queues), (long[])properties, (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandBarrierWithWaitListKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_sync_point_khr const *") int @Nullable [] sync_point_wait_list, @NativeType(value="cl_sync_point_khr *") int @Nullable [] sync_point, @NativeType(value="cl_mutable_command_khr *") @Nullable PointerBuffer mutable_handle) {
        long __functionAddress = CL.getICD().clCommandBarrierWithWaitListKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
            Checks.checkSafe((int[])sync_point, (int)1);
            Checks.checkSafe((CustomBuffer)mutable_handle, (int)1);
        }
        return JNI.callPPPPPI((long)command_buffer, (long)command_queue, (int)Checks.lengthSafe((int[])sync_point_wait_list), (int[])sync_point_wait_list, (int[])sync_point, (long)MemoryUtil.memAddressSafe((Pointer)mutable_handle), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandCopyBufferKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_buffer, @NativeType(value="cl_mem") long dst_buffer, @NativeType(value="size_t") long src_offset, @NativeType(value="size_t") long dst_offset, @NativeType(value="size_t") long size, @NativeType(value="cl_sync_point_khr const *") int @Nullable [] sync_point_wait_list, @NativeType(value="cl_sync_point_khr *") int @Nullable [] sync_point, @NativeType(value="cl_mutable_command_khr *") @Nullable PointerBuffer mutable_handle) {
        long __functionAddress = CL.getICD().clCommandCopyBufferKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
            Checks.check((long)src_buffer);
            Checks.check((long)dst_buffer);
            Checks.checkSafe((int[])sync_point, (int)1);
            Checks.checkSafe((CustomBuffer)mutable_handle, (int)1);
        }
        return JNI.callPPPPPPPPPPI((long)command_buffer, (long)command_queue, (long)src_buffer, (long)dst_buffer, (long)src_offset, (long)dst_offset, (long)size, (int)Checks.lengthSafe((int[])sync_point_wait_list), (int[])sync_point_wait_list, (int[])sync_point, (long)MemoryUtil.memAddressSafe((Pointer)mutable_handle), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandCopyBufferRectKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_buffer, @NativeType(value="cl_mem") long dst_buffer, @NativeType(value="size_t const *") PointerBuffer src_origin, @NativeType(value="size_t const *") PointerBuffer dst_origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long src_row_pitch, @NativeType(value="size_t") long src_slice_pitch, @NativeType(value="size_t") long dst_row_pitch, @NativeType(value="size_t") long dst_slice_pitch, @NativeType(value="cl_sync_point_khr const *") int @Nullable [] sync_point_wait_list, @NativeType(value="cl_sync_point_khr *") int @Nullable [] sync_point, @NativeType(value="cl_mutable_command_khr *") @Nullable PointerBuffer mutable_handle) {
        long __functionAddress = CL.getICD().clCommandCopyBufferRectKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
            Checks.check((long)src_buffer);
            Checks.check((long)dst_buffer);
            Checks.check((CustomBuffer)src_origin, (int)3);
            Checks.check((CustomBuffer)dst_origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((int[])sync_point, (int)1);
            Checks.checkSafe((CustomBuffer)mutable_handle, (int)1);
        }
        return JNI.callPPPPPPPPPPPPPPI((long)command_buffer, (long)command_queue, (long)src_buffer, (long)dst_buffer, (long)MemoryUtil.memAddress((CustomBuffer)src_origin), (long)MemoryUtil.memAddress((CustomBuffer)dst_origin), (long)MemoryUtil.memAddress((CustomBuffer)region), (long)src_row_pitch, (long)src_slice_pitch, (long)dst_row_pitch, (long)dst_slice_pitch, (int)Checks.lengthSafe((int[])sync_point_wait_list), (int[])sync_point_wait_list, (int[])sync_point, (long)MemoryUtil.memAddressSafe((Pointer)mutable_handle), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandCopyBufferToImageKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_buffer, @NativeType(value="cl_mem") long dst_image, @NativeType(value="size_t") long src_offset, @NativeType(value="size_t const *") PointerBuffer dst_origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="cl_sync_point_khr const *") int @Nullable [] sync_point_wait_list, @NativeType(value="cl_sync_point_khr *") int @Nullable [] sync_point, @NativeType(value="cl_mutable_command_khr *") @Nullable PointerBuffer mutable_handle) {
        long __functionAddress = CL.getICD().clCommandCopyBufferToImageKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
            Checks.check((long)src_buffer);
            Checks.check((long)dst_image);
            Checks.check((CustomBuffer)dst_origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((int[])sync_point, (int)1);
            Checks.checkSafe((CustomBuffer)mutable_handle, (int)1);
        }
        return JNI.callPPPPPPPPPPI((long)command_buffer, (long)command_queue, (long)src_buffer, (long)dst_image, (long)src_offset, (long)MemoryUtil.memAddress((CustomBuffer)dst_origin), (long)MemoryUtil.memAddress((CustomBuffer)region), (int)Checks.lengthSafe((int[])sync_point_wait_list), (int[])sync_point_wait_list, (int[])sync_point, (long)MemoryUtil.memAddressSafe((Pointer)mutable_handle), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandCopyImageKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_image, @NativeType(value="cl_mem") long dst_image, @NativeType(value="size_t const *") PointerBuffer src_origin, @NativeType(value="size_t const *") PointerBuffer dst_origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="cl_sync_point_khr const *") int @Nullable [] sync_point_wait_list, @NativeType(value="cl_sync_point_khr *") int @Nullable [] sync_point, @NativeType(value="cl_mutable_command_khr *") @Nullable PointerBuffer mutable_handle) {
        long __functionAddress = CL.getICD().clCommandCopyImageKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
            Checks.check((long)src_image);
            Checks.check((long)dst_image);
            Checks.check((CustomBuffer)src_origin, (int)3);
            Checks.check((CustomBuffer)dst_origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((int[])sync_point, (int)1);
            Checks.checkSafe((CustomBuffer)mutable_handle, (int)1);
        }
        return JNI.callPPPPPPPPPPI((long)command_buffer, (long)command_queue, (long)src_image, (long)dst_image, (long)MemoryUtil.memAddress((CustomBuffer)src_origin), (long)MemoryUtil.memAddress((CustomBuffer)dst_origin), (long)MemoryUtil.memAddress((CustomBuffer)region), (int)Checks.lengthSafe((int[])sync_point_wait_list), (int[])sync_point_wait_list, (int[])sync_point, (long)MemoryUtil.memAddressSafe((Pointer)mutable_handle), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandCopyImageToBufferKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_image, @NativeType(value="cl_mem") long dst_buffer, @NativeType(value="size_t const *") PointerBuffer src_origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long dst_offset, @NativeType(value="cl_sync_point_khr const *") int @Nullable [] sync_point_wait_list, @NativeType(value="cl_sync_point_khr *") int @Nullable [] sync_point, @NativeType(value="cl_mutable_command_khr *") @Nullable PointerBuffer mutable_handle) {
        long __functionAddress = CL.getICD().clCommandCopyImageToBufferKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
            Checks.check((long)src_image);
            Checks.check((long)dst_buffer);
            Checks.check((CustomBuffer)src_origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((int[])sync_point, (int)1);
            Checks.checkSafe((CustomBuffer)mutable_handle, (int)1);
        }
        return JNI.callPPPPPPPPPPI((long)command_buffer, (long)command_queue, (long)src_image, (long)dst_buffer, (long)MemoryUtil.memAddress((CustomBuffer)src_origin), (long)MemoryUtil.memAddress((CustomBuffer)region), (long)dst_offset, (int)Checks.lengthSafe((int[])sync_point_wait_list), (int[])sync_point_wait_list, (int[])sync_point, (long)MemoryUtil.memAddressSafe((Pointer)mutable_handle), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandFillBufferKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="void const *") ByteBuffer pattern, @NativeType(value="size_t") long offset, @NativeType(value="size_t") long size, @NativeType(value="cl_sync_point_khr const *") int @Nullable [] sync_point_wait_list, @NativeType(value="cl_sync_point_khr *") int @Nullable [] sync_point, @NativeType(value="cl_mutable_command_khr *") @Nullable PointerBuffer mutable_handle) {
        long __functionAddress = CL.getICD().clCommandFillBufferKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
            Checks.check((long)buffer);
            Checks.checkSafe((int[])sync_point, (int)1);
            Checks.checkSafe((CustomBuffer)mutable_handle, (int)1);
        }
        return JNI.callPPPPPPPPPPI((long)command_buffer, (long)command_queue, (long)buffer, (long)MemoryUtil.memAddress((ByteBuffer)pattern), (long)pattern.remaining(), (long)offset, (long)size, (int)Checks.lengthSafe((int[])sync_point_wait_list), (int[])sync_point_wait_list, (int[])sync_point, (long)MemoryUtil.memAddressSafe((Pointer)mutable_handle), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandFillImageKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="void const *") ByteBuffer fill_color, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="cl_sync_point_khr const *") int @Nullable [] sync_point_wait_list, @NativeType(value="cl_sync_point_khr *") int @Nullable [] sync_point, @NativeType(value="cl_mutable_command_khr *") @Nullable PointerBuffer mutable_handle) {
        long __functionAddress = CL.getICD().clCommandFillImageKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
            Checks.check((long)image);
            Checks.check((Buffer)fill_color, (int)16);
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((int[])sync_point, (int)1);
            Checks.checkSafe((CustomBuffer)mutable_handle, (int)1);
        }
        return JNI.callPPPPPPPPPI((long)command_buffer, (long)command_queue, (long)image, (long)MemoryUtil.memAddress((ByteBuffer)fill_color), (long)MemoryUtil.memAddress((CustomBuffer)origin), (long)MemoryUtil.memAddress((CustomBuffer)region), (int)Checks.lengthSafe((int[])sync_point_wait_list), (int[])sync_point_wait_list, (int[])sync_point, (long)MemoryUtil.memAddressSafe((Pointer)mutable_handle), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandFillImageKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="void const *") int[] fill_color, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="cl_sync_point_khr const *") int @Nullable [] sync_point_wait_list, @NativeType(value="cl_sync_point_khr *") int @Nullable [] sync_point, @NativeType(value="cl_mutable_command_khr *") @Nullable PointerBuffer mutable_handle) {
        long __functionAddress = CL.getICD().clCommandFillImageKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
            Checks.check((long)image);
            Checks.check((int[])fill_color, (int)4);
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((int[])sync_point, (int)1);
            Checks.checkSafe((CustomBuffer)mutable_handle, (int)1);
        }
        return JNI.callPPPPPPPPPI((long)command_buffer, (long)command_queue, (long)image, (int[])fill_color, (long)MemoryUtil.memAddress((CustomBuffer)origin), (long)MemoryUtil.memAddress((CustomBuffer)region), (int)Checks.lengthSafe((int[])sync_point_wait_list), (int[])sync_point_wait_list, (int[])sync_point, (long)MemoryUtil.memAddressSafe((Pointer)mutable_handle), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandFillImageKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="void const *") float[] fill_color, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="cl_sync_point_khr const *") int @Nullable [] sync_point_wait_list, @NativeType(value="cl_sync_point_khr *") int @Nullable [] sync_point, @NativeType(value="cl_mutable_command_khr *") @Nullable PointerBuffer mutable_handle) {
        long __functionAddress = CL.getICD().clCommandFillImageKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
            Checks.check((long)image);
            Checks.check((float[])fill_color, (int)4);
            Checks.check((CustomBuffer)origin, (int)3);
            Checks.check((CustomBuffer)region, (int)3);
            Checks.checkSafe((int[])sync_point, (int)1);
            Checks.checkSafe((CustomBuffer)mutable_handle, (int)1);
        }
        return JNI.callPPPPPPPPPI((long)command_buffer, (long)command_queue, (long)image, (float[])fill_color, (long)MemoryUtil.memAddress((CustomBuffer)origin), (long)MemoryUtil.memAddress((CustomBuffer)region), (int)Checks.lengthSafe((int[])sync_point_wait_list), (int[])sync_point_wait_list, (int[])sync_point, (long)MemoryUtil.memAddressSafe((Pointer)mutable_handle), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCommandNDRangeKernelKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_ndrange_kernel_command_properties_khr const *") long @Nullable [] properties, @NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int work_dim, @NativeType(value="size_t const *") @Nullable PointerBuffer global_work_offset, @NativeType(value="size_t const *") @Nullable PointerBuffer global_work_size, @NativeType(value="size_t const *") @Nullable PointerBuffer local_work_size, @NativeType(value="cl_sync_point_khr const *") int @Nullable [] sync_point_wait_list, @NativeType(value="cl_sync_point_khr *") int @Nullable [] sync_point, @NativeType(value="cl_mutable_command_khr *") @Nullable PointerBuffer mutable_handle) {
        long __functionAddress = CL.getICD().clCommandNDRangeKernelKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
            Checks.checkNTSafe((long[])properties);
            Checks.check((long)kernel);
            Checks.checkSafe((CustomBuffer)global_work_offset, (int)work_dim);
            Checks.checkSafe((CustomBuffer)global_work_size, (int)work_dim);
            Checks.checkSafe((CustomBuffer)local_work_size, (int)work_dim);
            Checks.checkSafe((int[])sync_point, (int)1);
            Checks.checkSafe((CustomBuffer)mutable_handle, (int)1);
        }
        return JNI.callPPPPPPPPPPI((long)command_buffer, (long)command_queue, (long[])properties, (long)kernel, (int)work_dim, (long)MemoryUtil.memAddressSafe((Pointer)global_work_offset), (long)MemoryUtil.memAddressSafe((Pointer)global_work_size), (long)MemoryUtil.memAddressSafe((Pointer)local_work_size), (int)Checks.lengthSafe((int[])sync_point_wait_list), (int[])sync_point_wait_list, (int[])sync_point, (long)MemoryUtil.memAddressSafe((Pointer)mutable_handle), (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetCommandBufferInfoKHR(@NativeType(value="cl_command_buffer_khr") long command_buffer, @NativeType(value="cl_command_buffer_info_khr") int param_name, @NativeType(value="void *") int @Nullable [] param_value, @NativeType(value="size_t *") @Nullable PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetCommandBufferInfoKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_buffer);
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return JNI.callPPPPI((long)command_buffer, (int)param_name, (long)(Integer.toUnsignedLong(Checks.lengthSafe((int[])param_value)) << 2), (int[])param_value, (long)MemoryUtil.memAddressSafe((Pointer)param_value_size_ret), (long)__functionAddress);
    }
}

