/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.util.Set;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;

public class XRCapabilities {
    public final long xrDestroyInstance;
    public final long xrGetInstanceProperties;
    public final long xrPollEvent;
    public final long xrResultToString;
    public final long xrStructureTypeToString;
    public final long xrGetSystem;
    public final long xrGetSystemProperties;
    public final long xrEnumerateEnvironmentBlendModes;
    public final long xrCreateSession;
    public final long xrDestroySession;
    public final long xrEnumerateReferenceSpaces;
    public final long xrCreateReferenceSpace;
    public final long xrGetReferenceSpaceBoundsRect;
    public final long xrCreateActionSpace;
    public final long xrLocateSpace;
    public final long xrDestroySpace;
    public final long xrEnumerateViewConfigurations;
    public final long xrGetViewConfigurationProperties;
    public final long xrEnumerateViewConfigurationViews;
    public final long xrEnumerateSwapchainFormats;
    public final long xrCreateSwapchain;
    public final long xrDestroySwapchain;
    public final long xrEnumerateSwapchainImages;
    public final long xrAcquireSwapchainImage;
    public final long xrWaitSwapchainImage;
    public final long xrReleaseSwapchainImage;
    public final long xrBeginSession;
    public final long xrEndSession;
    public final long xrRequestExitSession;
    public final long xrWaitFrame;
    public final long xrBeginFrame;
    public final long xrEndFrame;
    public final long xrLocateViews;
    public final long xrStringToPath;
    public final long xrPathToString;
    public final long xrCreateActionSet;
    public final long xrDestroyActionSet;
    public final long xrCreateAction;
    public final long xrDestroyAction;
    public final long xrSuggestInteractionProfileBindings;
    public final long xrAttachSessionActionSets;
    public final long xrGetCurrentInteractionProfile;
    public final long xrGetActionStateBoolean;
    public final long xrGetActionStateFloat;
    public final long xrGetActionStateVector2f;
    public final long xrGetActionStatePose;
    public final long xrSyncActions;
    public final long xrEnumerateBoundSourcesForAction;
    public final long xrGetInputSourceLocalizedName;
    public final long xrApplyHapticFeedback;
    public final long xrStopHapticFeedback;
    public final long xrSetDigitalLensControlALMALENCE;
    public final long xrSetInputDeviceActiveEXT;
    public final long xrSetInputDeviceStateBoolEXT;
    public final long xrSetInputDeviceStateFloatEXT;
    public final long xrSetInputDeviceStateVector2fEXT;
    public final long xrSetInputDeviceLocationEXT;
    public final long xrSetDebugUtilsObjectNameEXT;
    public final long xrCreateDebugUtilsMessengerEXT;
    public final long xrDestroyDebugUtilsMessengerEXT;
    public final long xrSubmitDebugUtilsMessageEXT;
    public final long xrSessionBeginDebugUtilsLabelRegionEXT;
    public final long xrSessionEndDebugUtilsLabelRegionEXT;
    public final long xrSessionInsertDebugUtilsLabelEXT;
    public final long xrCreateHandTrackerEXT;
    public final long xrDestroyHandTrackerEXT;
    public final long xrLocateHandJointsEXT;
    public final long xrPerfSettingsSetPerformanceLevelEXT;
    public final long xrThermalGetTemperatureTrendEXT;
    public final long xrCreateBodyTrackerFB;
    public final long xrDestroyBodyTrackerFB;
    public final long xrLocateBodyJointsFB;
    public final long xrGetBodySkeletonFB;
    public final long xrEnumerateColorSpacesFB;
    public final long xrSetColorSpaceFB;
    public final long xrEnumerateDisplayRefreshRatesFB;
    public final long xrGetDisplayRefreshRateFB;
    public final long xrRequestDisplayRefreshRateFB;
    public final long xrCreateEyeTrackerFB;
    public final long xrDestroyEyeTrackerFB;
    public final long xrGetEyeGazesFB;
    public final long xrCreateFaceTrackerFB;
    public final long xrDestroyFaceTrackerFB;
    public final long xrGetFaceExpressionWeightsFB;
    public final long xrCreateFoveationProfileFB;
    public final long xrDestroyFoveationProfileFB;
    public final long xrGetHandMeshFB;
    public final long xrGetDeviceSampleRateFB;
    public final long xrQuerySystemTrackedKeyboardFB;
    public final long xrCreateKeyboardSpaceFB;
    public final long xrCreatePassthroughFB;
    public final long xrDestroyPassthroughFB;
    public final long xrPassthroughStartFB;
    public final long xrPassthroughPauseFB;
    public final long xrCreatePassthroughLayerFB;
    public final long xrDestroyPassthroughLayerFB;
    public final long xrPassthroughLayerPauseFB;
    public final long xrPassthroughLayerResumeFB;
    public final long xrPassthroughLayerSetStyleFB;
    public final long xrCreateGeometryInstanceFB;
    public final long xrDestroyGeometryInstanceFB;
    public final long xrGeometryInstanceSetTransformFB;
    public final long xrPassthroughLayerSetKeyboardHandsIntensityFB;
    public final long xrEnumerateRenderModelPathsFB;
    public final long xrGetRenderModelPropertiesFB;
    public final long xrLoadRenderModelFB;
    public final long xrGetSpaceBoundingBox2DFB;
    public final long xrGetSpaceBoundingBox3DFB;
    public final long xrGetSpaceSemanticLabelsFB;
    public final long xrGetSpaceBoundary2DFB;
    public final long xrGetSpaceRoomLayoutFB;
    public final long xrRequestSceneCaptureFB;
    public final long xrCreateSpatialAnchorFB;
    public final long xrGetSpaceUuidFB;
    public final long xrEnumerateSpaceSupportedComponentsFB;
    public final long xrSetSpaceComponentStatusFB;
    public final long xrGetSpaceComponentStatusFB;
    public final long xrGetSpaceContainerFB;
    public final long xrQuerySpacesFB;
    public final long xrRetrieveSpaceQueryResultsFB;
    public final long xrShareSpacesFB;
    public final long xrSaveSpaceFB;
    public final long xrEraseSpaceFB;
    public final long xrSaveSpaceListFB;
    public final long xrCreateSpaceUserFB;
    public final long xrGetSpaceUserIdFB;
    public final long xrDestroySpaceUserFB;
    public final long xrUpdateSwapchainFB;
    public final long xrGetSwapchainStateFB;
    public final long xrCreateTriangleMeshFB;
    public final long xrDestroyTriangleMeshFB;
    public final long xrTriangleMeshGetVertexBufferFB;
    public final long xrTriangleMeshGetIndexBufferFB;
    public final long xrTriangleMeshBeginUpdateFB;
    public final long xrTriangleMeshEndUpdateFB;
    public final long xrTriangleMeshBeginVertexBufferUpdateFB;
    public final long xrTriangleMeshEndVertexBufferUpdateFB;
    public final long xrCreateFacialTrackerHTC;
    public final long xrDestroyFacialTrackerHTC;
    public final long xrGetFacialExpressionsHTC;
    public final long xrApplyFoveationHTC;
    public final long xrCreatePassthroughHTC;
    public final long xrDestroyPassthroughHTC;
    public final long xrEnumerateViveTrackerPathsHTCX;
    public final long xrConvertTimespecTimeToTimeKHR;
    public final long xrConvertTimeToTimespecTimeKHR;
    public final long xrGetOpenGLGraphicsRequirementsKHR;
    public final long xrGetVisibilityMaskKHR;
    public final long xrGetVulkanInstanceExtensionsKHR;
    public final long xrGetVulkanDeviceExtensionsKHR;
    public final long xrGetVulkanGraphicsDeviceKHR;
    public final long xrGetVulkanGraphicsRequirementsKHR;
    public final long xrCreateVulkanInstanceKHR;
    public final long xrCreateVulkanDeviceKHR;
    public final long xrGetVulkanGraphicsDevice2KHR;
    public final long xrGetVulkanGraphicsRequirements2KHR;
    public final long xrConvertWin32PerformanceCounterToTimeKHR;
    public final long xrConvertTimeToWin32PerformanceCounterKHR;
    public final long xrGetFoveationEyeTrackedStateMETA;
    public final long xrEnumeratePerformanceMetricsCounterPathsMETA;
    public final long xrSetPerformanceMetricsStateMETA;
    public final long xrGetPerformanceMetricsStateMETA;
    public final long xrQueryPerformanceMetricsCounterMETA;
    public final long xrCreateSpaceFromCoordinateFrameUIDML;
    public final long xrApplyForceFeedbackCurlMNDX;
    public final long xrEnumerateReprojectionModesMSFT;
    public final long xrGetControllerModelKeyMSFT;
    public final long xrLoadControllerModelMSFT;
    public final long xrGetControllerModelPropertiesMSFT;
    public final long xrGetControllerModelStateMSFT;
    public final long xrCreateHandMeshSpaceMSFT;
    public final long xrUpdateHandMeshMSFT;
    public final long xrCreateSpatialAnchorFromPerceptionAnchorMSFT;
    public final long xrTryGetPerceptionAnchorFromSpatialAnchorMSFT;
    public final long xrEnumerateSceneComputeFeaturesMSFT;
    public final long xrCreateSceneObserverMSFT;
    public final long xrDestroySceneObserverMSFT;
    public final long xrCreateSceneMSFT;
    public final long xrDestroySceneMSFT;
    public final long xrComputeNewSceneMSFT;
    public final long xrGetSceneComputeStateMSFT;
    public final long xrGetSceneComponentsMSFT;
    public final long xrLocateSceneComponentsMSFT;
    public final long xrGetSceneMeshBuffersMSFT;
    public final long xrDeserializeSceneMSFT;
    public final long xrGetSerializedSceneFragmentDataMSFT;
    public final long xrCreateSpatialAnchorMSFT;
    public final long xrCreateSpatialAnchorSpaceMSFT;
    public final long xrDestroySpatialAnchorMSFT;
    public final long xrCreateSpatialAnchorStoreConnectionMSFT;
    public final long xrDestroySpatialAnchorStoreConnectionMSFT;
    public final long xrPersistSpatialAnchorMSFT;
    public final long xrEnumeratePersistedSpatialAnchorNamesMSFT;
    public final long xrCreateSpatialAnchorFromPersistedNameMSFT;
    public final long xrUnpersistSpatialAnchorMSFT;
    public final long xrClearSpatialAnchorStoreMSFT;
    public final long xrCreateSpatialGraphNodeSpaceMSFT;
    public final long xrTryCreateSpatialGraphStaticNodeBindingMSFT;
    public final long xrDestroySpatialGraphNodeBindingMSFT;
    public final long xrGetSpatialGraphNodeBindingPropertiesMSFT;
    public final long xrGetAudioOutputDeviceGuidOculus;
    public final long xrGetAudioInputDeviceGuidOculus;
    public final long xrEnumerateExternalCamerasOCULUS;
    public final long xrSetTrackingOptimizationSettingsHintQCOM;
    public final long xrSetEnvironmentDepthEstimationVARJO;
    public final long xrSetMarkerTrackingVARJO;
    public final long xrSetMarkerTrackingTimeoutVARJO;
    public final long xrSetMarkerTrackingPredictionVARJO;
    public final long xrGetMarkerSizeVARJO;
    public final long xrCreateMarkerSpaceVARJO;
    public final long xrSetViewOffsetVARJO;
    public final long apiVersion;
    public final boolean OpenXR10;
    public final boolean XR_ALMALENCE_digital_lens_control;
    public final boolean XR_BD_controller_interaction;
    public final boolean XR_EPIC_view_configuration_fov;
    public final boolean XR_EXT_active_action_set_priority;
    public final boolean XR_EXT_conformance_automation;
    public final boolean XR_EXT_debug_utils;
    public final boolean XR_EXT_dpad_binding;
    public final boolean XR_EXT_eye_gaze_interaction;
    public final boolean XR_EXT_hand_joints_motion_range;
    public final boolean XR_EXT_hand_tracking;
    public final boolean XR_EXT_hp_mixed_reality_controller;
    public final boolean XR_EXT_local_floor;
    public final boolean XR_EXT_palm_pose;
    public final boolean XR_EXT_performance_settings;
    public final boolean XR_EXT_samsung_odyssey_controller;
    public final boolean XR_EXT_thermal_query;
    public final boolean XR_EXT_uuid;
    public final boolean XR_EXT_view_configuration_depth_range;
    public final boolean XR_EXT_win32_appcontainer_compatible;
    public final boolean XR_EXTX_overlay;
    public final boolean XR_FB_body_tracking;
    public final boolean XR_FB_color_space;
    public final boolean XR_FB_composition_layer_alpha_blend;
    public final boolean XR_FB_composition_layer_depth_test;
    public final boolean XR_FB_composition_layer_image_layout;
    public final boolean XR_FB_composition_layer_secure_content;
    public final boolean XR_FB_composition_layer_settings;
    public final boolean XR_FB_display_refresh_rate;
    public final boolean XR_FB_eye_tracking_social;
    public final boolean XR_FB_face_tracking;
    public final boolean XR_FB_foveation;
    public final boolean XR_FB_foveation_configuration;
    public final boolean XR_FB_foveation_vulkan;
    public final boolean XR_FB_hand_tracking_aim;
    public final boolean XR_FB_hand_tracking_capsules;
    public final boolean XR_FB_hand_tracking_mesh;
    public final boolean XR_FB_haptic_amplitude_envelope;
    public final boolean XR_FB_haptic_pcm;
    public final boolean XR_FB_keyboard_tracking;
    public final boolean XR_FB_passthrough;
    public final boolean XR_FB_passthrough_keyboard_hands;
    public final boolean XR_FB_render_model;
    public final boolean XR_FB_scene;
    public final boolean XR_FB_scene_capture;
    public final boolean XR_FB_space_warp;
    public final boolean XR_FB_spatial_entity;
    public final boolean XR_FB_spatial_entity_container;
    public final boolean XR_FB_spatial_entity_query;
    public final boolean XR_FB_spatial_entity_sharing;
    public final boolean XR_FB_spatial_entity_storage;
    public final boolean XR_FB_spatial_entity_storage_batch;
    public final boolean XR_FB_spatial_entity_user;
    public final boolean XR_FB_swapchain_update_state;
    public final boolean XR_FB_swapchain_update_state_opengl_es;
    public final boolean XR_FB_swapchain_update_state_vulkan;
    public final boolean XR_FB_touch_controller_pro;
    public final boolean XR_FB_touch_controller_proximity;
    public final boolean XR_FB_triangle_mesh;
    public final boolean XR_HTC_facial_tracking;
    public final boolean XR_HTC_foveation;
    public final boolean XR_HTC_hand_interaction;
    public final boolean XR_HTC_passthrough;
    public final boolean XR_HTC_vive_cosmos_controller_interaction;
    public final boolean XR_HTC_vive_focus3_controller_interaction;
    public final boolean XR_HTC_vive_wrist_tracker_interaction;
    public final boolean XR_HTCX_vive_tracker_interaction;
    public final boolean XR_HUAWEI_controller_interaction;
    public final boolean XR_KHR_binding_modification;
    public final boolean XR_KHR_composition_layer_color_scale_bias;
    public final boolean XR_KHR_composition_layer_cube;
    public final boolean XR_KHR_composition_layer_cylinder;
    public final boolean XR_KHR_composition_layer_depth;
    public final boolean XR_KHR_composition_layer_equirect;
    public final boolean XR_KHR_composition_layer_equirect2;
    public final boolean XR_KHR_convert_timespec_time;
    public final boolean XR_KHR_loader_init;
    public final boolean XR_KHR_opengl_enable;
    public final boolean XR_KHR_swapchain_usage_input_attachment_bit;
    public final boolean XR_KHR_visibility_mask;
    public final boolean XR_KHR_vulkan_enable;
    public final boolean XR_KHR_vulkan_enable2;
    public final boolean XR_KHR_vulkan_swapchain_format_list;
    public final boolean XR_KHR_win32_convert_performance_counter_time;
    public final boolean XR_META_foveation_eye_tracked;
    public final boolean XR_META_headset_id;
    public final boolean XR_META_local_dimming;
    public final boolean XR_META_performance_metrics;
    public final boolean XR_META_vulkan_swapchain_create_info;
    public final boolean XR_ML_compat;
    public final boolean XR_ML_frame_end_info;
    public final boolean XR_ML_global_dimmer;
    public final boolean XR_ML_ml2_controller_interaction;
    public final boolean XR_MND_headless;
    public final boolean XR_MND_swapchain_usage_input_attachment_bit;
    public final boolean XR_MNDX_egl_enable;
    public final boolean XR_MNDX_force_feedback_curl;
    public final boolean XR_MSFT_composition_layer_reprojection;
    public final boolean XR_MSFT_controller_model;
    public final boolean XR_MSFT_first_person_observer;
    public final boolean XR_MSFT_hand_interaction;
    public final boolean XR_MSFT_hand_tracking_mesh;
    public final boolean XR_MSFT_holographic_window_attachment;
    public final boolean XR_MSFT_perception_anchor_interop;
    public final boolean XR_MSFT_scene_understanding;
    public final boolean XR_MSFT_scene_understanding_serialization;
    public final boolean XR_MSFT_secondary_view_configuration;
    public final boolean XR_MSFT_spatial_anchor;
    public final boolean XR_MSFT_spatial_anchor_persistence;
    public final boolean XR_MSFT_spatial_graph_bridge;
    public final boolean XR_MSFT_unbounded_reference_space;
    public final boolean XR_OCULUS_audio_device_guid;
    public final boolean XR_OCULUS_external_camera;
    public final boolean XR_QCOM_tracking_optimization_settings;
    public final boolean XR_ULTRALEAP_hand_tracking_forearm;
    public final boolean XR_VALVE_analog_threshold;
    public final boolean XR_VARJO_composition_layer_depth_test;
    public final boolean XR_VARJO_environment_depth_estimation;
    public final boolean XR_VARJO_foveated_rendering;
    public final boolean XR_VARJO_marker_tracking;
    public final boolean XR_VARJO_quad_views;
    public final boolean XR_VARJO_view_offset;

    XRCapabilities(FunctionProvider provider, long apiVersion, Set<String> ext) {
        this.apiVersion = apiVersion;
        long[] caps = new long[211];
        this.OpenXR10 = XRCapabilities.check_XR10(provider, caps, ext);
        this.XR_ALMALENCE_digital_lens_control = XRCapabilities.check_ALMALENCE_digital_lens_control(provider, caps, ext);
        this.XR_BD_controller_interaction = ext.contains("XR_BD_controller_interaction");
        this.XR_EPIC_view_configuration_fov = ext.contains("XR_EPIC_view_configuration_fov");
        this.XR_EXT_active_action_set_priority = ext.contains("XR_EXT_active_action_set_priority");
        this.XR_EXT_conformance_automation = XRCapabilities.check_EXT_conformance_automation(provider, caps, ext);
        this.XR_EXT_debug_utils = XRCapabilities.check_EXT_debug_utils(provider, caps, ext);
        this.XR_EXT_dpad_binding = ext.contains("XR_EXT_dpad_binding");
        this.XR_EXT_eye_gaze_interaction = ext.contains("XR_EXT_eye_gaze_interaction");
        this.XR_EXT_hand_joints_motion_range = ext.contains("XR_EXT_hand_joints_motion_range");
        this.XR_EXT_hand_tracking = XRCapabilities.check_EXT_hand_tracking(provider, caps, ext);
        this.XR_EXT_hp_mixed_reality_controller = ext.contains("XR_EXT_hp_mixed_reality_controller");
        this.XR_EXT_local_floor = ext.contains("XR_EXT_local_floor");
        this.XR_EXT_palm_pose = ext.contains("XR_EXT_palm_pose");
        this.XR_EXT_performance_settings = XRCapabilities.check_EXT_performance_settings(provider, caps, ext);
        this.XR_EXT_samsung_odyssey_controller = ext.contains("XR_EXT_samsung_odyssey_controller");
        this.XR_EXT_thermal_query = XRCapabilities.check_EXT_thermal_query(provider, caps, ext);
        this.XR_EXT_uuid = ext.contains("XR_EXT_uuid");
        this.XR_EXT_view_configuration_depth_range = ext.contains("XR_EXT_view_configuration_depth_range");
        this.XR_EXT_win32_appcontainer_compatible = ext.contains("XR_EXT_win32_appcontainer_compatible");
        this.XR_EXTX_overlay = ext.contains("XR_EXTX_overlay");
        this.XR_FB_body_tracking = XRCapabilities.check_FB_body_tracking(provider, caps, ext);
        this.XR_FB_color_space = XRCapabilities.check_FB_color_space(provider, caps, ext);
        this.XR_FB_composition_layer_alpha_blend = ext.contains("XR_FB_composition_layer_alpha_blend");
        this.XR_FB_composition_layer_depth_test = ext.contains("XR_FB_composition_layer_depth_test");
        this.XR_FB_composition_layer_image_layout = ext.contains("XR_FB_composition_layer_image_layout");
        this.XR_FB_composition_layer_secure_content = ext.contains("XR_FB_composition_layer_secure_content");
        this.XR_FB_composition_layer_settings = ext.contains("XR_FB_composition_layer_settings");
        this.XR_FB_display_refresh_rate = XRCapabilities.check_FB_display_refresh_rate(provider, caps, ext);
        this.XR_FB_eye_tracking_social = XRCapabilities.check_FB_eye_tracking_social(provider, caps, ext);
        this.XR_FB_face_tracking = XRCapabilities.check_FB_face_tracking(provider, caps, ext);
        this.XR_FB_foveation = XRCapabilities.check_FB_foveation(provider, caps, ext);
        this.XR_FB_foveation_configuration = ext.contains("XR_FB_foveation_configuration");
        this.XR_FB_foveation_vulkan = ext.contains("XR_FB_foveation_vulkan");
        this.XR_FB_hand_tracking_aim = ext.contains("XR_FB_hand_tracking_aim");
        this.XR_FB_hand_tracking_capsules = ext.contains("XR_FB_hand_tracking_capsules");
        this.XR_FB_hand_tracking_mesh = XRCapabilities.check_FB_hand_tracking_mesh(provider, caps, ext);
        this.XR_FB_haptic_amplitude_envelope = ext.contains("XR_FB_haptic_amplitude_envelope");
        this.XR_FB_haptic_pcm = XRCapabilities.check_FB_haptic_pcm(provider, caps, ext);
        this.XR_FB_keyboard_tracking = XRCapabilities.check_FB_keyboard_tracking(provider, caps, ext);
        this.XR_FB_passthrough = XRCapabilities.check_FB_passthrough(provider, caps, ext);
        this.XR_FB_passthrough_keyboard_hands = XRCapabilities.check_FB_passthrough_keyboard_hands(provider, caps, ext);
        this.XR_FB_render_model = XRCapabilities.check_FB_render_model(provider, caps, ext);
        this.XR_FB_scene = XRCapabilities.check_FB_scene(provider, caps, ext);
        this.XR_FB_scene_capture = XRCapabilities.check_FB_scene_capture(provider, caps, ext);
        this.XR_FB_space_warp = ext.contains("XR_FB_space_warp");
        this.XR_FB_spatial_entity = XRCapabilities.check_FB_spatial_entity(provider, caps, ext);
        this.XR_FB_spatial_entity_container = XRCapabilities.check_FB_spatial_entity_container(provider, caps, ext);
        this.XR_FB_spatial_entity_query = XRCapabilities.check_FB_spatial_entity_query(provider, caps, ext);
        this.XR_FB_spatial_entity_sharing = XRCapabilities.check_FB_spatial_entity_sharing(provider, caps, ext);
        this.XR_FB_spatial_entity_storage = XRCapabilities.check_FB_spatial_entity_storage(provider, caps, ext);
        this.XR_FB_spatial_entity_storage_batch = XRCapabilities.check_FB_spatial_entity_storage_batch(provider, caps, ext);
        this.XR_FB_spatial_entity_user = XRCapabilities.check_FB_spatial_entity_user(provider, caps, ext);
        this.XR_FB_swapchain_update_state = XRCapabilities.check_FB_swapchain_update_state(provider, caps, ext);
        this.XR_FB_swapchain_update_state_opengl_es = ext.contains("XR_FB_swapchain_update_state_opengl_es");
        this.XR_FB_swapchain_update_state_vulkan = ext.contains("XR_FB_swapchain_update_state_vulkan");
        this.XR_FB_touch_controller_pro = ext.contains("XR_FB_touch_controller_pro");
        this.XR_FB_touch_controller_proximity = ext.contains("XR_FB_touch_controller_proximity");
        this.XR_FB_triangle_mesh = XRCapabilities.check_FB_triangle_mesh(provider, caps, ext);
        this.XR_HTC_facial_tracking = XRCapabilities.check_HTC_facial_tracking(provider, caps, ext);
        this.XR_HTC_foveation = XRCapabilities.check_HTC_foveation(provider, caps, ext);
        this.XR_HTC_hand_interaction = ext.contains("XR_HTC_hand_interaction");
        this.XR_HTC_passthrough = XRCapabilities.check_HTC_passthrough(provider, caps, ext);
        this.XR_HTC_vive_cosmos_controller_interaction = ext.contains("XR_HTC_vive_cosmos_controller_interaction");
        this.XR_HTC_vive_focus3_controller_interaction = ext.contains("XR_HTC_vive_focus3_controller_interaction");
        this.XR_HTC_vive_wrist_tracker_interaction = ext.contains("XR_HTC_vive_wrist_tracker_interaction");
        this.XR_HTCX_vive_tracker_interaction = XRCapabilities.check_HTCX_vive_tracker_interaction(provider, caps, ext);
        this.XR_HUAWEI_controller_interaction = ext.contains("XR_HUAWEI_controller_interaction");
        this.XR_KHR_binding_modification = ext.contains("XR_KHR_binding_modification");
        this.XR_KHR_composition_layer_color_scale_bias = ext.contains("XR_KHR_composition_layer_color_scale_bias");
        this.XR_KHR_composition_layer_cube = ext.contains("XR_KHR_composition_layer_cube");
        this.XR_KHR_composition_layer_cylinder = ext.contains("XR_KHR_composition_layer_cylinder");
        this.XR_KHR_composition_layer_depth = ext.contains("XR_KHR_composition_layer_depth");
        this.XR_KHR_composition_layer_equirect = ext.contains("XR_KHR_composition_layer_equirect");
        this.XR_KHR_composition_layer_equirect2 = ext.contains("XR_KHR_composition_layer_equirect2");
        this.XR_KHR_convert_timespec_time = XRCapabilities.check_KHR_convert_timespec_time(provider, caps, ext);
        this.XR_KHR_loader_init = ext.contains("XR_KHR_loader_init");
        this.XR_KHR_opengl_enable = XRCapabilities.check_KHR_opengl_enable(provider, caps, ext);
        this.XR_KHR_swapchain_usage_input_attachment_bit = ext.contains("XR_KHR_swapchain_usage_input_attachment_bit");
        this.XR_KHR_visibility_mask = XRCapabilities.check_KHR_visibility_mask(provider, caps, ext);
        this.XR_KHR_vulkan_enable = XRCapabilities.check_KHR_vulkan_enable(provider, caps, ext);
        this.XR_KHR_vulkan_enable2 = XRCapabilities.check_KHR_vulkan_enable2(provider, caps, ext);
        this.XR_KHR_vulkan_swapchain_format_list = ext.contains("XR_KHR_vulkan_swapchain_format_list");
        this.XR_KHR_win32_convert_performance_counter_time = XRCapabilities.check_KHR_win32_convert_performance_counter_time(provider, caps, ext);
        this.XR_META_foveation_eye_tracked = XRCapabilities.check_META_foveation_eye_tracked(provider, caps, ext);
        this.XR_META_headset_id = ext.contains("XR_META_headset_id");
        this.XR_META_local_dimming = ext.contains("XR_META_local_dimming");
        this.XR_META_performance_metrics = XRCapabilities.check_META_performance_metrics(provider, caps, ext);
        this.XR_META_vulkan_swapchain_create_info = ext.contains("XR_META_vulkan_swapchain_create_info");
        this.XR_ML_compat = XRCapabilities.check_ML_compat(provider, caps, ext);
        this.XR_ML_frame_end_info = ext.contains("XR_ML_frame_end_info");
        this.XR_ML_global_dimmer = ext.contains("XR_ML_global_dimmer");
        this.XR_ML_ml2_controller_interaction = ext.contains("XR_ML_ml2_controller_interaction");
        this.XR_MND_headless = ext.contains("XR_MND_headless");
        this.XR_MND_swapchain_usage_input_attachment_bit = ext.contains("XR_MND_swapchain_usage_input_attachment_bit");
        this.XR_MNDX_egl_enable = ext.contains("XR_MNDX_egl_enable");
        this.XR_MNDX_force_feedback_curl = XRCapabilities.check_MNDX_force_feedback_curl(provider, caps, ext);
        this.XR_MSFT_composition_layer_reprojection = XRCapabilities.check_MSFT_composition_layer_reprojection(provider, caps, ext);
        this.XR_MSFT_controller_model = XRCapabilities.check_MSFT_controller_model(provider, caps, ext);
        this.XR_MSFT_first_person_observer = ext.contains("XR_MSFT_first_person_observer");
        this.XR_MSFT_hand_interaction = ext.contains("XR_MSFT_hand_interaction");
        this.XR_MSFT_hand_tracking_mesh = XRCapabilities.check_MSFT_hand_tracking_mesh(provider, caps, ext);
        this.XR_MSFT_holographic_window_attachment = ext.contains("XR_MSFT_holographic_window_attachment");
        this.XR_MSFT_perception_anchor_interop = XRCapabilities.check_MSFT_perception_anchor_interop(provider, caps, ext);
        this.XR_MSFT_scene_understanding = XRCapabilities.check_MSFT_scene_understanding(provider, caps, ext);
        this.XR_MSFT_scene_understanding_serialization = XRCapabilities.check_MSFT_scene_understanding_serialization(provider, caps, ext);
        this.XR_MSFT_secondary_view_configuration = ext.contains("XR_MSFT_secondary_view_configuration");
        this.XR_MSFT_spatial_anchor = XRCapabilities.check_MSFT_spatial_anchor(provider, caps, ext);
        this.XR_MSFT_spatial_anchor_persistence = XRCapabilities.check_MSFT_spatial_anchor_persistence(provider, caps, ext);
        this.XR_MSFT_spatial_graph_bridge = XRCapabilities.check_MSFT_spatial_graph_bridge(provider, caps, ext);
        this.XR_MSFT_unbounded_reference_space = ext.contains("XR_MSFT_unbounded_reference_space");
        this.XR_OCULUS_audio_device_guid = XRCapabilities.check_OCULUS_audio_device_guid(provider, caps, ext);
        this.XR_OCULUS_external_camera = XRCapabilities.check_OCULUS_external_camera(provider, caps, ext);
        this.XR_QCOM_tracking_optimization_settings = XRCapabilities.check_QCOM_tracking_optimization_settings(provider, caps, ext);
        this.XR_ULTRALEAP_hand_tracking_forearm = ext.contains("XR_ULTRALEAP_hand_tracking_forearm");
        this.XR_VALVE_analog_threshold = ext.contains("XR_VALVE_analog_threshold");
        this.XR_VARJO_composition_layer_depth_test = ext.contains("XR_VARJO_composition_layer_depth_test");
        this.XR_VARJO_environment_depth_estimation = XRCapabilities.check_VARJO_environment_depth_estimation(provider, caps, ext);
        this.XR_VARJO_foveated_rendering = ext.contains("XR_VARJO_foveated_rendering");
        this.XR_VARJO_marker_tracking = XRCapabilities.check_VARJO_marker_tracking(provider, caps, ext);
        this.XR_VARJO_quad_views = ext.contains("XR_VARJO_quad_views");
        this.XR_VARJO_view_offset = XRCapabilities.check_VARJO_view_offset(provider, caps, ext);
        this.xrDestroyInstance = caps[0];
        this.xrGetInstanceProperties = caps[1];
        this.xrPollEvent = caps[2];
        this.xrResultToString = caps[3];
        this.xrStructureTypeToString = caps[4];
        this.xrGetSystem = caps[5];
        this.xrGetSystemProperties = caps[6];
        this.xrEnumerateEnvironmentBlendModes = caps[7];
        this.xrCreateSession = caps[8];
        this.xrDestroySession = caps[9];
        this.xrEnumerateReferenceSpaces = caps[10];
        this.xrCreateReferenceSpace = caps[11];
        this.xrGetReferenceSpaceBoundsRect = caps[12];
        this.xrCreateActionSpace = caps[13];
        this.xrLocateSpace = caps[14];
        this.xrDestroySpace = caps[15];
        this.xrEnumerateViewConfigurations = caps[16];
        this.xrGetViewConfigurationProperties = caps[17];
        this.xrEnumerateViewConfigurationViews = caps[18];
        this.xrEnumerateSwapchainFormats = caps[19];
        this.xrCreateSwapchain = caps[20];
        this.xrDestroySwapchain = caps[21];
        this.xrEnumerateSwapchainImages = caps[22];
        this.xrAcquireSwapchainImage = caps[23];
        this.xrWaitSwapchainImage = caps[24];
        this.xrReleaseSwapchainImage = caps[25];
        this.xrBeginSession = caps[26];
        this.xrEndSession = caps[27];
        this.xrRequestExitSession = caps[28];
        this.xrWaitFrame = caps[29];
        this.xrBeginFrame = caps[30];
        this.xrEndFrame = caps[31];
        this.xrLocateViews = caps[32];
        this.xrStringToPath = caps[33];
        this.xrPathToString = caps[34];
        this.xrCreateActionSet = caps[35];
        this.xrDestroyActionSet = caps[36];
        this.xrCreateAction = caps[37];
        this.xrDestroyAction = caps[38];
        this.xrSuggestInteractionProfileBindings = caps[39];
        this.xrAttachSessionActionSets = caps[40];
        this.xrGetCurrentInteractionProfile = caps[41];
        this.xrGetActionStateBoolean = caps[42];
        this.xrGetActionStateFloat = caps[43];
        this.xrGetActionStateVector2f = caps[44];
        this.xrGetActionStatePose = caps[45];
        this.xrSyncActions = caps[46];
        this.xrEnumerateBoundSourcesForAction = caps[47];
        this.xrGetInputSourceLocalizedName = caps[48];
        this.xrApplyHapticFeedback = caps[49];
        this.xrStopHapticFeedback = caps[50];
        this.xrSetDigitalLensControlALMALENCE = caps[51];
        this.xrSetInputDeviceActiveEXT = caps[52];
        this.xrSetInputDeviceStateBoolEXT = caps[53];
        this.xrSetInputDeviceStateFloatEXT = caps[54];
        this.xrSetInputDeviceStateVector2fEXT = caps[55];
        this.xrSetInputDeviceLocationEXT = caps[56];
        this.xrSetDebugUtilsObjectNameEXT = caps[57];
        this.xrCreateDebugUtilsMessengerEXT = caps[58];
        this.xrDestroyDebugUtilsMessengerEXT = caps[59];
        this.xrSubmitDebugUtilsMessageEXT = caps[60];
        this.xrSessionBeginDebugUtilsLabelRegionEXT = caps[61];
        this.xrSessionEndDebugUtilsLabelRegionEXT = caps[62];
        this.xrSessionInsertDebugUtilsLabelEXT = caps[63];
        this.xrCreateHandTrackerEXT = caps[64];
        this.xrDestroyHandTrackerEXT = caps[65];
        this.xrLocateHandJointsEXT = caps[66];
        this.xrPerfSettingsSetPerformanceLevelEXT = caps[67];
        this.xrThermalGetTemperatureTrendEXT = caps[68];
        this.xrCreateBodyTrackerFB = caps[69];
        this.xrDestroyBodyTrackerFB = caps[70];
        this.xrLocateBodyJointsFB = caps[71];
        this.xrGetBodySkeletonFB = caps[72];
        this.xrEnumerateColorSpacesFB = caps[73];
        this.xrSetColorSpaceFB = caps[74];
        this.xrEnumerateDisplayRefreshRatesFB = caps[75];
        this.xrGetDisplayRefreshRateFB = caps[76];
        this.xrRequestDisplayRefreshRateFB = caps[77];
        this.xrCreateEyeTrackerFB = caps[78];
        this.xrDestroyEyeTrackerFB = caps[79];
        this.xrGetEyeGazesFB = caps[80];
        this.xrCreateFaceTrackerFB = caps[81];
        this.xrDestroyFaceTrackerFB = caps[82];
        this.xrGetFaceExpressionWeightsFB = caps[83];
        this.xrCreateFoveationProfileFB = caps[84];
        this.xrDestroyFoveationProfileFB = caps[85];
        this.xrGetHandMeshFB = caps[86];
        this.xrGetDeviceSampleRateFB = caps[87];
        this.xrQuerySystemTrackedKeyboardFB = caps[88];
        this.xrCreateKeyboardSpaceFB = caps[89];
        this.xrCreatePassthroughFB = caps[90];
        this.xrDestroyPassthroughFB = caps[91];
        this.xrPassthroughStartFB = caps[92];
        this.xrPassthroughPauseFB = caps[93];
        this.xrCreatePassthroughLayerFB = caps[94];
        this.xrDestroyPassthroughLayerFB = caps[95];
        this.xrPassthroughLayerPauseFB = caps[96];
        this.xrPassthroughLayerResumeFB = caps[97];
        this.xrPassthroughLayerSetStyleFB = caps[98];
        this.xrCreateGeometryInstanceFB = caps[99];
        this.xrDestroyGeometryInstanceFB = caps[100];
        this.xrGeometryInstanceSetTransformFB = caps[101];
        this.xrPassthroughLayerSetKeyboardHandsIntensityFB = caps[102];
        this.xrEnumerateRenderModelPathsFB = caps[103];
        this.xrGetRenderModelPropertiesFB = caps[104];
        this.xrLoadRenderModelFB = caps[105];
        this.xrGetSpaceBoundingBox2DFB = caps[106];
        this.xrGetSpaceBoundingBox3DFB = caps[107];
        this.xrGetSpaceSemanticLabelsFB = caps[108];
        this.xrGetSpaceBoundary2DFB = caps[109];
        this.xrGetSpaceRoomLayoutFB = caps[110];
        this.xrRequestSceneCaptureFB = caps[111];
        this.xrCreateSpatialAnchorFB = caps[112];
        this.xrGetSpaceUuidFB = caps[113];
        this.xrEnumerateSpaceSupportedComponentsFB = caps[114];
        this.xrSetSpaceComponentStatusFB = caps[115];
        this.xrGetSpaceComponentStatusFB = caps[116];
        this.xrGetSpaceContainerFB = caps[117];
        this.xrQuerySpacesFB = caps[118];
        this.xrRetrieveSpaceQueryResultsFB = caps[119];
        this.xrShareSpacesFB = caps[120];
        this.xrSaveSpaceFB = caps[121];
        this.xrEraseSpaceFB = caps[122];
        this.xrSaveSpaceListFB = caps[123];
        this.xrCreateSpaceUserFB = caps[124];
        this.xrGetSpaceUserIdFB = caps[125];
        this.xrDestroySpaceUserFB = caps[126];
        this.xrUpdateSwapchainFB = caps[127];
        this.xrGetSwapchainStateFB = caps[128];
        this.xrCreateTriangleMeshFB = caps[129];
        this.xrDestroyTriangleMeshFB = caps[130];
        this.xrTriangleMeshGetVertexBufferFB = caps[131];
        this.xrTriangleMeshGetIndexBufferFB = caps[132];
        this.xrTriangleMeshBeginUpdateFB = caps[133];
        this.xrTriangleMeshEndUpdateFB = caps[134];
        this.xrTriangleMeshBeginVertexBufferUpdateFB = caps[135];
        this.xrTriangleMeshEndVertexBufferUpdateFB = caps[136];
        this.xrCreateFacialTrackerHTC = caps[137];
        this.xrDestroyFacialTrackerHTC = caps[138];
        this.xrGetFacialExpressionsHTC = caps[139];
        this.xrApplyFoveationHTC = caps[140];
        this.xrCreatePassthroughHTC = caps[141];
        this.xrDestroyPassthroughHTC = caps[142];
        this.xrEnumerateViveTrackerPathsHTCX = caps[143];
        this.xrConvertTimespecTimeToTimeKHR = caps[144];
        this.xrConvertTimeToTimespecTimeKHR = caps[145];
        this.xrGetOpenGLGraphicsRequirementsKHR = caps[146];
        this.xrGetVisibilityMaskKHR = caps[147];
        this.xrGetVulkanInstanceExtensionsKHR = caps[148];
        this.xrGetVulkanDeviceExtensionsKHR = caps[149];
        this.xrGetVulkanGraphicsDeviceKHR = caps[150];
        this.xrGetVulkanGraphicsRequirementsKHR = caps[151];
        this.xrCreateVulkanInstanceKHR = caps[152];
        this.xrCreateVulkanDeviceKHR = caps[153];
        this.xrGetVulkanGraphicsDevice2KHR = caps[154];
        this.xrGetVulkanGraphicsRequirements2KHR = caps[155];
        this.xrConvertWin32PerformanceCounterToTimeKHR = caps[156];
        this.xrConvertTimeToWin32PerformanceCounterKHR = caps[157];
        this.xrGetFoveationEyeTrackedStateMETA = caps[158];
        this.xrEnumeratePerformanceMetricsCounterPathsMETA = caps[159];
        this.xrSetPerformanceMetricsStateMETA = caps[160];
        this.xrGetPerformanceMetricsStateMETA = caps[161];
        this.xrQueryPerformanceMetricsCounterMETA = caps[162];
        this.xrCreateSpaceFromCoordinateFrameUIDML = caps[163];
        this.xrApplyForceFeedbackCurlMNDX = caps[164];
        this.xrEnumerateReprojectionModesMSFT = caps[165];
        this.xrGetControllerModelKeyMSFT = caps[166];
        this.xrLoadControllerModelMSFT = caps[167];
        this.xrGetControllerModelPropertiesMSFT = caps[168];
        this.xrGetControllerModelStateMSFT = caps[169];
        this.xrCreateHandMeshSpaceMSFT = caps[170];
        this.xrUpdateHandMeshMSFT = caps[171];
        this.xrCreateSpatialAnchorFromPerceptionAnchorMSFT = caps[172];
        this.xrTryGetPerceptionAnchorFromSpatialAnchorMSFT = caps[173];
        this.xrEnumerateSceneComputeFeaturesMSFT = caps[174];
        this.xrCreateSceneObserverMSFT = caps[175];
        this.xrDestroySceneObserverMSFT = caps[176];
        this.xrCreateSceneMSFT = caps[177];
        this.xrDestroySceneMSFT = caps[178];
        this.xrComputeNewSceneMSFT = caps[179];
        this.xrGetSceneComputeStateMSFT = caps[180];
        this.xrGetSceneComponentsMSFT = caps[181];
        this.xrLocateSceneComponentsMSFT = caps[182];
        this.xrGetSceneMeshBuffersMSFT = caps[183];
        this.xrDeserializeSceneMSFT = caps[184];
        this.xrGetSerializedSceneFragmentDataMSFT = caps[185];
        this.xrCreateSpatialAnchorMSFT = caps[186];
        this.xrCreateSpatialAnchorSpaceMSFT = caps[187];
        this.xrDestroySpatialAnchorMSFT = caps[188];
        this.xrCreateSpatialAnchorStoreConnectionMSFT = caps[189];
        this.xrDestroySpatialAnchorStoreConnectionMSFT = caps[190];
        this.xrPersistSpatialAnchorMSFT = caps[191];
        this.xrEnumeratePersistedSpatialAnchorNamesMSFT = caps[192];
        this.xrCreateSpatialAnchorFromPersistedNameMSFT = caps[193];
        this.xrUnpersistSpatialAnchorMSFT = caps[194];
        this.xrClearSpatialAnchorStoreMSFT = caps[195];
        this.xrCreateSpatialGraphNodeSpaceMSFT = caps[196];
        this.xrTryCreateSpatialGraphStaticNodeBindingMSFT = caps[197];
        this.xrDestroySpatialGraphNodeBindingMSFT = caps[198];
        this.xrGetSpatialGraphNodeBindingPropertiesMSFT = caps[199];
        this.xrGetAudioOutputDeviceGuidOculus = caps[200];
        this.xrGetAudioInputDeviceGuidOculus = caps[201];
        this.xrEnumerateExternalCamerasOCULUS = caps[202];
        this.xrSetTrackingOptimizationSettingsHintQCOM = caps[203];
        this.xrSetEnvironmentDepthEstimationVARJO = caps[204];
        this.xrSetMarkerTrackingVARJO = caps[205];
        this.xrSetMarkerTrackingTimeoutVARJO = caps[206];
        this.xrSetMarkerTrackingPredictionVARJO = caps[207];
        this.xrGetMarkerSizeVARJO = caps[208];
        this.xrCreateMarkerSpaceVARJO = caps[209];
        this.xrSetViewOffsetVARJO = caps[210];
    }

    private static boolean check_XR10(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("OpenXR10")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50}, (String[])new String[]{"xrDestroyInstance", "xrGetInstanceProperties", "xrPollEvent", "xrResultToString", "xrStructureTypeToString", "xrGetSystem", "xrGetSystemProperties", "xrEnumerateEnvironmentBlendModes", "xrCreateSession", "xrDestroySession", "xrEnumerateReferenceSpaces", "xrCreateReferenceSpace", "xrGetReferenceSpaceBoundsRect", "xrCreateActionSpace", "xrLocateSpace", "xrDestroySpace", "xrEnumerateViewConfigurations", "xrGetViewConfigurationProperties", "xrEnumerateViewConfigurationViews", "xrEnumerateSwapchainFormats", "xrCreateSwapchain", "xrDestroySwapchain", "xrEnumerateSwapchainImages", "xrAcquireSwapchainImage", "xrWaitSwapchainImage", "xrReleaseSwapchainImage", "xrBeginSession", "xrEndSession", "xrRequestExitSession", "xrWaitFrame", "xrBeginFrame", "xrEndFrame", "xrLocateViews", "xrStringToPath", "xrPathToString", "xrCreateActionSet", "xrDestroyActionSet", "xrCreateAction", "xrDestroyAction", "xrSuggestInteractionProfileBindings", "xrAttachSessionActionSets", "xrGetCurrentInteractionProfile", "xrGetActionStateBoolean", "xrGetActionStateFloat", "xrGetActionStateVector2f", "xrGetActionStatePose", "xrSyncActions", "xrEnumerateBoundSourcesForAction", "xrGetInputSourceLocalizedName", "xrApplyHapticFeedback", "xrStopHapticFeedback"}) || Checks.reportMissing((String)"XR", (String)"OpenXR10");
    }

    private static boolean check_ALMALENCE_digital_lens_control(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_ALMALENCE_digital_lens_control")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{51}, (String[])new String[]{"xrSetDigitalLensControlALMALENCE"}) || Checks.reportMissing((String)"XR", (String)"XR_ALMALENCE_digital_lens_control");
    }

    private static boolean check_EXT_conformance_automation(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_EXT_conformance_automation")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{52, 53, 54, 55, 56}, (String[])new String[]{"xrSetInputDeviceActiveEXT", "xrSetInputDeviceStateBoolEXT", "xrSetInputDeviceStateFloatEXT", "xrSetInputDeviceStateVector2fEXT", "xrSetInputDeviceLocationEXT"}) || Checks.reportMissing((String)"XR", (String)"XR_EXT_conformance_automation");
    }

    private static boolean check_EXT_debug_utils(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_EXT_debug_utils")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{57, 58, 59, 60, 61, 62, 63}, (String[])new String[]{"xrSetDebugUtilsObjectNameEXT", "xrCreateDebugUtilsMessengerEXT", "xrDestroyDebugUtilsMessengerEXT", "xrSubmitDebugUtilsMessageEXT", "xrSessionBeginDebugUtilsLabelRegionEXT", "xrSessionEndDebugUtilsLabelRegionEXT", "xrSessionInsertDebugUtilsLabelEXT"}) || Checks.reportMissing((String)"XR", (String)"XR_EXT_debug_utils");
    }

    private static boolean check_EXT_hand_tracking(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_EXT_hand_tracking")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{64, 65, 66}, (String[])new String[]{"xrCreateHandTrackerEXT", "xrDestroyHandTrackerEXT", "xrLocateHandJointsEXT"}) || Checks.reportMissing((String)"XR", (String)"XR_EXT_hand_tracking");
    }

    private static boolean check_EXT_performance_settings(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_EXT_performance_settings")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{67}, (String[])new String[]{"xrPerfSettingsSetPerformanceLevelEXT"}) || Checks.reportMissing((String)"XR", (String)"XR_EXT_performance_settings");
    }

    private static boolean check_EXT_thermal_query(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_EXT_thermal_query")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{68}, (String[])new String[]{"xrThermalGetTemperatureTrendEXT"}) || Checks.reportMissing((String)"XR", (String)"XR_EXT_thermal_query");
    }

    private static boolean check_FB_body_tracking(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_body_tracking")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{69, 70, 71, 72}, (String[])new String[]{"xrCreateBodyTrackerFB", "xrDestroyBodyTrackerFB", "xrLocateBodyJointsFB", "xrGetBodySkeletonFB"}) || Checks.reportMissing((String)"XR", (String)"XR_FB_body_tracking");
    }

    private static boolean check_FB_color_space(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_color_space")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{73, 74}, (String[])new String[]{"xrEnumerateColorSpacesFB", "xrSetColorSpaceFB"}) || Checks.reportMissing((String)"XR", (String)"XR_FB_color_space");
    }

    private static boolean check_FB_display_refresh_rate(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_display_refresh_rate")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{75, 76, 77}, (String[])new String[]{"xrEnumerateDisplayRefreshRatesFB", "xrGetDisplayRefreshRateFB", "xrRequestDisplayRefreshRateFB"}) || Checks.reportMissing((String)"XR", (String)"XR_FB_display_refresh_rate");
    }

    private static boolean check_FB_eye_tracking_social(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_eye_tracking_social")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{78, 79, 80}, (String[])new String[]{"xrCreateEyeTrackerFB", "xrDestroyEyeTrackerFB", "xrGetEyeGazesFB"}) || Checks.reportMissing((String)"XR", (String)"XR_FB_eye_tracking_social");
    }

    private static boolean check_FB_face_tracking(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_face_tracking")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{81, 82, 83}, (String[])new String[]{"xrCreateFaceTrackerFB", "xrDestroyFaceTrackerFB", "xrGetFaceExpressionWeightsFB"}) || Checks.reportMissing((String)"XR", (String)"XR_FB_face_tracking");
    }

    private static boolean check_FB_foveation(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_foveation")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{84, 85}, (String[])new String[]{"xrCreateFoveationProfileFB", "xrDestroyFoveationProfileFB"}) || Checks.reportMissing((String)"XR", (String)"XR_FB_foveation");
    }

    private static boolean check_FB_hand_tracking_mesh(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_hand_tracking_mesh")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{86}, (String[])new String[]{"xrGetHandMeshFB"}) || Checks.reportMissing((String)"XR", (String)"XR_FB_hand_tracking_mesh");
    }

    private static boolean check_FB_haptic_pcm(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_haptic_pcm")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{87}, (String[])new String[]{"xrGetDeviceSampleRateFB"}) || Checks.reportMissing((String)"XR", (String)"XR_FB_haptic_pcm");
    }

    private static boolean check_FB_keyboard_tracking(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_keyboard_tracking")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{88, 89}, (String[])new String[]{"xrQuerySystemTrackedKeyboardFB", "xrCreateKeyboardSpaceFB"}) || Checks.reportMissing((String)"XR", (String)"XR_FB_keyboard_tracking");
    }

    private static boolean check_FB_passthrough(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_passthrough")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101}, (String[])new String[]{"xrCreatePassthroughFB", "xrDestroyPassthroughFB", "xrPassthroughStartFB", "xrPassthroughPauseFB", "xrCreatePassthroughLayerFB", "xrDestroyPassthroughLayerFB", "xrPassthroughLayerPauseFB", "xrPassthroughLayerResumeFB", "xrPassthroughLayerSetStyleFB", "xrCreateGeometryInstanceFB", "xrDestroyGeometryInstanceFB", "xrGeometryInstanceSetTransformFB"}) || Checks.reportMissing((String)"XR", (String)"XR_FB_passthrough");
    }

    private static boolean check_FB_passthrough_keyboard_hands(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_passthrough_keyboard_hands")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{102}, (String[])new String[]{"xrPassthroughLayerSetKeyboardHandsIntensityFB"}) || Checks.reportMissing((String)"XR", (String)"XR_FB_passthrough_keyboard_hands");
    }

    private static boolean check_FB_render_model(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_render_model")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{103, 104, 105}, (String[])new String[]{"xrEnumerateRenderModelPathsFB", "xrGetRenderModelPropertiesFB", "xrLoadRenderModelFB"}) || Checks.reportMissing((String)"XR", (String)"XR_FB_render_model");
    }

    private static boolean check_FB_scene(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_scene")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{106, 107, 108, 109, 110}, (String[])new String[]{"xrGetSpaceBoundingBox2DFB", "xrGetSpaceBoundingBox3DFB", "xrGetSpaceSemanticLabelsFB", "xrGetSpaceBoundary2DFB", "xrGetSpaceRoomLayoutFB"}) || Checks.reportMissing((String)"XR", (String)"XR_FB_scene");
    }

    private static boolean check_FB_scene_capture(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_scene_capture")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{111}, (String[])new String[]{"xrRequestSceneCaptureFB"}) || Checks.reportMissing((String)"XR", (String)"XR_FB_scene_capture");
    }

    private static boolean check_FB_spatial_entity(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_spatial_entity")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{112, 113, 114, 115, 116}, (String[])new String[]{"xrCreateSpatialAnchorFB", "xrGetSpaceUuidFB", "xrEnumerateSpaceSupportedComponentsFB", "xrSetSpaceComponentStatusFB", "xrGetSpaceComponentStatusFB"}) || Checks.reportMissing((String)"XR", (String)"XR_FB_spatial_entity");
    }

    private static boolean check_FB_spatial_entity_container(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_spatial_entity_container")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{117}, (String[])new String[]{"xrGetSpaceContainerFB"}) || Checks.reportMissing((String)"XR", (String)"XR_FB_spatial_entity_container");
    }

    private static boolean check_FB_spatial_entity_query(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_spatial_entity_query")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{118, 119}, (String[])new String[]{"xrQuerySpacesFB", "xrRetrieveSpaceQueryResultsFB"}) || Checks.reportMissing((String)"XR", (String)"XR_FB_spatial_entity_query");
    }

    private static boolean check_FB_spatial_entity_sharing(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_spatial_entity_sharing")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{120}, (String[])new String[]{"xrShareSpacesFB"}) || Checks.reportMissing((String)"XR", (String)"XR_FB_spatial_entity_sharing");
    }

    private static boolean check_FB_spatial_entity_storage(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_spatial_entity_storage")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{121, 122}, (String[])new String[]{"xrSaveSpaceFB", "xrEraseSpaceFB"}) || Checks.reportMissing((String)"XR", (String)"XR_FB_spatial_entity_storage");
    }

    private static boolean check_FB_spatial_entity_storage_batch(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_spatial_entity_storage_batch")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{123}, (String[])new String[]{"xrSaveSpaceListFB"}) || Checks.reportMissing((String)"XR", (String)"XR_FB_spatial_entity_storage_batch");
    }

    private static boolean check_FB_spatial_entity_user(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_spatial_entity_user")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{124, 125, 126}, (String[])new String[]{"xrCreateSpaceUserFB", "xrGetSpaceUserIdFB", "xrDestroySpaceUserFB"}) || Checks.reportMissing((String)"XR", (String)"XR_FB_spatial_entity_user");
    }

    private static boolean check_FB_swapchain_update_state(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_swapchain_update_state")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{127, 128}, (String[])new String[]{"xrUpdateSwapchainFB", "xrGetSwapchainStateFB"}) || Checks.reportMissing((String)"XR", (String)"XR_FB_swapchain_update_state");
    }

    private static boolean check_FB_triangle_mesh(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_triangle_mesh")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{129, 130, 131, 132, 133, 134, 135, 136}, (String[])new String[]{"xrCreateTriangleMeshFB", "xrDestroyTriangleMeshFB", "xrTriangleMeshGetVertexBufferFB", "xrTriangleMeshGetIndexBufferFB", "xrTriangleMeshBeginUpdateFB", "xrTriangleMeshEndUpdateFB", "xrTriangleMeshBeginVertexBufferUpdateFB", "xrTriangleMeshEndVertexBufferUpdateFB"}) || Checks.reportMissing((String)"XR", (String)"XR_FB_triangle_mesh");
    }

    private static boolean check_HTC_facial_tracking(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_HTC_facial_tracking")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{137, 138, 139}, (String[])new String[]{"xrCreateFacialTrackerHTC", "xrDestroyFacialTrackerHTC", "xrGetFacialExpressionsHTC"}) || Checks.reportMissing((String)"XR", (String)"XR_HTC_facial_tracking");
    }

    private static boolean check_HTC_foveation(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_HTC_foveation")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{140}, (String[])new String[]{"xrApplyFoveationHTC"}) || Checks.reportMissing((String)"XR", (String)"XR_HTC_foveation");
    }

    private static boolean check_HTC_passthrough(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_HTC_passthrough")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{141, 142}, (String[])new String[]{"xrCreatePassthroughHTC", "xrDestroyPassthroughHTC"}) || Checks.reportMissing((String)"XR", (String)"XR_HTC_passthrough");
    }

    private static boolean check_HTCX_vive_tracker_interaction(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_HTCX_vive_tracker_interaction")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{143}, (String[])new String[]{"xrEnumerateViveTrackerPathsHTCX"}) || Checks.reportMissing((String)"XR", (String)"XR_HTCX_vive_tracker_interaction");
    }

    private static boolean check_KHR_convert_timespec_time(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_KHR_convert_timespec_time")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{144, 145}, (String[])new String[]{"xrConvertTimespecTimeToTimeKHR", "xrConvertTimeToTimespecTimeKHR"}) || Checks.reportMissing((String)"XR", (String)"XR_KHR_convert_timespec_time");
    }

    private static boolean check_KHR_opengl_enable(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_KHR_opengl_enable")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{146}, (String[])new String[]{"xrGetOpenGLGraphicsRequirementsKHR"}) || Checks.reportMissing((String)"XR", (String)"XR_KHR_opengl_enable");
    }

    private static boolean check_KHR_visibility_mask(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_KHR_visibility_mask")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{147}, (String[])new String[]{"xrGetVisibilityMaskKHR"}) || Checks.reportMissing((String)"XR", (String)"XR_KHR_visibility_mask");
    }

    private static boolean check_KHR_vulkan_enable(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_KHR_vulkan_enable")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{148, 149, 150, 151}, (String[])new String[]{"xrGetVulkanInstanceExtensionsKHR", "xrGetVulkanDeviceExtensionsKHR", "xrGetVulkanGraphicsDeviceKHR", "xrGetVulkanGraphicsRequirementsKHR"}) || Checks.reportMissing((String)"XR", (String)"XR_KHR_vulkan_enable");
    }

    private static boolean check_KHR_vulkan_enable2(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_KHR_vulkan_enable2")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{152, 153, 154, 155}, (String[])new String[]{"xrCreateVulkanInstanceKHR", "xrCreateVulkanDeviceKHR", "xrGetVulkanGraphicsDevice2KHR", "xrGetVulkanGraphicsRequirements2KHR"}) || Checks.reportMissing((String)"XR", (String)"XR_KHR_vulkan_enable2");
    }

    private static boolean check_KHR_win32_convert_performance_counter_time(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_KHR_win32_convert_performance_counter_time")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{156, 157}, (String[])new String[]{"xrConvertWin32PerformanceCounterToTimeKHR", "xrConvertTimeToWin32PerformanceCounterKHR"}) || Checks.reportMissing((String)"XR", (String)"XR_KHR_win32_convert_performance_counter_time");
    }

    private static boolean check_META_foveation_eye_tracked(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_META_foveation_eye_tracked")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{158}, (String[])new String[]{"xrGetFoveationEyeTrackedStateMETA"}) || Checks.reportMissing((String)"XR", (String)"XR_META_foveation_eye_tracked");
    }

    private static boolean check_META_performance_metrics(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_META_performance_metrics")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{159, 160, 161, 162}, (String[])new String[]{"xrEnumeratePerformanceMetricsCounterPathsMETA", "xrSetPerformanceMetricsStateMETA", "xrGetPerformanceMetricsStateMETA", "xrQueryPerformanceMetricsCounterMETA"}) || Checks.reportMissing((String)"XR", (String)"XR_META_performance_metrics");
    }

    private static boolean check_ML_compat(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_ML_compat")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{163}, (String[])new String[]{"xrCreateSpaceFromCoordinateFrameUIDML"}) || Checks.reportMissing((String)"XR", (String)"XR_ML_compat");
    }

    private static boolean check_MNDX_force_feedback_curl(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_MNDX_force_feedback_curl")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{164}, (String[])new String[]{"xrApplyForceFeedbackCurlMNDX"}) || Checks.reportMissing((String)"XR", (String)"XR_MNDX_force_feedback_curl");
    }

    private static boolean check_MSFT_composition_layer_reprojection(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_MSFT_composition_layer_reprojection")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{165}, (String[])new String[]{"xrEnumerateReprojectionModesMSFT"}) || Checks.reportMissing((String)"XR", (String)"XR_MSFT_composition_layer_reprojection");
    }

    private static boolean check_MSFT_controller_model(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_MSFT_controller_model")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{166, 167, 168, 169}, (String[])new String[]{"xrGetControllerModelKeyMSFT", "xrLoadControllerModelMSFT", "xrGetControllerModelPropertiesMSFT", "xrGetControllerModelStateMSFT"}) || Checks.reportMissing((String)"XR", (String)"XR_MSFT_controller_model");
    }

    private static boolean check_MSFT_hand_tracking_mesh(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_MSFT_hand_tracking_mesh")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{170, 171}, (String[])new String[]{"xrCreateHandMeshSpaceMSFT", "xrUpdateHandMeshMSFT"}) || Checks.reportMissing((String)"XR", (String)"XR_MSFT_hand_tracking_mesh");
    }

    private static boolean check_MSFT_perception_anchor_interop(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_MSFT_perception_anchor_interop")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{172, 173}, (String[])new String[]{"xrCreateSpatialAnchorFromPerceptionAnchorMSFT", "xrTryGetPerceptionAnchorFromSpatialAnchorMSFT"}) || Checks.reportMissing((String)"XR", (String)"XR_MSFT_perception_anchor_interop");
    }

    private static boolean check_MSFT_scene_understanding(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_MSFT_scene_understanding")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{174, 175, 176, 177, 178, 179, 180, 181, 182, 183}, (String[])new String[]{"xrEnumerateSceneComputeFeaturesMSFT", "xrCreateSceneObserverMSFT", "xrDestroySceneObserverMSFT", "xrCreateSceneMSFT", "xrDestroySceneMSFT", "xrComputeNewSceneMSFT", "xrGetSceneComputeStateMSFT", "xrGetSceneComponentsMSFT", "xrLocateSceneComponentsMSFT", "xrGetSceneMeshBuffersMSFT"}) || Checks.reportMissing((String)"XR", (String)"XR_MSFT_scene_understanding");
    }

    private static boolean check_MSFT_scene_understanding_serialization(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_MSFT_scene_understanding_serialization")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{184, 185}, (String[])new String[]{"xrDeserializeSceneMSFT", "xrGetSerializedSceneFragmentDataMSFT"}) || Checks.reportMissing((String)"XR", (String)"XR_MSFT_scene_understanding_serialization");
    }

    private static boolean check_MSFT_spatial_anchor(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_MSFT_spatial_anchor")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{186, 187, 188}, (String[])new String[]{"xrCreateSpatialAnchorMSFT", "xrCreateSpatialAnchorSpaceMSFT", "xrDestroySpatialAnchorMSFT"}) || Checks.reportMissing((String)"XR", (String)"XR_MSFT_spatial_anchor");
    }

    private static boolean check_MSFT_spatial_anchor_persistence(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_MSFT_spatial_anchor_persistence")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{189, 190, 191, 192, 193, 194, 195}, (String[])new String[]{"xrCreateSpatialAnchorStoreConnectionMSFT", "xrDestroySpatialAnchorStoreConnectionMSFT", "xrPersistSpatialAnchorMSFT", "xrEnumeratePersistedSpatialAnchorNamesMSFT", "xrCreateSpatialAnchorFromPersistedNameMSFT", "xrUnpersistSpatialAnchorMSFT", "xrClearSpatialAnchorStoreMSFT"}) || Checks.reportMissing((String)"XR", (String)"XR_MSFT_spatial_anchor_persistence");
    }

    private static boolean check_MSFT_spatial_graph_bridge(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_MSFT_spatial_graph_bridge")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{196, 197, 198, 199}, (String[])new String[]{"xrCreateSpatialGraphNodeSpaceMSFT", "xrTryCreateSpatialGraphStaticNodeBindingMSFT", "xrDestroySpatialGraphNodeBindingMSFT", "xrGetSpatialGraphNodeBindingPropertiesMSFT"}) || Checks.reportMissing((String)"XR", (String)"XR_MSFT_spatial_graph_bridge");
    }

    private static boolean check_OCULUS_audio_device_guid(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_OCULUS_audio_device_guid")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{200, 201}, (String[])new String[]{"xrGetAudioOutputDeviceGuidOculus", "xrGetAudioInputDeviceGuidOculus"}) || Checks.reportMissing((String)"XR", (String)"XR_OCULUS_audio_device_guid");
    }

    private static boolean check_OCULUS_external_camera(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_OCULUS_external_camera")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{202}, (String[])new String[]{"xrEnumerateExternalCamerasOCULUS"}) || Checks.reportMissing((String)"XR", (String)"XR_OCULUS_external_camera");
    }

    private static boolean check_QCOM_tracking_optimization_settings(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_QCOM_tracking_optimization_settings")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{203}, (String[])new String[]{"xrSetTrackingOptimizationSettingsHintQCOM"}) || Checks.reportMissing((String)"XR", (String)"XR_QCOM_tracking_optimization_settings");
    }

    private static boolean check_VARJO_environment_depth_estimation(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_VARJO_environment_depth_estimation")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{204}, (String[])new String[]{"xrSetEnvironmentDepthEstimationVARJO"}) || Checks.reportMissing((String)"XR", (String)"XR_VARJO_environment_depth_estimation");
    }

    private static boolean check_VARJO_marker_tracking(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_VARJO_marker_tracking")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{205, 206, 207, 208, 209}, (String[])new String[]{"xrSetMarkerTrackingVARJO", "xrSetMarkerTrackingTimeoutVARJO", "xrSetMarkerTrackingPredictionVARJO", "xrGetMarkerSizeVARJO", "xrCreateMarkerSpaceVARJO"}) || Checks.reportMissing((String)"XR", (String)"XR_VARJO_marker_tracking");
    }

    private static boolean check_VARJO_view_offset(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_VARJO_view_offset")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (long[])caps, (int[])new int[]{210}, (String[])new String[]{"xrSetViewOffsetVARJO"}) || Checks.reportMissing((String)"XR", (String)"XR_VARJO_view_offset");
    }
}

