/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrActionSet;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrActiveActionSetPriorityEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ACTIONSET;
    public static final int PRIORITYOVERRIDE;

    public XrActiveActionSetPriorityEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrActiveActionSetPriorityEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrActionSet")
    public long actionSet() {
        return XrActiveActionSetPriorityEXT.nactionSet(this.address());
    }

    @NativeType(value="uint32_t")
    public int priorityOverride() {
        return XrActiveActionSetPriorityEXT.npriorityOverride(this.address());
    }

    public XrActiveActionSetPriorityEXT actionSet(XrActionSet value) {
        XrActiveActionSetPriorityEXT.nactionSet(this.address(), value);
        return this;
    }

    public XrActiveActionSetPriorityEXT priorityOverride(@NativeType(value="uint32_t") int value) {
        XrActiveActionSetPriorityEXT.npriorityOverride(this.address(), value);
        return this;
    }

    public XrActiveActionSetPriorityEXT set(XrActionSet actionSet, int priorityOverride) {
        this.actionSet(actionSet);
        this.priorityOverride(priorityOverride);
        return this;
    }

    public XrActiveActionSetPriorityEXT set(XrActiveActionSetPriorityEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrActiveActionSetPriorityEXT malloc() {
        return (XrActiveActionSetPriorityEXT)XrActiveActionSetPriorityEXT.wrap(XrActiveActionSetPriorityEXT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrActiveActionSetPriorityEXT calloc() {
        return (XrActiveActionSetPriorityEXT)XrActiveActionSetPriorityEXT.wrap(XrActiveActionSetPriorityEXT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrActiveActionSetPriorityEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrActiveActionSetPriorityEXT)XrActiveActionSetPriorityEXT.wrap(XrActiveActionSetPriorityEXT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrActiveActionSetPriorityEXT create(long address) {
        return (XrActiveActionSetPriorityEXT)XrActiveActionSetPriorityEXT.wrap(XrActiveActionSetPriorityEXT.class, (long)address);
    }

    @Nullable
    public static XrActiveActionSetPriorityEXT createSafe(long address) {
        return address == 0L ? null : (XrActiveActionSetPriorityEXT)XrActiveActionSetPriorityEXT.wrap(XrActiveActionSetPriorityEXT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrActiveActionSetPriorityEXT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrActiveActionSetPriorityEXT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrActiveActionSetPriorityEXT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrActiveActionSetPriorityEXT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrActiveActionSetPriorityEXT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrActiveActionSetPriorityEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrActiveActionSetPriorityEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrActiveActionSetPriorityEXT malloc(MemoryStack stack) {
        return (XrActiveActionSetPriorityEXT)XrActiveActionSetPriorityEXT.wrap(XrActiveActionSetPriorityEXT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrActiveActionSetPriorityEXT calloc(MemoryStack stack) {
        return (XrActiveActionSetPriorityEXT)XrActiveActionSetPriorityEXT.wrap(XrActiveActionSetPriorityEXT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrActiveActionSetPriorityEXT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrActiveActionSetPriorityEXT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nactionSet(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ACTIONSET));
    }

    public static int npriorityOverride(long struct) {
        return UNSAFE.getInt(null, struct + (long)PRIORITYOVERRIDE);
    }

    public static void nactionSet(long struct, XrActionSet value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ACTIONSET), (long)value.address());
    }

    public static void npriorityOverride(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PRIORITYOVERRIDE, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)ACTIONSET)));
    }

    static {
        Struct.Layout layout = XrActiveActionSetPriorityEXT.__struct((Struct.Member[])new Struct.Member[]{XrActiveActionSetPriorityEXT.__member((int)POINTER_SIZE), XrActiveActionSetPriorityEXT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ACTIONSET = layout.offsetof(0);
        PRIORITYOVERRIDE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrActiveActionSetPriorityEXT, Buffer>
    implements NativeResource {
        private static final XrActiveActionSetPriorityEXT ELEMENT_FACTORY = XrActiveActionSetPriorityEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrActiveActionSetPriorityEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrActionSet")
        public long actionSet() {
            return XrActiveActionSetPriorityEXT.nactionSet(this.address());
        }

        @NativeType(value="uint32_t")
        public int priorityOverride() {
            return XrActiveActionSetPriorityEXT.npriorityOverride(this.address());
        }

        public Buffer actionSet(XrActionSet value) {
            XrActiveActionSetPriorityEXT.nactionSet(this.address(), value);
            return this;
        }

        public Buffer priorityOverride(@NativeType(value="uint32_t") int value) {
            XrActiveActionSetPriorityEXT.npriorityOverride(this.address(), value);
            return this;
        }
    }
}

