/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBodyJointLocationFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LOCATIONFLAGS;
    public static final int POSE;

    public XrBodyJointLocationFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrBodyJointLocationFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrSpaceLocationFlags")
    public long locationFlags() {
        return XrBodyJointLocationFB.nlocationFlags(this.address());
    }

    public XrPosef pose() {
        return XrBodyJointLocationFB.npose(this.address());
    }

    public XrBodyJointLocationFB locationFlags(@NativeType(value="XrSpaceLocationFlags") long value) {
        XrBodyJointLocationFB.nlocationFlags(this.address(), value);
        return this;
    }

    public XrBodyJointLocationFB pose(XrPosef value) {
        XrBodyJointLocationFB.npose(this.address(), value);
        return this;
    }

    public XrBodyJointLocationFB pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrBodyJointLocationFB set(long locationFlags, XrPosef pose) {
        this.locationFlags(locationFlags);
        this.pose(pose);
        return this;
    }

    public XrBodyJointLocationFB set(XrBodyJointLocationFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrBodyJointLocationFB malloc() {
        return (XrBodyJointLocationFB)XrBodyJointLocationFB.wrap(XrBodyJointLocationFB.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrBodyJointLocationFB calloc() {
        return (XrBodyJointLocationFB)XrBodyJointLocationFB.wrap(XrBodyJointLocationFB.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrBodyJointLocationFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrBodyJointLocationFB)XrBodyJointLocationFB.wrap(XrBodyJointLocationFB.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrBodyJointLocationFB create(long address) {
        return (XrBodyJointLocationFB)XrBodyJointLocationFB.wrap(XrBodyJointLocationFB.class, (long)address);
    }

    @Nullable
    public static XrBodyJointLocationFB createSafe(long address) {
        return address == 0L ? null : (XrBodyJointLocationFB)XrBodyJointLocationFB.wrap(XrBodyJointLocationFB.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrBodyJointLocationFB.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrBodyJointLocationFB.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrBodyJointLocationFB.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBodyJointLocationFB.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrBodyJointLocationFB.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrBodyJointLocationFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrBodyJointLocationFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrBodyJointLocationFB malloc(MemoryStack stack) {
        return (XrBodyJointLocationFB)XrBodyJointLocationFB.wrap(XrBodyJointLocationFB.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrBodyJointLocationFB calloc(MemoryStack stack) {
        return (XrBodyJointLocationFB)XrBodyJointLocationFB.wrap(XrBodyJointLocationFB.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrBodyJointLocationFB.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrBodyJointLocationFB.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nlocationFlags(long struct) {
        return UNSAFE.getLong(null, struct + (long)LOCATIONFLAGS);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static void nlocationFlags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)LOCATIONFLAGS, value);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSE), (long)XrPosef.SIZEOF);
    }

    static {
        Struct.Layout layout = XrBodyJointLocationFB.__struct((Struct.Member[])new Struct.Member[]{XrBodyJointLocationFB.__member((int)8), XrBodyJointLocationFB.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LOCATIONFLAGS = layout.offsetof(0);
        POSE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrBodyJointLocationFB, Buffer>
    implements NativeResource {
        private static final XrBodyJointLocationFB ELEMENT_FACTORY = XrBodyJointLocationFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrBodyJointLocationFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrSpaceLocationFlags")
        public long locationFlags() {
            return XrBodyJointLocationFB.nlocationFlags(this.address());
        }

        public XrPosef pose() {
            return XrBodyJointLocationFB.npose(this.address());
        }

        public Buffer locationFlags(@NativeType(value="XrSpaceLocationFlags") long value) {
            XrBodyJointLocationFB.nlocationFlags(this.address(), value);
            return this;
        }

        public Buffer pose(XrPosef value) {
            XrBodyJointLocationFB.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }
    }
}

