/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrBodySkeletonJointFB;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBodySkeletonFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int JOINTCOUNT;
    public static final int JOINTS;

    public XrBodySkeletonFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrBodySkeletonFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrBodySkeletonFB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrBodySkeletonFB.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int jointCount() {
        return XrBodySkeletonFB.njointCount(this.address());
    }

    @NativeType(value="XrBodySkeletonJointFB *")
    public XrBodySkeletonJointFB.Buffer joints() {
        return XrBodySkeletonFB.njoints(this.address());
    }

    public XrBodySkeletonFB type(@NativeType(value="XrStructureType") int value) {
        XrBodySkeletonFB.ntype(this.address(), value);
        return this;
    }

    public XrBodySkeletonFB type$Default() {
        return this.type(1000076006);
    }

    public XrBodySkeletonFB next(@NativeType(value="void *") long value) {
        XrBodySkeletonFB.nnext(this.address(), value);
        return this;
    }

    public XrBodySkeletonFB joints(@NativeType(value="XrBodySkeletonJointFB *") XrBodySkeletonJointFB.Buffer value) {
        XrBodySkeletonFB.njoints(this.address(), value);
        return this;
    }

    public XrBodySkeletonFB set(int type, long next, XrBodySkeletonJointFB.Buffer joints) {
        this.type(type);
        this.next(next);
        this.joints(joints);
        return this;
    }

    public XrBodySkeletonFB set(XrBodySkeletonFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrBodySkeletonFB malloc() {
        return (XrBodySkeletonFB)XrBodySkeletonFB.wrap(XrBodySkeletonFB.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrBodySkeletonFB calloc() {
        return (XrBodySkeletonFB)XrBodySkeletonFB.wrap(XrBodySkeletonFB.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrBodySkeletonFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrBodySkeletonFB)XrBodySkeletonFB.wrap(XrBodySkeletonFB.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrBodySkeletonFB create(long address) {
        return (XrBodySkeletonFB)XrBodySkeletonFB.wrap(XrBodySkeletonFB.class, (long)address);
    }

    @Nullable
    public static XrBodySkeletonFB createSafe(long address) {
        return address == 0L ? null : (XrBodySkeletonFB)XrBodySkeletonFB.wrap(XrBodySkeletonFB.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrBodySkeletonFB.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrBodySkeletonFB.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrBodySkeletonFB.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBodySkeletonFB.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrBodySkeletonFB.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrBodySkeletonFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrBodySkeletonFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrBodySkeletonFB malloc(MemoryStack stack) {
        return (XrBodySkeletonFB)XrBodySkeletonFB.wrap(XrBodySkeletonFB.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrBodySkeletonFB calloc(MemoryStack stack) {
        return (XrBodySkeletonFB)XrBodySkeletonFB.wrap(XrBodySkeletonFB.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrBodySkeletonFB.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrBodySkeletonFB.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int njointCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)JOINTCOUNT);
    }

    public static XrBodySkeletonJointFB.Buffer njoints(long struct) {
        return XrBodySkeletonJointFB.create(MemoryUtil.memGetAddress((long)(struct + (long)JOINTS)), XrBodySkeletonFB.njointCount(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void njointCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)JOINTCOUNT, value);
    }

    public static void njoints(long struct, XrBodySkeletonJointFB.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)JOINTS), (long)value.address());
        XrBodySkeletonFB.njointCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)JOINTS)));
    }

    static {
        Struct.Layout layout = XrBodySkeletonFB.__struct((Struct.Member[])new Struct.Member[]{XrBodySkeletonFB.__member((int)4), XrBodySkeletonFB.__member((int)POINTER_SIZE), XrBodySkeletonFB.__member((int)4), XrBodySkeletonFB.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        JOINTCOUNT = layout.offsetof(2);
        JOINTS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrBodySkeletonFB, Buffer>
    implements NativeResource {
        private static final XrBodySkeletonFB ELEMENT_FACTORY = XrBodySkeletonFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrBodySkeletonFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrBodySkeletonFB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrBodySkeletonFB.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int jointCount() {
            return XrBodySkeletonFB.njointCount(this.address());
        }

        @NativeType(value="XrBodySkeletonJointFB *")
        public XrBodySkeletonJointFB.Buffer joints() {
            return XrBodySkeletonFB.njoints(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrBodySkeletonFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000076006);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrBodySkeletonFB.nnext(this.address(), value);
            return this;
        }

        public Buffer joints(@NativeType(value="XrBodySkeletonJointFB *") XrBodySkeletonJointFB.Buffer value) {
            XrBodySkeletonFB.njoints(this.address(), value);
            return this;
        }
    }
}

