/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBodyTrackerCreateInfoFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int BODYJOINTSET;

    public XrBodyTrackerCreateInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrBodyTrackerCreateInfoFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrBodyTrackerCreateInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrBodyTrackerCreateInfoFB.nnext(this.address());
    }

    @NativeType(value="XrBodyJointSetFB")
    public int bodyJointSet() {
        return XrBodyTrackerCreateInfoFB.nbodyJointSet(this.address());
    }

    public XrBodyTrackerCreateInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrBodyTrackerCreateInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrBodyTrackerCreateInfoFB type$Default() {
        return this.type(1000076001);
    }

    public XrBodyTrackerCreateInfoFB next(@NativeType(value="void const *") long value) {
        XrBodyTrackerCreateInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrBodyTrackerCreateInfoFB bodyJointSet(@NativeType(value="XrBodyJointSetFB") int value) {
        XrBodyTrackerCreateInfoFB.nbodyJointSet(this.address(), value);
        return this;
    }

    public XrBodyTrackerCreateInfoFB set(int type, long next, int bodyJointSet) {
        this.type(type);
        this.next(next);
        this.bodyJointSet(bodyJointSet);
        return this;
    }

    public XrBodyTrackerCreateInfoFB set(XrBodyTrackerCreateInfoFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrBodyTrackerCreateInfoFB malloc() {
        return (XrBodyTrackerCreateInfoFB)XrBodyTrackerCreateInfoFB.wrap(XrBodyTrackerCreateInfoFB.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrBodyTrackerCreateInfoFB calloc() {
        return (XrBodyTrackerCreateInfoFB)XrBodyTrackerCreateInfoFB.wrap(XrBodyTrackerCreateInfoFB.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrBodyTrackerCreateInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrBodyTrackerCreateInfoFB)XrBodyTrackerCreateInfoFB.wrap(XrBodyTrackerCreateInfoFB.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrBodyTrackerCreateInfoFB create(long address) {
        return (XrBodyTrackerCreateInfoFB)XrBodyTrackerCreateInfoFB.wrap(XrBodyTrackerCreateInfoFB.class, (long)address);
    }

    @Nullable
    public static XrBodyTrackerCreateInfoFB createSafe(long address) {
        return address == 0L ? null : (XrBodyTrackerCreateInfoFB)XrBodyTrackerCreateInfoFB.wrap(XrBodyTrackerCreateInfoFB.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrBodyTrackerCreateInfoFB.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrBodyTrackerCreateInfoFB.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrBodyTrackerCreateInfoFB.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBodyTrackerCreateInfoFB.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrBodyTrackerCreateInfoFB.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrBodyTrackerCreateInfoFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrBodyTrackerCreateInfoFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrBodyTrackerCreateInfoFB malloc(MemoryStack stack) {
        return (XrBodyTrackerCreateInfoFB)XrBodyTrackerCreateInfoFB.wrap(XrBodyTrackerCreateInfoFB.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrBodyTrackerCreateInfoFB calloc(MemoryStack stack) {
        return (XrBodyTrackerCreateInfoFB)XrBodyTrackerCreateInfoFB.wrap(XrBodyTrackerCreateInfoFB.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrBodyTrackerCreateInfoFB.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrBodyTrackerCreateInfoFB.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nbodyJointSet(long struct) {
        return UNSAFE.getInt(null, struct + (long)BODYJOINTSET);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nbodyJointSet(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BODYJOINTSET, value);
    }

    static {
        Struct.Layout layout = XrBodyTrackerCreateInfoFB.__struct((Struct.Member[])new Struct.Member[]{XrBodyTrackerCreateInfoFB.__member((int)4), XrBodyTrackerCreateInfoFB.__member((int)POINTER_SIZE), XrBodyTrackerCreateInfoFB.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        BODYJOINTSET = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrBodyTrackerCreateInfoFB, Buffer>
    implements NativeResource {
        private static final XrBodyTrackerCreateInfoFB ELEMENT_FACTORY = XrBodyTrackerCreateInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrBodyTrackerCreateInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrBodyTrackerCreateInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrBodyTrackerCreateInfoFB.nnext(this.address());
        }

        @NativeType(value="XrBodyJointSetFB")
        public int bodyJointSet() {
            return XrBodyTrackerCreateInfoFB.nbodyJointSet(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrBodyTrackerCreateInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000076001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrBodyTrackerCreateInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer bodyJointSet(@NativeType(value="XrBodyJointSetFB") int value) {
            XrBodyTrackerCreateInfoFB.nbodyJointSet(this.address(), value);
            return this;
        }
    }
}

