/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrVector2f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBoundary2DFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int VERTEXCAPACITYINPUT;
    public static final int VERTEXCOUNTOUTPUT;
    public static final int VERTICES;

    public XrBoundary2DFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrBoundary2DFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrBoundary2DFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrBoundary2DFB.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int vertexCapacityInput() {
        return XrBoundary2DFB.nvertexCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int vertexCountOutput() {
        return XrBoundary2DFB.nvertexCountOutput(this.address());
    }

    @Nullable
    @NativeType(value="XrVector2f *")
    public XrVector2f.Buffer vertices() {
        return XrBoundary2DFB.nvertices(this.address());
    }

    public XrBoundary2DFB type(@NativeType(value="XrStructureType") int value) {
        XrBoundary2DFB.ntype(this.address(), value);
        return this;
    }

    public XrBoundary2DFB type$Default() {
        return this.type(1000175002);
    }

    public XrBoundary2DFB next(@NativeType(value="void const *") long value) {
        XrBoundary2DFB.nnext(this.address(), value);
        return this;
    }

    public XrBoundary2DFB vertexCapacityInput(@NativeType(value="uint32_t") int value) {
        XrBoundary2DFB.nvertexCapacityInput(this.address(), value);
        return this;
    }

    public XrBoundary2DFB vertexCountOutput(@NativeType(value="uint32_t") int value) {
        XrBoundary2DFB.nvertexCountOutput(this.address(), value);
        return this;
    }

    public XrBoundary2DFB vertices(@Nullable @NativeType(value="XrVector2f *") XrVector2f.Buffer value) {
        XrBoundary2DFB.nvertices(this.address(), value);
        return this;
    }

    public XrBoundary2DFB set(int type, long next, int vertexCapacityInput, int vertexCountOutput, @Nullable XrVector2f.Buffer vertices) {
        this.type(type);
        this.next(next);
        this.vertexCapacityInput(vertexCapacityInput);
        this.vertexCountOutput(vertexCountOutput);
        this.vertices(vertices);
        return this;
    }

    public XrBoundary2DFB set(XrBoundary2DFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrBoundary2DFB malloc() {
        return (XrBoundary2DFB)XrBoundary2DFB.wrap(XrBoundary2DFB.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrBoundary2DFB calloc() {
        return (XrBoundary2DFB)XrBoundary2DFB.wrap(XrBoundary2DFB.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrBoundary2DFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrBoundary2DFB)XrBoundary2DFB.wrap(XrBoundary2DFB.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrBoundary2DFB create(long address) {
        return (XrBoundary2DFB)XrBoundary2DFB.wrap(XrBoundary2DFB.class, (long)address);
    }

    @Nullable
    public static XrBoundary2DFB createSafe(long address) {
        return address == 0L ? null : (XrBoundary2DFB)XrBoundary2DFB.wrap(XrBoundary2DFB.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrBoundary2DFB.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrBoundary2DFB.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrBoundary2DFB.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBoundary2DFB.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrBoundary2DFB.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrBoundary2DFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrBoundary2DFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrBoundary2DFB malloc(MemoryStack stack) {
        return (XrBoundary2DFB)XrBoundary2DFB.wrap(XrBoundary2DFB.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrBoundary2DFB calloc(MemoryStack stack) {
        return (XrBoundary2DFB)XrBoundary2DFB.wrap(XrBoundary2DFB.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrBoundary2DFB.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrBoundary2DFB.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nvertexCapacityInput(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERTEXCAPACITYINPUT);
    }

    public static int nvertexCountOutput(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERTEXCOUNTOUTPUT);
    }

    @Nullable
    public static XrVector2f.Buffer nvertices(long struct) {
        return XrVector2f.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)VERTICES)), XrBoundary2DFB.nvertexCapacityInput(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nvertexCapacityInput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VERTEXCAPACITYINPUT, value);
    }

    public static void nvertexCountOutput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VERTEXCOUNTOUTPUT, value);
    }

    public static void nvertices(long struct, @Nullable XrVector2f.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)VERTICES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            XrBoundary2DFB.nvertexCapacityInput(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrBoundary2DFB.__struct((Struct.Member[])new Struct.Member[]{XrBoundary2DFB.__member((int)4), XrBoundary2DFB.__member((int)POINTER_SIZE), XrBoundary2DFB.__member((int)4), XrBoundary2DFB.__member((int)4), XrBoundary2DFB.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        VERTEXCAPACITYINPUT = layout.offsetof(2);
        VERTEXCOUNTOUTPUT = layout.offsetof(3);
        VERTICES = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrBoundary2DFB, Buffer>
    implements NativeResource {
        private static final XrBoundary2DFB ELEMENT_FACTORY = XrBoundary2DFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrBoundary2DFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrBoundary2DFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrBoundary2DFB.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int vertexCapacityInput() {
            return XrBoundary2DFB.nvertexCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int vertexCountOutput() {
            return XrBoundary2DFB.nvertexCountOutput(this.address());
        }

        @Nullable
        @NativeType(value="XrVector2f *")
        public XrVector2f.Buffer vertices() {
            return XrBoundary2DFB.nvertices(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrBoundary2DFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000175002);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrBoundary2DFB.nnext(this.address(), value);
            return this;
        }

        public Buffer vertexCapacityInput(@NativeType(value="uint32_t") int value) {
            XrBoundary2DFB.nvertexCapacityInput(this.address(), value);
            return this;
        }

        public Buffer vertexCountOutput(@NativeType(value="uint32_t") int value) {
            XrBoundary2DFB.nvertexCountOutput(this.address(), value);
            return this;
        }

        public Buffer vertices(@Nullable @NativeType(value="XrVector2f *") XrVector2f.Buffer value) {
            XrBoundary2DFB.nvertices(this.address(), value);
            return this;
        }
    }
}

