/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.MLCoordinateFrameUID;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrCoordinateSpaceCreateInfoML
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int CFUID;
    public static final int POSEINCOORDINATESPACE;

    public XrCoordinateSpaceCreateInfoML(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrCoordinateSpaceCreateInfoML.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrCoordinateSpaceCreateInfoML.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrCoordinateSpaceCreateInfoML.nnext(this.address());
    }

    public MLCoordinateFrameUID cfuid() {
        return XrCoordinateSpaceCreateInfoML.ncfuid(this.address());
    }

    public XrPosef poseInCoordinateSpace() {
        return XrCoordinateSpaceCreateInfoML.nposeInCoordinateSpace(this.address());
    }

    public XrCoordinateSpaceCreateInfoML type(@NativeType(value="XrStructureType") int value) {
        XrCoordinateSpaceCreateInfoML.ntype(this.address(), value);
        return this;
    }

    public XrCoordinateSpaceCreateInfoML type$Default() {
        return this.type(1000137000);
    }

    public XrCoordinateSpaceCreateInfoML next(@NativeType(value="void const *") long value) {
        XrCoordinateSpaceCreateInfoML.nnext(this.address(), value);
        return this;
    }

    public XrCoordinateSpaceCreateInfoML cfuid(MLCoordinateFrameUID value) {
        XrCoordinateSpaceCreateInfoML.ncfuid(this.address(), value);
        return this;
    }

    public XrCoordinateSpaceCreateInfoML poseInCoordinateSpace(XrPosef value) {
        XrCoordinateSpaceCreateInfoML.nposeInCoordinateSpace(this.address(), value);
        return this;
    }

    public XrCoordinateSpaceCreateInfoML poseInCoordinateSpace(Consumer<XrPosef> consumer) {
        consumer.accept(this.poseInCoordinateSpace());
        return this;
    }

    public XrCoordinateSpaceCreateInfoML set(int type, long next, MLCoordinateFrameUID cfuid, XrPosef poseInCoordinateSpace) {
        this.type(type);
        this.next(next);
        this.cfuid(cfuid);
        this.poseInCoordinateSpace(poseInCoordinateSpace);
        return this;
    }

    public XrCoordinateSpaceCreateInfoML set(XrCoordinateSpaceCreateInfoML src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrCoordinateSpaceCreateInfoML malloc() {
        return (XrCoordinateSpaceCreateInfoML)XrCoordinateSpaceCreateInfoML.wrap(XrCoordinateSpaceCreateInfoML.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrCoordinateSpaceCreateInfoML calloc() {
        return (XrCoordinateSpaceCreateInfoML)XrCoordinateSpaceCreateInfoML.wrap(XrCoordinateSpaceCreateInfoML.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrCoordinateSpaceCreateInfoML create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrCoordinateSpaceCreateInfoML)XrCoordinateSpaceCreateInfoML.wrap(XrCoordinateSpaceCreateInfoML.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrCoordinateSpaceCreateInfoML create(long address) {
        return (XrCoordinateSpaceCreateInfoML)XrCoordinateSpaceCreateInfoML.wrap(XrCoordinateSpaceCreateInfoML.class, (long)address);
    }

    @Nullable
    public static XrCoordinateSpaceCreateInfoML createSafe(long address) {
        return address == 0L ? null : (XrCoordinateSpaceCreateInfoML)XrCoordinateSpaceCreateInfoML.wrap(XrCoordinateSpaceCreateInfoML.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrCoordinateSpaceCreateInfoML.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrCoordinateSpaceCreateInfoML.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrCoordinateSpaceCreateInfoML.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrCoordinateSpaceCreateInfoML.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrCoordinateSpaceCreateInfoML.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrCoordinateSpaceCreateInfoML.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrCoordinateSpaceCreateInfoML.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrCoordinateSpaceCreateInfoML malloc(MemoryStack stack) {
        return (XrCoordinateSpaceCreateInfoML)XrCoordinateSpaceCreateInfoML.wrap(XrCoordinateSpaceCreateInfoML.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrCoordinateSpaceCreateInfoML calloc(MemoryStack stack) {
        return (XrCoordinateSpaceCreateInfoML)XrCoordinateSpaceCreateInfoML.wrap(XrCoordinateSpaceCreateInfoML.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrCoordinateSpaceCreateInfoML.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrCoordinateSpaceCreateInfoML.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static MLCoordinateFrameUID ncfuid(long struct) {
        return MLCoordinateFrameUID.create(struct + (long)CFUID);
    }

    public static XrPosef nposeInCoordinateSpace(long struct) {
        return XrPosef.create(struct + (long)POSEINCOORDINATESPACE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void ncfuid(long struct, MLCoordinateFrameUID value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CFUID), (long)MLCoordinateFrameUID.SIZEOF);
    }

    public static void nposeInCoordinateSpace(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSEINCOORDINATESPACE), (long)XrPosef.SIZEOF);
    }

    static {
        Struct.Layout layout = XrCoordinateSpaceCreateInfoML.__struct((Struct.Member[])new Struct.Member[]{XrCoordinateSpaceCreateInfoML.__member((int)4), XrCoordinateSpaceCreateInfoML.__member((int)POINTER_SIZE), XrCoordinateSpaceCreateInfoML.__member((int)MLCoordinateFrameUID.SIZEOF, (int)MLCoordinateFrameUID.ALIGNOF), XrCoordinateSpaceCreateInfoML.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        CFUID = layout.offsetof(2);
        POSEINCOORDINATESPACE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrCoordinateSpaceCreateInfoML, Buffer>
    implements NativeResource {
        private static final XrCoordinateSpaceCreateInfoML ELEMENT_FACTORY = XrCoordinateSpaceCreateInfoML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrCoordinateSpaceCreateInfoML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrCoordinateSpaceCreateInfoML.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrCoordinateSpaceCreateInfoML.nnext(this.address());
        }

        public MLCoordinateFrameUID cfuid() {
            return XrCoordinateSpaceCreateInfoML.ncfuid(this.address());
        }

        public XrPosef poseInCoordinateSpace() {
            return XrCoordinateSpaceCreateInfoML.nposeInCoordinateSpace(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrCoordinateSpaceCreateInfoML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000137000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrCoordinateSpaceCreateInfoML.nnext(this.address(), value);
            return this;
        }

        public Buffer cfuid(MLCoordinateFrameUID value) {
            XrCoordinateSpaceCreateInfoML.ncfuid(this.address(), value);
            return this;
        }

        public Buffer poseInCoordinateSpace(XrPosef value) {
            XrCoordinateSpaceCreateInfoML.nposeInCoordinateSpace(this.address(), value);
            return this;
        }

        public Buffer poseInCoordinateSpace(Consumer<XrPosef> consumer) {
            consumer.accept(this.poseInCoordinateSpace());
            return this;
        }
    }
}

