/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrExtent3DfFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int DEPTH;

    public XrExtent3DfFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrExtent3DfFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float width() {
        return XrExtent3DfFB.nwidth(this.address());
    }

    public float height() {
        return XrExtent3DfFB.nheight(this.address());
    }

    public float depth() {
        return XrExtent3DfFB.ndepth(this.address());
    }

    public XrExtent3DfFB width(float value) {
        XrExtent3DfFB.nwidth(this.address(), value);
        return this;
    }

    public XrExtent3DfFB height(float value) {
        XrExtent3DfFB.nheight(this.address(), value);
        return this;
    }

    public XrExtent3DfFB depth(float value) {
        XrExtent3DfFB.ndepth(this.address(), value);
        return this;
    }

    public XrExtent3DfFB set(float width, float height, float depth) {
        this.width(width);
        this.height(height);
        this.depth(depth);
        return this;
    }

    public XrExtent3DfFB set(XrExtent3DfFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrExtent3DfFB malloc() {
        return (XrExtent3DfFB)XrExtent3DfFB.wrap(XrExtent3DfFB.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrExtent3DfFB calloc() {
        return (XrExtent3DfFB)XrExtent3DfFB.wrap(XrExtent3DfFB.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrExtent3DfFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrExtent3DfFB)XrExtent3DfFB.wrap(XrExtent3DfFB.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrExtent3DfFB create(long address) {
        return (XrExtent3DfFB)XrExtent3DfFB.wrap(XrExtent3DfFB.class, (long)address);
    }

    @Nullable
    public static XrExtent3DfFB createSafe(long address) {
        return address == 0L ? null : (XrExtent3DfFB)XrExtent3DfFB.wrap(XrExtent3DfFB.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrExtent3DfFB.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrExtent3DfFB.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrExtent3DfFB.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrExtent3DfFB.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrExtent3DfFB.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrExtent3DfFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrExtent3DfFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrExtent3DfFB malloc(MemoryStack stack) {
        return (XrExtent3DfFB)XrExtent3DfFB.wrap(XrExtent3DfFB.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrExtent3DfFB calloc(MemoryStack stack) {
        return (XrExtent3DfFB)XrExtent3DfFB.wrap(XrExtent3DfFB.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrExtent3DfFB.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrExtent3DfFB.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static float nwidth(long struct) {
        return UNSAFE.getFloat(null, struct + (long)WIDTH);
    }

    public static float nheight(long struct) {
        return UNSAFE.getFloat(null, struct + (long)HEIGHT);
    }

    public static float ndepth(long struct) {
        return UNSAFE.getFloat(null, struct + (long)DEPTH);
    }

    public static void nwidth(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)HEIGHT, value);
    }

    public static void ndepth(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)DEPTH, value);
    }

    static {
        Struct.Layout layout = XrExtent3DfFB.__struct((Struct.Member[])new Struct.Member[]{XrExtent3DfFB.__member((int)4), XrExtent3DfFB.__member((int)4), XrExtent3DfFB.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
        DEPTH = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrExtent3DfFB, Buffer>
    implements NativeResource {
        private static final XrExtent3DfFB ELEMENT_FACTORY = XrExtent3DfFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrExtent3DfFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float width() {
            return XrExtent3DfFB.nwidth(this.address());
        }

        public float height() {
            return XrExtent3DfFB.nheight(this.address());
        }

        public float depth() {
            return XrExtent3DfFB.ndepth(this.address());
        }

        public Buffer width(float value) {
            XrExtent3DfFB.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(float value) {
            XrExtent3DfFB.nheight(this.address(), value);
            return this;
        }

        public Buffer depth(float value) {
            XrExtent3DfFB.ndepth(this.address(), value);
            return this;
        }
    }
}

