/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrExternalCameraExtrinsicsOCULUS;
import org.lwjgl.openxr.XrExternalCameraIntrinsicsOCULUS;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrExternalCameraOCULUS
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int NAME;
    public static final int INTRINSICS;
    public static final int EXTRINSICS;

    public XrExternalCameraOCULUS(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrExternalCameraOCULUS.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrExternalCameraOCULUS.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrExternalCameraOCULUS.nnext(this.address());
    }

    @NativeType(value="char[XR_MAX_EXTERNAL_CAMERA_NAME_SIZE_OCULUS]")
    public ByteBuffer name() {
        return XrExternalCameraOCULUS.nname(this.address());
    }

    @NativeType(value="char[XR_MAX_EXTERNAL_CAMERA_NAME_SIZE_OCULUS]")
    public String nameString() {
        return XrExternalCameraOCULUS.nnameString(this.address());
    }

    public XrExternalCameraIntrinsicsOCULUS intrinsics() {
        return XrExternalCameraOCULUS.nintrinsics(this.address());
    }

    public XrExternalCameraExtrinsicsOCULUS extrinsics() {
        return XrExternalCameraOCULUS.nextrinsics(this.address());
    }

    public XrExternalCameraOCULUS type(@NativeType(value="XrStructureType") int value) {
        XrExternalCameraOCULUS.ntype(this.address(), value);
        return this;
    }

    public XrExternalCameraOCULUS type$Default() {
        return this.type(1000226000);
    }

    public XrExternalCameraOCULUS next(@NativeType(value="void const *") long value) {
        XrExternalCameraOCULUS.nnext(this.address(), value);
        return this;
    }

    public XrExternalCameraOCULUS set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrExternalCameraOCULUS set(XrExternalCameraOCULUS src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrExternalCameraOCULUS malloc() {
        return (XrExternalCameraOCULUS)XrExternalCameraOCULUS.wrap(XrExternalCameraOCULUS.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrExternalCameraOCULUS calloc() {
        return (XrExternalCameraOCULUS)XrExternalCameraOCULUS.wrap(XrExternalCameraOCULUS.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrExternalCameraOCULUS create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrExternalCameraOCULUS)XrExternalCameraOCULUS.wrap(XrExternalCameraOCULUS.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrExternalCameraOCULUS create(long address) {
        return (XrExternalCameraOCULUS)XrExternalCameraOCULUS.wrap(XrExternalCameraOCULUS.class, (long)address);
    }

    @Nullable
    public static XrExternalCameraOCULUS createSafe(long address) {
        return address == 0L ? null : (XrExternalCameraOCULUS)XrExternalCameraOCULUS.wrap(XrExternalCameraOCULUS.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrExternalCameraOCULUS.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrExternalCameraOCULUS.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrExternalCameraOCULUS.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrExternalCameraOCULUS.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrExternalCameraOCULUS.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrExternalCameraOCULUS.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrExternalCameraOCULUS.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrExternalCameraOCULUS malloc(MemoryStack stack) {
        return (XrExternalCameraOCULUS)XrExternalCameraOCULUS.wrap(XrExternalCameraOCULUS.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrExternalCameraOCULUS calloc(MemoryStack stack) {
        return (XrExternalCameraOCULUS)XrExternalCameraOCULUS.wrap(XrExternalCameraOCULUS.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrExternalCameraOCULUS.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrExternalCameraOCULUS.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)NAME), (int)32);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)NAME));
    }

    public static XrExternalCameraIntrinsicsOCULUS nintrinsics(long struct) {
        return XrExternalCameraIntrinsicsOCULUS.create(struct + (long)INTRINSICS);
    }

    public static XrExternalCameraExtrinsicsOCULUS nextrinsics(long struct) {
        return XrExternalCameraExtrinsicsOCULUS.create(struct + (long)EXTRINSICS);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    static {
        Struct.Layout layout = XrExternalCameraOCULUS.__struct((Struct.Member[])new Struct.Member[]{XrExternalCameraOCULUS.__member((int)4), XrExternalCameraOCULUS.__member((int)POINTER_SIZE), XrExternalCameraOCULUS.__array((int)1, (int)32), XrExternalCameraOCULUS.__member((int)XrExternalCameraIntrinsicsOCULUS.SIZEOF, (int)XrExternalCameraIntrinsicsOCULUS.ALIGNOF), XrExternalCameraOCULUS.__member((int)XrExternalCameraExtrinsicsOCULUS.SIZEOF, (int)XrExternalCameraExtrinsicsOCULUS.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        NAME = layout.offsetof(2);
        INTRINSICS = layout.offsetof(3);
        EXTRINSICS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrExternalCameraOCULUS, Buffer>
    implements NativeResource {
        private static final XrExternalCameraOCULUS ELEMENT_FACTORY = XrExternalCameraOCULUS.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrExternalCameraOCULUS getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrExternalCameraOCULUS.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrExternalCameraOCULUS.nnext(this.address());
        }

        @NativeType(value="char[XR_MAX_EXTERNAL_CAMERA_NAME_SIZE_OCULUS]")
        public ByteBuffer name() {
            return XrExternalCameraOCULUS.nname(this.address());
        }

        @NativeType(value="char[XR_MAX_EXTERNAL_CAMERA_NAME_SIZE_OCULUS]")
        public String nameString() {
            return XrExternalCameraOCULUS.nnameString(this.address());
        }

        public XrExternalCameraIntrinsicsOCULUS intrinsics() {
            return XrExternalCameraOCULUS.nintrinsics(this.address());
        }

        public XrExternalCameraExtrinsicsOCULUS extrinsics() {
            return XrExternalCameraOCULUS.nextrinsics(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrExternalCameraOCULUS.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000226000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrExternalCameraOCULUS.nnext(this.address(), value);
            return this;
        }
    }
}

