/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrFaceExpressionStatusFB;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrFaceExpressionWeightsFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int WEIGHTCOUNT;
    public static final int WEIGHTS;
    public static final int CONFIDENCECOUNT;
    public static final int CONFIDENCES;
    public static final int STATUS;
    public static final int TIME;

    public XrFaceExpressionWeightsFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrFaceExpressionWeightsFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrFaceExpressionWeightsFB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrFaceExpressionWeightsFB.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int weightCount() {
        return XrFaceExpressionWeightsFB.nweightCount(this.address());
    }

    @NativeType(value="float *")
    public FloatBuffer weights() {
        return XrFaceExpressionWeightsFB.nweights(this.address());
    }

    @NativeType(value="uint32_t")
    public int confidenceCount() {
        return XrFaceExpressionWeightsFB.nconfidenceCount(this.address());
    }

    @NativeType(value="float *")
    public FloatBuffer confidences() {
        return XrFaceExpressionWeightsFB.nconfidences(this.address());
    }

    public XrFaceExpressionStatusFB status() {
        return XrFaceExpressionWeightsFB.nstatus(this.address());
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrFaceExpressionWeightsFB.ntime(this.address());
    }

    public XrFaceExpressionWeightsFB type(@NativeType(value="XrStructureType") int value) {
        XrFaceExpressionWeightsFB.ntype(this.address(), value);
        return this;
    }

    public XrFaceExpressionWeightsFB type$Default() {
        return this.type(1000201006);
    }

    public XrFaceExpressionWeightsFB next(@NativeType(value="void *") long value) {
        XrFaceExpressionWeightsFB.nnext(this.address(), value);
        return this;
    }

    public XrFaceExpressionWeightsFB weights(@NativeType(value="float *") FloatBuffer value) {
        XrFaceExpressionWeightsFB.nweights(this.address(), value);
        return this;
    }

    public XrFaceExpressionWeightsFB confidences(@NativeType(value="float *") FloatBuffer value) {
        XrFaceExpressionWeightsFB.nconfidences(this.address(), value);
        return this;
    }

    public XrFaceExpressionWeightsFB status(XrFaceExpressionStatusFB value) {
        XrFaceExpressionWeightsFB.nstatus(this.address(), value);
        return this;
    }

    public XrFaceExpressionWeightsFB status(Consumer<XrFaceExpressionStatusFB> consumer) {
        consumer.accept(this.status());
        return this;
    }

    public XrFaceExpressionWeightsFB time(@NativeType(value="XrTime") long value) {
        XrFaceExpressionWeightsFB.ntime(this.address(), value);
        return this;
    }

    public XrFaceExpressionWeightsFB set(int type, long next, FloatBuffer weights, FloatBuffer confidences, XrFaceExpressionStatusFB status, long time) {
        this.type(type);
        this.next(next);
        this.weights(weights);
        this.confidences(confidences);
        this.status(status);
        this.time(time);
        return this;
    }

    public XrFaceExpressionWeightsFB set(XrFaceExpressionWeightsFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrFaceExpressionWeightsFB malloc() {
        return (XrFaceExpressionWeightsFB)XrFaceExpressionWeightsFB.wrap(XrFaceExpressionWeightsFB.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrFaceExpressionWeightsFB calloc() {
        return (XrFaceExpressionWeightsFB)XrFaceExpressionWeightsFB.wrap(XrFaceExpressionWeightsFB.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrFaceExpressionWeightsFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrFaceExpressionWeightsFB)XrFaceExpressionWeightsFB.wrap(XrFaceExpressionWeightsFB.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrFaceExpressionWeightsFB create(long address) {
        return (XrFaceExpressionWeightsFB)XrFaceExpressionWeightsFB.wrap(XrFaceExpressionWeightsFB.class, (long)address);
    }

    @Nullable
    public static XrFaceExpressionWeightsFB createSafe(long address) {
        return address == 0L ? null : (XrFaceExpressionWeightsFB)XrFaceExpressionWeightsFB.wrap(XrFaceExpressionWeightsFB.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrFaceExpressionWeightsFB.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrFaceExpressionWeightsFB.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrFaceExpressionWeightsFB.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrFaceExpressionWeightsFB.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrFaceExpressionWeightsFB.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrFaceExpressionWeightsFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrFaceExpressionWeightsFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrFaceExpressionWeightsFB malloc(MemoryStack stack) {
        return (XrFaceExpressionWeightsFB)XrFaceExpressionWeightsFB.wrap(XrFaceExpressionWeightsFB.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrFaceExpressionWeightsFB calloc(MemoryStack stack) {
        return (XrFaceExpressionWeightsFB)XrFaceExpressionWeightsFB.wrap(XrFaceExpressionWeightsFB.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrFaceExpressionWeightsFB.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrFaceExpressionWeightsFB.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nweightCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)WEIGHTCOUNT);
    }

    public static FloatBuffer nweights(long struct) {
        return MemoryUtil.memFloatBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)WEIGHTS)), (int)XrFaceExpressionWeightsFB.nweightCount(struct));
    }

    public static int nconfidenceCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)CONFIDENCECOUNT);
    }

    public static FloatBuffer nconfidences(long struct) {
        return MemoryUtil.memFloatBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)CONFIDENCES)), (int)XrFaceExpressionWeightsFB.nconfidenceCount(struct));
    }

    public static XrFaceExpressionStatusFB nstatus(long struct) {
        return XrFaceExpressionStatusFB.create(struct + (long)STATUS);
    }

    public static long ntime(long struct) {
        return UNSAFE.getLong(null, struct + (long)TIME);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nweightCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WEIGHTCOUNT, value);
    }

    public static void nweights(long struct, FloatBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)WEIGHTS), (long)MemoryUtil.memAddress((FloatBuffer)value));
        XrFaceExpressionWeightsFB.nweightCount(struct, value.remaining());
    }

    public static void nconfidenceCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CONFIDENCECOUNT, value);
    }

    public static void nconfidences(long struct, FloatBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CONFIDENCES), (long)MemoryUtil.memAddress((FloatBuffer)value));
        XrFaceExpressionWeightsFB.nconfidenceCount(struct, value.remaining());
    }

    public static void nstatus(long struct, XrFaceExpressionStatusFB value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)STATUS), (long)XrFaceExpressionStatusFB.SIZEOF);
    }

    public static void ntime(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)TIME, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)WEIGHTS)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)CONFIDENCES)));
    }

    static {
        Struct.Layout layout = XrFaceExpressionWeightsFB.__struct((Struct.Member[])new Struct.Member[]{XrFaceExpressionWeightsFB.__member((int)4), XrFaceExpressionWeightsFB.__member((int)POINTER_SIZE), XrFaceExpressionWeightsFB.__member((int)4), XrFaceExpressionWeightsFB.__member((int)POINTER_SIZE), XrFaceExpressionWeightsFB.__member((int)4), XrFaceExpressionWeightsFB.__member((int)POINTER_SIZE), XrFaceExpressionWeightsFB.__member((int)XrFaceExpressionStatusFB.SIZEOF, (int)XrFaceExpressionStatusFB.ALIGNOF), XrFaceExpressionWeightsFB.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        WEIGHTCOUNT = layout.offsetof(2);
        WEIGHTS = layout.offsetof(3);
        CONFIDENCECOUNT = layout.offsetof(4);
        CONFIDENCES = layout.offsetof(5);
        STATUS = layout.offsetof(6);
        TIME = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<XrFaceExpressionWeightsFB, Buffer>
    implements NativeResource {
        private static final XrFaceExpressionWeightsFB ELEMENT_FACTORY = XrFaceExpressionWeightsFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrFaceExpressionWeightsFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrFaceExpressionWeightsFB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrFaceExpressionWeightsFB.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int weightCount() {
            return XrFaceExpressionWeightsFB.nweightCount(this.address());
        }

        @NativeType(value="float *")
        public FloatBuffer weights() {
            return XrFaceExpressionWeightsFB.nweights(this.address());
        }

        @NativeType(value="uint32_t")
        public int confidenceCount() {
            return XrFaceExpressionWeightsFB.nconfidenceCount(this.address());
        }

        @NativeType(value="float *")
        public FloatBuffer confidences() {
            return XrFaceExpressionWeightsFB.nconfidences(this.address());
        }

        public XrFaceExpressionStatusFB status() {
            return XrFaceExpressionWeightsFB.nstatus(this.address());
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrFaceExpressionWeightsFB.ntime(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrFaceExpressionWeightsFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000201006);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrFaceExpressionWeightsFB.nnext(this.address(), value);
            return this;
        }

        public Buffer weights(@NativeType(value="float *") FloatBuffer value) {
            XrFaceExpressionWeightsFB.nweights(this.address(), value);
            return this;
        }

        public Buffer confidences(@NativeType(value="float *") FloatBuffer value) {
            XrFaceExpressionWeightsFB.nconfidences(this.address(), value);
            return this;
        }

        public Buffer status(XrFaceExpressionStatusFB value) {
            XrFaceExpressionWeightsFB.nstatus(this.address(), value);
            return this;
        }

        public Buffer status(Consumer<XrFaceExpressionStatusFB> consumer) {
            consumer.accept(this.status());
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrFaceExpressionWeightsFB.ntime(this.address(), value);
            return this;
        }
    }
}

