/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrFaceTrackerCreateInfoFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int FACEEXPRESSIONSET;

    public XrFaceTrackerCreateInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrFaceTrackerCreateInfoFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrFaceTrackerCreateInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrFaceTrackerCreateInfoFB.nnext(this.address());
    }

    @NativeType(value="XrFaceExpressionSetFB")
    public int faceExpressionSet() {
        return XrFaceTrackerCreateInfoFB.nfaceExpressionSet(this.address());
    }

    public XrFaceTrackerCreateInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrFaceTrackerCreateInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrFaceTrackerCreateInfoFB type$Default() {
        return this.type(1000201005);
    }

    public XrFaceTrackerCreateInfoFB next(@NativeType(value="void const *") long value) {
        XrFaceTrackerCreateInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrFaceTrackerCreateInfoFB faceExpressionSet(@NativeType(value="XrFaceExpressionSetFB") int value) {
        XrFaceTrackerCreateInfoFB.nfaceExpressionSet(this.address(), value);
        return this;
    }

    public XrFaceTrackerCreateInfoFB set(int type, long next, int faceExpressionSet) {
        this.type(type);
        this.next(next);
        this.faceExpressionSet(faceExpressionSet);
        return this;
    }

    public XrFaceTrackerCreateInfoFB set(XrFaceTrackerCreateInfoFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrFaceTrackerCreateInfoFB malloc() {
        return (XrFaceTrackerCreateInfoFB)XrFaceTrackerCreateInfoFB.wrap(XrFaceTrackerCreateInfoFB.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrFaceTrackerCreateInfoFB calloc() {
        return (XrFaceTrackerCreateInfoFB)XrFaceTrackerCreateInfoFB.wrap(XrFaceTrackerCreateInfoFB.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrFaceTrackerCreateInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrFaceTrackerCreateInfoFB)XrFaceTrackerCreateInfoFB.wrap(XrFaceTrackerCreateInfoFB.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrFaceTrackerCreateInfoFB create(long address) {
        return (XrFaceTrackerCreateInfoFB)XrFaceTrackerCreateInfoFB.wrap(XrFaceTrackerCreateInfoFB.class, (long)address);
    }

    @Nullable
    public static XrFaceTrackerCreateInfoFB createSafe(long address) {
        return address == 0L ? null : (XrFaceTrackerCreateInfoFB)XrFaceTrackerCreateInfoFB.wrap(XrFaceTrackerCreateInfoFB.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrFaceTrackerCreateInfoFB.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrFaceTrackerCreateInfoFB.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrFaceTrackerCreateInfoFB.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrFaceTrackerCreateInfoFB.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrFaceTrackerCreateInfoFB.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrFaceTrackerCreateInfoFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrFaceTrackerCreateInfoFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrFaceTrackerCreateInfoFB malloc(MemoryStack stack) {
        return (XrFaceTrackerCreateInfoFB)XrFaceTrackerCreateInfoFB.wrap(XrFaceTrackerCreateInfoFB.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrFaceTrackerCreateInfoFB calloc(MemoryStack stack) {
        return (XrFaceTrackerCreateInfoFB)XrFaceTrackerCreateInfoFB.wrap(XrFaceTrackerCreateInfoFB.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrFaceTrackerCreateInfoFB.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrFaceTrackerCreateInfoFB.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nfaceExpressionSet(long struct) {
        return UNSAFE.getInt(null, struct + (long)FACEEXPRESSIONSET);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nfaceExpressionSet(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FACEEXPRESSIONSET, value);
    }

    static {
        Struct.Layout layout = XrFaceTrackerCreateInfoFB.__struct((Struct.Member[])new Struct.Member[]{XrFaceTrackerCreateInfoFB.__member((int)4), XrFaceTrackerCreateInfoFB.__member((int)POINTER_SIZE), XrFaceTrackerCreateInfoFB.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        FACEEXPRESSIONSET = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrFaceTrackerCreateInfoFB, Buffer>
    implements NativeResource {
        private static final XrFaceTrackerCreateInfoFB ELEMENT_FACTORY = XrFaceTrackerCreateInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrFaceTrackerCreateInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrFaceTrackerCreateInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrFaceTrackerCreateInfoFB.nnext(this.address());
        }

        @NativeType(value="XrFaceExpressionSetFB")
        public int faceExpressionSet() {
            return XrFaceTrackerCreateInfoFB.nfaceExpressionSet(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrFaceTrackerCreateInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000201005);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrFaceTrackerCreateInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer faceExpressionSet(@NativeType(value="XrFaceExpressionSetFB") int value) {
            XrFaceTrackerCreateInfoFB.nfaceExpressionSet(this.address(), value);
            return this;
        }
    }
}

