/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrVector2f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrFoveationConfigurationHTC
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LEVEL;
    public static final int CLEARFOVDEGREE;
    public static final int FOCALCENTEROFFSET;

    public XrFoveationConfigurationHTC(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrFoveationConfigurationHTC.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrFoveationLevelHTC")
    public int level() {
        return XrFoveationConfigurationHTC.nlevel(this.address());
    }

    public float clearFovDegree() {
        return XrFoveationConfigurationHTC.nclearFovDegree(this.address());
    }

    public XrVector2f focalCenterOffset() {
        return XrFoveationConfigurationHTC.nfocalCenterOffset(this.address());
    }

    public XrFoveationConfigurationHTC level(@NativeType(value="XrFoveationLevelHTC") int value) {
        XrFoveationConfigurationHTC.nlevel(this.address(), value);
        return this;
    }

    public XrFoveationConfigurationHTC clearFovDegree(float value) {
        XrFoveationConfigurationHTC.nclearFovDegree(this.address(), value);
        return this;
    }

    public XrFoveationConfigurationHTC focalCenterOffset(XrVector2f value) {
        XrFoveationConfigurationHTC.nfocalCenterOffset(this.address(), value);
        return this;
    }

    public XrFoveationConfigurationHTC focalCenterOffset(Consumer<XrVector2f> consumer) {
        consumer.accept(this.focalCenterOffset());
        return this;
    }

    public XrFoveationConfigurationHTC set(int level, float clearFovDegree, XrVector2f focalCenterOffset) {
        this.level(level);
        this.clearFovDegree(clearFovDegree);
        this.focalCenterOffset(focalCenterOffset);
        return this;
    }

    public XrFoveationConfigurationHTC set(XrFoveationConfigurationHTC src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrFoveationConfigurationHTC malloc() {
        return (XrFoveationConfigurationHTC)XrFoveationConfigurationHTC.wrap(XrFoveationConfigurationHTC.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrFoveationConfigurationHTC calloc() {
        return (XrFoveationConfigurationHTC)XrFoveationConfigurationHTC.wrap(XrFoveationConfigurationHTC.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrFoveationConfigurationHTC create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrFoveationConfigurationHTC)XrFoveationConfigurationHTC.wrap(XrFoveationConfigurationHTC.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrFoveationConfigurationHTC create(long address) {
        return (XrFoveationConfigurationHTC)XrFoveationConfigurationHTC.wrap(XrFoveationConfigurationHTC.class, (long)address);
    }

    @Nullable
    public static XrFoveationConfigurationHTC createSafe(long address) {
        return address == 0L ? null : (XrFoveationConfigurationHTC)XrFoveationConfigurationHTC.wrap(XrFoveationConfigurationHTC.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrFoveationConfigurationHTC.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrFoveationConfigurationHTC.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrFoveationConfigurationHTC.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrFoveationConfigurationHTC.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrFoveationConfigurationHTC.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrFoveationConfigurationHTC.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrFoveationConfigurationHTC.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrFoveationConfigurationHTC malloc(MemoryStack stack) {
        return (XrFoveationConfigurationHTC)XrFoveationConfigurationHTC.wrap(XrFoveationConfigurationHTC.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrFoveationConfigurationHTC calloc(MemoryStack stack) {
        return (XrFoveationConfigurationHTC)XrFoveationConfigurationHTC.wrap(XrFoveationConfigurationHTC.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrFoveationConfigurationHTC.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrFoveationConfigurationHTC.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nlevel(long struct) {
        return UNSAFE.getInt(null, struct + (long)LEVEL);
    }

    public static float nclearFovDegree(long struct) {
        return UNSAFE.getFloat(null, struct + (long)CLEARFOVDEGREE);
    }

    public static XrVector2f nfocalCenterOffset(long struct) {
        return XrVector2f.create(struct + (long)FOCALCENTEROFFSET);
    }

    public static void nlevel(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LEVEL, value);
    }

    public static void nclearFovDegree(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)CLEARFOVDEGREE, value);
    }

    public static void nfocalCenterOffset(long struct, XrVector2f value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FOCALCENTEROFFSET), (long)XrVector2f.SIZEOF);
    }

    static {
        Struct.Layout layout = XrFoveationConfigurationHTC.__struct((Struct.Member[])new Struct.Member[]{XrFoveationConfigurationHTC.__member((int)4), XrFoveationConfigurationHTC.__member((int)4), XrFoveationConfigurationHTC.__member((int)XrVector2f.SIZEOF, (int)XrVector2f.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LEVEL = layout.offsetof(0);
        CLEARFOVDEGREE = layout.offsetof(1);
        FOCALCENTEROFFSET = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrFoveationConfigurationHTC, Buffer>
    implements NativeResource {
        private static final XrFoveationConfigurationHTC ELEMENT_FACTORY = XrFoveationConfigurationHTC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrFoveationConfigurationHTC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrFoveationLevelHTC")
        public int level() {
            return XrFoveationConfigurationHTC.nlevel(this.address());
        }

        public float clearFovDegree() {
            return XrFoveationConfigurationHTC.nclearFovDegree(this.address());
        }

        public XrVector2f focalCenterOffset() {
            return XrFoveationConfigurationHTC.nfocalCenterOffset(this.address());
        }

        public Buffer level(@NativeType(value="XrFoveationLevelHTC") int value) {
            XrFoveationConfigurationHTC.nlevel(this.address(), value);
            return this;
        }

        public Buffer clearFovDegree(float value) {
            XrFoveationConfigurationHTC.nclearFovDegree(this.address(), value);
            return this;
        }

        public Buffer focalCenterOffset(XrVector2f value) {
            XrFoveationConfigurationHTC.nfocalCenterOffset(this.address(), value);
            return this;
        }

        public Buffer focalCenterOffset(Consumer<XrVector2f> consumer) {
            consumer.accept(this.focalCenterOffset());
            return this;
        }
    }
}

