/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrGlobalDimmerFrameEndInfoML
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int DIMMERVALUE;
    public static final int FLAGS;

    public XrGlobalDimmerFrameEndInfoML(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrGlobalDimmerFrameEndInfoML.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrGlobalDimmerFrameEndInfoML.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrGlobalDimmerFrameEndInfoML.nnext(this.address());
    }

    public float dimmerValue() {
        return XrGlobalDimmerFrameEndInfoML.ndimmerValue(this.address());
    }

    @NativeType(value="XrGlobalDimmerFrameEndInfoFlagsML")
    public long flags() {
        return XrGlobalDimmerFrameEndInfoML.nflags(this.address());
    }

    public XrGlobalDimmerFrameEndInfoML type(@NativeType(value="XrStructureType") int value) {
        XrGlobalDimmerFrameEndInfoML.ntype(this.address(), value);
        return this;
    }

    public XrGlobalDimmerFrameEndInfoML type$Default() {
        return this.type(1000136000);
    }

    public XrGlobalDimmerFrameEndInfoML next(@NativeType(value="void const *") long value) {
        XrGlobalDimmerFrameEndInfoML.nnext(this.address(), value);
        return this;
    }

    public XrGlobalDimmerFrameEndInfoML dimmerValue(float value) {
        XrGlobalDimmerFrameEndInfoML.ndimmerValue(this.address(), value);
        return this;
    }

    public XrGlobalDimmerFrameEndInfoML flags(@NativeType(value="XrGlobalDimmerFrameEndInfoFlagsML") long value) {
        XrGlobalDimmerFrameEndInfoML.nflags(this.address(), value);
        return this;
    }

    public XrGlobalDimmerFrameEndInfoML set(int type, long next, float dimmerValue, long flags) {
        this.type(type);
        this.next(next);
        this.dimmerValue(dimmerValue);
        this.flags(flags);
        return this;
    }

    public XrGlobalDimmerFrameEndInfoML set(XrGlobalDimmerFrameEndInfoML src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrGlobalDimmerFrameEndInfoML malloc() {
        return (XrGlobalDimmerFrameEndInfoML)XrGlobalDimmerFrameEndInfoML.wrap(XrGlobalDimmerFrameEndInfoML.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrGlobalDimmerFrameEndInfoML calloc() {
        return (XrGlobalDimmerFrameEndInfoML)XrGlobalDimmerFrameEndInfoML.wrap(XrGlobalDimmerFrameEndInfoML.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrGlobalDimmerFrameEndInfoML create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrGlobalDimmerFrameEndInfoML)XrGlobalDimmerFrameEndInfoML.wrap(XrGlobalDimmerFrameEndInfoML.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrGlobalDimmerFrameEndInfoML create(long address) {
        return (XrGlobalDimmerFrameEndInfoML)XrGlobalDimmerFrameEndInfoML.wrap(XrGlobalDimmerFrameEndInfoML.class, (long)address);
    }

    @Nullable
    public static XrGlobalDimmerFrameEndInfoML createSafe(long address) {
        return address == 0L ? null : (XrGlobalDimmerFrameEndInfoML)XrGlobalDimmerFrameEndInfoML.wrap(XrGlobalDimmerFrameEndInfoML.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrGlobalDimmerFrameEndInfoML.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrGlobalDimmerFrameEndInfoML.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrGlobalDimmerFrameEndInfoML.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrGlobalDimmerFrameEndInfoML.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrGlobalDimmerFrameEndInfoML.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrGlobalDimmerFrameEndInfoML.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrGlobalDimmerFrameEndInfoML.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrGlobalDimmerFrameEndInfoML malloc(MemoryStack stack) {
        return (XrGlobalDimmerFrameEndInfoML)XrGlobalDimmerFrameEndInfoML.wrap(XrGlobalDimmerFrameEndInfoML.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrGlobalDimmerFrameEndInfoML calloc(MemoryStack stack) {
        return (XrGlobalDimmerFrameEndInfoML)XrGlobalDimmerFrameEndInfoML.wrap(XrGlobalDimmerFrameEndInfoML.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrGlobalDimmerFrameEndInfoML.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrGlobalDimmerFrameEndInfoML.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static float ndimmerValue(long struct) {
        return UNSAFE.getFloat(null, struct + (long)DIMMERVALUE);
    }

    public static long nflags(long struct) {
        return UNSAFE.getLong(null, struct + (long)FLAGS);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void ndimmerValue(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)DIMMERVALUE, value);
    }

    public static void nflags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = XrGlobalDimmerFrameEndInfoML.__struct((Struct.Member[])new Struct.Member[]{XrGlobalDimmerFrameEndInfoML.__member((int)4), XrGlobalDimmerFrameEndInfoML.__member((int)POINTER_SIZE), XrGlobalDimmerFrameEndInfoML.__member((int)4), XrGlobalDimmerFrameEndInfoML.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        DIMMERVALUE = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrGlobalDimmerFrameEndInfoML, Buffer>
    implements NativeResource {
        private static final XrGlobalDimmerFrameEndInfoML ELEMENT_FACTORY = XrGlobalDimmerFrameEndInfoML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrGlobalDimmerFrameEndInfoML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrGlobalDimmerFrameEndInfoML.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrGlobalDimmerFrameEndInfoML.nnext(this.address());
        }

        public float dimmerValue() {
            return XrGlobalDimmerFrameEndInfoML.ndimmerValue(this.address());
        }

        @NativeType(value="XrGlobalDimmerFrameEndInfoFlagsML")
        public long flags() {
            return XrGlobalDimmerFrameEndInfoML.nflags(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrGlobalDimmerFrameEndInfoML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000136000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrGlobalDimmerFrameEndInfoML.nnext(this.address(), value);
            return this;
        }

        public Buffer dimmerValue(float value) {
            XrGlobalDimmerFrameEndInfoML.ndimmerValue(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="XrGlobalDimmerFrameEndInfoFlagsML") long value) {
            XrGlobalDimmerFrameEndInfoML.nflags(this.address(), value);
            return this;
        }
    }
}

