/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandTrackingScaleFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SENSOROUTPUT;
    public static final int CURRENTOUTPUT;
    public static final int OVERRIDEHANDSCALE;
    public static final int OVERRIDEVALUEINPUT;

    public XrHandTrackingScaleFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrHandTrackingScaleFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHandTrackingScaleFB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrHandTrackingScaleFB.nnext(this.address());
    }

    public float sensorOutput() {
        return XrHandTrackingScaleFB.nsensorOutput(this.address());
    }

    public float currentOutput() {
        return XrHandTrackingScaleFB.ncurrentOutput(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean overrideHandScale() {
        return XrHandTrackingScaleFB.noverrideHandScale(this.address()) != 0;
    }

    public float overrideValueInput() {
        return XrHandTrackingScaleFB.noverrideValueInput(this.address());
    }

    public XrHandTrackingScaleFB type(@NativeType(value="XrStructureType") int value) {
        XrHandTrackingScaleFB.ntype(this.address(), value);
        return this;
    }

    public XrHandTrackingScaleFB type$Default() {
        return this.type(1000110003);
    }

    public XrHandTrackingScaleFB next(@NativeType(value="void *") long value) {
        XrHandTrackingScaleFB.nnext(this.address(), value);
        return this;
    }

    public XrHandTrackingScaleFB set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrHandTrackingScaleFB set(XrHandTrackingScaleFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrHandTrackingScaleFB malloc() {
        return (XrHandTrackingScaleFB)XrHandTrackingScaleFB.wrap(XrHandTrackingScaleFB.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrHandTrackingScaleFB calloc() {
        return (XrHandTrackingScaleFB)XrHandTrackingScaleFB.wrap(XrHandTrackingScaleFB.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrHandTrackingScaleFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrHandTrackingScaleFB)XrHandTrackingScaleFB.wrap(XrHandTrackingScaleFB.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrHandTrackingScaleFB create(long address) {
        return (XrHandTrackingScaleFB)XrHandTrackingScaleFB.wrap(XrHandTrackingScaleFB.class, (long)address);
    }

    @Nullable
    public static XrHandTrackingScaleFB createSafe(long address) {
        return address == 0L ? null : (XrHandTrackingScaleFB)XrHandTrackingScaleFB.wrap(XrHandTrackingScaleFB.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrHandTrackingScaleFB.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrHandTrackingScaleFB.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrHandTrackingScaleFB.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandTrackingScaleFB.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrHandTrackingScaleFB.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrHandTrackingScaleFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrHandTrackingScaleFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrHandTrackingScaleFB malloc(MemoryStack stack) {
        return (XrHandTrackingScaleFB)XrHandTrackingScaleFB.wrap(XrHandTrackingScaleFB.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrHandTrackingScaleFB calloc(MemoryStack stack) {
        return (XrHandTrackingScaleFB)XrHandTrackingScaleFB.wrap(XrHandTrackingScaleFB.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrHandTrackingScaleFB.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrHandTrackingScaleFB.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static float nsensorOutput(long struct) {
        return UNSAFE.getFloat(null, struct + (long)SENSOROUTPUT);
    }

    public static float ncurrentOutput(long struct) {
        return UNSAFE.getFloat(null, struct + (long)CURRENTOUTPUT);
    }

    public static int noverrideHandScale(long struct) {
        return UNSAFE.getInt(null, struct + (long)OVERRIDEHANDSCALE);
    }

    public static float noverrideValueInput(long struct) {
        return UNSAFE.getFloat(null, struct + (long)OVERRIDEVALUEINPUT);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    static {
        Struct.Layout layout = XrHandTrackingScaleFB.__struct((Struct.Member[])new Struct.Member[]{XrHandTrackingScaleFB.__member((int)4), XrHandTrackingScaleFB.__member((int)POINTER_SIZE), XrHandTrackingScaleFB.__member((int)4), XrHandTrackingScaleFB.__member((int)4), XrHandTrackingScaleFB.__member((int)4), XrHandTrackingScaleFB.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SENSOROUTPUT = layout.offsetof(2);
        CURRENTOUTPUT = layout.offsetof(3);
        OVERRIDEHANDSCALE = layout.offsetof(4);
        OVERRIDEVALUEINPUT = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrHandTrackingScaleFB, Buffer>
    implements NativeResource {
        private static final XrHandTrackingScaleFB ELEMENT_FACTORY = XrHandTrackingScaleFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrHandTrackingScaleFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHandTrackingScaleFB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrHandTrackingScaleFB.nnext(this.address());
        }

        public float sensorOutput() {
            return XrHandTrackingScaleFB.nsensorOutput(this.address());
        }

        public float currentOutput() {
            return XrHandTrackingScaleFB.ncurrentOutput(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean overrideHandScale() {
            return XrHandTrackingScaleFB.noverrideHandScale(this.address()) != 0;
        }

        public float overrideValueInput() {
            return XrHandTrackingScaleFB.noverrideValueInput(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHandTrackingScaleFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000110003);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrHandTrackingScaleFB.nnext(this.address(), value);
            return this;
        }
    }
}

