/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrHapticAmplitudeEnvelopeVibrationFB;
import org.lwjgl.openxr.XrHapticPcmVibrationFB;
import org.lwjgl.openxr.XrHapticVibration;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHapticBaseHeader
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    public XrHapticBaseHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrHapticBaseHeader.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHapticBaseHeader.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrHapticBaseHeader.nnext(this.address());
    }

    public XrHapticBaseHeader type(@NativeType(value="XrStructureType") int value) {
        XrHapticBaseHeader.ntype(this.address(), value);
        return this;
    }

    public XrHapticBaseHeader next(@NativeType(value="void const *") long value) {
        XrHapticBaseHeader.nnext(this.address(), value);
        return this;
    }

    public XrHapticBaseHeader set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrHapticBaseHeader set(XrHapticBaseHeader src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrHapticBaseHeader malloc() {
        return (XrHapticBaseHeader)XrHapticBaseHeader.wrap(XrHapticBaseHeader.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrHapticBaseHeader calloc() {
        return (XrHapticBaseHeader)XrHapticBaseHeader.wrap(XrHapticBaseHeader.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrHapticBaseHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrHapticBaseHeader)XrHapticBaseHeader.wrap(XrHapticBaseHeader.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrHapticBaseHeader create(long address) {
        return (XrHapticBaseHeader)XrHapticBaseHeader.wrap(XrHapticBaseHeader.class, (long)address);
    }

    @Nullable
    public static XrHapticBaseHeader createSafe(long address) {
        return address == 0L ? null : (XrHapticBaseHeader)XrHapticBaseHeader.wrap(XrHapticBaseHeader.class, (long)address);
    }

    public static XrHapticBaseHeader create(XrHapticVibration value) {
        return (XrHapticBaseHeader)XrHapticBaseHeader.wrap(XrHapticBaseHeader.class, (Struct)value);
    }

    public static XrHapticBaseHeader create(XrHapticAmplitudeEnvelopeVibrationFB value) {
        return (XrHapticBaseHeader)XrHapticBaseHeader.wrap(XrHapticBaseHeader.class, (Struct)value);
    }

    public static XrHapticBaseHeader create(XrHapticPcmVibrationFB value) {
        return (XrHapticBaseHeader)XrHapticBaseHeader.wrap(XrHapticBaseHeader.class, (Struct)value);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrHapticBaseHeader.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrHapticBaseHeader.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrHapticBaseHeader.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHapticBaseHeader.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrHapticBaseHeader.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrHapticBaseHeader.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrHapticBaseHeader.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static Buffer create(XrHapticVibration.Buffer value) {
        return (Buffer)XrHapticBaseHeader.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static Buffer create(XrHapticAmplitudeEnvelopeVibrationFB.Buffer value) {
        return (Buffer)XrHapticBaseHeader.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static Buffer create(XrHapticPcmVibrationFB.Buffer value) {
        return (Buffer)XrHapticBaseHeader.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static XrHapticBaseHeader malloc(MemoryStack stack) {
        return (XrHapticBaseHeader)XrHapticBaseHeader.wrap(XrHapticBaseHeader.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrHapticBaseHeader calloc(MemoryStack stack) {
        return (XrHapticBaseHeader)XrHapticBaseHeader.wrap(XrHapticBaseHeader.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrHapticBaseHeader.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrHapticBaseHeader.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    static {
        Struct.Layout layout = XrHapticBaseHeader.__struct((Struct.Member[])new Struct.Member[]{XrHapticBaseHeader.__member((int)4), XrHapticBaseHeader.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrHapticBaseHeader, Buffer>
    implements NativeResource {
        private static final XrHapticBaseHeader ELEMENT_FACTORY = XrHapticBaseHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrHapticBaseHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHapticBaseHeader.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrHapticBaseHeader.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHapticBaseHeader.ntype(this.address(), value);
            return this;
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrHapticBaseHeader.nnext(this.address(), value);
            return this;
        }
    }
}

