/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrOffset3DfFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;

    public XrOffset3DfFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrOffset3DfFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return XrOffset3DfFB.nx(this.address());
    }

    public float y() {
        return XrOffset3DfFB.ny(this.address());
    }

    public float z() {
        return XrOffset3DfFB.nz(this.address());
    }

    public XrOffset3DfFB x(float value) {
        XrOffset3DfFB.nx(this.address(), value);
        return this;
    }

    public XrOffset3DfFB y(float value) {
        XrOffset3DfFB.ny(this.address(), value);
        return this;
    }

    public XrOffset3DfFB z(float value) {
        XrOffset3DfFB.nz(this.address(), value);
        return this;
    }

    public XrOffset3DfFB set(float x, float y, float z) {
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public XrOffset3DfFB set(XrOffset3DfFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrOffset3DfFB malloc() {
        return (XrOffset3DfFB)XrOffset3DfFB.wrap(XrOffset3DfFB.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrOffset3DfFB calloc() {
        return (XrOffset3DfFB)XrOffset3DfFB.wrap(XrOffset3DfFB.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrOffset3DfFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrOffset3DfFB)XrOffset3DfFB.wrap(XrOffset3DfFB.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrOffset3DfFB create(long address) {
        return (XrOffset3DfFB)XrOffset3DfFB.wrap(XrOffset3DfFB.class, (long)address);
    }

    @Nullable
    public static XrOffset3DfFB createSafe(long address) {
        return address == 0L ? null : (XrOffset3DfFB)XrOffset3DfFB.wrap(XrOffset3DfFB.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrOffset3DfFB.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrOffset3DfFB.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrOffset3DfFB.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrOffset3DfFB.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrOffset3DfFB.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrOffset3DfFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrOffset3DfFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrOffset3DfFB malloc(MemoryStack stack) {
        return (XrOffset3DfFB)XrOffset3DfFB.wrap(XrOffset3DfFB.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrOffset3DfFB calloc(MemoryStack stack) {
        return (XrOffset3DfFB)XrOffset3DfFB.wrap(XrOffset3DfFB.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrOffset3DfFB.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrOffset3DfFB.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static float nx(long struct) {
        return UNSAFE.getFloat(null, struct + (long)X);
    }

    public static float ny(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Y);
    }

    public static float nz(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Z);
    }

    public static void nx(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Y, value);
    }

    public static void nz(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Z, value);
    }

    static {
        Struct.Layout layout = XrOffset3DfFB.__struct((Struct.Member[])new Struct.Member[]{XrOffset3DfFB.__member((int)4), XrOffset3DfFB.__member((int)4), XrOffset3DfFB.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrOffset3DfFB, Buffer>
    implements NativeResource {
        private static final XrOffset3DfFB ELEMENT_FACTORY = XrOffset3DfFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrOffset3DfFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return XrOffset3DfFB.nx(this.address());
        }

        public float y() {
            return XrOffset3DfFB.ny(this.address());
        }

        public float z() {
            return XrOffset3DfFB.nz(this.address());
        }

        public Buffer x(float value) {
            XrOffset3DfFB.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            XrOffset3DfFB.ny(this.address(), value);
            return this;
        }

        public Buffer z(float value) {
            XrOffset3DfFB.nz(this.address(), value);
            return this;
        }
    }
}

