/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrPassthroughCreateInfoHTC
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int FORM;

    public XrPassthroughCreateInfoHTC(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrPassthroughCreateInfoHTC.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrPassthroughCreateInfoHTC.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrPassthroughCreateInfoHTC.nnext(this.address());
    }

    @NativeType(value="XrPassthroughFormHTC")
    public int form() {
        return XrPassthroughCreateInfoHTC.nform(this.address());
    }

    public XrPassthroughCreateInfoHTC type(@NativeType(value="XrStructureType") int value) {
        XrPassthroughCreateInfoHTC.ntype(this.address(), value);
        return this;
    }

    public XrPassthroughCreateInfoHTC type$Default() {
        return this.type(1000317001);
    }

    public XrPassthroughCreateInfoHTC next(@NativeType(value="void const *") long value) {
        XrPassthroughCreateInfoHTC.nnext(this.address(), value);
        return this;
    }

    public XrPassthroughCreateInfoHTC form(@NativeType(value="XrPassthroughFormHTC") int value) {
        XrPassthroughCreateInfoHTC.nform(this.address(), value);
        return this;
    }

    public XrPassthroughCreateInfoHTC set(int type, long next, int form) {
        this.type(type);
        this.next(next);
        this.form(form);
        return this;
    }

    public XrPassthroughCreateInfoHTC set(XrPassthroughCreateInfoHTC src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrPassthroughCreateInfoHTC malloc() {
        return (XrPassthroughCreateInfoHTC)XrPassthroughCreateInfoHTC.wrap(XrPassthroughCreateInfoHTC.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrPassthroughCreateInfoHTC calloc() {
        return (XrPassthroughCreateInfoHTC)XrPassthroughCreateInfoHTC.wrap(XrPassthroughCreateInfoHTC.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrPassthroughCreateInfoHTC create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrPassthroughCreateInfoHTC)XrPassthroughCreateInfoHTC.wrap(XrPassthroughCreateInfoHTC.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrPassthroughCreateInfoHTC create(long address) {
        return (XrPassthroughCreateInfoHTC)XrPassthroughCreateInfoHTC.wrap(XrPassthroughCreateInfoHTC.class, (long)address);
    }

    @Nullable
    public static XrPassthroughCreateInfoHTC createSafe(long address) {
        return address == 0L ? null : (XrPassthroughCreateInfoHTC)XrPassthroughCreateInfoHTC.wrap(XrPassthroughCreateInfoHTC.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrPassthroughCreateInfoHTC.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrPassthroughCreateInfoHTC.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrPassthroughCreateInfoHTC.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrPassthroughCreateInfoHTC.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrPassthroughCreateInfoHTC.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrPassthroughCreateInfoHTC.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrPassthroughCreateInfoHTC.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrPassthroughCreateInfoHTC malloc(MemoryStack stack) {
        return (XrPassthroughCreateInfoHTC)XrPassthroughCreateInfoHTC.wrap(XrPassthroughCreateInfoHTC.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrPassthroughCreateInfoHTC calloc(MemoryStack stack) {
        return (XrPassthroughCreateInfoHTC)XrPassthroughCreateInfoHTC.wrap(XrPassthroughCreateInfoHTC.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrPassthroughCreateInfoHTC.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrPassthroughCreateInfoHTC.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nform(long struct) {
        return UNSAFE.getInt(null, struct + (long)FORM);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nform(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FORM, value);
    }

    static {
        Struct.Layout layout = XrPassthroughCreateInfoHTC.__struct((Struct.Member[])new Struct.Member[]{XrPassthroughCreateInfoHTC.__member((int)4), XrPassthroughCreateInfoHTC.__member((int)POINTER_SIZE), XrPassthroughCreateInfoHTC.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        FORM = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrPassthroughCreateInfoHTC, Buffer>
    implements NativeResource {
        private static final XrPassthroughCreateInfoHTC ELEMENT_FACTORY = XrPassthroughCreateInfoHTC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrPassthroughCreateInfoHTC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrPassthroughCreateInfoHTC.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrPassthroughCreateInfoHTC.nnext(this.address());
        }

        @NativeType(value="XrPassthroughFormHTC")
        public int form() {
            return XrPassthroughCreateInfoHTC.nform(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrPassthroughCreateInfoHTC.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000317001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrPassthroughCreateInfoHTC.nnext(this.address(), value);
            return this;
        }

        public Buffer form(@NativeType(value="XrPassthroughFormHTC") int value) {
            XrPassthroughCreateInfoHTC.nform(this.address(), value);
            return this;
        }
    }
}

