/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrColor4f;
import org.lwjgl.openxr.XrPassthroughBrightnessContrastSaturationFB;
import org.lwjgl.openxr.XrPassthroughColorMapMonoToMonoFB;
import org.lwjgl.openxr.XrPassthroughColorMapMonoToRgbaFB;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrPassthroughStyleFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int TEXTUREOPACITYFACTOR;
    public static final int EDGECOLOR;

    public XrPassthroughStyleFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrPassthroughStyleFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrPassthroughStyleFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrPassthroughStyleFB.nnext(this.address());
    }

    public float textureOpacityFactor() {
        return XrPassthroughStyleFB.ntextureOpacityFactor(this.address());
    }

    public XrColor4f edgeColor() {
        return XrPassthroughStyleFB.nedgeColor(this.address());
    }

    public XrPassthroughStyleFB type(@NativeType(value="XrStructureType") int value) {
        XrPassthroughStyleFB.ntype(this.address(), value);
        return this;
    }

    public XrPassthroughStyleFB type$Default() {
        return this.type(1000118020);
    }

    public XrPassthroughStyleFB next(@NativeType(value="void const *") long value) {
        XrPassthroughStyleFB.nnext(this.address(), value);
        return this;
    }

    public XrPassthroughStyleFB next(XrPassthroughBrightnessContrastSaturationFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrPassthroughStyleFB next(XrPassthroughColorMapMonoToMonoFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrPassthroughStyleFB next(XrPassthroughColorMapMonoToRgbaFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrPassthroughStyleFB textureOpacityFactor(float value) {
        XrPassthroughStyleFB.ntextureOpacityFactor(this.address(), value);
        return this;
    }

    public XrPassthroughStyleFB edgeColor(XrColor4f value) {
        XrPassthroughStyleFB.nedgeColor(this.address(), value);
        return this;
    }

    public XrPassthroughStyleFB edgeColor(Consumer<XrColor4f> consumer) {
        consumer.accept(this.edgeColor());
        return this;
    }

    public XrPassthroughStyleFB set(int type, long next, float textureOpacityFactor, XrColor4f edgeColor) {
        this.type(type);
        this.next(next);
        this.textureOpacityFactor(textureOpacityFactor);
        this.edgeColor(edgeColor);
        return this;
    }

    public XrPassthroughStyleFB set(XrPassthroughStyleFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrPassthroughStyleFB malloc() {
        return (XrPassthroughStyleFB)XrPassthroughStyleFB.wrap(XrPassthroughStyleFB.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrPassthroughStyleFB calloc() {
        return (XrPassthroughStyleFB)XrPassthroughStyleFB.wrap(XrPassthroughStyleFB.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrPassthroughStyleFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrPassthroughStyleFB)XrPassthroughStyleFB.wrap(XrPassthroughStyleFB.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrPassthroughStyleFB create(long address) {
        return (XrPassthroughStyleFB)XrPassthroughStyleFB.wrap(XrPassthroughStyleFB.class, (long)address);
    }

    @Nullable
    public static XrPassthroughStyleFB createSafe(long address) {
        return address == 0L ? null : (XrPassthroughStyleFB)XrPassthroughStyleFB.wrap(XrPassthroughStyleFB.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrPassthroughStyleFB.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrPassthroughStyleFB.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrPassthroughStyleFB.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrPassthroughStyleFB.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrPassthroughStyleFB.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrPassthroughStyleFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrPassthroughStyleFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrPassthroughStyleFB malloc(MemoryStack stack) {
        return (XrPassthroughStyleFB)XrPassthroughStyleFB.wrap(XrPassthroughStyleFB.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrPassthroughStyleFB calloc(MemoryStack stack) {
        return (XrPassthroughStyleFB)XrPassthroughStyleFB.wrap(XrPassthroughStyleFB.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrPassthroughStyleFB.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrPassthroughStyleFB.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static float ntextureOpacityFactor(long struct) {
        return UNSAFE.getFloat(null, struct + (long)TEXTUREOPACITYFACTOR);
    }

    public static XrColor4f nedgeColor(long struct) {
        return XrColor4f.create(struct + (long)EDGECOLOR);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void ntextureOpacityFactor(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)TEXTUREOPACITYFACTOR, value);
    }

    public static void nedgeColor(long struct, XrColor4f value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)EDGECOLOR), (long)XrColor4f.SIZEOF);
    }

    static {
        Struct.Layout layout = XrPassthroughStyleFB.__struct((Struct.Member[])new Struct.Member[]{XrPassthroughStyleFB.__member((int)4), XrPassthroughStyleFB.__member((int)POINTER_SIZE), XrPassthroughStyleFB.__member((int)4), XrPassthroughStyleFB.__member((int)XrColor4f.SIZEOF, (int)XrColor4f.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        TEXTUREOPACITYFACTOR = layout.offsetof(2);
        EDGECOLOR = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrPassthroughStyleFB, Buffer>
    implements NativeResource {
        private static final XrPassthroughStyleFB ELEMENT_FACTORY = XrPassthroughStyleFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrPassthroughStyleFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrPassthroughStyleFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrPassthroughStyleFB.nnext(this.address());
        }

        public float textureOpacityFactor() {
            return XrPassthroughStyleFB.ntextureOpacityFactor(this.address());
        }

        public XrColor4f edgeColor() {
            return XrPassthroughStyleFB.nedgeColor(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrPassthroughStyleFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000118020);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrPassthroughStyleFB.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrPassthroughBrightnessContrastSaturationFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrPassthroughColorMapMonoToMonoFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrPassthroughColorMapMonoToRgbaFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer textureOpacityFactor(float value) {
            XrPassthroughStyleFB.ntextureOpacityFactor(this.address(), value);
            return this;
        }

        public Buffer edgeColor(XrColor4f value) {
            XrPassthroughStyleFB.nedgeColor(this.address(), value);
            return this;
        }

        public Buffer edgeColor(Consumer<XrColor4f> consumer) {
            consumer.accept(this.edgeColor());
            return this;
        }
    }
}

