/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrPerformanceMetricsCounterMETA
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int COUNTERFLAGS;
    public static final int COUNTERUNIT;
    public static final int UINTVALUE;
    public static final int FLOATVALUE;

    public XrPerformanceMetricsCounterMETA(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrPerformanceMetricsCounterMETA.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrPerformanceMetricsCounterMETA.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrPerformanceMetricsCounterMETA.nnext(this.address());
    }

    @NativeType(value="XrPerformanceMetricsCounterFlagsMETA")
    public long counterFlags() {
        return XrPerformanceMetricsCounterMETA.ncounterFlags(this.address());
    }

    @NativeType(value="XrPerformanceMetricsCounterUnitMETA")
    public int counterUnit() {
        return XrPerformanceMetricsCounterMETA.ncounterUnit(this.address());
    }

    @NativeType(value="uint32_t")
    public int uintValue() {
        return XrPerformanceMetricsCounterMETA.nuintValue(this.address());
    }

    public float floatValue() {
        return XrPerformanceMetricsCounterMETA.nfloatValue(this.address());
    }

    public XrPerformanceMetricsCounterMETA type(@NativeType(value="XrStructureType") int value) {
        XrPerformanceMetricsCounterMETA.ntype(this.address(), value);
        return this;
    }

    public XrPerformanceMetricsCounterMETA type$Default() {
        return this.type(1000232002);
    }

    public XrPerformanceMetricsCounterMETA next(@NativeType(value="void const *") long value) {
        XrPerformanceMetricsCounterMETA.nnext(this.address(), value);
        return this;
    }

    public XrPerformanceMetricsCounterMETA counterFlags(@NativeType(value="XrPerformanceMetricsCounterFlagsMETA") long value) {
        XrPerformanceMetricsCounterMETA.ncounterFlags(this.address(), value);
        return this;
    }

    public XrPerformanceMetricsCounterMETA counterUnit(@NativeType(value="XrPerformanceMetricsCounterUnitMETA") int value) {
        XrPerformanceMetricsCounterMETA.ncounterUnit(this.address(), value);
        return this;
    }

    public XrPerformanceMetricsCounterMETA uintValue(@NativeType(value="uint32_t") int value) {
        XrPerformanceMetricsCounterMETA.nuintValue(this.address(), value);
        return this;
    }

    public XrPerformanceMetricsCounterMETA floatValue(float value) {
        XrPerformanceMetricsCounterMETA.nfloatValue(this.address(), value);
        return this;
    }

    public XrPerformanceMetricsCounterMETA set(int type, long next, long counterFlags, int counterUnit, int uintValue, float floatValue) {
        this.type(type);
        this.next(next);
        this.counterFlags(counterFlags);
        this.counterUnit(counterUnit);
        this.uintValue(uintValue);
        this.floatValue(floatValue);
        return this;
    }

    public XrPerformanceMetricsCounterMETA set(XrPerformanceMetricsCounterMETA src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrPerformanceMetricsCounterMETA malloc() {
        return (XrPerformanceMetricsCounterMETA)XrPerformanceMetricsCounterMETA.wrap(XrPerformanceMetricsCounterMETA.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrPerformanceMetricsCounterMETA calloc() {
        return (XrPerformanceMetricsCounterMETA)XrPerformanceMetricsCounterMETA.wrap(XrPerformanceMetricsCounterMETA.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrPerformanceMetricsCounterMETA create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrPerformanceMetricsCounterMETA)XrPerformanceMetricsCounterMETA.wrap(XrPerformanceMetricsCounterMETA.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrPerformanceMetricsCounterMETA create(long address) {
        return (XrPerformanceMetricsCounterMETA)XrPerformanceMetricsCounterMETA.wrap(XrPerformanceMetricsCounterMETA.class, (long)address);
    }

    @Nullable
    public static XrPerformanceMetricsCounterMETA createSafe(long address) {
        return address == 0L ? null : (XrPerformanceMetricsCounterMETA)XrPerformanceMetricsCounterMETA.wrap(XrPerformanceMetricsCounterMETA.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrPerformanceMetricsCounterMETA.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrPerformanceMetricsCounterMETA.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrPerformanceMetricsCounterMETA.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrPerformanceMetricsCounterMETA.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrPerformanceMetricsCounterMETA.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrPerformanceMetricsCounterMETA.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrPerformanceMetricsCounterMETA.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrPerformanceMetricsCounterMETA malloc(MemoryStack stack) {
        return (XrPerformanceMetricsCounterMETA)XrPerformanceMetricsCounterMETA.wrap(XrPerformanceMetricsCounterMETA.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrPerformanceMetricsCounterMETA calloc(MemoryStack stack) {
        return (XrPerformanceMetricsCounterMETA)XrPerformanceMetricsCounterMETA.wrap(XrPerformanceMetricsCounterMETA.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrPerformanceMetricsCounterMETA.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrPerformanceMetricsCounterMETA.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long ncounterFlags(long struct) {
        return UNSAFE.getLong(null, struct + (long)COUNTERFLAGS);
    }

    public static int ncounterUnit(long struct) {
        return UNSAFE.getInt(null, struct + (long)COUNTERUNIT);
    }

    public static int nuintValue(long struct) {
        return UNSAFE.getInt(null, struct + (long)UINTVALUE);
    }

    public static float nfloatValue(long struct) {
        return UNSAFE.getFloat(null, struct + (long)FLOATVALUE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void ncounterFlags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)COUNTERFLAGS, value);
    }

    public static void ncounterUnit(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COUNTERUNIT, value);
    }

    public static void nuintValue(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)UINTVALUE, value);
    }

    public static void nfloatValue(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)FLOATVALUE, value);
    }

    static {
        Struct.Layout layout = XrPerformanceMetricsCounterMETA.__struct((Struct.Member[])new Struct.Member[]{XrPerformanceMetricsCounterMETA.__member((int)4), XrPerformanceMetricsCounterMETA.__member((int)POINTER_SIZE), XrPerformanceMetricsCounterMETA.__member((int)8), XrPerformanceMetricsCounterMETA.__member((int)4), XrPerformanceMetricsCounterMETA.__member((int)4), XrPerformanceMetricsCounterMETA.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        COUNTERFLAGS = layout.offsetof(2);
        COUNTERUNIT = layout.offsetof(3);
        UINTVALUE = layout.offsetof(4);
        FLOATVALUE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrPerformanceMetricsCounterMETA, Buffer>
    implements NativeResource {
        private static final XrPerformanceMetricsCounterMETA ELEMENT_FACTORY = XrPerformanceMetricsCounterMETA.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrPerformanceMetricsCounterMETA getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrPerformanceMetricsCounterMETA.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrPerformanceMetricsCounterMETA.nnext(this.address());
        }

        @NativeType(value="XrPerformanceMetricsCounterFlagsMETA")
        public long counterFlags() {
            return XrPerformanceMetricsCounterMETA.ncounterFlags(this.address());
        }

        @NativeType(value="XrPerformanceMetricsCounterUnitMETA")
        public int counterUnit() {
            return XrPerformanceMetricsCounterMETA.ncounterUnit(this.address());
        }

        @NativeType(value="uint32_t")
        public int uintValue() {
            return XrPerformanceMetricsCounterMETA.nuintValue(this.address());
        }

        public float floatValue() {
            return XrPerformanceMetricsCounterMETA.nfloatValue(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrPerformanceMetricsCounterMETA.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000232002);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrPerformanceMetricsCounterMETA.nnext(this.address(), value);
            return this;
        }

        public Buffer counterFlags(@NativeType(value="XrPerformanceMetricsCounterFlagsMETA") long value) {
            XrPerformanceMetricsCounterMETA.ncounterFlags(this.address(), value);
            return this;
        }

        public Buffer counterUnit(@NativeType(value="XrPerformanceMetricsCounterUnitMETA") int value) {
            XrPerformanceMetricsCounterMETA.ncounterUnit(this.address(), value);
            return this;
        }

        public Buffer uintValue(@NativeType(value="uint32_t") int value) {
            XrPerformanceMetricsCounterMETA.nuintValue(this.address(), value);
            return this;
        }

        public Buffer floatValue(float value) {
            XrPerformanceMetricsCounterMETA.nfloatValue(this.address(), value);
            return this;
        }
    }
}

