/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrExtent3DfFB;
import org.lwjgl.openxr.XrOffset3DfFB;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrRect3DfFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OFFSET;
    public static final int EXTENT;

    public XrRect3DfFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrRect3DfFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public XrOffset3DfFB offset() {
        return XrRect3DfFB.noffset(this.address());
    }

    public XrExtent3DfFB extent() {
        return XrRect3DfFB.nextent(this.address());
    }

    public XrRect3DfFB offset(XrOffset3DfFB value) {
        XrRect3DfFB.noffset(this.address(), value);
        return this;
    }

    public XrRect3DfFB offset(Consumer<XrOffset3DfFB> consumer) {
        consumer.accept(this.offset());
        return this;
    }

    public XrRect3DfFB extent(XrExtent3DfFB value) {
        XrRect3DfFB.nextent(this.address(), value);
        return this;
    }

    public XrRect3DfFB extent(Consumer<XrExtent3DfFB> consumer) {
        consumer.accept(this.extent());
        return this;
    }

    public XrRect3DfFB set(XrOffset3DfFB offset, XrExtent3DfFB extent) {
        this.offset(offset);
        this.extent(extent);
        return this;
    }

    public XrRect3DfFB set(XrRect3DfFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrRect3DfFB malloc() {
        return (XrRect3DfFB)XrRect3DfFB.wrap(XrRect3DfFB.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrRect3DfFB calloc() {
        return (XrRect3DfFB)XrRect3DfFB.wrap(XrRect3DfFB.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrRect3DfFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrRect3DfFB)XrRect3DfFB.wrap(XrRect3DfFB.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrRect3DfFB create(long address) {
        return (XrRect3DfFB)XrRect3DfFB.wrap(XrRect3DfFB.class, (long)address);
    }

    @Nullable
    public static XrRect3DfFB createSafe(long address) {
        return address == 0L ? null : (XrRect3DfFB)XrRect3DfFB.wrap(XrRect3DfFB.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrRect3DfFB.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrRect3DfFB.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrRect3DfFB.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrRect3DfFB.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrRect3DfFB.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrRect3DfFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrRect3DfFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrRect3DfFB malloc(MemoryStack stack) {
        return (XrRect3DfFB)XrRect3DfFB.wrap(XrRect3DfFB.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrRect3DfFB calloc(MemoryStack stack) {
        return (XrRect3DfFB)XrRect3DfFB.wrap(XrRect3DfFB.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrRect3DfFB.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrRect3DfFB.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static XrOffset3DfFB noffset(long struct) {
        return XrOffset3DfFB.create(struct + (long)OFFSET);
    }

    public static XrExtent3DfFB nextent(long struct) {
        return XrExtent3DfFB.create(struct + (long)EXTENT);
    }

    public static void noffset(long struct, XrOffset3DfFB value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)OFFSET), (long)XrOffset3DfFB.SIZEOF);
    }

    public static void nextent(long struct, XrExtent3DfFB value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)EXTENT), (long)XrExtent3DfFB.SIZEOF);
    }

    static {
        Struct.Layout layout = XrRect3DfFB.__struct((Struct.Member[])new Struct.Member[]{XrRect3DfFB.__member((int)XrOffset3DfFB.SIZEOF, (int)XrOffset3DfFB.ALIGNOF), XrRect3DfFB.__member((int)XrExtent3DfFB.SIZEOF, (int)XrExtent3DfFB.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OFFSET = layout.offsetof(0);
        EXTENT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrRect3DfFB, Buffer>
    implements NativeResource {
        private static final XrRect3DfFB ELEMENT_FACTORY = XrRect3DfFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrRect3DfFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public XrOffset3DfFB offset() {
            return XrRect3DfFB.noffset(this.address());
        }

        public XrExtent3DfFB extent() {
            return XrRect3DfFB.nextent(this.address());
        }

        public Buffer offset(XrOffset3DfFB value) {
            XrRect3DfFB.noffset(this.address(), value);
            return this;
        }

        public Buffer offset(Consumer<XrOffset3DfFB> consumer) {
            consumer.accept(this.offset());
            return this;
        }

        public Buffer extent(XrExtent3DfFB value) {
            XrRect3DfFB.nextent(this.address(), value);
            return this;
        }

        public Buffer extent(Consumer<XrExtent3DfFB> consumer) {
            consumer.accept(this.extent());
            return this;
        }
    }
}

